/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageLayer;
import com.ge.med.terra.jami.XpSelectionManager;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XpImageScene
implements XpImageRenderAttributesOwner {
    public static final String IRA_PROP = "IRA_PROP";
    public static final String COMPONENT_ADDED = "COMPONENT_ADDED";
    public static final String COMPONENT_REMOVED = "COMPONENT_REMOVED";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private XpImage frame = null;
    private XpImageRenderAttributes ira = null;
    private HashMap<String, Object> data = new HashMap();
    private List roiList = new ArrayList();
    private List userAnnoList = new ArrayList();
    private int selectedState = 0;
    private boolean initScene = true;
    private double initWW = 0.0;
    private double initWL = 0.0;
    private List imgLayers = null;

    public XpImageScene(XpImage frame) {
        this.init(frame, null);
    }

    public XpImageScene(XpImage frame, XpImageRenderAttributes ira) {
        this.init(frame, ira);
    }

    private void init(XpImage frame, XpImageRenderAttributes ira) {
        this.setImage(frame);
        this.ira = ira;
        if (ira != null) {
            this.initWW = ira.getWindowWidth();
            this.initWL = ira.getWindowLevel();
            this.initScene = false;
        } else {
            this.ira = new XpImageRenderAttributes();
            this.initScene = true;
        }
    }

    public final List getImageLayers() {
        return this.imgLayers;
    }

    public final int addImageLayer(XpImageLayer il) {
        if (this.imgLayers == null) {
            this.imgLayers = new ArrayList(4);
        }
        this.imgLayers.add(il);
        return this.imgLayers.size();
    }

    public final int removeImageLayer(int layer_no) {
        int removeIdx;
        if (this.imgLayers != null && layer_no > 0 && (removeIdx = layer_no - 1) < this.imgLayers.size()) {
            XpImageLayer removed = (XpImageLayer)this.imgLayers.remove(removeIdx);
            if (removed != null) {
                removed.dispose();
            }
            removed = null;
            int new_size = this.imgLayers.size();
            if (new_size == 0) {
                this.imgLayers = null;
            }
            return new_size;
        }
        return -1;
    }

    public final int getNumLayers() {
        int nlayers = 0;
        if (this.imgLayers != null) {
            nlayers = this.imgLayers.size();
        }
        return nlayers + 1;
    }

    public final void resetWWWL() {
        if (!this.initScene) {
            XpImageRenderAttributes ira = this.getImageRenderAttributes();
            ira.setWindowing(this.initWW, this.initWL);
            this.setImageRenderAttributes(ira);
        }
    }

    public final void resetIRA() {
        this.ira.reset();
        this.resetWWWL();
    }

    public final void copyScene(XpImageScene is) {
        XpImageRenderAttributes fsira = is.getImageRenderAttributes();
        this.setImageRenderAttributes(fsira);
        XpImage img = is.getFrame();
        this.setImage(img);
    }

    public final void setSelectedState(int selection) {
        this.selectedState = selection;
    }

    public final int getSelectedState() {
        return this.selectedState;
    }

    public final void clear() {
        this.roiList.clear();
        this.userAnnoList.clear();
        this.ira.reset();
        this.selectedState = 0;
        this.initScene = true;
    }

    private void setImage(XpImage img) {
        this.frame = img;
    }

    public final XpImage getFrame() {
        return this.frame;
    }

    @Override
    public final void setImageRenderAttributes(XpImageRenderAttributes ira) {
        this.ira = ira;
        this.pcs.firePropertyChange(IRA_PROP, null, this.ira);
    }

    @Override
    public final XpImageRenderAttributes getImageRenderAttributes() {
        if (this.initScene && this.frame != null) {
            this.initScene = false;
            double ww = this.frame.getDefaultWindowWidth();
            double wl = this.frame.getDefaultWindowLevel();
            this.initWW = ww;
            this.initWL = wl;
            this.ira.setWindowing(ww, wl);
        }
        return this.ira;
    }

    public final void add(RoiActor ra) {
        if (this.frame != null) {
            ra.setImage(this.frame);
            this.roiList.add(ra);
            XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
            sm.addSelectable(ra);
            this.pcs.firePropertyChange(COMPONENT_ADDED, null, ra);
        }
    }

    public final List getRois() {
        return this.roiList;
    }

    public final boolean remove(RoiActor ra) {
        XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
        sm.removeSelectable(ra);
        boolean res = this.roiList.remove(ra);
        if (res) {
            ra.setImage(null);
            this.pcs.firePropertyChange(COMPONENT_REMOVED, null, ra);
        }
        return res;
    }

    public final RoiActor getRoi() {
        int size = this.roiList.size();
        RoiActor ra = null;
        if (size > 0) {
            ra = (RoiActor)this.roiList.get(size - 1);
        }
        return ra;
    }

    public final void add(XpUserAnnotationModel m2) {
        this.userAnnoList.add(m2);
        XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
        sm.addSelectable(m2);
        this.pcs.firePropertyChange(COMPONENT_ADDED, null, m2);
    }

    public final boolean remove(XpUserAnnotationModel m2) {
        XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
        sm.removeSelectable(m2);
        boolean ret = this.userAnnoList.remove(m2);
        if (ret) {
            this.pcs.firePropertyChange(COMPONENT_REMOVED, null, m2);
        }
        return ret;
    }

    public final List getUserAnnos() {
        return this.userAnnoList;
    }

    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    public Object clone() {
        XpImageScene newscene = new XpImageScene(this.getFrame());
        XpImageRenderAttributes ira = this.getImageRenderAttributes();
        XpImageRenderAttributes nira = newscene.getImageRenderAttributes();
        nira.set(ira);
        List rl = this.getRois();
        for (int j2 = 0; j2 < rl.size(); ++j2) {
            Replicable sr;
            RoiActor newra;
            RoiActor ra = (RoiActor)rl.get(j2);
            if (!(ra instanceof Replicable) || (newra = (RoiActor)(sr = (Replicable)((Object)ra)).clone()) == null) continue;
            newscene.add(newra);
        }
        List ual = this.getUserAnnos();
        for (int j3 = 0; j3 < ual.size(); ++j3) {
            XpUserAnnotationModel uam = (XpUserAnnotationModel)ual.get(j3);
            XpUserAnnotationModel newuam = (XpUserAnnotationModel)uam.clone();
            newscene.add(newuam);
        }
        return newscene;
    }

    protected static void copyScenes(List oldScenes, List newScenes) {
        for (int i2 = 0; i2 < oldScenes.size(); ++i2) {
            XpImageScene scene2 = (XpImageScene)oldScenes.get(i2);
            XpImageScene newscene = (XpImageScene)newScenes.get(i2);
            XpImageRenderAttributes ira = scene2.getImageRenderAttributes();
            XpImageRenderAttributes nira = newscene.getImageRenderAttributes();
            nira.set(ira);
            List rl = scene2.getRois();
            for (int j2 = 0; j2 < rl.size(); ++j2) {
                Replicable sr;
                RoiActor newra;
                RoiActor ra = (RoiActor)rl.get(j2);
                if (!(ra instanceof Replicable) || (newra = (RoiActor)(sr = (Replicable)((Object)ra)).clone()) == null) continue;
                newscene.add(newra);
            }
            List ual = scene2.getUserAnnos();
            for (int j3 = 0; j3 < ual.size(); ++j3) {
                XpUserAnnotationModel uam = (XpUserAnnotationModel)ual.get(j3);
                XpUserAnnotationModel newuam = (XpUserAnnotationModel)uam.clone();
                newscene.add(newuam);
            }
        }
    }

    public void addDataObject(String key, Object dataObject) {
        this.data.put(key, dataObject);
    }

    public void removeDataObject(String key, Object dataObject) {
        this.data.remove(key);
    }

    public void removeAllDataObjects() {
        this.data.clear();
    }
}

