/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.XjImage;
import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpComponentSave;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageViewport;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.plot.XpPlotModel;
import com.ge.med.terra.jami.plot.XpPlotter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class XpImageUtils {
    public static final double MIN_WL_VALUE = -32767.0;
    public static final double MIN_WW_VALUE = 0.0;
    public static final double DEFAULT_RESCALE_INTERCEPT = 0.0;
    public static final double DEFAULT_RESCALE_SLOPE = 1.0;
    private static XpDicomElement imgtype = new XpDicomElement(8, 8);
    private static XpDicomElement scouttype = new XpDicomElement(39, 4112);
    private static final double EPSILON = 1.0E-5;
    private static double[] _reg = new double[6];

    public static RenderedImage downSample(BufferedImage input, int nw, int nh) {
        BufferedImage out;
        block7: {
            int scY;
            int scX;
            int offset;
            DataBuffer db;
            int h2;
            int w2;
            int type;
            block8: {
                block6: {
                    out = input;
                    type = input.getType();
                    w2 = input.getWidth();
                    h2 = input.getHeight();
                    db = input.getRaster().getDataBuffer();
                    offset = db.getOffset();
                    scX = (int)((double)w2 / (double)nw);
                    scY = (int)((double)h2 / (double)nh);
                    if (type != 0) break block6;
                    DataBufferByte dbb = (DataBufferByte)db;
                    byte[] data = dbb.getData();
                    out = new BufferedImage(nw, nh, 5);
                    DataBufferByte dbo = (DataBufferByte)out.getRaster().getDataBuffer();
                    byte[] outdata = dbo.getData();
                    for (int i2 = 0; i2 < nh; ++i2) {
                        for (int j2 = 0; j2 < nw; ++j2) {
                            int ii = scX * i2;
                            int jj = scY * j2;
                            if (ii < 0 || ii >= h2 || jj < 0 || jj >= w2) continue;
                            outdata[i2 * (nw * 3) + j2 * 3] = data[offset + ii * (w2 * 3) + jj * 3 + 2];
                            outdata[i2 * (nw * 3) + j2 * 3 + 1] = data[offset + ii * (w2 * 3) + jj * 3 + 1];
                            outdata[i2 * (nw * 3) + j2 * 3 + 2] = data[offset + ii * (w2 * 3) + jj * 3];
                        }
                    }
                    break block7;
                }
                if (type != 5) break block8;
                DataBufferByte dbb = (DataBufferByte)db;
                byte[] data = dbb.getData();
                out = new BufferedImage(nw, nh, 5);
                DataBufferByte dbo = (DataBufferByte)out.getRaster().getDataBuffer();
                byte[] outdata = dbo.getData();
                for (int i3 = 0; i3 < nh; ++i3) {
                    for (int j3 = 0; j3 < nw; ++j3) {
                        int ii = scX * i3;
                        int jj = scY * j3;
                        if (ii < 0 || ii >= h2 || jj < 0 || jj >= w2) continue;
                        outdata[i3 * (nw * 3) + j3 * 3] = data[offset + ii * (w2 * 3) + jj * 3];
                        outdata[i3 * (nw * 3) + j3 * 3 + 1] = data[offset + ii * (w2 * 3) + jj * 3 + 1];
                        outdata[i3 * (nw * 3) + j3 * 3 + 2] = data[offset + ii * (w2 * 3) + jj * 3 + 2];
                    }
                }
                break block7;
            }
            if (type != 1) break block7;
            DataBufferInt dbi = (DataBufferInt)db;
            int[] data = dbi.getData();
            out = new BufferedImage(nw, nh, 1);
            DataBufferInt dbo = (DataBufferInt)out.getRaster().getDataBuffer();
            int[] outdata = dbo.getData();
            for (int i4 = 0; i4 < nh; ++i4) {
                for (int j4 = 0; j4 < nw; ++j4) {
                    int ii = scX * i4;
                    int jj = scY * j4;
                    if (ii < 0 || ii >= h2 || jj < 0 || jj >= w2) continue;
                    outdata[i4 * nw + j4] = data[offset + ii * w2 + jj];
                }
            }
        }
        return out;
    }

    public static PixelDiff diff(BufferedImage op1, BufferedImage op2, BufferedImage res) {
        byte b1;
        byte g1;
        byte r1;
        int i2;
        byte[] out;
        Object[] buff2;
        byte[] buff1;
        int type1 = op1.getType();
        int type2 = op2.getType();
        int typer = res.getType();
        DataBuffer db1 = op1.getRaster().getDataBuffer();
        DataBuffer db2 = op2.getRaster().getDataBuffer();
        DataBuffer dbr = res.getRaster().getDataBuffer();
        PixelDiff ps = new PixelDiff(3);
        if (type1 == 1 && type2 == 0 || type1 == 0 && type2 == 1) {
            buff1 = null;
            buff2 = null;
            out = ((DataBufferByte)dbr).getData();
            if (type1 == 1) {
                buff2 = ((DataBufferInt)db1).getData();
                buff1 = ((DataBufferByte)db2).getData();
            } else {
                buff2 = ((DataBufferInt)db2).getData();
                buff1 = ((DataBufferByte)db1).getData();
            }
            for (i2 = 0; i2 < buff2.length; ++i2) {
                r1 = buff1[3 * i2 + 0];
                g1 = buff1[3 * i2 + 1];
                b1 = buff1[3 * i2 + 2];
                int pixVal = buff2[i2];
                byte r2 = (byte)(pixVal >> 16 & 0xFF);
                byte g2 = (byte)(pixVal >> 8 & 0xFF);
                byte b2 = (byte)(pixVal & 0xFF);
                int dr = r2 - r1;
                int dg = g2 - g1;
                int db = b2 - b1;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out[3 * i2 + 0] = (byte)db;
                out[3 * i2 + 1] = (byte)dg;
                out[3 * i2 + 2] = (byte)dr;
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff2.length);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)buff2.length);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)buff2.length);
        } else if (type1 == 0 && type2 == 0) {
            buff1 = null;
            buff2 = null;
            out = ((DataBufferByte)dbr).getData();
            buff2 = ((DataBufferByte)db1).getData();
            buff1 = ((DataBufferByte)db2).getData();
            for (i2 = 0; i2 < buff2.length; i2 += 3) {
                r1 = buff1[i2 + 0];
                g1 = buff1[i2 + 1];
                b1 = buff1[i2 + 2];
                byte r2 = buff1[i2 + 0];
                byte g2 = buff1[i2 + 1];
                byte b2 = buff1[i2 + 2];
                int dr = r2 - r1;
                int dg = g2 - g1;
                int db = b2 - b1;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out[i2 + 0] = (byte)db;
                out[i2 + 1] = (byte)dg;
                out[i2 + 2] = (byte)dr;
            }
            int len = buff2.length / 3;
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)len);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)len);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)len);
        }
        if (type1 == 1 && type2 == 1) {
            byte[] out2 = ((DataBufferByte)dbr).getData();
            int[] buff12 = ((DataBufferInt)db1).getData();
            int[] buff22 = ((DataBufferInt)db2).getData();
            for (i2 = 0; i2 < buff22.length; ++i2) {
                int pixVal1 = buff12[i2];
                byte r12 = (byte)(pixVal1 >> 16 & 0xFF);
                byte g12 = (byte)(pixVal1 >> 8 & 0xFF);
                byte b12 = (byte)(pixVal1 & 0xFF);
                int pixVal2 = buff22[i2];
                byte r2 = (byte)(pixVal2 >> 16 & 0xFF);
                byte g2 = (byte)(pixVal2 >> 8 & 0xFF);
                byte b2 = (byte)(pixVal2 & 0xFF);
                int dr = r2 - r12;
                int dg = g2 - g12;
                int db = b2 - b12;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
                out2[3 * i2 + 0] = (byte)db;
                out2[3 * i2 + 1] = (byte)dg;
                out2[3 * i2 + 2] = (byte)dr;
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff22.length);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)buff22.length);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)buff22.length);
        }
        return ps;
    }

    public static void imageSave(RenderedImage rimg, String imgFormat, String fileName) {
        try {
            File f2 = new File(fileName);
            ImageIO.write(rimg, imgFormat, f2);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Writing to " + fileName);
        }
    }

    public static BufferedImage genImage(JComponent jc) {
        BufferedImage bimg = new BufferedImage(jc.getWidth(), jc.getHeight(), 2);
        jc.paint(bimg.getGraphics());
        return bimg;
    }

    public static BufferedImage imageRead(String fileName) {
        BufferedImage readImage = null;
        try {
            File f2 = new File(fileName);
            readImage = ImageIO.read(f2);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Reading from " + fileName);
        }
        return readImage;
    }

    public static boolean getMinMax(XpImage ximg, int subsample, double[] minmax) {
        if (ximg == null) {
            return false;
        }
        try {
            XpPixelStatistics pixStats = XpImageUtils.calcStats(ximg, subsample, null);
            minmax[0] = pixStats.getMin();
            minmax[1] = pixStats.getMax();
        }
        catch (Exception e2) {
            minmax[0] = 0.0;
            minmax[1] = 1200.0;
        }
        return true;
    }

    public static JFrame displayImage(RenderedImage bi) {
        return XpImageUtils.displayImage(bi, "Image");
    }

    public static JComponent displayHistogram(int[] hist, int xmin, int xmax, String legend) {
        XpPlotModel mpm = new XpPlotModel();
        XpPlotter mp = new XpPlotter(mpm);
        mpm.clearWaveforms();
        ArrayList<Point2D.Double> waveform = new ArrayList<Point2D.Double>();
        double deltaX = (double)(xmax - xmin + 1) / (double)hist.length;
        waveform.add(new Point2D.Double(0.0, 0.0));
        waveform.add(new Point2D.Double(xmin, 0.0));
        double x2 = xmin;
        int i2 = 0;
        while (i2 < hist.length) {
            Point2D.Double p2 = new Point2D.Double(x2, hist[i2]);
            waveform.add(p2);
            ++i2;
            x2 += deltaX;
        }
        mpm.addWaveform(waveform, legend);
        JFrame frame = new JFrame("Histogram");
        frame.setContentPane(mp);
        frame.pack();
        frame.setVisible(true);
        return mp;
    }

    public static JComponent displayHistogram(RenderedImage ri, int bSize, String legend) {
        JFrame frame = new JFrame("Histogram");
        JPanel histGraph = XpImageUtils.getHistogram(ri, bSize, legend);
        frame.setContentPane(histGraph);
        frame.pack();
        frame.setVisible(true);
        return histGraph;
    }

    public static JPanel getHistogram(RenderedImage ri, int bSize, String legend) {
        XpComponentSave cs = new XpComponentSave();
        XpPixelStatistics ps = XpImageUtils.calcStats(ri, 1.0, 0.0, 1, 1, null);
        Point2D.Double maxPt = new Point2D.Double();
        JnHistogram histogram = new JnHistogram(80);
        XpImageUtils.calcHistogram(ri, 1, 1, histogram);
        int[] hist = histogram.histogram;
        double[] minmax = new double[]{ps.getMin(), ps.getMax()};
        int npts = hist.length;
        XpPlotModel mpm = new XpPlotModel();
        XpPlotter mp = new XpPlotter(mpm);
        mpm.clearWaveforms();
        ArrayList<Point2D.Double> waveform = new ArrayList<Point2D.Double>();
        waveform.add(new Point2D.Double(0.0, 0.0));
        waveform.add(new Point2D.Double(minmax[0], 0.0));
        for (int i2 = 0; i2 < npts; ++i2) {
            Point2D.Double p2 = new Point2D.Double((double)(bSize * i2) + minmax[0], hist[i2]);
            waveform.add(p2);
        }
        mpm.addWaveform(waveform, legend);
        return mp;
    }

    public static double gehcAzimuth(XpMedicalImage mimg) {
        Integer type;
        int itype;
        int r2;
        int r1 = mimg.getValue(imgtype);
        String imgType = "" + XpImageUtils.imgtype.value;
        if (imgType.indexOf("LOCALIZER") >= 0 && (r2 = mimg.getValue(scouttype)) == 0 && XpImageUtils.scouttype.value instanceof Integer && (itype = (type = (Integer)XpImageUtils.scouttype.value).intValue()) == 2) {
            return 270.0;
        }
        return 0.0;
    }

    public static double calcShapeLength(Shape shape, double pdX, double pdY) {
        double px = 0.0;
        double py = 0.0;
        double len = 0.0;
        boolean prev = false;
        int idx = 0;
        PathIterator pi = shape.getPathIterator(null, 0.5);
        while (!pi.isDone()) {
            pi.currentSegment(_reg);
            double x2 = _reg[0];
            double y2 = _reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    px = x2;
                    py = y2;
                    prev = true;
                    break;
                }
                case 1: {
                    if (prev) {
                        double dx = (x2 - px) * pdX;
                        double dy = (y2 - py) * pdY;
                        double dlen = Math.sqrt(dx * dx + dy * dy);
                        len += dlen;
                    }
                    prev = true;
                    px = x2;
                    py = y2;
                    break;
                }
            }
            ++idx;
            pi.next();
            if (!pi.isDone()) continue;
            break;
        }
        return len;
    }

    public static JFrame displayImage(RenderedImage bi, String title) {
        int w2 = bi.getWidth();
        int h2 = bi.getHeight();
        ImagePanel imgPanel = new ImagePanel(bi);
        JFrame frame = new JFrame(title);
        frame.setContentPane(imgPanel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static JFrame displayImage(XpMedicalImage mi, String title) {
        int w2 = mi.getSlice().getSliceColumns();
        int h2 = mi.getSlice().getSliceRows();
        XpImageViewport iv = new XpImageViewport();
        iv.setPreferredSize(new Dimension(w2, h2));
        iv.addImage(mi);
        JFrame frame = new JFrame(title);
        frame.setContentPane(iv);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public static JFrame displayImage(XjImage mi, String title) {
        return XpImageUtils.displayImage(new XjMedicalImage(mi), title);
    }

    public static void printARGB(int argb) {
        long a2 = argb >> 24 & 0xFF;
        long r2 = argb >> 16 & 0xFF;
        long g2 = argb >> 8 & 0xFF;
        long b2 = argb & 0xFF;
        System.out.println("ALPHA=" + a2 + " RED=" + r2 + " GREEN=" + g2 + " BLUE=" + b2);
    }

    private static Raster getRaster(RenderedImage ri) {
        Raster r2 = null;
        if (ri != null) {
            r2 = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return r2;
    }

    private static double square(double val) {
        return val * val;
    }

    public static XpPixelStatistics calcStats(XpImage img, int subSample, XpPixelStatistics ps) {
        RenderedImage rimg = img.getPixelData();
        double rescaleSlope = img.getRescaleSlope();
        double rescaleIntercept = img.getRescaleIntercept();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        return XpImageUtils.calcStats(rimg, rescaleSlope, rescaleIntercept, pixelRepresentation, subSample, ps);
    }

    public static XpPixelStatistics calcStats(RenderedImage rimg, double rescaleSlope, double rescaleIntercept, int subSample, XpPixelStatistics ps) {
        return XpImageUtils.calcStats(rimg, rescaleSlope, rescaleIntercept, 1, subSample, ps);
    }

    public static XpPixelStatistics calcStats(RenderedImage rimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, int subSample, XpPixelStatistics ps) {
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        ps.resetStatistics();
        int imageWidth = rimg.getWidth();
        int imageHeight = rimg.getHeight();
        Raster r2 = XpImageUtils.getRaster(rimg);
        int x1 = r2.getMinX();
        int y1 = r2.getMinY();
        int x2 = x1 + imageWidth;
        int y2 = y1 + imageHeight;
        ps.bounds.setBounds(x1, y1, imageWidth, imageHeight);
        DataBuffer db = r2.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        if (sdata != null) {
            for (int y3 = y1; y3 < y2; y3 += subSample) {
                for (int x3 = x1; x3 < x2; x3 += subSample) {
                    int pval;
                    int n2 = pval = pixelRepresentation != 0 ? sdata[offset + y3 * imageWidth + x3] : sdata[offset + y3 * imageWidth + x3] & 0xFFFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += (double)(pval * pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        } else if (bdata != null) {
            for (int y4 = y1; y4 < y2; y4 += subSample) {
                for (int x4 = x1; x4 < x2; x4 += subSample) {
                    int pval = bdata[offset + y4 * imageWidth + x4] & 0xFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += (double)(pval * pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        } else if (idata != null) {
            for (int y5 = y1; y5 < y2; y5 += subSample) {
                for (int x5 = x1; x5 < x2; x5 += subSample) {
                    int pval = idata[offset + y5 * imageWidth + x5];
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    ps.sumSq += (double)(pval * pval);
                    ps.sum += (double)pval;
                    ++ps.npixels;
                }
            }
        }
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = ps.mean * rescaleSlope + rescaleIntercept;
        ps.max = ps.max * rescaleSlope + rescaleIntercept;
        ps.min = ps.min * rescaleSlope + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    public static int getPixelRepresentation(XpImage img) {
        int pixelRepresentation = 1;
        try {
            XpDicomElement de;
            int retval;
            if (img instanceof XpDicomObject && (retval = ((XpDicomObject)((Object)img)).getValue(de = new XpDicomElement(40, 259))) == 0 && de.value != null) {
                pixelRepresentation = Integer.parseInt(de.value.toString());
            }
        }
        catch (NumberFormatException e2) {
            XpLog.warning("Pixel representation tag (0x0028,0x0103 ) is not valid number");
        }
        return pixelRepresentation;
    }

    public static void calcHistogram(XpImage img, int subsample, JnHistogram hist) {
        RenderedImage rimg = img.getPixelData();
        int pixelRepresentation = XpImageUtils.getPixelRepresentation(img);
        XpImageUtils.calcHistogram(rimg, pixelRepresentation, subsample, hist);
    }

    public static void calcHistogram(RenderedImage rimg, int subsample, JnHistogram hist) {
        XpImageUtils.calcHistogram(rimg, 1, subsample, hist);
    }

    public static void calcHistogram(RenderedImage rimg, int pixelRepresentation, int subsample, JnHistogram hist) {
        Raster r2 = null;
        r2 = rimg instanceof BufferedImage ? ((BufferedImage)rimg).getRaster() : rimg.getData();
        int imageWidth = rimg.getWidth();
        int imageHeight = rimg.getHeight();
        int x1 = r2.getMinX();
        int y1 = r2.getMinY();
        int x2 = x1 + imageWidth;
        int y2 = y1 + imageHeight;
        DataBuffer db = r2.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        XpPixelStatistics ps = XpImageUtils.calcStats(rimg, 1.0, 0.0, pixelRepresentation, subsample, null);
        int[] histogram = hist.histogram;
        Arrays.fill(histogram, 0);
        double bucketSize = (ps.max - ps.min) / (double)histogram.length;
        int maxX = 0;
        int maxY = 0;
        for (int y3 = y1; y3 < y2; y3 += subsample) {
            for (int x3 = x1; x3 < x2; x3 += subsample) {
                int pval = 0;
                if (sdata != null) {
                    pval = pixelRepresentation != 0 ? sdata[offset + y3 * imageWidth + x3] : sdata[offset + y3 * imageWidth + x3] & 0xFFFF;
                } else if (bdata != null) {
                    pval = bdata[offset + y3 * imageWidth + x3] & 0xFF;
                } else if (idata != null) {
                    pval = idata[offset + y3 * imageWidth + x3];
                }
                int bucket = (int)(((double)pval - ps.min) / bucketSize);
                if (bucket < 0) {
                    bucket = 0;
                } else if (bucket >= histogram.length) {
                    bucket = histogram.length - 1;
                }
                int n2 = bucket;
                histogram[n2] = histogram[n2] + 1;
                if (histogram[bucket] <= maxY) continue;
                maxY = histogram[bucket];
                maxX = bucket;
            }
        }
        hist.bucketSize = bucketSize;
        hist.startX = ps.min;
        hist.endX = ps.max;
        hist.maximumPt.setLocation(maxX, maxY);
    }

    public static void calcHistogram(RenderedImage rimg, XpPixelStatistics ps, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, JnHistogram hist) {
        XpImageUtils.calcHistogram(rimg, ps, bitimg, rescaleSlope, rescaleIntercept, 1, hist);
    }

    public static void calcHistogram(RenderedImage rimg, XpPixelStatistics ps, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, JnHistogram hist) {
        int width = rimg.getWidth();
        int ROWLEN_BITMAP = (width + 7) / 8;
        int height = rimg.getHeight();
        int[] histogram = hist.histogram;
        Arrays.fill(histogram, 0);
        double maxval = (ps.max - rescaleIntercept) / rescaleSlope;
        double minval = (ps.min - rescaleIntercept) / rescaleSlope;
        double BUCKETSIZE = (maxval - minval) / (double)histogram.length;
        Raster r2 = XpImageUtils.getRaster(rimg);
        DataBuffer db = r2.getDataBuffer();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        int maxX = 0;
        int maxY = 0;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        int sX = ps.bounds.x;
        int sY = ps.bounds.y;
        int eX = ps.bounds.x + ps.bounds.width;
        int eY = ps.bounds.y + ps.bounds.height;
        for (int y2 = sY; y2 <= eY; ++y2) {
            int idx_offset = y2 * ROWLEN_BITMAP;
            for (int x2 = sX; x2 <= eX; ++x2) {
                int bit = x2 & 7;
                int idx = idx_offset + x2 / 8;
                int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx];
                if (on == 0) continue;
                int pval = 0;
                if (sdata != null) {
                    pval = pixelRepresentation != 0 ? sdata[y2 * width + x2] : sdata[y2 * width + x2] & 0xFFFF;
                } else if (bdata != null) {
                    pval = bdata[y2 * width + x2] & 0xFF;
                } else if (idata != null) {
                    pval = idata[y2 * width + x2];
                }
                int bucket = (int)(((double)pval - minval) / BUCKETSIZE);
                if (bucket >= histogram.length) {
                    bucket = histogram.length - 1;
                }
                try {
                    int n2 = bucket;
                    histogram[n2] = histogram[n2] + 1;
                    if (histogram[bucket] <= maxY) continue;
                    maxY = histogram[bucket];
                    maxX = bucket;
                    continue;
                }
                catch (Exception ex) {
                    XpLog.logger().warning("Histogram Array Indexing problem: bucket=" + bucket + " | min=" + ps.min + " | pval=" + pval + " | BucketSize=" + BUCKETSIZE);
                }
            }
        }
        hist.bucketSize = BUCKETSIZE;
        hist.startX = ps.min;
        hist.endX = ps.max;
        hist.maximumPt.setLocation(maxX, maxY);
    }

    public static void calcStats(RenderedImage rimg, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int x1, int y1, int x2, int y2, XpPixelStatistics ps) {
        XpImageUtils.calcStats(rimg, bitimg, rescaleSlope, rescaleIntercept, 1, x1, y1, x2, y2, ps);
    }

    public static void calcStats(RenderedImage rimg, BufferedImage bitimg, double rescaleSlope, double rescaleIntercept, int pixelRepresentation, int x1, int y1, int x2, int y2, XpPixelStatistics ps) {
        int width = Math.min(rimg.getWidth(), bitimg.getWidth());
        int height = Math.min(rimg.getHeight(), bitimg.getHeight());
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 >= width) {
            x2 = width - 1;
        }
        if (y2 >= height) {
            y2 = height - 1;
        }
        int RBLEN = width / 8;
        if (width % 8 != 0) {
            ++RBLEN;
        }
        ps.resetStatistics();
        int bx1 = Integer.MAX_VALUE;
        int by1 = Integer.MAX_VALUE;
        int bx2 = Integer.MIN_VALUE;
        int by2 = Integer.MIN_VALUE;
        Raster r2 = XpImageUtils.getRaster(rimg);
        DataBuffer db = r2.getDataBuffer();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        byte[] bitmap = ((DataBufferByte)bitimg.getRaster().getDataBuffer()).getData();
        if (sdata != null) {
            for (int y3 = y1; y3 <= y2; ++y3) {
                int idx_offset = y3 * RBLEN;
                for (int x3 = x1; x3 <= x2; ++x3) {
                    int pval;
                    int bit = x3 & 7;
                    int idx = idx_offset + x3 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int n2 = pval = pixelRepresentation != 0 ? sdata[offset + y3 * width + x3] : sdata[offset + y3 * width + x3] & 0xFFFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x3 < bx1) {
                        bx1 = x3;
                    }
                    if (y3 < by1) {
                        by1 = y3;
                    }
                    if (x3 > bx2) {
                        bx2 = x3;
                    }
                    if (y3 > by2) {
                        by2 = y3;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += (double)(pval * pval);
                    ++ps.npixels;
                }
            }
        } else if (bdata != null) {
            for (int y4 = y1; y4 <= y2; ++y4) {
                int idx_offset = y4 * RBLEN;
                for (int x4 = x1; x4 <= x2; ++x4) {
                    int bit = x4 & 7;
                    int idx = idx_offset + x4 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int pval = bdata[offset + y4 * width + x4] & 0xFF;
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x4 < bx1) {
                        bx1 = x4;
                    }
                    if (y4 < by1) {
                        by1 = y4;
                    }
                    if (x4 > bx2) {
                        bx2 = x4;
                    }
                    if (y4 > by2) {
                        by2 = y4;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += (double)(pval * pval);
                    ++ps.npixels;
                }
            }
        } else if (idata != null) {
            for (int y5 = y1; y5 <= y2; ++y5) {
                int idx_offset = y5 * RBLEN;
                for (int x5 = x1; x5 <= x2; ++x5) {
                    int bit = x5 & 7;
                    int idx = idx_offset + x5 / 8;
                    int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx] & 0xFF;
                    if (on == 0) continue;
                    int pval = idata[offset + y5 * width + x5];
                    if ((double)pval < ps.min) {
                        ps.min = pval;
                    }
                    if ((double)pval > ps.max) {
                        ps.max = pval;
                    }
                    if (x5 < bx1) {
                        bx1 = x5;
                    }
                    if (y5 < by1) {
                        by1 = y5;
                    }
                    if (x5 > bx2) {
                        bx2 = x5;
                    }
                    if (y5 > by2) {
                        by2 = y5;
                    }
                    ps.sum += (double)pval;
                    ps.sumSq += (double)(pval * pval);
                    ++ps.npixels;
                }
            }
        }
        ps.bounds.setBounds(bx1, by1, bx2 - bx1, by2 - by1);
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = rescaleSlope * ps.mean + rescaleIntercept;
        ps.max = rescaleSlope * ps.max + rescaleIntercept;
        ps.min = rescaleSlope * ps.min + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
    }

    public static XpPixelStatistics calcStats(J3DVolumeModel jvm, int subSample, XpPixelStatistics ps) {
        double rescaleSlope = jvm.j_vol.rescaleSlope;
        double rescaleIntercept = jvm.j_vol.rescaleIntercept;
        if (ps == null) {
            ps = new XpPixelStatistics();
        }
        ps.resetStatistics();
        int dx = jvm.j_vol.dx;
        int dy = jvm.j_vol.dy;
        int dz = jvm.j_vol.dz;
        int offset = jvm.j_vol.PAD;
        short[] sdata = null;
        byte[] bdata = null;
        Object idata = null;
        if (jvm.j_vol instanceof JVolume.LinearShort) {
            sdata = ((JVolume.LinearShort)jvm.j_vol).volume;
        } else if (jvm.j_vol instanceof JVolume.LinearByte) {
            bdata = ((JVolume.LinearByte)jvm.j_vol).volume;
        }
        ps.min = Double.MAX_VALUE;
        ps.max = Double.MIN_VALUE;
        int pgsize = dy * dx;
        if (sdata != null) {
            for (int z2 = 0; z2 < dz; z2 += subSample) {
                for (int y2 = 0; y2 < dy; y2 += subSample) {
                    for (int x2 = 0; x2 < dx; x2 += subSample) {
                        short pval = sdata[offset + z2 * pgsize + y2 * dx + x2];
                        if ((double)pval < ps.min) {
                            ps.min = pval;
                        }
                        if ((double)pval > ps.max) {
                            ps.max = pval;
                        }
                        ps.sumSq += (double)(pval * pval);
                        ps.sum += (double)pval;
                        ++ps.npixels;
                    }
                }
            }
        } else if (bdata != null) {
            for (int z3 = 0; z3 < dz; z3 += subSample) {
                for (int y3 = 0; y3 < dy; y3 += subSample) {
                    for (int x3 = 0; x3 < dx; x3 += subSample) {
                        int pval = bdata[offset + z3 * pgsize + y3 * dx + x3] & 0xFF;
                        if ((double)pval < ps.min) {
                            ps.min = pval;
                        }
                        if ((double)pval > ps.max) {
                            ps.max = pval;
                        }
                        ps.sumSq += (double)(pval * pval);
                        ps.sum += (double)pval;
                        ++ps.npixels;
                    }
                }
            }
        }
        ps.min = ps.min == Double.MAX_VALUE ? 0.0 : ps.min;
        ps.max = ps.max == Double.MIN_VALUE ? 0.0 : ps.max;
        ps.mean = ps.npixels != 0 ? ps.sum / (double)ps.npixels : 0.0;
        ps.mean = ps.mean * rescaleSlope + rescaleIntercept;
        ps.max = ps.max * rescaleSlope + rescaleIntercept;
        ps.min = ps.min * rescaleSlope + rescaleIntercept;
        ps.sumSq = XpImageUtils.square(rescaleSlope) * ps.sumSq + 2.0 * rescaleSlope * rescaleIntercept * ps.sum + (double)ps.npixels * XpImageUtils.square(rescaleIntercept);
        ps.sum = rescaleSlope * ps.sum + (double)ps.npixels * rescaleIntercept;
        ps.diffsumSq = (double)ps.npixels * ps.mean * ps.mean - 2.0 * ps.mean * ps.sum + ps.sumSq;
        ps.variance = ps.npixels > 1 ? ps.diffsumSq / (double)(ps.npixels - 1) : 0.0;
        return ps;
    }

    public static Object getPixelValue(RenderedImage rimg, int x2, int y2) {
        Number pixelvalue = null;
        DataBuffer db = rimg.getData().getDataBuffer();
        int imageWidth = rimg.getWidth();
        int offset = db.getOffset();
        short[] sdata = null;
        byte[] bdata = null;
        int[] idata = null;
        if (db instanceof DataBufferUShort) {
            sdata = ((DataBufferUShort)db).getData();
            pixelvalue = sdata[offset + y2 * imageWidth + x2];
        } else if (db instanceof DataBufferShort) {
            sdata = ((DataBufferShort)db).getData();
            pixelvalue = sdata[offset + y2 * imageWidth + x2];
        } else if (db instanceof DataBufferByte) {
            bdata = ((DataBufferByte)db).getData();
            pixelvalue = bdata[offset + y2 * imageWidth + x2];
        } else if (db instanceof DataBufferInt) {
            idata = ((DataBufferInt)db).getData();
            pixelvalue = idata[offset + y2 * imageWidth + x2];
        }
        return pixelvalue;
    }

    private XpImageUtils() {
    }

    public static double parseImageWL(Object obj) {
        double deflevel = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == deflevel) {
            deflevel = -32767.0;
            XpLog.fine("Could not parse window level");
        }
        return deflevel;
    }

    public static double parseImageWW(Object obj) {
        double defwidth = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == defwidth) {
            defwidth = -1.0;
            XpLog.fine("Could not parse window width");
        }
        return defwidth;
    }

    public static double parseImageRescaleIntercept(Object obj) {
        double rescaleIntercept = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == rescaleIntercept) {
            rescaleIntercept = 0.0;
            XpLog.fine("Could not parse rescale intercept, using default");
        }
        return rescaleIntercept;
    }

    public static double parseImageRescaleSlope(Object obj) {
        double rescaleSlope = XpImageUtils.parseValue(obj);
        if (Double.NEGATIVE_INFINITY == rescaleSlope) {
            rescaleSlope = 1.0;
            XpLog.fine("Could not parse rescale slope, using default");
        }
        return rescaleSlope;
    }

    private static double parseValue(Object obj) {
        double value = Double.NEGATIVE_INFINITY;
        if (null != obj) {
            try {
                if (obj instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)obj, "\\");
                    String token = st.nextToken();
                    value = Double.parseDouble(token);
                } else if (obj instanceof Number) {
                    value = ((Number)obj).doubleValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static class ImagePanel
    extends JPanel {
        private RenderedImage image = null;

        public ImagePanel(RenderedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            g22.drawRenderedImage(this.image, null);
        }
    }

    public static final class PixelDiff {
        public long[] diff = null;
        public double[] rms = null;
        public int nbanks = 0;

        public PixelDiff(int nBanks) {
            this.nbanks = nBanks;
            this.diff = new long[this.nbanks];
            this.rms = new double[this.nbanks];
        }

        public String toString() {
            int i2;
            String str = "absdiff=[";
            for (i2 = 0; i2 < this.nbanks; ++i2) {
                str = str + this.diff[i2];
                if (i2 >= this.nbanks - 1) continue;
                str = str + ",";
            }
            str = str + "]";
            str = str + "  rms=[";
            for (i2 = 0; i2 < this.nbanks; ++i2) {
                str = str + this.rms[i2];
                if (i2 >= this.nbanks - 1) continue;
                str = str + ",";
            }
            str = str + "]";
            return str;
        }
    }
}

