/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Vector;

public final class XpPNMReaderWriter {
    private Vector v = null;
    private String fileFormat = null;
    private int width = 0;
    private int height = 0;
    private RenderedImage renderImage = null;
    private RenderedImage[] array_rImages = null;
    public RenderedImage testImage = null;

    public RenderedImage[] getRenderImages(String[] fileList) {
        if (fileList != null) {
            int noFiles = fileList.length;
            this.array_rImages = new RenderedImage[noFiles];
            for (int i2 = 0; i2 < noFiles; ++i2) {
                this.array_rImages[i2] = this.getRenderImage(fileList[i2]);
            }
            return this.array_rImages;
        }
        return null;
    }

    public void displayPNMfiles(String[] fileList) {
        if (fileList != null) {
            int noFiles = fileList.length;
            for (int i2 = 0; i2 < noFiles; ++i2) {
                this.displayPNMfile(fileList[i2]);
            }
        } else {
            System.out.println("fileList is Null");
        }
    }

    public void displayPNMfile(String dirPath) {
        String filename = null;
        filename = this.checkDirectory(dirPath) ? this.getFileFromDirectoy(dirPath) : dirPath;
        this.extractFileformat(filename);
        try {
            if (this.fileFormat.equals("P6")) {
                this.displayPNM_6(filename);
            } else if (this.fileFormat.equals("P3")) {
                this.displayPNM_P3(filename);
            } else {
                System.out.println("UNKNOWN FILE FORMAT: " + filename);
            }
        }
        catch (Exception e2) {
            System.out.println("readPNMfiles Exception:" + e2.getMessage());
        }
    }

    private void displayPNM_6(String filename) {
        RenderedImage img = this.getRenderImage_P6(filename);
        XpImageUtils.displayImage(img);
    }

    private void displayPNM_P3(String filename) {
        RenderedImage rImg = this.getRenderImage_P3(filename);
        XpImageUtils.displayImage(rImg, "PNM READER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFileformat(String filename) {
        String line = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader lnr = null;
        try {
            fis = new FileInputStream(filename);
            isr = new InputStreamReader(fis);
            lnr = new LineNumberReader(isr);
            line = ((LineNumberReader)lnr).readLine();
            String[] fields = line.split("\\s+");
            System.out.println("File Format:" + fields[0]);
            this.fileFormat = fields[0];
            line = ((LineNumberReader)lnr).readLine();
            fields = line.split("\\s+");
            System.out.println("WIDTH  :" + fields[0]);
            System.out.println("HEIGHT :" + fields[1]);
            this.width = Integer.parseInt(fields[0]);
            this.height = Integer.parseInt(fields[1]);
        }
        catch (Exception e2) {
            System.out.println("extractFileformat:Exception " + e2.getMessage());
            System.out.println("Exiting");
            System.exit(0);
        }
        finally {
            if (lnr != null) {
                try {
                    lnr.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
        }
    }

    public RenderedImage getRenderImage(String dirPath) {
        String filename = null;
        filename = this.checkDirectory(dirPath) ? this.getFileFromDirectoy(dirPath) : dirPath;
        this.extractFileformat(filename);
        try {
            if (this.fileFormat.equals("P6")) {
                return this.getRenderImage_P6(filename);
            }
            if (this.fileFormat.equals("P3")) {
                return this.getRenderImage_P3(filename);
            }
            System.out.println("UNKNOWN FILE FORMAT: " + filename);
        }
        catch (Exception e2) {
            System.out.println("readPNMfiles Exception:" + e2.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage getRenderImage_P6(String dirPath) {
        FileInputStream ft = null;
        try {
            byte[] arrayByte = null;
            Object img = null;
            Object rImg = null;
            int[] pixels = null;
            String filename = null;
            filename = this.checkDirectory(dirPath) ? this.getFileFromDirectoy(dirPath) : dirPath;
            File f2 = new File(filename);
            ft = new FileInputStream(f2);
            arrayByte = new byte[ft.available()];
            pixels = new int[ft.available()];
            int size = ft.available();
            int count = ft.read(arrayByte, 0, size);
            int pixIndex = 0;
            for (int k2 = 0; k2 < size - 3; k2 += 3) {
                int r2 = arrayByte[k2] & 0xFF;
                int g2 = arrayByte[k2 + 1] & 0xFF;
                int b2 = arrayByte[k2 + 2] & 0xFF;
                pixels[pixIndex++] = r2 << 16 | g2 << 8 | b2;
            }
            DirectColorModel model = new DirectColorModel(24, 0xFF0000, 65280, 255);
            int[] bandmasks = new int[3];
            DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
            bandmasks[0] = model.getRedMask();
            bandmasks[1] = model.getGreenMask();
            bandmasks[2] = model.getBlueMask();
            WritableRaster raster = Raster.createPackedRaster(buffer, 256, 256, 256, bandmasks, null);
            BufferedImage image = new BufferedImage(model, raster, false, null);
            this.renderImage = image;
        }
        catch (Exception e2) {
            System.out.println("Exception");
            e2.printStackTrace();
        }
        finally {
            if (ft != null) {
                try {
                    ft.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return this.renderImage;
    }

    private RenderedImage getRenderImage_P3(String dirPath) {
        int width = 0;
        int height = 0;
        byte[] arrayData = null;
        Object img = null;
        int[] pixels = null;
        int size = 0;
        int skipHeader = 4;
        String filename = null;
        filename = this.checkDirectory(dirPath) ? this.getFileFromDirectoy(dirPath) : dirPath;
        try {
            this.readData(filename);
        }
        catch (Exception e2) {
            System.out.println("Exception displayPNM_P3 :" + e2.getMessage());
        }
        size = this.v.size();
        arrayData = new byte[this.v.size()];
        for (int i2 = skipHeader; i2 < this.v.size(); ++i2) {
            arrayData[i2 - 4] = (byte)Integer.parseInt((String)this.v.get(i2));
        }
        width = Integer.parseInt((String)this.v.get(1));
        height = Integer.parseInt((String)this.v.get(2));
        pixels = new int[this.v.size()];
        int count = 0;
        for (int j2 = 0; j2 < this.v.size() - 3; j2 += 3) {
            int r2 = arrayData[j2] & 0xFF;
            int g2 = arrayData[j2 + 1] & 0xFF;
            int b2 = arrayData[j2 + 2] & 0xFF;
            pixels[count++] = 0xFF000000 | r2 << 16 | g2 << 8 | b2;
        }
        DirectColorModel model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        int[] bandmasks = new int[3];
        DataBufferInt buffer = new DataBufferInt(pixels, pixels.length);
        bandmasks[0] = model.getRedMask();
        bandmasks[1] = model.getGreenMask();
        bandmasks[2] = model.getBlueMask();
        WritableRaster raster = Raster.createPackedRaster(buffer, 256, 256, 256, bandmasks, null);
        BufferedImage image = new BufferedImage(model, raster, false, null);
        this.renderImage = image;
        return this.renderImage;
    }

    private Vector readData(String filename) throws IOException {
        String line = "";
        int nLine = 0;
        Vector<String> vector = new Vector<String>();
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader(fis);
        LineNumberReader lnr = new LineNumberReader(isr);
        int size = fis.available();
        while ((line = lnr.readLine()) != null) {
            String[] fields = line.split("\\s+");
            for (int index = 0; index < fields.length; ++index) {
                vector.addElement(fields[index]);
            }
            ++nLine;
        }
        this.v = vector;
        lnr.close();
        isr.close();
        fis.close();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePNM(String fileName, BufferedImage img) {
        FileOutputStream fileWriter = null;
        int width = img.getWidth();
        int height = img.getHeight();
        DataBuffer db = img.getRaster().getDataBuffer();
        int[] buff = new int[db.getSize()];
        buff = ((DataBufferInt)db).getData();
        String maxVal = new String("255");
        int skipHeader = 0;
        try {
            fileWriter = new FileOutputStream(fileName);
            String str = new String("P6");
            byte[] buf = str.getBytes();
            fileWriter.write(buf);
            str = "\n";
            buf = str.getBytes();
            fileWriter.write(buf);
            str = "" + width;
            buf = str.getBytes();
            fileWriter.write(buf);
            str = " ";
            buf = str.getBytes();
            fileWriter.write(buf);
            str = "" + height + "\n";
            buf = str.getBytes();
            fileWriter.write(buf);
            str = maxVal + "\n";
            buf = str.getBytes();
            fileWriter.write(buf);
            for (int i2 = skipHeader; i2 < db.getSize(); ++i2) {
                int pixVal = buff[i2];
                int r2 = pixVal >> 16 & 0xFF;
                int g2 = pixVal >> 8 & 0xFF;
                int b2 = pixVal & 0xFF;
                fileWriter.write(r2);
                fileWriter.write(g2);
                fileWriter.write(b2);
            }
            str = "\n";
            buf = str.getBytes();
            fileWriter.write(buf);
        }
        catch (Exception e2) {
            System.out.println("Exception in Writing");
            e2.printStackTrace();
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePNM_P3(String fileName, BufferedImage img) {
        FileOutputStream fileWriter = null;
        BufferedWriter bufWriter = null;
        int width = img.getWidth();
        int height = img.getHeight();
        DataBuffer db = img.getRaster().getDataBuffer();
        int[] buff = new int[db.getSize()];
        buff = ((DataBufferInt)db).getData();
        String maxVal = new String("255");
        int skipHeader = 0;
        try {
            fileWriter = new FileOutputStream(fileName);
            bufWriter = new BufferedWriter(new OutputStreamWriter(fileWriter));
            bufWriter.write("P3");
            bufWriter.newLine();
            bufWriter.write("256");
            bufWriter.write(" ");
            bufWriter.write("256");
            bufWriter.write(" ");
            bufWriter.newLine();
            bufWriter.write("255");
            bufWriter.newLine();
            for (int i2 = skipHeader; i2 < db.getSize(); ++i2) {
                int pixVal = buff[i2];
                int r2 = pixVal >> 16 & 0xFF;
                int g2 = pixVal >> 8 & 0xFF;
                int b2 = pixVal & 0xFF;
                bufWriter.write(String.valueOf(r2));
                bufWriter.write(" ");
                bufWriter.write(String.valueOf(g2));
                bufWriter.write(" ");
                bufWriter.write(String.valueOf(b2));
                bufWriter.write(" ");
            }
            bufWriter.newLine();
        }
        catch (Exception e2) {
            System.out.println("Exception in Writing");
            e2.printStackTrace();
        }
        finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    public static XpImageUtils.PixelDiff diff(BufferedImage op1, BufferedImage op2, BufferedImage res) {
        int type1 = op1.getType();
        int type2 = op2.getType();
        int typer = res.getType();
        int[] buff1 = null;
        int[] buff2 = null;
        int[] out = null;
        DataBuffer db1 = op1.getRaster().getDataBuffer();
        DataBuffer db2 = op2.getRaster().getDataBuffer();
        DataBuffer dbr = res.getRaster().getDataBuffer();
        XpImageUtils.PixelDiff ps = new XpImageUtils.PixelDiff(3);
        if (type1 == 1 && type2 == 1) {
            buff1 = null;
            buff2 = null;
            out = ((DataBufferInt)dbr).getData();
        }
        if (type1 == 1 | type1 == 2) {
            buff1 = ((DataBufferInt)db1).getData();
        }
        if (type2 == 1 | type2 == 2) {
            buff2 = ((DataBufferInt)db2).getData();
        }
        System.out.println("BUFF1 LENGTH " + (buff1 != null ? Integer.valueOf(buff1.length) : "null"));
        System.out.println("BUFF2 LENGTH " + (buff2 != null ? Integer.valueOf(buff2.length) : "null"));
        if (buff1 != null && buff2 != null) {
            for (int i2 = 0; i2 < buff1.length; ++i2) {
                int pixVal = buff1[i2];
                int r1 = pixVal >> 16 & 0xFF;
                int g1 = pixVal >> 8 & 0xFF;
                int b1 = pixVal & 0xFF;
                int pixVal2 = buff2[i2];
                int r2 = pixVal2 >> 16 & 0xFF;
                int g2 = pixVal2 >> 8 & 0xFF;
                int b2 = pixVal2 & 0xFF;
                int dr = r2 - r1;
                int dg = g2 - g1;
                int db = b2 - b1;
                int sdr = dr * dr;
                int sdg = dg * dg;
                int sdb = db * db;
                int adr = Math.abs(dr);
                int adg = Math.abs(dg);
                int adb = Math.abs(db);
                ps.diff[0] = ps.diff[0] + (long)adr;
                ps.diff[1] = ps.diff[1] + (long)adg;
                ps.diff[2] = ps.diff[2] + (long)adb;
                ps.rms[0] = ps.rms[0] + (double)sdr;
                ps.rms[1] = ps.rms[1] + (double)sdg;
                ps.rms[2] = ps.rms[2] + (double)sdb;
            }
            ps.rms[0] = Math.sqrt(ps.rms[0] / (double)buff2.length);
            ps.rms[1] = Math.sqrt(ps.rms[1] / (double)buff2.length);
            ps.rms[2] = Math.sqrt(ps.rms[2] / (double)buff2.length);
        }
        return ps;
    }

    public boolean checkDirectory(String dirPath) {
        File fis = new File(dirPath);
        return fis.isDirectory();
    }

    private String getFileFromDirectoy(String dirPath) {
        File fis = new File(dirPath);
        String line = null;
        String[] fileExnt = null;
        if (fis.isDirectory()) {
            int length = (int)fis.length();
            String[] files = fis.list();
            for (int i2 = 0; i2 < files.length; ++i2) {
                line = files[i2];
                fileExnt = line.split("\\.");
                if (fileExnt[1].compareTo("pnm") != 0) continue;
                System.out.println("Gvtk pattern File Name " + dirPath + "/" + files[i2]);
                return dirPath + "/" + files[i2];
            }
        } else {
            return null;
        }
        return null;
    }
}

