/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class XpPropertiesManager {
    private static Properties prop;

    private XpPropertiesManager() {
    }

    public static void loadPropertyValues(String propertyFile) {
        InputStream is = XpPropertiesManager.class.getResourceAsStream(propertyFile);
        XpPropertiesManager.loadPropertyValues(is);
    }

    public static void loadPropertyValues(InputStream is) {
        try {
            prop.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XpLog.logger().warning("Cannot load property file...");
        }
    }

    private static void loadPropertyValues() {
        XpPropertiesManager.loadPropertyValues("jami.properties");
    }

    public static String getProperty(String propName) {
        return XpPropertiesManager.getProperty(propName, null);
    }

    private static String pad(String content, int len) {
        int clen = content.length();
        if (clen < len) {
            int dlen = len - clen;
            char[] spaces = new char[dlen];
            Arrays.fill(spaces, ' ');
            String space = new String(spaces);
            return content + space;
        }
        return content;
    }

    public static void printProperties() {
        Set<Map.Entry<Object, Object>> s2 = prop.entrySet();
        for (Map.Entry<Object, Object> o2 : s2) {
            String key = "" + o2.getKey();
            String val = "" + o2.getValue();
            if (!key.startsWith("jami.")) continue;
            System.err.println(XpPropertiesManager.pad(key, 34) + ": " + val);
        }
    }

    public static void setProperty(String propName, String value) {
        prop.setProperty(propName, value);
        XpLog.logger().finer("Setting Key=" + propName + "  Value=" + value);
    }

    public static String getProperty(String propName, String defaultValue) {
        String value = prop.getProperty(propName, defaultValue);
        if (value == null) {
            try {
                value = System.getProperty(propName, defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        XpLog.logger().finer("Key=" + propName + "  Value=" + value);
        return value;
    }

    public static Object create(String typeName) {
        Object obj = null;
        Class cl = XpPropertiesManager.getClass(typeName);
        if (cl != null) {
            try {
                Class<?>[] paramType = null;
                Constructor c2 = cl.getConstructor(paramType);
                if (c2 != null) {
                    Object[] args = null;
                    obj = c2.newInstance(args);
                }
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        } else {
            XpLog.logger().warning("JAMI: Error looking implementation " + typeName);
        }
        return obj;
    }

    public static Class getClass(String className) {
        try {
            Class<?> c2 = Class.forName(className);
            if (c2 != null) {
                XpLog.logger().config("Created object of type: [" + className + "].");
                return c2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            XpLog.logger().severe("Class not found: " + className);
            XpLog.logger().severe(e2.getMessage());
        }
        return null;
    }

    public static int[] parseIntList(String value, String delims) {
        ArrayList<String> l2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delims);
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            l2.add(val);
        }
        int[] ivals = new int[l2.size()];
        for (int i2 = 0; i2 < l2.size(); ++i2) {
            String val = (String)l2.get(i2);
            ivals[i2] = Integer.parseInt(val);
        }
        return ivals;
    }

    public static double[] parseDoubleList(String value, String delims) {
        ArrayList<String> l2 = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, delims);
        while (st.hasMoreTokens()) {
            String val = st.nextToken();
            l2.add(val);
        }
        double[] dvals = new double[l2.size()];
        for (int i2 = 0; i2 < l2.size(); ++i2) {
            String val = (String)l2.get(i2);
            dvals[i2] = Double.parseDouble(val);
        }
        return dvals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String printprops;
        String upropname;
        prop = null;
        prop = new Properties();
        XpPropertiesManager.loadPropertyValues();
        try {
            Properties sprop = System.getProperties();
            Set<Map.Entry<Object, Object>> s2 = sprop.entrySet();
            for (Map.Entry<Object, Object> pe : s2) {
                String key = (String)pe.getKey();
                String value = (String)pe.getValue();
                prop.setProperty(key, value);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if ((upropname = XpPropertiesManager.getProperty("jami.properties")) != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(upropname);
                try {
                    prop.load(fis);
                }
                catch (IOException ex) {
                    XpLog.warning("Cannot read user property file: " + upropname);
                }
            }
            catch (FileNotFoundException ex) {
                XpLog.warning("Cannot find user property file: " + upropname);
            }
            finally {
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioex) {
                        XpLog.warning("Cannot close user property file: " + upropname);
                    }
                }
            }
        }
        if ((printprops = XpPropertiesManager.getProperty("jami.printproperties")) != null && printprops.toUpperCase().equals("TRUE")) {
            try {
                prop.store(System.out, "JAMI System Properties");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

