/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;

public class XpSliceCollection
extends XpVisualComponent
implements PropertyChangeListener,
Serializable {
    public static final String SLICENO = "SliceNo";
    private ArrayList slices = new ArrayList();
    private XpSlice imageSlice = null;
    private Point2D[] segments;
    private boolean invalid = true;
    private int index = 0;
    private CPoint imgPt = new CPoint(0);
    private CPoint dispPt = new CPoint(1);
    private Point dp1 = new Point();
    private Point dp2 = new Point();
    private String lineStyle = "DOTTED";
    private int oldValue = this.index;
    private Integer newIndex = new Integer("0");
    private int newValue = 0;
    private XpSliceCollection myComp;
    private AffineTransform inv = new AffineTransform();
    private XpGeomUtils gu = new XpGeomUtils();
    private int sliceIncrementer = 1;
    private int sliceStartindex = 0;
    private int numberingPos = 0;
    private Color choiceSelectedColor = Color.red;
    private Color choiceunSelectedColor = Color.cyan;

    public XpSliceCollection() {
        this.addMouseListener(new sliceMouseListener(this));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().compareTo("FrameIndex") == 0) {
            this.newIndex = (Integer)e2.getNewValue();
            this.newValue = this.newIndex;
            this.repaint();
        }
    }

    public final XpSlice getImageSlice() {
        return this.imageSlice;
    }

    public void setImageSlice(XpSlice s2) {
        this.imageSlice = s2;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        XpVisualComponent parent = this.getXpVisualComponentParent();
        if (parent instanceof XpImage2DVc) {
            XpImage image = ((XpImage2DVc)parent).getFrame();
            if (image == null) {
                return;
            }
            XpSlice slice = image.getSlice();
            this.setImageSlice(slice);
        } else {
            this.setImageSlice(new XpSlice(new CPoint(-10.0, 0.0, -10.0, 2), new CPoint(10.0, 0.0, -10.0, 2), new CPoint(10.0, 0.0, 10.0, 2)));
        }
    }

    public void addSlice(XpSlice s2) {
        this.slices.add(s2);
        this.invalid = true;
    }

    public void removeAllSlices() {
        this.slices.clear();
    }

    public final int getNumberOfSlices() {
        return this.slices.size();
    }

    final void line(Graphics g2, Point2D p0, Point2D p1, int offset) {
        g2.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int i2;
        Graphics2D g2 = (Graphics2D)graphics;
        CTransform t2 = this.getTransform((byte)0, (byte)1);
        if (t2 != null) {
            AffineTransform at = t2.getTransform2D();
            this.gu.calcInverse(at, this.inv);
            g2.transform(at);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.invalid && this.imageSlice != null) {
            if (this.slices.size() > 0) {
                this.segments = new Point2D[2 * this.slices.size()];
                for (i2 = 0; i2 < this.slices.size(); ++i2) {
                    XpSlice s2 = (XpSlice)this.slices.get(i2);
                    Point2D[] p2 = this.imageSlice.getIntersection(s2);
                    this.segments[2 * i2] = p2[0];
                    this.segments[2 * i2 + 1] = p2[1];
                }
            } else {
                this.segments = null;
            }
            this.invalid = false;
        }
        g2.setColor(Color.black);
        if (this.segments != null) {
            for (i2 = this.sliceStartindex; i2 < this.slices.size(); i2 += this.sliceIncrementer) {
                if (this.lineStyle == null) continue;
                if (this.lineStyle.compareTo("SOLID") == 0) {
                    this.line(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 1);
                    continue;
                }
                if (this.lineStyle.compareTo("DOTTED") != 0) continue;
                this.drawDottedLine(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 1);
            }
            for (i2 = this.sliceStartindex; i2 < this.slices.size(); i2 += this.sliceIncrementer) {
                if (i2 == this.newValue) {
                    g2.setColor(this.choiceSelectedColor);
                    this.drawsliceNumber(g2, i2, (int)this.segments[2 * i2 + this.numberingPos].getX(), (int)this.segments[2 * i2 + this.numberingPos].getY());
                    if (this.lineStyle != null) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            this.line(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 0);
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            this.drawDottedLine(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 0);
                        }
                    }
                } else {
                    g2.setColor(this.choiceunSelectedColor);
                    this.drawsliceNumber(g2, i2, (int)this.segments[2 * i2 + this.numberingPos].getX(), (int)this.segments[2 * i2 + this.numberingPos].getY());
                    if (this.lineStyle != null) {
                        if (this.lineStyle.compareTo("SOLID") == 0) {
                            this.line(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 0);
                        } else if (this.lineStyle.compareTo("DOTTED") == 0) {
                            this.drawDottedLine(g2, this.segments[2 * i2], this.segments[2 * i2 + 1], 0);
                        }
                    }
                }
                this.numberingPos = this.numberingPos == 0 ? 1 : 0;
            }
        }
        g2.setTransform(this.inv);
    }

    public void drawsliceNumber(Graphics2D g2, int index, int xPos, int yPos) {
        int fontStyle = Integer.parseInt(System.getProperty("jami.xpslicecollection.font.style", "5"));
        int fontSize = Integer.parseInt(System.getProperty("jami.xpslicecollection.font.size", "6"));
        g2.setFont(new Font("", fontStyle, fontSize));
        g2.drawString(String.valueOf(index), xPos, yPos);
    }

    public void drawDottedLine(Graphics2D g2, Point2D p0, Point2D p1, int offset) {
        float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
        g2.drawLine(offset + (int)p0.getX(), offset + (int)p0.getY(), offset + (int)p1.getX(), offset + (int)p1.getY());
    }

    @Override
    public boolean contains(int x2, int y2) {
        int x1 = x2 - 6;
        int x22 = x2 + 6;
        int y1 = y2 - 6;
        int y22 = y2 + 6;
        CTransform ctc = this.getTransform((byte)0, (byte)1);
        for (int i2 = this.sliceStartindex; i2 < this.slices.size(); i2 += this.sliceIncrementer) {
            if (this.segments == null) {
                return false;
            }
            this.imgPt.setPoint((int)this.segments[2 * i2].getX(), (int)this.segments[2 * i2].getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp1.setLocation(this.dispPt.x, this.dispPt.y);
            this.imgPt.setPoint((int)this.segments[2 * i2 + 1].getX(), (int)this.segments[2 * i2 + 1].getY(), 0.0, (byte)0);
            ctc.transform(this.imgPt, this.dispPt);
            this.dp2.setLocation(this.dispPt.x, this.dispPt.y);
            if (!this.intersects(x1, y1, x22, y22, this.dp1.x, this.dp1.y, this.dp2.x, this.dp2.y)) continue;
            this.index = i2;
            return true;
        }
        return false;
    }

    private boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return true;
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    public void setlineStyle(String style) {
        this.lineStyle = style;
    }

    public void setSelectedlineColor(Color c2) {
        this.choiceSelectedColor = c2;
    }

    public void setUnSelectedlineColor(Color c2) {
        this.choiceunSelectedColor = c2;
    }

    class sliceMouseListener
    implements MouseListener {
        public sliceMouseListener(XpSliceCollection outerComp) {
            XpSliceCollection.this.myComp = outerComp;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            XpSliceCollection.this.myComp.validate();
            XpSliceCollection.this.myComp.repaint();
            XpSliceCollection.this.newValue = XpSliceCollection.this.index;
            XpSliceCollection.this.firePropertyChange(XpSliceCollection.SLICENO, XpSliceCollection.this.oldValue, XpSliceCollection.this.newValue);
            XpSliceCollection.this.oldValue = XpSliceCollection.this.newValue;
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }
    }
}

