/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSelectableOwner;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.FrameOwner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.text.Caret;

public class XpUserAnnotationVc
extends XpVisualComponent
implements MouseInputListener,
XpSelectableOwner {
    public static final int CARET_POLICY_LASTPOS = 800;
    public static final int CARET_POLICY_AT_END = 801;
    private static Border blackBorder;
    private static final Cursor PRESELECT_CURSOR;
    private static final int INSIDE_NONE = 0;
    private static final int INSIDE_MOVE = 1;
    private static final int INSIDE_TARGET = 2;
    private static final int INSIDE_RESIZE = 3;
    private static final int INSIDE_LINE = 4;
    private static int TARGET_WIDTH;
    private static int TARGET_HEIGHT;
    private static int uavc_id;
    private static Shape CIRCLE_SHAPE;
    private static Rectangle2D resizeRect;
    private static Color handleColor;
    private static Dimension minSize;
    private static int caretPolicy;
    private static boolean dohighlight;
    private Font defaultFont = null;
    private UAnnoTextArea _textArea = new UAnnoTextArea(" ");
    private UserAnnotationLayout _ual = null;
    private XpUserAnnotationModel _uam = null;
    private CPoint tmpPoint1 = new CPoint();
    private CPoint tmpPoint2 = new CPoint();
    private CPoint dispAnchorPt = new CPoint(1);
    private CPoint dispTargetPt = new CPoint(1);
    private CPoint dispMidAnchorPt = new CPoint(1);
    private CPoint _dragV = new CPoint();
    private CPoint _cp0 = new CPoint();
    private CPoint _cp1 = new CPoint();
    private CPoint imgTarget = new CPoint(0);
    private int _insideCode = 0;
    private int dragCode = 0;
    private Point pMouse = null;
    private Point initMouse = null;
    private Dimension initTxtBoxDim = new Dimension();
    private Point tbPoint = new Point(0, 0);
    private Caret caret = null;
    private int caretPosition = 0;
    private boolean editMute = false;
    private Shape pointerShape = CIRCLE_SHAPE;
    private AffineTransform at = new AffineTransform();
    private Selectable[] sel = new Selectable[1];
    private static final Point2D ARROW_TIP1;
    private static final Point2D ARROW_TIP2;
    private Point2D tempPt1 = new Point2D.Double();
    private Rectangle2D domain = null;
    private CPoint temp = new CPoint(0);
    private CPoint anchorpt = new CPoint();
    private CPoint tmpptMA = new CPoint();
    private CPoint tmpptMT = new CPoint();
    private CPoint targetpt = new CPoint();

    public XpUserAnnotationVc(XpUserAnnotationModel uam) {
        this.setName("XpUserAnnotationVc_" + uavc_id);
        ++uavc_id;
        this.defaultFont = this._textArea.getFont();
        this._textArea.setMinimumSize(minSize);
        this._textArea.addMouseListener(this);
        if (!dohighlight) {
            this._textArea.setHighlighter(null);
        }
        this._textArea.setCaretColor(uam.getSelectedColor());
        this._textArea.setForeground(uam.getSelectedColor());
        this._textArea.setBackground(new Color(0, true));
        this._textArea.setBorder(uam.getSelectedBorder());
        this._textArea.setEditable(true);
        this._textArea.setWrapStyleWord(true);
        this.setUserAnnotationModel(uam);
        this._ual = new UserAnnotationLayout();
        this.setLayout(this._ual);
        this.add(this._textArea);
        this._textArea.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void removeListeners(XpUserAnnotationModel uam) {
        EventListener l2;
        int i2;
        List ml = uam.getMouseListeners();
        List mml = uam.getMouseMotionListeners();
        List kl = uam.getKeyListeners();
        List fl = uam.getFocusListeners();
        for (i2 = 0; i2 < ml.size(); ++i2) {
            l2 = (MouseListener)ml.get(i2);
            this.removeMouseListener((MouseListener)l2);
            this._textArea.removeMouseListener((MouseListener)l2);
        }
        for (i2 = 0; i2 < mml.size(); ++i2) {
            l2 = (MouseMotionListener)mml.get(i2);
            this.removeMouseMotionListener((MouseMotionListener)l2);
            this._textArea.removeMouseMotionListener((MouseMotionListener)l2);
        }
        for (i2 = 0; i2 < kl.size(); ++i2) {
            l2 = (KeyListener)kl.get(i2);
            this.removeKeyListener((KeyListener)l2);
            this._textArea.removeKeyListener((KeyListener)l2);
        }
        for (i2 = 0; i2 < fl.size(); ++i2) {
            l2 = (FocusListener)fl.get(i2);
            this.removeFocusListener((FocusListener)l2);
            this._textArea.removeFocusListener((FocusListener)l2);
        }
    }

    private void addListeners(XpUserAnnotationModel uam) {
        EventListener l2;
        int i2;
        List ml = uam.getMouseListeners();
        List mml = uam.getMouseMotionListeners();
        List kl = uam.getKeyListeners();
        List fl = uam.getFocusListeners();
        for (i2 = 0; i2 < ml.size(); ++i2) {
            l2 = (MouseListener)ml.get(i2);
            this.addMouseListener((MouseListener)l2);
            this._textArea.addMouseListener((MouseListener)l2);
        }
        for (i2 = 0; i2 < mml.size(); ++i2) {
            l2 = (MouseMotionListener)mml.get(i2);
            this.addMouseMotionListener((MouseMotionListener)l2);
            this._textArea.addMouseMotionListener((MouseMotionListener)l2);
        }
        for (i2 = 0; i2 < kl.size(); ++i2) {
            l2 = (KeyListener)kl.get(i2);
            this.addKeyListener((KeyListener)l2);
            this._textArea.addKeyListener((KeyListener)l2);
        }
        for (i2 = 0; i2 < fl.size(); ++i2) {
            l2 = (FocusListener)fl.get(i2);
            this.addFocusListener((FocusListener)l2);
            this._textArea.addFocusListener((FocusListener)l2);
        }
    }

    public void setUserAnnotationModel(XpUserAnnotationModel uam) {
        if (uam == this._uam) {
            if (!this._textArea.getLineWrap()) {
                this.updateText(uam);
            }
            this._uam.setUserAnnotationVc(this);
            return;
        }
        if (this._uam != null) {
            Dimension d2 = this._textArea.getSize();
            this._uam.setHeight(d2.getHeight());
            this._uam.setWidth(d2.getWidth());
            this._uam.setText(this._textArea.getText());
        }
        if (this._uam != null) {
            this.removeListeners(this._uam);
            this._uam.setUserAnnotationVc(null);
        }
        this._uam = uam;
        this.addListeners(this._uam);
        this._uam.setUserAnnotationVc(this);
        this._textArea.setText(uam.getText());
        this._textArea.setLocation(0, 0);
        this._textArea.setFont(this.defaultFont);
        double w2 = this._uam.getWidth();
        double h2 = this._uam.getHeight();
        this.resizeTextArea(w2, h2);
    }

    protected void updateText(XpUserAnnotationModel uam) {
        if (uam != null) {
            this._textArea.setText(uam.getText());
            this._textArea.setLocation(0, 0);
            this._textArea.setFont(this.defaultFont);
            double w2 = this._uam.getWidth();
            double h2 = this._uam.getHeight();
            this.resizeTextArea(w2, h2);
        }
    }

    public JTextArea getTextArea() {
        return this._textArea;
    }

    public int getTextAreaRowHeight() {
        return this._textArea.getRowHeight();
    }

    public XpUserAnnotationModel getUserAnnotationModel() {
        return this._uam;
    }

    private void resizeTextArea(Dimension d2) {
        this._textArea.setSize(d2);
    }

    private void resizeTextArea(double w2, double h2) {
        Dimension d2 = new Dimension((int)w2, (int)h2);
        this.resizeTextArea(d2);
    }

    private void line(Graphics2D g2, int x0, int y0, int x1, int y1) {
        int offX = TARGET_WIDTH / 2;
        int offY = TARGET_HEIGHT / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.drawLine(x0 + 1, y0, x1 + 1, y1);
        g2.drawLine(x0, y0 + 1, x1, y1 + 1);
        if (this._uam.isSelected()) {
            g2.setColor(this._uam.getSelectedColor());
        } else {
            g2.setColor(this._uam.getUnselectedColor());
        }
        if (this._uam.isGrayScaleMode()) {
            g2.setColor(Color.WHITE);
        }
        g2.drawLine(x0, y0, x1, y1);
        if (this._uam.getPointerShape() == 0) {
            double tx = x1 - offX;
            double ty = y1 - offY;
            g2.translate(tx, ty);
            g2.fill(CIRCLE_SHAPE);
            g2.translate(-tx, -ty);
        } else {
            double theta = Math.atan2(x1 - x0, y1 - y0);
            Color c2 = g2.getColor();
            g2.translate(1, 1);
            g2.setColor(Color.BLACK);
            this.at.setToIdentity();
            this.at.rotate(-theta);
            this.at.transform(ARROW_TIP1, this.tempPt1);
            g2.drawLine(x1, y1, (int)((double)x1 - this.tempPt1.getX()), (int)((double)y1 - this.tempPt1.getY()));
            this.at.transform(ARROW_TIP2, this.tempPt1);
            g2.drawLine(x1, y1, (int)((double)x1 - this.tempPt1.getX()), (int)((double)y1 - this.tempPt1.getY()));
            g2.translate(-1, -1);
            g2.setColor(c2);
            this.at.setToIdentity();
            this.at.rotate(-theta);
            this.at.transform(ARROW_TIP1, this.tempPt1);
            g2.drawLine(x1, y1, (int)((double)x1 - this.tempPt1.getX()), (int)((double)y1 - this.tempPt1.getY()));
            this.at.transform(ARROW_TIP2, this.tempPt1);
            g2.drawLine(x1, y1, (int)((double)x1 - this.tempPt1.getX()), (int)((double)y1 - this.tempPt1.getY()));
        }
    }

    @Override
    public final void paintChildren(Graphics g2) {
        Font cfont = this._textArea.getFont();
        Font uamFont = this._uam.getFont();
        if (uamFont != null && cfont != uamFont) {
            this._textArea.setFont(uamFont);
        }
        if (this._uam.isSelected()) {
            if (this.editMute) {
                boolean textEditState = this._uam.isEditable();
                this._textArea.setEditable(textEditState);
                if (this.caret != null) {
                    this._textArea.setCaret(this.caret);
                    if (this.caretPosition >= 0 && this.caretPosition <= this._textArea.getText().length()) {
                        if (caretPolicy == 800) {
                            this._textArea.setCaretPosition(this.caretPosition);
                        } else {
                            this._textArea.setCaretPosition(this._textArea.getText().length());
                        }
                    }
                }
                this.editMute = false;
            }
            this._uam.configUserAnnotation();
        } else {
            if (!this.editMute) {
                this.caret = this._textArea.getCaret();
                this.caretPosition = this._textArea.getCaretPosition();
                this.editMute = true;
            }
            this._uam.configUserAnnotation();
        }
        if (XpAppContext.isShadowed() || this._uam.isGrayScaleMode()) {
            this._textArea.setShadowed(true);
            g2.translate(1, 1);
            super.paintChildren(g2);
            g2.translate(-1, -1);
            this._textArea.setShadowed(false);
        }
        super.paintChildren(g2);
    }

    @Override
    public final void paintComponent(Graphics g2) {
        CPoint anchorPt = this._uam.getTextAnchor();
        CTransform t2 = this.getTransform(anchorPt.csystem, (byte)1);
        if (t2 != null) {
            CTransform t22;
            int offX = TARGET_WIDTH / 2;
            int offY = TARGET_HEIGHT / 2;
            boolean selected = this._uam.isSelected();
            Graphics2D g22 = (Graphics2D)g2;
            t2.transform(anchorPt, this.dispAnchorPt);
            int w2 = this._textArea.getWidth();
            int hw = w2 / 2;
            int h2 = this._textArea.getHeight();
            int hh = h2 / 2;
            this._textArea.setMinimumSize(minSize);
            if (selected) {
                g22.setColor(handleColor);
                Shape moveShape = this._uam.getMoveHandleShape(TARGET_WIDTH, TARGET_HEIGHT);
                double tx = this.dispAnchorPt.x - (double)offX;
                double ty = this.dispAnchorPt.y - (double)offY;
                g22.translate(tx, ty);
                if (this._uam.isMoveHandleFilled()) {
                    g22.fill(moveShape);
                } else {
                    g22.draw(moveShape);
                }
                g22.translate(-tx, -ty);
                if (this._uam.isResize()) {
                    Shape resizeShape = this._uam.getResizeHandleShape(TARGET_WIDTH, TARGET_HEIGHT);
                    g22.translate(tx + (double)w2, ty + (double)h2);
                    if (this._uam.isResizeHandleFilled()) {
                        g22.fill(resizeShape);
                    } else {
                        g22.draw(resizeShape);
                    }
                    g22.translate(-(tx + (double)w2), -(ty + (double)h2));
                }
            }
            if ((t22 = this.getTransform(this._uam.getTarget().csystem, (byte)1)) != null) {
                this.imgTarget.setPoint(this._uam.getTarget());
                t22.transform(this.imgTarget, this.dispTargetPt);
            }
            boolean inTextBox = this.validateTargetMovement(this.dispTargetPt);
            this.dispMidAnchorPt.setLocation(this.dispAnchorPt.x + (double)hw, this.dispAnchorPt.y + (double)h2, 0.0);
            if (this._uam.isShowTarget() && !inTextBox) {
                double mindist = this.dispMidAnchorPt.sqDistance(this.dispTargetPt);
                this.tmpPoint2.setLocation(this.dispAnchorPt.x + (double)hw, this.dispAnchorPt.y, 0.0);
                double dist = this.tmpPoint2.sqDistance(this.dispTargetPt);
                if (dist < mindist) {
                    mindist = dist;
                    this.dispMidAnchorPt.setLocation(this.tmpPoint2.x, this.tmpPoint2.y, this.tmpPoint2.z);
                }
                this.tmpPoint2.setLocation(this.dispAnchorPt.x, this.dispAnchorPt.y + (double)hh, 0.0);
                dist = this.tmpPoint2.sqDistance(this.dispTargetPt);
                if (dist < mindist) {
                    mindist = dist;
                    this.dispMidAnchorPt.setLocation(this.tmpPoint2.x, this.tmpPoint2.y, this.tmpPoint2.z);
                }
                this.tmpPoint2.setLocation(this.dispAnchorPt.x + (double)w2, this.dispAnchorPt.y + (double)hh, 0.0);
                dist = this.tmpPoint2.sqDistance(this.dispTargetPt);
                if (dist < mindist) {
                    mindist = dist;
                    this.dispMidAnchorPt.setLocation(this.tmpPoint2.x, this.tmpPoint2.y, this.tmpPoint2.z);
                }
                this.line(g22, (int)this.dispMidAnchorPt.x, (int)this.dispMidAnchorPt.y, (int)this.dispTargetPt.x, (int)this.dispTargetPt.y);
            }
            this._textArea.getLocation(this.tbPoint);
            int tbx = (int)this.dispAnchorPt.x;
            int tby = (int)this.dispAnchorPt.y;
            if (this.tbPoint.x != tbx || this.tbPoint.y != tby) {
                this._textArea.setLocation(tbx, tby);
            }
            if (this._uam != null) {
                this._uam.setText(this._textArea.getText());
            }
        }
    }

    private boolean insideTextBox(double x2, double y2) {
        int w2 = this._textArea.getWidth();
        int h2 = this._textArea.getHeight();
        double x1 = this.dispAnchorPt.x;
        double y1 = this.dispAnchorPt.y;
        double x22 = x1 + (double)w2;
        double y22 = y1 + (double)h2;
        return x2 >= x1 && x2 <= x22 && y2 >= y1 && y2 <= y22;
    }

    @Override
    public boolean contains(int x2, int y2) {
        int h2;
        double rY;
        int w2;
        double rX;
        boolean resizeContains;
        boolean taContains = this._textArea.contains((int)((double)x2 - this.dispAnchorPt.x), (int)((double)y2 - this.dispAnchorPt.y));
        if (taContains) {
            this._textArea.requestFocus();
            return true;
        }
        int offX = TARGET_WIDTH / 2;
        double mX = (double)x2 - this.dispAnchorPt.x + (double)offX;
        int offY = TARGET_HEIGHT / 2;
        double mY = (double)y2 - this.dispAnchorPt.y + (double)offY;
        boolean moveContains = resizeRect.contains(mX, mY);
        if (moveContains) {
            this._insideCode = 1;
            return true;
        }
        if (this._uam.isResize() && (resizeContains = resizeRect.contains(rX = (double)x2 - (this.dispAnchorPt.x + (double)(w2 = this._textArea.getWidth())) + (double)offX, rY = (double)y2 - (this.dispAnchorPt.y + (double)(h2 = this._textArea.getHeight())) + (double)offY))) {
            this._insideCode = 3;
            return true;
        }
        if (this._uam.isShowTarget()) {
            double targetX = (double)x2 - this.dispTargetPt.x + (double)offX;
            double targetY = (double)y2 - this.dispTargetPt.y + (double)offY;
            boolean targetContains = this.pointerShape.contains(targetX, targetY);
            if (targetContains) {
                this._insideCode = 2;
                return true;
            }
            if (this.containsCoord(x2, y2, this.dispMidAnchorPt, this.dispTargetPt)) {
                this._insideCode = 4;
                return true;
            }
        }
        this._insideCode = 0;
        return false;
    }

    private boolean containsCoord(int x2, int y2, CPoint p1, CPoint p2) {
        int x1 = x2 - 4;
        int y1 = y2 - 4;
        int x22 = x2 + 4;
        int y22 = y2 + 4;
        if (this.intersects(x1, y1, x22, y22, (int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y)) {
            return true;
        }
        return this.intersects(x1, y22, x22, y1, (int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    private boolean intersects(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        int x43 = x4 - x3;
        int y13 = y1 - y3;
        int y43 = y4 - y3;
        int x13 = x1 - x3;
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int denom = y43 * x21 - x43 * y21;
        int n1 = x43 * y13 - y43 * x13;
        int n2 = x21 * y13 - y21 * x13;
        if (denom == 0 && (n1 == 0 || n2 == 0)) {
            return true;
        }
        if (denom == 0) {
            return false;
        }
        double ua = (double)n1 / (double)denom;
        double ub = (double)n2 / (double)denom;
        return ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (!this._uam.isEditable()) {
            return;
        }
        this.pMouse = this.initMouse = e2.getPoint();
        this.anchorpt.setPoint(this._uam.getTextAnchor());
        this.targetpt.setPoint(this._uam.getTarget());
        this.initTxtBoxDim.setSize(this._textArea.getWidth(), this._textArea.getHeight());
        this.dragCode = this._insideCode;
        MouseEvent me = new MouseEvent(this, e2.getID(), System.currentTimeMillis(), e2.getModifiers(), e2.getX(), e2.getY(), e2.getClickCount(), false);
        XpAppContext.instance().getSelectionManager().mousePressed(me);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (!this._uam.isEditable()) {
            return;
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (!this._uam.isEditable()) {
            return;
        }
        if (this._insideCode == 3 && XpUserAnnotationModel.getResizeHandleCursor() != null) {
            this.setCursor(XpUserAnnotationModel.getResizeHandleCursor());
        } else if (this._insideCode == 1 && XpUserAnnotationModel.getMoveHandleCursor() != null) {
            this.setCursor(XpUserAnnotationModel.getMoveHandleCursor());
        } else if (XpUserAnnotationModel.getSelectionCursor() != null) {
            this.setCursor(XpUserAnnotationModel.getSelectionCursor());
        } else {
            this.setCursor(PRESELECT_CURSOR);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this._insideCode = 0;
        this.dragCode = 0;
        this.initMouse = null;
        this.pMouse = null;
    }

    public boolean validateTargetMovement(CPoint targetPt) {
        boolean bIsCoveredByAnchor = false;
        if (this.insideTextBox(targetPt.x, targetPt.y)) {
            bIsCoveredByAnchor = true;
        }
        return bIsCoveredByAnchor;
    }

    private void getDomain(Rectangle2D r2, boolean withTextBox) {
        int width = this.getParent().getWidth();
        int height = this.getParent().getHeight();
        int tw = this._textArea.getWidth();
        int th = this._textArea.getHeight();
        double dMaxX = width - 1;
        double dMaxY = height - 1;
        double dMinX = 0.0;
        double dMinY = 0.0;
        if (this.domain != null) {
            CPoint dim = new CPoint(this.domain.getMinX(), this.domain.getMinY(), 0.0, 0);
            CPoint dpt0 = this.transform(dim, (byte)1);
            dMinX = dpt0.x;
            dMinY = dpt0.y;
            dim.setPoint(this.domain.getMaxX(), this.domain.getMaxY(), 0.0, (byte)0);
            CPoint dpt1 = this.transform(dim, (byte)1);
            dMaxX = dpt1.x;
            dMaxY = dpt1.y;
        }
        if (withTextBox) {
            dMaxX -= (double)tw;
            dMaxY -= (double)th;
        }
        r2.setFrame(dMinX, dMinY, dMaxX - dMinX, dMaxY - dMinY);
    }

    private boolean userAnnotationInDomain(CPoint apt, CPoint tpt) {
        Rectangle2D.Double ra = new Rectangle2D.Double();
        this.getDomain(ra, true);
        Rectangle2D.Double rt = new Rectangle2D.Double();
        this.getDomain(rt, false);
        this.temp.csystem = 1;
        CTransform ct0 = this.getTransform(apt.csystem, (byte)1);
        ct0.transform(apt, this.temp);
        if (this.temp.x < ra.getMinX() || this.temp.x > ra.getMaxX() || this.temp.y < ra.getMinY() || this.temp.y > ra.getMaxY()) {
            return false;
        }
        CTransform ct1 = this.getTransform(tpt.csystem, (byte)1);
        ct1.transform(tpt, this.temp);
        return !(this.temp.x < rt.getMinX() || this.temp.x > rt.getMaxX() || this.temp.y < rt.getMinY()) && !(this.temp.y > rt.getMaxY());
    }

    private void clipToDomain(CPoint pt, CPoint result, byte clip_csystem, boolean withTextBox) {
        Rectangle2D.Double r2 = new Rectangle2D.Double();
        this.getDomain(r2, withTextBox);
        this.temp.csystem = 1;
        CTransform ct = this.getTransform(pt.csystem, (byte)1);
        ct.transform(pt, this.temp);
        if (this.temp.x < r2.getMinX()) {
            this.temp.x = r2.getMinX();
        }
        if (this.temp.x > r2.getMaxX()) {
            this.temp.x = r2.getMaxX();
        }
        if (this.temp.y < r2.getMinY()) {
            this.temp.y = r2.getMinY();
        }
        if (this.temp.y > r2.getMaxY()) {
            this.temp.y = r2.getMaxY();
        }
        CTransform t2 = this.getTransform((byte)1, clip_csystem);
        result.csystem = clip_csystem;
        t2.transform(this.temp, result);
    }

    private void translateAnchor(Point to, Point from) {
        CPoint cptxt = this._uam.getTextAnchor();
        this.calcDragVector(to, from, cptxt.csystem);
        if (this.anchorpt.csystem == 1) {
            this.anchorpt.subtract(this._dragV);
        } else {
            this.anchorpt.add(this._dragV);
        }
    }

    private void moveAnchor(Point to, Point from) {
        this.translateAnchor(to, from);
        this.clipToDomain(this.anchorpt, this.tmpptMA, this.anchorpt.csystem, true);
        this._uam.setTextAnchor(this.tmpptMA);
    }

    private void moveArrowLine(Point to, Point from) {
        this.translateAnchor(to, from);
        CPoint uatarget = this._uam.getTarget();
        this.calcDragVector(to, from, uatarget.csystem);
        this.targetpt.add(this._dragV);
        if (this.userAnnotationInDomain(this.anchorpt, this.targetpt)) {
            this._uam.setTextAnchor(this.anchorpt);
            this._uam.setTarget(this.targetpt);
        }
    }

    private void moveTarget(Point dest) {
        if (!this.insideTextBox(dest.x, dest.y)) {
            CTransform t2 = this.getTransform((byte)1, this.targetpt.csystem);
            this.tmpptMT.setPoint(dest.x, dest.y, 0.0, (byte)1);
            t2.transform(this.tmpptMT, this.targetpt);
            this.clipToDomain(this.targetpt, this.tmpptMT, this.targetpt.csystem, false);
            this._uam.setTarget(this.tmpptMT);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        Point cmouse = e2.getPoint();
        int initialX = (int)cmouse.getX();
        int initialY = (int)cmouse.getY();
        int x2 = (int)cmouse.getX();
        int y2 = (int)cmouse.getY();
        Container c2 = this.getParent();
        int width = c2.getWidth();
        int height = c2.getHeight();
        if (this.domain != null && c2 instanceof FrameOwner) {
            XpImage img = ((FrameOwner)((Object)c2)).getFrame();
            width = img.getSlice().width;
            height = img.getSlice().height;
        }
        double dMaxX = width - 1;
        double dMaxY = height - 1;
        double dMinX = 0.0;
        double dMinY = 0.0;
        Point2D.Double mousePt = new Point2D.Double();
        if (this.domain != null) {
            this.transformDisplayToImage(cmouse, (Point2D)mousePt);
            x2 = (int)((Point2D)mousePt).getX();
            y2 = (int)((Point2D)mousePt).getY();
            dMinX = this.domain.getX();
            dMinY = this.domain.getY();
            dMaxX = dMinX + this.domain.getWidth();
            dMaxY = dMinY + this.domain.getHeight();
        }
        if (x2 < (int)dMinX) {
            x2 = (int)dMinX;
        }
        if (x2 > (int)dMaxX) {
            x2 = (int)dMaxX;
        }
        if (y2 < (int)dMinY) {
            y2 = (int)dMinY;
        }
        if (y2 > (int)dMaxY) {
            y2 = (int)dMaxY;
        }
        if (this.domain != null) {
            Point ptFinale = new Point();
            ((Point2D)mousePt).setLocation(x2, y2);
            this.transformImageToDisplay(mousePt, ptFinale);
            cmouse.setLocation(((Point2D)ptFinale).getX(), ((Point2D)ptFinale).getY());
        } else {
            cmouse.setLocation(x2, y2);
        }
        if (this.domain == null && x2 != initialX && y2 != initialY) {
            return;
        }
        if (!this._uam.isEditable()) {
            return;
        }
        if (this.pMouse != null) {
            boolean processDrag = false;
            int modifiers = e2.getModifiers();
            int button1 = modifiers & 0x10;
            int button3 = modifiers & 4;
            if (button1 != 0) {
                processDrag = true;
            }
            if (button3 != 0) {
                processDrag = true;
            }
            if (processDrag) {
                switch (this.dragCode) {
                    case 3: {
                        double dx = cmouse.getX() - this.initMouse.getX();
                        double dy = cmouse.getY() - this.initMouse.getY();
                        double w2 = this.initTxtBoxDim.getWidth() + dx;
                        double h2 = this.initTxtBoxDim.getHeight() + dy;
                        if (w2 < (double)XpUserAnnotationVc.minSize.width) {
                            w2 = XpUserAnnotationVc.minSize.width;
                        }
                        if (h2 < (double)XpUserAnnotationVc.minSize.height) {
                            h2 = XpUserAnnotationVc.minSize.height;
                        }
                        Rectangle2D.Double r2 = new Rectangle2D.Double();
                        this.getDomain(r2, false);
                        double tx = (double)this._textArea.getX() + w2;
                        double ty = (double)this._textArea.getY() + h2;
                        if (tx > r2.getMaxX()) {
                            w2 -= tx - r2.getMaxX();
                        } else if (tx < r2.getMinX()) {
                            w2 += r2.getMinX() - tx;
                        }
                        if (ty > r2.getMaxY()) {
                            h2 -= ty - r2.getMaxY();
                        } else if (ty < r2.getMinY()) {
                            h2 += r2.getMinY() - ty;
                        }
                        this.resizeTextArea(w2, h2);
                        this._uam.setWidth(w2);
                        this._uam.setHeight(h2);
                        this.repaint();
                        break;
                    }
                    case 1: {
                        this.moveAnchor(cmouse, this.pMouse);
                        this.repaint();
                        break;
                    }
                    case 2: {
                        this.moveTarget(cmouse);
                        this.repaint();
                        break;
                    }
                    case 4: {
                        this.moveArrowLine(cmouse, this.pMouse);
                        this.repaint();
                    }
                }
            }
        }
        this.pMouse = cmouse;
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    public final String getText() {
        return this._uam.getText();
    }

    public CPoint getTextAnchor() {
        return this._uam.getTextAnchor();
    }

    public void setTextAnchor(CPoint textAnchor) {
        this._uam.setTextAnchor(textAnchor);
    }

    public CPoint getTarget() {
        return this._uam.getTarget();
    }

    public void setTarget(CPoint target) {
        this._uam.setTarget(target);
    }

    public void setDomain(Rectangle2D adomain) {
        this.domain = null;
        if (adomain != null) {
            this.domain = (Rectangle2D)adomain.clone();
        }
    }

    public Rectangle2D getDomain() {
        return this.domain;
    }

    private void calcDragVector(Point p1, Point p0, byte csystem) {
        if (csystem == 1) {
            this._dragV.setPoint(p1, p0);
            return;
        }
        this.tmpPoint1.setPoint(p0.x, p0.y, 0.0, (byte)1);
        this.transform(this.tmpPoint1, this._cp0, csystem);
        this.tmpPoint1.setPoint(p1.x, p1.y, 0.0, (byte)1);
        this.transform(this.tmpPoint1, this._cp1, csystem);
        this._cp1.subtract(this._cp0);
        this._dragV.setPoint(this._cp1);
    }

    @Override
    public final Selectable[] getSelectable() {
        this.sel[0] = this._uam;
        return this.sel;
    }

    public static void setHandleColor(Color hColor) {
        handleColor = hColor;
    }

    public static Color getHandleColor() {
        return handleColor;
    }

    public static void setTextMinimumSize(Dimension d2) {
        minSize.setSize(d2);
    }

    public static Dimension getTextMinimumSize() {
        return minSize;
    }

    public static void setCaretPolicy(int policy) {
        caretPolicy = policy;
    }

    public static int getCaretPolicy() {
        return caretPolicy;
    }

    static {
        int[] idims;
        String dims;
        blackBorder = BorderFactory.createLineBorder(Color.black);
        PRESELECT_CURSOR = new Cursor(12);
        TARGET_WIDTH = 10;
        TARGET_HEIGHT = 10;
        uavc_id = 1000;
        CIRCLE_SHAPE = null;
        resizeRect = null;
        handleColor = Color.red;
        minSize = new Dimension(10, 18);
        caretPolicy = 800;
        dohighlight = true;
        ARROW_TIP1 = new Point2D.Double(4.0, 5.0);
        ARROW_TIP2 = new Point2D.Double(-4.0, 5.0);
        String highlight = XpPropertiesManager.getProperty("jami.userannot.highlighting");
        if (highlight.toUpperCase().equals("FALSE")) {
            dohighlight = false;
        }
        if ((dims = XpPropertiesManager.getProperty("jami.userannot.target.dimensions")) != null && (idims = XpPropertiesManager.parseIntList(dims, ", ")) != null && idims.length >= 2) {
            TARGET_WIDTH = idims[0];
            TARGET_HEIGHT = idims[1];
        }
        CIRCLE_SHAPE = new Ellipse2D.Double(0.0, 0.0, TARGET_WIDTH, TARGET_HEIGHT);
        resizeRect = new Rectangle2D.Double(0.0, 0.0, TARGET_WIDTH + 2, TARGET_HEIGHT + 2);
    }

    private class UserAnnotationLayout
    implements LayoutManager,
    Serializable {
        private CPoint dpy_anchor = new CPoint(1);

        @Override
        public void addLayoutComponent(String name, Component comp) {
            XpLog.logger().info("Add Layout Component   : " + name + "  Component=" + comp.getClass());
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            XpLog.logger().info("Remove Layout Component: " + comp.getClass());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getParent().getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getParent().getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            Component[] comps = parent.getComponents();
            int nComps = comps.length;
            XpUserAnnotationVc xua = (XpUserAnnotationVc)parent;
            XpUserAnnotationModel uam = xua.getUserAnnotationModel();
            CPoint anchorPt = uam.getTextAnchor();
            XpUserAnnotationVc.this.transform(anchorPt, this.dpy_anchor, (byte)1);
            for (int i2 = 0; i2 < nComps; ++i2) {
                comps[i2].setLocation((int)this.dpy_anchor.x, (int)this.dpy_anchor.y);
                Dimension pd = comps[i2].getPreferredSize();
                Dimension md = comps[i2].getMinimumSize();
                int w2 = pd.width;
                int h2 = pd.height;
                if (md != null) {
                    if (w2 < md.width) {
                        w2 = md.width;
                    }
                    if (h2 < md.height) {
                        h2 = md.height;
                    }
                }
                if (XpUserAnnotationVc.this._uam == null || !XpUserAnnotationVc.this._uam.isAutoResize()) continue;
                comps[i2].setSize(w2, h2);
            }
        }
    }

    private class UAnnoTextArea
    extends JTextArea {
        boolean doit;
        boolean shadow;

        public UAnnoTextArea(String t2) {
            super(t2);
            this.doit = false;
            this.shadow = false;
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        public void setShadowed(boolean shadow) {
            this.shadow = shadow;
        }

        @Override
        public Color getForeground() {
            if (this.shadow) {
                return Color.black;
            }
            return super.getForeground();
        }

        @Override
        public Border getBorder() {
            Border b2 = super.getBorder();
            if (this.shadow && XpUserAnnotationVc.this._uam.isShowBorder() && b2 != null) {
                return blackBorder;
            }
            return b2;
        }

        @Override
        public int getRowHeight() {
            return super.getRowHeight();
        }
    }
}

