/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicyManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class XpAnnotationModel {
    public static final String ACTIVE_ANNOT_MAP = "ACTIVE_ANNOT_MAP";
    private XpDicomObject dicomObject = null;
    private int margin = 3;
    private Color foreground = Color.white;
    private Color activeForeground = Color.orange;
    private static XpAnnotationPolicy defPolicy = new DefaultAnnotationPolicy();
    private static XpAnnotationPolicy policy = null;
    private static boolean shadowed = true;
    private XpAnnotationConfig aConfig = null;
    private boolean tagsLoaded = false;
    private char[] onechar = new char[1];
    private static AnnotationOutputListener aol;

    public XpAnnotationModel(XpDicomObject dobj) {
        this.dicomObject = dobj;
    }

    public final XpDicomObject getDicomObject() {
        return this.dicomObject;
    }

    public void dispose() {
        this.dicomObject = null;
        this.aConfig = null;
    }

    protected final void setTagsLoaded(boolean tagsLoaded) {
        this.tagsLoaded = tagsLoaded;
    }

    public final boolean isTagsLoaded() {
        return this.tagsLoaded;
    }

    public final XpAnnotationConfig getAnnotationConfig() {
        return this.aConfig;
    }

    public final void setAnnotationConfig(XpAnnotationConfig aConfig) {
        this.aConfig = aConfig;
    }

    public abstract void loadDicomTags();

    public final int getMargin() {
        return this.margin;
    }

    public final void setMargin(int margin) {
        this.margin = margin;
    }

    public final void setForeground(Color c2) {
        this.foreground = c2;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    public final void setActiveForeground(Color c2) {
        this.activeForeground = c2;
    }

    public final Color getActiveForeground() {
        return this.activeForeground;
    }

    public String[] getAnnotationGroups() {
        return null;
    }

    public String[] getAnnotationItems() {
        return null;
    }

    public void setAnnotationGroup(String agName, boolean activate) {
    }

    public void setAnnotationItems(String[] annoItems, boolean activate) {
    }

    public void queryAnnotationItems(String[] annoItems, boolean[] queryRes) {
    }

    public boolean queryAnnotationItem(String aiName) {
        return false;
    }

    public String[] getAnnotationItems(String agName) {
        return null;
    }

    protected final void lineVertical(Graphics g2, String s2, int x2, int y2, int dy) {
        this.lineVertical(g2, s2, x2, y2, dy, false);
    }

    protected final void lineVertical(Graphics g2, String s2, int x2, int y2, int dy, boolean active) {
        this.lineVertical(g2, s2, x2, y2, dy, active, this.foreground);
    }

    protected final void lineVertical(Graphics g2, String s2, int x2, int y2, int dy, boolean active, Color drawColor) {
        Color c2 = drawColor;
        if (active) {
            c2 = this.activeForeground;
        }
        int len = s2.length();
        int offsety = y2;
        for (int i2 = 0; i2 < len; ++i2) {
            this.onechar[0] = s2.charAt(i2);
            XpAnnotationModel.drawShadowedChars(g2, c2, this.onechar, 1, x2, offsety);
            offsety += dy;
        }
    }

    protected final void lineVertical(Graphics g2, String s2, int x2, int y2, int dy, boolean active, Font f2, Color drawColor) {
        Color c2 = drawColor;
        if (active) {
            c2 = this.activeForeground;
        }
        Font savefont = g2.getFont();
        g2.setFont(f2);
        int len = s2.length();
        int offsety = y2;
        for (int i2 = 0; i2 < len; ++i2) {
            this.onechar[0] = s2.charAt(i2);
            XpAnnotationModel.drawShadowedChars(g2, c2, this.onechar, 1, x2, offsety);
            offsety += dy;
        }
        g2.setFont(savefont);
    }

    public static void setAnnotationOutputListener(AnnotationOutputListener ao_listener) {
        aol = ao_listener;
    }

    protected final void line(Graphics g2, String s2, int x2, int y2) {
        this.line(g2, s2, x2, y2, false, this.foreground);
    }

    protected final void line(Graphics g2, String s2, int x2, int y2, boolean active) {
        this.line(g2, s2, x2, y2, active, this.foreground);
    }

    protected final void line(Graphics g2, char[] chars, int nchars, int x2, int y2) {
        XpAnnotationModel.line(g2, chars, nchars, x2, y2, this.foreground);
    }

    protected final void line(Graphics g2, String s2, int x2, int y2, Color drawColor) {
        this.line(g2, s2, x2, y2, false, drawColor);
    }

    protected void line(Graphics g2, String s2, int x2, int y2, boolean active, Color drawColor) {
        Color c2 = drawColor;
        if (active) {
            c2 = this.activeForeground;
        }
        XpAnnotationModel.drawShadowedString(g2, c2, s2, x2, y2);
    }

    protected void line(Graphics g2, String s2, int x2, int y2, boolean active, Font f2, Color drawColor) {
        Color c2 = drawColor;
        if (active) {
            c2 = this.activeForeground;
        }
        XpAnnotationModel.drawShadowedString(g2, f2, c2, s2, x2, y2);
    }

    protected static void line(Graphics g2, char[] chars, int nchars, int x2, int y2, Color drawColor) {
        XpAnnotationModel.drawShadowedChars(g2, drawColor, chars, nchars, x2, y2);
    }

    public static void drawShadowedString(Graphics g2, Color foreground, String s2, int x2, int y2) {
        if (shadowed) {
            g2.setColor(Color.black);
            g2.drawString(s2, x2 + 1, y2 + 1);
        }
        g2.setColor(foreground);
        g2.drawString(s2, x2, y2);
        if (aol != null) {
            aol.annotationOutput(x2, y2, s2);
        }
    }

    public static void drawShadowedString(Graphics g2, Font f2, Color foreground, String s2, int x2, int y2) {
        Font savefont = g2.getFont();
        g2.setFont(f2);
        if (shadowed) {
            g2.setColor(Color.black);
            g2.drawString(s2, x2 + 1, y2 + 1);
        }
        g2.setColor(foreground);
        g2.drawString(s2, x2, y2);
        g2.setFont(savefont);
        if (aol != null) {
            aol.annotationOutput(x2, y2, s2);
        }
    }

    public static void drawShadowedChars(Graphics g2, Color foreground, char[] chars, int nchars, int x2, int y2) {
        if (shadowed) {
            g2.setColor(Color.black);
            g2.drawChars(chars, 0, nchars, x2 + 1, y2 + 1);
        }
        g2.setColor(foreground);
        g2.drawChars(chars, 0, nchars, x2, y2);
        if (aol != null) {
            aol.annotationOutput(x2, y2, new String(chars, 0, nchars));
        }
    }

    public abstract void drawAnnotation(Graphics var1, Rectangle var2);

    public int insideAnnotation(int x2, int y2) {
        return -1;
    }

    public int getAnnotationKey(String annotationItem) {
        return -1;
    }

    public String getTooltip(int key) {
        return "No Tooltip For you";
    }

    public void setProperty(String propName, double value) {
    }

    public void setProperty(String propName, long value) {
    }

    public void setProperty(String propName, int value) {
    }

    public void setProperty(String propName, boolean value) {
    }

    public void setProperty(String propName, String value) {
    }

    public void setProperty(String propName, Object value) {
    }

    public static void setShadowed(boolean s2) {
        shadowed = s2;
    }

    public static boolean isShadowed() {
        return shadowed;
    }

    public static XpAnnotationPolicy getAnnotationPolicy() {
        return policy;
    }

    public static void setAnnotationPolicy(XpAnnotationPolicy ap) {
        policy = ap != null ? ap : defPolicy;
    }

    public String[] getAnnotationSegments() {
        return null;
    }

    static {
        boolean setPolicy = false;
        String policyClass = XpPropertiesManager.getProperty("jami.annotationpolicy", null);
        if (policyClass != null) {
            policy = (XpAnnotationPolicy)XpPropertiesManager.create(policyClass);
            if (policy != null) {
                setPolicy = true;
            }
        } else {
            XpLog.logger().warning("Could not load jami.annotationpolicy, going to default");
        }
        if (!setPolicy) {
            policy = defPolicy;
        }
        XpLog.logger().config("Using annotation policy=" + policy.getClass());
        aol = null;
    }

    public static final class DefaultAnnotationPolicy
    implements XpAnnotationPolicyManager {
        private static final int LARGEVP_SIZE = 600;
        private static final int SMALLVP_SIZE = 300;
        private static Font fontNormal = null;
        private static Font fontSmall = null;
        private static Font fontLarge = null;
        private static Font fontVeryLarge = null;
        private static Font fontBoldNormal = null;
        private static Font fontBoldSmall = null;
        private static Font fontBoldLarge = null;
        private static Font fontBoldVeryLarge = null;

        public DefaultAnnotationPolicy() {
            if (fontNormal == null || fontSmall == null || fontLarge == null) {
                String fontName = XpPropertiesManager.getProperty("jami.annotation.font", "Serif");
                fontNormal = new Font(fontName, 0, 12);
                fontSmall = new Font(fontName, 0, 10);
                fontLarge = new Font(fontName, 0, 16);
                fontVeryLarge = new Font(fontName, 0, 18);
                fontBoldNormal = new Font(fontName, 1, 12);
                fontBoldSmall = new Font(fontName, 1, 10);
                fontBoldLarge = new Font(fontName, 1, 16);
                fontBoldVeryLarge = new Font(fontName, 1, 18);
                XpLog.logger().config("Using font=[" + fontName + "] for medical image annotation.");
            }
        }

        @Override
        public int getAnnotationPriority(int width, int height) {
            int ret = 0;
            ret = width > 500 && height > 500 ? 0 : (width > 400 && height > 400 ? 1 : (width > 400 && height > 400 ? 5 : (width > 220 && height > 220 ? 6 : (width > 125 && height > 125 ? 8 : 9))));
            return ret;
        }

        @Override
        public Font getAnnotationFont(int width, int height) {
            return this.getAnnotationFont(width, height, 1, 0);
        }

        @Override
        public Font getAnnotationFont(int width, int height, int annotationSize, int annotationStyle) {
            if (annotationStyle == 0) {
                switch (annotationSize) {
                    case 1: {
                        if (width > 600 && height > 600) {
                            return fontLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontSmall;
                        }
                        return fontNormal;
                    }
                    case 0: {
                        if (width > 600 && height > 600) {
                            return fontNormal;
                        }
                        if (width < 300 && height < 300) {
                            return fontSmall;
                        }
                        return fontSmall;
                    }
                    case 2: {
                        if (width > 600 && height > 600) {
                            return fontLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontNormal;
                        }
                        return fontLarge;
                    }
                    case 3: {
                        if (width > 600 && height > 600) {
                            return fontVeryLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontLarge;
                        }
                        return fontVeryLarge;
                    }
                }
            } else {
                switch (annotationSize) {
                    case 1: {
                        if (width > 600 && height > 600) {
                            return fontBoldLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontBoldSmall;
                        }
                        return fontBoldNormal;
                    }
                    case 0: {
                        if (width > 600 && height > 600) {
                            return fontBoldNormal;
                        }
                        if (width < 300 && height < 300) {
                            return fontBoldSmall;
                        }
                        return fontBoldSmall;
                    }
                    case 2: {
                        if (width > 600 && height > 600) {
                            return fontBoldLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontBoldNormal;
                        }
                        return fontBoldLarge;
                    }
                    case 3: {
                        if (width > 600 && height > 600) {
                            return fontBoldVeryLarge;
                        }
                        if (width < 300 && height < 300) {
                            return fontBoldLarge;
                        }
                        return fontBoldVeryLarge;
                    }
                }
            }
            return fontNormal;
        }

        public final String toString() {
            return "DefaultAnnotationPolicy";
        }
    }

    public static interface AnnotationOutputListener {
        public void annotationOutput(int var1, int var2, String var3);
    }
}

