/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.annotation;

import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.annotation.XpAnnotationConfig;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.annotation.XpAnnotationPolicy;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JComponent;

public class XpSimpleAnnotation
extends XpAnnotationModel {
    private static final DecimalFormat df = new DecimalFormat("##0.##");
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MINIMAL = 1;
    public static final int STUDY_DATE = 0;
    public static final int ACQUISITION_DATE = 1;
    public static final int STUDY_TIME = 2;
    public static final int ACQUISITION_TIME = 3;
    public static final int MODALITY = 4;
    public static final int MANUFACTURER = 5;
    public static final int INSTITUTION = 6;
    public static final int STATION_NAME = 7;
    public static final int STUDY_DESC = 8;
    public static final int MANUFACTURER_MOD = 9;
    public static final int PATIENT = 10;
    public static final int PATIENT_ID = 11;
    public static final int BIRTH_DATE = 12;
    public static final int SEX = 13;
    public static final int AGE = 14;
    public static final int WEIGHT = 15;
    public static final int EXAM = 16;
    public static final int SERIES = 17;
    public static final int IMAGE = 18;
    public static final int ROWS = 19;
    public static final int COLUMNS = 20;
    public static final int WWWL_KEY = 21;
    public static final int MULTI_OP_KEY = 22;
    public static final int IMAGE_DIM_KEY = 23;
    public static final int SINGLE_OP_KEY = 24;
    private FontRenderContext frc = null;
    private DateFormat dateFormat = DateFormat.getDateInstance(2);
    private DateFormat timeFormat = DateFormat.getTimeInstance(2);
    private Calendar calendar = new GregorianCalendar();
    private String acq_date = "";
    private String study_date = "";
    private String acq_time = "";
    private String study_time = "";
    private boolean wwwlStyle = true;
    private XpDicomElement[] header = null;
    private double currWW = 0.0;
    private double currWL = 0.0;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private List currOperations = null;
    private int level = 0;
    private AnnotationTipItem[] ati = new AnnotationTipItem[25];
    private Rectangle2D[] rects = new Rectangle2D[25];
    private static String[] desc = null;
    private static int num = 0;

    public XpSimpleAnnotation(XpDicomObject dobj, int level) {
        this(dobj);
        this.level = level;
    }

    public XpSimpleAnnotation(XpDicomObject dobj) {
        super(dobj);
        if (desc == null) {
            desc = new String[25];
            this.loadDescriptions();
        }
        this.setAnnotationConfig(new SimpleAnnotationConfig());
    }

    private Date getDate(String datestr, String timestr) {
        int year = Integer.parseInt(datestr.substring(0, 4));
        int mo = Integer.parseInt(datestr.substring(4, 6));
        int da = Integer.parseInt(datestr.substring(6, 8));
        int hour = Integer.parseInt(timestr.substring(0, 2));
        int min = Integer.parseInt(timestr.substring(2, 4));
        int sec = Integer.parseInt(timestr.substring(4, 6));
        this.calendar.set(year, mo - 1, da, hour, min, sec);
        Date date = this.calendar.getTime();
        return date;
    }

    private void formatDateTime() {
        String str_acq_date = "" + this.header[1].value;
        String str_acq_time = "" + this.header[3].value;
        String str_study_date = "" + this.header[0].value;
        String str_study_time = "" + this.header[2].value;
        try {
            Date date_acq = this.getDate(str_acq_date, str_acq_time);
            this.acq_date = "" + this.dateFormat.format(date_acq);
            this.acq_time = "" + this.timeFormat.format(date_acq);
            Date date_study = this.getDate(str_study_date, str_study_time);
            this.study_date = "" + this.dateFormat.format(date_study);
            this.study_time = "" + this.timeFormat.format(date_study);
        }
        catch (Exception ex) {
            this.acq_date = str_acq_date;
            this.acq_time = str_acq_time;
            this.study_date = str_study_date;
            this.study_time = str_study_time;
        }
    }

    private void loadDescriptions() {
        XpSimpleAnnotation.desc[10] = "Patient name";
        XpSimpleAnnotation.desc[17] = "Series";
        XpSimpleAnnotation.desc[18] = "Image number";
        XpSimpleAnnotation.desc[5] = "Manufacturer";
        XpSimpleAnnotation.desc[6] = "Hospital name";
        XpSimpleAnnotation.desc[4] = "Modality";
        XpSimpleAnnotation.desc[11] = "Patient id";
        XpSimpleAnnotation.desc[12] = "Patient birth date";
        XpSimpleAnnotation.desc[13] = "Sex";
        XpSimpleAnnotation.desc[14] = "Age";
        XpSimpleAnnotation.desc[15] = "Weight";
        XpSimpleAnnotation.desc[19] = "Image rows";
        XpSimpleAnnotation.desc[20] = "Image columns";
        XpSimpleAnnotation.desc[0] = "Study date";
        XpSimpleAnnotation.desc[1] = "Acquisition date";
        XpSimpleAnnotation.desc[16] = "Exam Id";
        XpSimpleAnnotation.desc[3] = "Acquisition time";
        XpSimpleAnnotation.desc[2] = "Study time";
        XpSimpleAnnotation.desc[8] = "Study Description";
        XpSimpleAnnotation.desc[7] = "Station name";
        XpSimpleAnnotation.desc[9] = "Manufacturer model";
        XpSimpleAnnotation.desc[21] = "Window width/Window Level";
        XpSimpleAnnotation.desc[22] = "Multi-image operation";
        XpSimpleAnnotation.desc[23] = "Image dimensions (row X col)";
        XpSimpleAnnotation.desc[24] = "Filters";
    }

    @Override
    public void loadDicomTags() {
        if (this.header == null) {
            this.header = new XpDicomElement[21];
            this.header[0] = new XpDicomElement(8, 32);
            this.header[1] = new XpDicomElement(8, 34);
            this.header[2] = new XpDicomElement(8, 48);
            this.header[3] = new XpDicomElement(8, 50);
            this.header[4] = new XpDicomElement(8, 96);
            this.header[5] = new XpDicomElement(8, 112);
            this.header[6] = new XpDicomElement(8, 128);
            this.header[7] = new XpDicomElement(8, 4112);
            this.header[8] = new XpDicomElement(8, 4144);
            this.header[9] = new XpDicomElement(8, 4240);
            this.header[10] = new XpDicomElement(16, 16);
            this.header[11] = new XpDicomElement(16, 32);
            this.header[12] = new XpDicomElement(16, 48);
            this.header[13] = new XpDicomElement(16, 64);
            this.header[14] = new XpDicomElement(16, 4112);
            this.header[15] = new XpDicomElement(16, 4144);
            this.header[16] = new XpDicomElement(32, 16);
            this.header[17] = new XpDicomElement(32, 17);
            this.header[18] = new XpDicomElement(32, 19);
            this.header[19] = new XpDicomElement(40, 16);
            this.header[20] = new XpDicomElement(40, 17);
            XpDicomObject dicomObj = this.getDicomObject();
            dicomObj.getValues(this.header);
            this.formatDateTime();
            String modality = "" + this.header[4].value;
            if (modality.equals("PT")) {
                this.wwwlStyle = false;
            }
        }
    }

    private int drawLine(int key, Graphics2D g2, Rectangle vp, Object o2, int y2) {
        if (o2 != null) {
            int x2 = (int)vp.getX() + this.getMargin();
            String str = o2.toString();
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D b2 = g2.getFont().getStringBounds(str, frc);
            this.line(g2, str, x2, y2);
            Rectangle2D r2 = this.rects[key];
            if (r2 == null) {
                r2 = this.rects[key] = new Rectangle2D.Double();
            }
            double h2 = b2.getHeight();
            r2.setRect(x2, (double)y2 - h2, b2.getWidth(), h2);
            return (int)b2.getHeight();
        }
        return 0;
    }

    private int drawRJLine(int key, Graphics2D g2, Rectangle vp, Object o2, int y2) {
        if (o2 != null) {
            double width = vp.getWidth();
            FontRenderContext frc = g2.getFontRenderContext();
            String str = o2.toString();
            Rectangle2D b2 = g2.getFont().getStringBounds(str, frc);
            int x2 = (int)(width - b2.getWidth() - 2.0);
            this.line(g2, str, x2, y2);
            Rectangle2D r2 = this.rects[key];
            if (r2 == null) {
                r2 = this.rects[key] = new Rectangle2D.Double();
            }
            double h2 = b2.getHeight();
            r2.setRect(x2, (double)y2 - h2, b2.getWidth(), h2);
            return (int)b2.getHeight();
        }
        return 0;
    }

    @Override
    public void drawAnnotation(Graphics g2, Rectangle bounds) {
        boolean paintAll = true;
        int w2 = (int)bounds.getWidth();
        int h2 = (int)bounds.getHeight();
        if (w2 < 200 || h2 < 180) {
            paintAll = false;
        } else if (this.level == 1) {
            paintAll = false;
        }
        Graphics2D g22 = (Graphics2D)g2;
        Rectangle vp = bounds;
        int height = (int)vp.getHeight();
        int width = (int)vp.getWidth();
        int bottomY = height - this.getMargin();
        Font saveFont = g2.getFont();
        XpAnnotationPolicy policy = XpAnnotationModel.getAnnotationPolicy();
        if (policy != null) {
            Font f2 = policy.getAnnotationFont(w2, h2);
            g2.setFont(f2);
        }
        int y2 = (int)vp.getY() + this.getMargin();
        int lineSpacing = 15;
        if (paintAll && this.header != null) {
            y2 += lineSpacing;
            lineSpacing = this.drawLine(10, g22, vp, this.header[10].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(16, g22, vp, "Ex: " + this.header[16].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(17, g22, vp, "Se: " + this.header[17].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(18, g22, vp, "Im: " + this.getImageIdDesc(), y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(14, g22, vp, this.header[14].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(13, g22, vp, this.header[13].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(12, g22, vp, this.header[12].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawLine(15, g22, vp, this.header[15].value, y2);
            lineSpacing = 0;
            bottomY -= lineSpacing;
            lineSpacing = this.drawLine(3, g22, vp, this.acq_time, bottomY);
            bottomY -= lineSpacing;
            lineSpacing = this.drawLine(2, g22, vp, this.study_time, bottomY);
            bottomY -= lineSpacing;
            lineSpacing = this.drawLine(0, g22, vp, this.acq_date, bottomY);
            bottomY -= lineSpacing;
            lineSpacing = this.drawLine(1, g22, vp, this.study_date, bottomY);
            bottomY -= lineSpacing;
            lineSpacing = this.drawLine(6, g22, vp, this.header[6].value, bottomY);
            lineSpacing = 15;
            y2 = (int)vp.getY() + this.getMargin();
            y2 += lineSpacing;
            lineSpacing = this.drawRJLine(5, g22, vp, this.header[5].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawRJLine(4, g22, vp, this.header[4].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawRJLine(9, g22, vp, this.header[9].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawRJLine(7, g22, vp, this.header[7].value, y2);
            y2 += lineSpacing;
            lineSpacing = this.drawRJLine(8, g22, vp, this.header[8].value, y2);
        }
        lineSpacing = 0;
        y2 = height - this.getMargin();
        if (this.wwwlStyle) {
            y2 -= lineSpacing;
            lineSpacing = this.drawRJLine(21, g22, vp, "W: " + df.format(this.currWW) + "  L: " + df.format(this.currWL), y2);
        } else {
            double HWW = this.currWW * 0.5;
            double min = this.currWL - HWW;
            double max = this.currWL + HWW;
            y2 -= lineSpacing;
            lineSpacing = this.drawRJLine(21, g22, vp, "Min: " + df.format(min) + " Max: " + df.format(max), y2);
        }
        if (paintAll) {
            y2 -= lineSpacing;
            lineSpacing = this.drawRJLine(23, g22, vp, "" + this.imgWidth + " x " + this.imgHeight, y2);
            if (this.currOperations != null) {
                int size = this.currOperations.size();
                String ops = "";
                boolean first = true;
                for (int i2 = 0; i2 < size; ++i2) {
                    XpImageOp iop = (XpImageOp)this.currOperations.get(i2);
                    ops = first ? iop.getImageOpName() : ops + "," + iop.getImageOpName();
                    first = false;
                }
                y2 -= lineSpacing;
                lineSpacing = this.drawRJLine(24, g22, vp, ops, y2);
            }
        }
        g2.setFont(saveFont);
    }

    public final String getImageIdDesc() {
        return "" + this.header[18].value;
    }

    @Override
    public int insideAnnotation(int x2, int y2) {
        int len = 25;
        for (int i2 = 0; i2 < len; ++i2) {
            Rectangle2D r2 = this.rects[i2];
            if (r2 == null || !r2.contains(x2, y2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public String getTooltip(int key) {
        if (key >= 0 && key < 25) {
            return desc[key];
        }
        return "Simple Annotation";
    }

    private class SimpleAnnotationConfig
    implements XpAnnotationConfig {
        private SimpleAnnotationConfig() {
        }

        @Override
        public final void configAnnotation(XpAnnotationVc avc, JComponent jc) {
            XpSlice slice;
            XpImageRenderAttributesOwner iraowner = (XpImageRenderAttributesOwner)((Object)jc);
            XpImageRenderAttributes ira = iraowner.getImageRenderAttributes();
            XpSimpleAnnotation.this.currWW = ira.getWindowWidth();
            XpSimpleAnnotation.this.currWL = ira.getWindowLevel();
            XpSimpleAnnotation.this.currOperations = ira.getImageOperations();
            FrameOwner fowner = (FrameOwner)((Object)jc);
            XpImage img = fowner.getFrame();
            if (img != null && (slice = img.getSlice()) != null) {
                XpSimpleAnnotation.this.imgWidth = slice.width;
                XpSimpleAnnotation.this.imgHeight = slice.height;
            }
        }
    }

    private static class AnnotationTipItem {
        public Rectangle2D r = new Rectangle2D.Double();

        private AnnotationTipItem() {
        }
    }
}

