/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.autoviewer;

import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjImage;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpCineMotor;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageMouseControls;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpMedicalImageListListener;
import com.ge.med.terra.jami.XpSelectionManager;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpStackLayout;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.autoviewer.XpMedicalImageEvent;
import com.ge.med.terra.jami.autoviewer.XpMedicalImageFilter;
import com.ge.med.terra.jami.autoviewer.XpMedicalImageListener;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.FrameCapable;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.capable.SliceListener;
import com.ge.med.terra.jami.image.XjMedicalImage;
import com.ge.med.terra.jami.image.XpPatternImage;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributesOwner;
import java.awt.RenderingHints;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;

public class XpAutoViewport
extends XpSingularPort
implements FrameCapable,
FramePositioningCapable,
XpMedicalImageListener,
WindowLevelCapable,
XpImageRenderAttributesOwner,
AnnotCapable,
CineCapable,
SliceControlledCapable,
XpMedicalImageListListener {
    protected XpImageRenderAttributes ira = new XpImageRenderAttributes();
    protected boolean initJcTree = true;
    protected XpMedicalImage[] imageRing = null;
    protected int newIdx = -1;
    protected int curIdx = -1;
    protected int capacity = 0;
    protected int numImages = 0;
    protected List roiActors = new ArrayList();
    protected List userAnnoModels = new ArrayList();
    protected XpCineMotor projector = new XpCineMotor(this, 20);
    protected int cineSkip = 1;
    protected boolean _cineOn = false;
    protected int _cineRate = 20;
    protected int _cineStartOffset = 0;
    protected int _cineEndOffset = 0;
    protected int _cineMode = 0;
    protected Object cineQuality = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    protected XpImage lastXpImage = null;
    protected boolean autoViewMode = true;
    protected double[] wwList = null;
    protected double[] wlList = null;
    protected int[] indices = null;
    protected boolean autoWWWL = false;
    protected IndexComparator idxComparator = new IndexComparator();
    protected XpMedicalImageFilter miFilter = null;
    protected boolean newFrameRepaint = true;
    protected List sliceListeners = new ArrayList(20);
    protected boolean DEBUG = false;
    protected int newImageCount = 0;
    protected XpViewport.IntValueDispatcher framedispatcher = new XpViewport.IntValueDispatcher("FrameIndex");

    public XpAutoViewport(int capacity) {
        this.initializeAutoViewport(capacity);
    }

    public XpAutoViewport(int capacity, String rendererType) {
        super(rendererType);
        this.initializeAutoViewport(capacity);
    }

    protected void initializeAutoViewport(int capacity) {
        if (capacity < 0) {
            capacity = 0;
            this.newIdx = -1;
        } else {
            this.imageRing = new XpMedicalImage[capacity];
            this.indices = new int[capacity];
            this.wwList = new double[capacity];
            this.wlList = new double[capacity];
            this.newIdx = 0;
        }
        this.capacity = capacity;
        this.curIdx = -1;
        this.setLayout(new XpStackLayout());
        this.setMouseController(new XpImageMouseControls());
        if (Beans.isDesignTime()) {
            XpMedicalImage[] imgs = XpPatternImage.getPatternImages(5, 256, 256, 2);
            this.setImages(imgs);
        }
    }

    @Override
    public XpMedicalImage[] getImages() {
        return this.imageRing;
    }

    public void setImages(XjImage[] imgList) {
        this.setImages(XjMedicalImage.createImages(imgList));
    }

    @Override
    public void setImages(XpMedicalImage[] images) {
        XpMedicalImage medImg;
        int i2;
        if (images.length >= this.capacity) {
            for (i2 = 0; i2 < this.capacity; ++i2) {
                this.imageRing[i2] = images[i2 + images.length - this.capacity];
                this.indices[i2] = i2;
                if (images[i2] == null) continue;
                this.wwList[i2] = images[i2].getDefaultWindowWidth();
                this.wlList[i2] = images[i2].getDefaultWindowLevel();
            }
            this.newIdx = 0;
            this.curIdx = this.capacity - 1;
            if (this._cineEndOffset == this.numImages - 1) {
                this._cineEndOffset = this.capacity - 1;
            }
            this.numImages = this.capacity;
        } else {
            for (i2 = 0; i2 < images.length; ++i2) {
                this.imageRing[i2] = images[i2];
                this.indices[i2] = i2;
                this.wwList[i2] = images[i2].getDefaultWindowWidth();
                this.wlList[i2] = images[i2].getDefaultWindowLevel();
            }
            this.numImages = images.length;
            this._cineEndOffset = this.numImages - 1;
            this.newIdx = this.numImages;
            this.curIdx = this.numImages - 1;
        }
        if (this.autoWWWL) {
            double ww = this.imageRing[this.indices[this.curIdx]].getDefaultWindowWidth();
            double wl = this.imageRing[this.indices[this.curIdx]].getDefaultWindowLevel();
            this.ira.setWindowing(ww, wl);
            this.setImageRenderAttributes(this.ira);
        }
        if (this.miFilter != null && !this.miFilter.filter(medImg = this.imageRing[this.indices[this.curIdx]])) {
            this.curIdx = this.findNextImage(false);
        }
        this.updateImageVc();
    }

    public void clearImages() {
        this.numImages = 0;
        this.newIdx = 0;
        this.curIdx = -1;
        this._cineStartOffset = 0;
        this._cineEndOffset = 0;
        this.updateImageVc();
    }

    public boolean forward() {
        XpMedicalImage medImg;
        if (this.numImages == 0) {
            return false;
        }
        if (!this.autoWWWL) {
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            double ww = mivc.getImageRenderAttributes().getWindowWidth();
            double wl = mivc.getImageRenderAttributes().getWindowLevel();
            this.wwList[this.indices[this.curIdx]] = ww;
            this.wlList[this.indices[this.curIdx]] = wl;
        }
        this.curIdx = this.curIdx == this.numImages - 1 ? 0 : ++this.curIdx;
        if (this.miFilter != null && !this.miFilter.filter(medImg = this.imageRing[this.indices[this.curIdx]])) {
            this.curIdx = this.findNextImage(true);
        }
        this.updateImageVc();
        return true;
    }

    public boolean backward() {
        XpMedicalImage medImg;
        if (this.numImages == 0) {
            return false;
        }
        if (!this.autoWWWL) {
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            double ww = mivc.getImageRenderAttributes().getWindowWidth();
            double wl = mivc.getImageRenderAttributes().getWindowLevel();
            this.wwList[this.indices[this.curIdx]] = ww;
            this.wlList[this.indices[this.curIdx]] = wl;
        }
        this.curIdx = this.curIdx == 0 ? this.numImages - 1 : --this.curIdx;
        if (this.miFilter != null && !this.miFilter.filter(medImg = this.imageRing[this.indices[this.curIdx]])) {
            this.curIdx = this.findNextImage(false);
        }
        this.updateImageVc();
        return true;
    }

    public XpMedicalImage getCurrentImage() {
        return this.imageRing[this.indices[this.curIdx]];
    }

    @Override
    public void newImage(XpMedicalImageEvent miEvent) {
        ++this.newImageCount;
        if (this.numImages < this.capacity) {
            this.indices[this.newIdx] = this.newIdx;
        }
        this.imageRing[this.indices[this.newIdx]] = miEvent.getImage();
        boolean updateDisplay = true;
        if (this.autoViewMode) {
            if (this.miFilter != null && !this.miFilter.filter(miEvent.getImage())) {
                updateDisplay = false;
            }
        } else {
            updateDisplay = false;
        }
        if (!this.autoWWWL) {
            this.wwList[this.indices[this.newIdx]] = this.imageRing[this.indices[this.newIdx]].getDefaultWindowWidth();
            this.wlList[this.indices[this.newIdx]] = this.imageRing[this.indices[this.newIdx]].getDefaultWindowLevel();
        }
        int thisIdx = this.newIdx;
        this.newIdx = (this.newIdx + 1) % this.capacity;
        if (this.numImages < this.capacity) {
            if (this._cineEndOffset == this.numImages - 1) {
                ++this._cineEndOffset;
            }
            ++this.numImages;
        }
        if (updateDisplay) {
            this.curIdx = thisIdx;
            this.updateImageVc();
        }
    }

    protected void updateImageVc() {
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        if (this.numImages == 0 || this.curIdx == -1) {
            mivc.setMedicalImage(null, null);
            this.lastXpImage = null;
            return;
        }
        XpMedicalImage image = this.imageRing[this.indices[this.curIdx]];
        if (image != this.lastXpImage) {
            XpDicomObject dicomSource = null;
            if (image instanceof XpMedicalImage) {
                dicomSource = image;
            }
            mivc.setMedicalImage(image, dicomSource);
            this.lastXpImage = image;
        }
        if (!this.autoWWWL) {
            double ww = this.wwList[this.indices[this.curIdx]];
            double wl = this.wlList[this.indices[this.curIdx]];
            this.ira.setWindowing(ww, wl);
            mivc.setImageRenderAttributes(this.ira);
        } else if (this.numImages == 1) {
            double ww = this.imageRing[this.indices[this.curIdx]].getDefaultWindowWidth();
            double wl = this.imageRing[this.indices[this.curIdx]].getDefaultWindowLevel();
            this.ira.setWindowing(ww, wl);
            mivc.setImageRenderAttributes(this.ira);
        }
        this.syncScene();
        if (this.initJcTree) {
            this.invalidate();
            this.validate();
            this.initJcTree = false;
        }
        if (this.newFrameRepaint) {
            this.request_repaint();
        }
        this.notifySliceListeners();
    }

    public int getNumImages() {
        return this.numImages;
    }

    public int getCapacity() {
        return this.capacity;
    }

    protected int getNextIndex(int index) {
        index = index == this.numImages - 1 ? 0 : ++index;
        return index;
    }

    protected int getPrevIndex(int index) {
        index = index == 0 ? this.numImages - 1 : --index;
        return index;
    }

    protected int findNextImage(boolean forward) {
        if (this.miFilter == null) {
            return this.curIdx;
        }
        int startIdx = this.curIdx;
        int index = forward ? this.getNextIndex(startIdx) : this.getPrevIndex(startIdx);
        while (index != startIdx) {
            XpMedicalImage medImg = this.imageRing[this.indices[index]];
            if (this.miFilter.filter(medImg)) {
                return index;
            }
            if (forward) {
                index = this.getNextIndex(index);
                continue;
            }
            index = this.getPrevIndex(index);
        }
        return -1;
    }

    @Override
    public XpImage getImageAt(int idx) {
        return this.imageRing[this.indices[idx]];
    }

    @Override
    public XpImage getFrame() {
        if (this.curIdx < 0) {
            return null;
        }
        return this.imageRing[this.indices[this.curIdx]];
    }

    @Override
    public XpImage getFrame(int idx) {
        return this.getImageAt(idx);
    }

    @Override
    public int getNumFrames() {
        return this.numImages;
    }

    @Override
    public int getFrameIndex() {
        if (this.numImages < this.capacity) {
            return this.curIdx;
        }
        if (this.curIdx - this.newIdx < 0) {
            return this.curIdx - this.newIdx + this.numImages;
        }
        return this.curIdx - this.newIdx;
    }

    @Override
    public void setFrameIndex(int index) {
        this.setFrame(index);
    }

    public void setFrame(int index) {
        if (index >= 0 && index < this.numImages) {
            XpMedicalImage medImg;
            if (!this.autoWWWL) {
                XpMedicalImage2DVc mivc = this.getMedicalImageVc();
                double ww = mivc.getImageRenderAttributes().getWindowWidth();
                double wl = mivc.getImageRenderAttributes().getWindowLevel();
                this.wwList[this.indices[this.curIdx]] = ww;
                this.wlList[this.indices[this.curIdx]] = wl;
            }
            boolean updateDisplay = true;
            if (this.miFilter != null && !this.miFilter.filter(medImg = this.imageRing[this.indices[this.curIdx]])) {
                updateDisplay = false;
            }
            if (updateDisplay) {
                this.curIdx = this.numImages < this.capacity ? index : (index + this.newIdx >= this.numImages ? index + this.newIdx - this.numImages : index + this.newIdx);
                this.framedispatcher.setValues(this, index);
                SwingUtilities.invokeLater(this.framedispatcher);
                this.updateImageVc();
            }
        }
    }

    @Override
    public int getMaxFrame() {
        return this.getNumImages();
    }

    @Override
    public boolean getCine() {
        return this._cineOn;
    }

    @Override
    public void setCine(boolean cine) {
        boolean prevCine = this.getCine();
        this._cineOn = cine;
        if (!prevCine && cine) {
            this.setInterpolationHint(this.cineQuality);
            this.projector.setCineRate(this.getCineRate());
            this.projector.start();
        }
        if (!cine) {
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.projector.stopProjection();
        }
        this.firePropertyChange("Cine", prevCine, cine);
    }

    @Override
    public void setCineRate(int rate) {
        int oldRate = this.getCineRate();
        this._cineRate = rate;
        if (this.projector != null) {
            this.projector.setCineRate(rate);
        }
        this.firePropertyChange("CineRate", oldRate, rate);
    }

    @Override
    public int getCineRate() {
        return this._cineRate;
    }

    @Override
    public void setCineMode(int cineMode) {
        this._cineMode = cineMode;
    }

    @Override
    public int getCineMode() {
        return this._cineMode;
    }

    @Override
    public void setOffset(int offset) {
        this.setFrame(offset);
    }

    @Override
    public int getOffset() {
        return this.getFrameIndex();
    }

    @Override
    public void setCineSkip(int cineSkip) {
        this.cineSkip = cineSkip;
    }

    @Override
    public int getCineSkip() {
        return this.cineSkip;
    }

    @Override
    public int getNumberShown() {
        return 1;
    }

    @Override
    public void setStartOffset(int offset) {
        int n2 = this.getNumFrames();
        if (offset <= this._cineEndOffset && offset >= 0) {
            this._cineStartOffset = offset;
        }
    }

    @Override
    public int getStartOffset() {
        return this._cineStartOffset;
    }

    @Override
    public void setEndOffset(int offset) {
        int n2 = this.getNumFrames();
        if (offset >= this._cineStartOffset && offset < n2) {
            this._cineEndOffset = offset;
        }
    }

    @Override
    public int getEndOffset() {
        return this._cineEndOffset;
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        if (this.numImages > 0) {
            super.setImageRenderAttributes(attr);
        }
    }

    @Override
    public void add(RoiActor m2) {
        XpMedicalImage2DVc mivc = this.getMedicalImageVc();
        XpImage img = mivc.getFrame();
        if (img != null) {
            m2.setImage(img);
            this.roiActors.add(m2);
            XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
            sm.addSelectable(m2);
            this.initJcTree = true;
            this.updateImageVc();
            this.firePropertyChange("ROI_ADDED", null, m2);
        }
    }

    @Override
    public boolean remove(RoiActor m2) {
        boolean res = this.roiActors.remove(m2);
        this.updateImageVc();
        if (res) {
            this.firePropertyChange("ROI_REMOVED", null, m2);
        }
        return res;
    }

    @Override
    public List getRois() {
        return this.roiActors;
    }

    @Override
    public RoiActor getRoi() {
        if (this.roiActors.size() <= 0) {
            return null;
        }
        return (RoiActor)this.roiActors.get(this.roiActors.size() - 1);
    }

    @Override
    public void add(XpUserAnnotationModel m2) {
        this.userAnnoModels.add(m2);
        XpSelectionManager sm = XpAppContext.instance().getSelectionManager();
        sm.addSelectable(m2);
        this.initJcTree = true;
        this.updateImageVc();
        this.firePropertyChange("USERANNO_ADDED", null, m2);
    }

    @Override
    public boolean remove(XpUserAnnotationModel m2) {
        boolean res = this.userAnnoModels.remove(m2);
        this.updateImageVc();
        if (res) {
            this.firePropertyChange("USERANNO_REMOVED", null, m2);
        }
        return res;
    }

    @Override
    public List getUserAnnos() {
        return this.userAnnoModels;
    }

    public void setDebugOutput(boolean debug_out) {
        this.DEBUG = debug_out;
    }

    public void enableAutoViewMode(boolean enabled) {
        if (!enabled && this.autoViewMode) {
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            double ww = 0.0;
            double wl = 0.0;
            for (int i2 = 0; i2 < this.numImages; ++i2) {
                ww = mivc.getImageRenderAttributes().getWindowWidth();
                wl = mivc.getImageRenderAttributes().getWindowLevel();
                this.wwList[this.indices[i2]] = ww;
                this.wlList[this.indices[i2]] = wl;
            }
        }
        this.autoViewMode = enabled;
    }

    public void enableAutoWWWL(boolean enabled) {
        this.autoWWWL = enabled;
    }

    public boolean isAutoWWWL() {
        return this.autoWWWL;
    }

    public void sortImages(Comparator comp) {
        XpMedicalImage medImg;
        int i2;
        this.idxComparator.setComparator(comp);
        this.idxComparator.setData(this.imageRing);
        Integer[] sortIndices = new Integer[this.indices.length];
        for (i2 = 0; i2 < this.indices.length; ++i2) {
            sortIndices[i2] = new Integer(this.indices[i2]);
        }
        Arrays.sort(sortIndices, 0, this.numImages, this.idxComparator);
        for (i2 = 0; i2 < this.indices.length; ++i2) {
            this.indices[i2] = sortIndices[i2];
        }
        this.newIdx = this.numImages < this.capacity ? this.numImages : 0;
        this.curIdx = this.numImages - 1;
        if (this.miFilter != null && !this.miFilter.filter(medImg = this.imageRing[this.indices[this.curIdx]])) {
            this.curIdx = this.findNextImage(false);
        }
        this.updateImageVc();
    }

    public void enableFilter(XpMedicalImageFilter f2) {
        this.miFilter = f2;
        XpMedicalImage medImg = this.imageRing[this.indices[this.curIdx]];
        if (!this.miFilter.filter(medImg)) {
            this.curIdx = this.findNextImage(false);
            this.updateImageVc();
        }
    }

    public void disableFilter() {
        this.miFilter = null;
        if (this.curIdx == -1 && this.numImages > 0) {
            this.curIdx = this.numImages - 1;
            this.updateImageVc();
        }
    }

    public void setNewFrameRepaint(boolean enabled) {
        this.newFrameRepaint = enabled;
    }

    public boolean getNewFrameRepaint() {
        return this.newFrameRepaint;
    }

    public long getNewImageCount() {
        return this.newImageCount;
    }

    @Override
    public void addSliceListener(SliceListener sl) {
        if (this.sliceListeners.contains(sl)) {
            return;
        }
        this.sliceListeners.add(sl);
    }

    @Override
    public void removeSliceListener(SliceListener sl) {
        this.sliceListeners.remove(sl);
    }

    @Override
    public void setActiveSlice(XpSlice slice) {
    }

    @Override
    public void setActiveSliceIndex(int sliceIndex) {
        this.setFrame(sliceIndex);
    }

    @Override
    public int getActiveSliceIndex() {
        return this.indices[this.curIdx];
    }

    @Override
    public XpSlice[] getSlices() {
        int nFrames = this.getNumSlices();
        XpSlice[] slices = new XpSlice[nFrames];
        for (int i2 = 0; i2 < nFrames; ++i2) {
            XpSlice miSlice;
            XpImage image = this.getFrame(i2);
            slices[i2] = miSlice = image.getSlice();
        }
        return slices;
    }

    @Override
    public XpSlice getSlice(int idx) {
        XpSlice slice = null;
        XpImage image = this.getFrame(idx);
        if (image != null) {
            slice = image.getSlice();
        }
        return slice;
    }

    @Override
    public int getNumSlices() {
        return this.getNumFrames();
    }

    @Override
    public Object clone() {
        String rtype = this.getRendererType();
        XpAutoViewport iv = null;
        iv = rtype != null ? new XpAutoViewport(this.capacity, rtype) : new XpAutoViewport(this.capacity);
        iv.setSize(this.getSize());
        iv.setPreferredSize(this.getPreferredSize());
        XpMedicalImage[] imgs = this.getImages();
        int frameIndex = this.getFrameIndex();
        iv.setImages(imgs);
        iv.setFrameIndex(frameIndex);
        iv.cineQuality = this.cineQuality;
        iv.cineSkip = this.cineSkip;
        iv.lastXpImage = this.lastXpImage;
        iv._cineEndOffset = this._cineEndOffset;
        iv._cineMode = this._cineMode;
        iv._cineRate = this._cineRate;
        iv._cineStartOffset = this._cineStartOffset;
        iv.autoViewMode = this.autoViewMode;
        iv.autoWWWL = this.autoWWWL;
        int roilen = this.roiActors.size();
        for (int i2 = 0; i2 < roilen; ++i2) {
            Replicable sr;
            RoiActor newra;
            RoiActor ra = (RoiActor)this.roiActors.get(i2);
            if (!(ra instanceof Replicable) || (newra = (RoiActor)(sr = (Replicable)((Object)ra)).clone()) == null) continue;
            iv.add(newra);
        }
        int uannolen = this.userAnnoModels.size();
        for (int i3 = 0; i3 < uannolen; ++i3) {
            XpUserAnnotationModel sr;
            XpUserAnnotationModel newuam;
            XpUserAnnotationModel uam = (XpUserAnnotationModel)this.userAnnoModels.get(i3);
            if (!(uam instanceof Replicable) || (newuam = (XpUserAnnotationModel)(sr = uam).clone()) == null) continue;
            iv.add(newuam);
        }
        iv.initJcTree = true;
        iv.updateImageVc();
        this.copyObject(iv);
        iv.setImageRenderAttributes(this.ira);
        return iv;
    }

    protected void notifySliceListeners() {
        int len = this.sliceListeners.size();
        if (len > 0) {
            XpMedicalImage2DVc mivc = this.getMedicalImageVc();
            XpImage mi = mivc.getFrame();
            XpSlice activeSlice = null;
            if (mi != null) {
                activeSlice = mi.getSlice();
            }
            for (int i2 = 0; i2 < len; ++i2) {
                SliceListener sl = (SliceListener)this.sliceListeners.get(i2);
                sl.setActiveSlice(this, activeSlice);
            }
        }
    }

    protected class IndexComparator
    implements Comparator {
        protected Comparator comparator = null;
        protected XpMedicalImage[] miData = null;

        public IndexComparator() {
        }

        public IndexComparator(Comparator comp, XpMedicalImage[] data) {
            this.comparator = comp;
            this.miData = data;
        }

        public void setComparator(Comparator comp) {
            this.comparator = comp;
        }

        public void setData(XpMedicalImage[] data) {
            this.miData = data;
        }

        public int compare(Object o1, Object o2) {
            Integer i1 = (Integer)o1;
            Integer i2 = (Integer)o2;
            return this.comparator.compare(this.miData[i1], this.miData[i2]);
        }
    }
}

