/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.image.patterns.CheckerBW;
import com.ge.med.terra.jami.image.patterns.ConeSlice;
import com.ge.med.terra.jami.image.patterns.FingerPrints;
import com.ge.med.terra.jami.image.patterns.GVTK;
import com.ge.med.terra.jami.image.patterns.Hazed3DCone;
import com.ge.med.terra.jami.image.patterns.Mandelbrot;
import com.ge.med.terra.jami.image.patterns.MultiColorChecker;
import com.ge.med.terra.jami.image.patterns.Sphere;
import com.ge.med.terra.jami.image.patterns.Vertical3Color;
import com.ge.med.terra.jami.image.patterns.VerticalBW;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.TreeMap;

public abstract class XpPatternImage
implements XpMedicalImage {
    public static final int L8u = 0;
    public static final int L10u = 1;
    public static final int L12u = 2;
    public static final int L16 = 3;
    public static final int L16u = 4;
    public static final int RGB24u = 5;
    public static final int RGB32u = 6;
    public static final int CHECKER_BLOCK_DIM = 64;
    public static final String I_MANDELBROT = "mandelbrot";
    public static final String I_GVTK = "gvtk";
    public static final String I_VERT_BW = "verticalbw";
    public static final String I_VERT_3_COLOR = "vertical3color";
    public static final String I_CHECKER_BW = "checkerbw";
    public static final String I_CHECKER_COLOR = "multicolorchecker";
    public static final String I_FINGER_PRINTS = "fingerprints";
    public static final String I_SPHERE = "sphere";
    public static final String I_HAZED_3D_CONE = "hazed3DCone";
    public static final String I_CONE_SLICE = "coneslice";
    protected static Map patternFactoryMap = null;
    private static int IMAGE_FLAGS = 1;
    protected XpSlice slice = null;
    protected BufferedImage bi = null;
    protected int pixelFormat = 2;
    protected int width = 256;
    protected int height = 256;
    protected boolean loadedDefWW = false;
    protected boolean loadedDefWL = false;
    protected double defwidth = 1200.0;
    protected double deflevel = 600.0;
    protected int imageNumber = 0;
    protected double[] minmax = new double[2];
    protected static int nImages = 0;

    public XpPatternImage(int w2, int h2, XpSlice theSlice, int imgNum) {
        this.slice = theSlice;
        this.width = w2;
        this.height = h2;
        this.imageNumber = imgNum;
    }

    public XpPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
        this(w2, h2, theSlice, imgNum);
        this.pixelFormat = pixelFormat;
    }

    public XpPatternImage() {
    }

    @Override
    public final int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i2 = 0; i2 < values.length; ++i2) {
            int result = this.getValue(values[i2]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    @Override
    public final int getValue(XpDicomElement value) {
        value.value = "XXXXXXX";
        switch (value.group) {
            case 8: {
                if (value.element == 32) {
                    value.value = "2/14/2003";
                    break;
                }
                if (value.element == 34) {
                    value.value = "2/14/2003";
                    break;
                }
                if (value.element == 48) {
                    value.value = "9:01:24";
                    break;
                }
                if (value.element == 50) {
                    value.value = "9:05:47";
                    break;
                }
                if (value.element == 96) {
                    value.value = "CS";
                    break;
                }
                if (value.element == 112) {
                    value.value = "GE Power Tools";
                    break;
                }
                if (value.element == 128) {
                    value.value = "Jami Hospital";
                    break;
                }
                if (value.element == 4112) {
                    value.value = "Grinder 5";
                    break;
                }
                if (value.element == 4144) {
                    value.value = "Sawing Job";
                    break;
                }
                if (value.element != 4240) break;
                value.value = "Chainsaw 2000";
                break;
            }
            case 16: {
                if (value.element == 16) {
                    value.value = "Joe Test";
                    break;
                }
                if (value.element == 32) {
                    value.value = "12345";
                    break;
                }
                if (value.element == 48) {
                    value.value = "5/25/1969";
                    break;
                }
                if (value.element == 64) {
                    value.value = "M";
                    break;
                }
                if (value.element == 4112) {
                    value.value = "32";
                    break;
                }
                if (value.element != 4144) break;
                value.value = "190";
                break;
            }
            case 32: {
                if (value.element == 16) {
                    value.value = "88";
                    break;
                }
                if (value.element == 17) {
                    value.value = "1";
                    break;
                }
                if (value.element != 19) break;
                value.value = "" + this.imageNumber;
                break;
            }
            case 40: {
                if (value.element == 16) {
                    value.value = "" + this.height;
                    break;
                }
                if (value.element == 17) {
                    value.value = "" + this.width;
                    break;
                }
                if (value.element == 4176) {
                    value.value = "" + this.getDefaultWindowLevel();
                    break;
                }
                if (value.element == 4177) {
                    value.value = "" + this.getDefaultWindowWidth();
                    break;
                }
                if (value.element == 4178) {
                    value.value = "0";
                    break;
                }
                if (value.element == 4179) {
                    value.value = "1";
                    break;
                }
                if (value.element != 259) break;
                int pixRep = 1;
                switch (this.pixelFormat) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: {
                        pixRep = 0;
                    }
                }
                value.value = new Integer(pixRep);
            }
        }
        return 0;
    }

    @Override
    public final double getPixelDimensionX() {
        return 1.0;
    }

    @Override
    public final double getPixelDimensionY() {
        return 1.0;
    }

    @Override
    public final XpSlice getSlice() {
        return this.slice;
    }

    @Override
    public final double getRescaleIntercept() {
        return 0.0;
    }

    @Override
    public final double getRescaleSlope() {
        return 1.0;
    }

    @Override
    public final double getAzimuth() {
        return 0.0;
    }

    private void loadWWWL() {
        XpImageUtils.getMinMax(this, 7, this.minmax);
        short minval = (short)this.minmax[0];
        int maxval = (int)this.minmax[1];
        switch (this.pixelFormat) {
            case 4: {
                minval = 0;
                maxval = 65535;
            }
        }
        double ww = maxval - minval;
        double wl = (double)(maxval + minval) / 2.0;
        this.defwidth = (int)ww;
        this.deflevel = (int)wl;
        this.loadedDefWL = true;
        this.loadedDefWW = true;
    }

    @Override
    public double getDefaultWindowWidth() {
        if (!this.loadedDefWW) {
            this.loadWWWL();
        }
        return this.defwidth;
    }

    @Override
    public double getDefaultWindowLevel() {
        if (!this.loadedDefWL) {
            this.loadWWWL();
        }
        return this.deflevel;
    }

    private static void registerPatternTypes() {
        patternFactoryMap = new TreeMap();
        patternFactoryMap.put(I_GVTK, new GvtkPatternCreator());
        patternFactoryMap.put("checker", new CheckerPatternCreator());
        patternFactoryMap.put(I_MANDELBROT, new MandelbrotPatternCreator());
        patternFactoryMap.put(I_VERT_BW, new VerticalBWPatternCreator());
        patternFactoryMap.put(I_VERT_3_COLOR, new Vertical3ColorPatternCreator());
        patternFactoryMap.put(I_CHECKER_BW, new CheckerBWPatternCreator());
        patternFactoryMap.put(I_CHECKER_COLOR, new MultiColorCheckerPatternCreator());
        patternFactoryMap.put(I_FINGER_PRINTS, new FingerPrintsPatternCreator());
        patternFactoryMap.put(I_SPHERE, new SphereCreator());
        patternFactoryMap.put(I_HAZED_3D_CONE, new Hazed3DConeCreator());
        patternFactoryMap.put(I_CONE_SLICE, new ConeSliceCreator());
    }

    public static XpMedicalImage[] getCheckeredImages(int nImages, int w2, int h2, int pixFormat) {
        return XpPatternImage.getPatternImages("checker", nImages, w2, h2, pixFormat);
    }

    public static XpMedicalImage[] getPatternImages(int nImages, int w2, int h2, int pixFormat) {
        return XpPatternImage.getPatternImages(I_GVTK, nImages, w2, h2, pixFormat);
    }

    public static XpMedicalImage[] getPatternImages(String patternType, int nImages, int w2, int h2, int pixFormat) {
        return XpPatternImage.getPatternImages(patternType, nImages, w2, h2, pixFormat, 1);
    }

    public static XpMedicalImage[] getPatternImages(String patternType, int nImages, int w2, int h2, int pixFormat, int flags) {
        XpPatternCreator pc;
        IMAGE_FLAGS = flags;
        XpPatternImage.nImages = nImages;
        if (patternFactoryMap == null) {
            XpPatternImage.registerPatternTypes();
        }
        if ((pc = (XpPatternCreator)patternFactoryMap.get(patternType)) == null) {
            return null;
        }
        XpMedicalImage[] imgs = new XpMedicalImage[nImages];
        CPoint ul = new CPoint(0, 0, 0, 2);
        CPoint ur = new CPoint(w2, 0, 0, 2);
        CPoint br = new CPoint(w2, h2, 0, 2);
        CPoint thickness = new CPoint(0, 0, 1, 2);
        for (int i2 = 0; i2 < nImages; ++i2) {
            XpSlice slice = new XpSlice(ul, ur, br, w2, h2);
            imgs[i2] = pc.createPatternImage(w2, h2, slice, pixFormat, i2);
            ul.add(thickness);
            ur.add(thickness);
            br.add(thickness);
        }
        return imgs;
    }

    @Override
    public abstract RenderedImage getPixelData();

    public XjImage getXjImage() {
        return new XjPatternImage(this);
    }

    private class XjPatternImage
    implements XjImage {
        private XpMedicalImage medImage = null;

        public XjPatternImage(XpMedicalImage medicalImage) {
            this.medImage = medicalImage;
        }

        @Override
        public Object getValue(int group, int element) {
            XpDicomElement elem = new XpDicomElement(group, element);
            if (this.medImage.getValue(elem) == 0) {
                return elem.value;
            }
            return null;
        }

        @Override
        public RenderedImage getImageData() {
            return this.medImage.getPixelData();
        }

        @Override
        public int getWidth() {
            return this.medImage.getPixelData().getWidth();
        }

        @Override
        public int getHeight() {
            return this.medImage.getPixelData().getHeight();
        }

        @Override
        public int getValues(XjTagValue[] tv) {
            for (int i2 = 0; i2 < tv.length; ++i2) {
                tv[i2].value = this.getValue(tv[i2].group, tv[i2].element);
            }
            return tv.length;
        }

        @Override
        public String getFilePath() {
            return "";
        }

        @Override
        public long getPixelOffset() {
            return 0L;
        }
    }

    private static class ConeSliceImage
    extends XpPatternImage {
        private int imgNum;

        public ConeSliceImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
            this.imgNum = imgNum;
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat != 5 && this.pixelFormat != 6) {
                    this.bi = new BufferedImage(this.width, this.height, 11);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferUShort db = (DataBufferUShort)r2.getDataBuffer();
                    short[] data = db.getData();
                    ConeSlice set = new ConeSlice();
                    double index = (double)(2 * this.width) / 5.0 / (double)nImages;
                    int dradius = (int)(index * (double)this.imgNum);
                    int radius = (int)((double)dradius * 0.66);
                    set.create(data, this.width, this.height, radius, dradius, 40.0, false, this.pixelFormat);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class ConeSliceCreator
    implements XpPatternCreator {
        private ConeSliceCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new ConeSliceImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class Hazed3DConeImage
    extends XpPatternImage {
        private int imgNum;

        public Hazed3DConeImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
            this.imgNum = imgNum;
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    Hazed3DCone set = new Hazed3DCone();
                    set.create(data, this.width, this.height, 20, 120, 50.5, 60, 180, false);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class Hazed3DConeCreator
    implements XpPatternCreator {
        private Hazed3DConeCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new Hazed3DConeImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class SphereImage
    extends XpPatternImage {
        public SphereImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    Sphere set = new Sphere();
                    set.create(data, this.width, this.height, 0, 160, 60.0, true);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class SphereCreator
    implements XpPatternCreator {
        private SphereCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new SphereImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class FingerPrintsPatternImage
    extends XpPatternImage {
        public FingerPrintsPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    FingerPrints set = new FingerPrints();
                    set.create(data, this.width, this.height);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class FingerPrintsPatternCreator
    implements XpPatternCreator {
        private FingerPrintsPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new FingerPrintsPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class CheckerBWPatternImage
    extends XpPatternImage {
        public CheckerBWPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                this.bi = new BufferedImage(this.width, this.height, 11);
                WritableRaster r2 = this.bi.getRaster();
                DataBufferUShort db = (DataBufferUShort)r2.getDataBuffer();
                short[] data = db.getData();
                CheckerBW set = new CheckerBW();
                set.create(data, this.width, this.height, this.pixelFormat);
            }
            return this.bi;
        }
    }

    private static class CheckerBWPatternCreator
    implements XpPatternCreator {
        private CheckerBWPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new CheckerBWPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class MultiColorCheckerPatternImage
    extends XpPatternImage {
        public MultiColorCheckerPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    MultiColorChecker set = new MultiColorChecker();
                    set.create(data, this.width, this.height);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class MultiColorCheckerPatternCreator
    implements XpPatternCreator {
        private MultiColorCheckerPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new MultiColorCheckerPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class Vertical3ColorPatternImage
    extends XpPatternImage {
        public Vertical3ColorPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    Vertical3Color set = new Vertical3Color();
                    set.create(data, this.width, this.height);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class Vertical3ColorPatternCreator
    implements XpPatternCreator {
        private Vertical3ColorPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new Vertical3ColorPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class VerticalBWPatternImage
    extends XpPatternImage {
        public VerticalBWPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    VerticalBW set = new VerticalBW();
                    set.createRGB(data, this.width, this.height);
                } else if (this.pixelFormat == 0) {
                    this.bi = new BufferedImage(this.width, this.height, 10);
                    WritableRaster r3 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r3.getDataBuffer();
                    byte[] data = db.getData();
                    VerticalBW set = new VerticalBW();
                    set.create(data, this.width, this.height);
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class VerticalBWPatternCreator
    implements XpPatternCreator {
        private VerticalBWPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new VerticalBWPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class MandelbrotPatternImage
    extends XpPatternImage {
        public MandelbrotPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r2.getDataBuffer();
                    byte[] data = db.getData();
                    String palette = "palette0" + IMAGE_FLAGS;
                    Mandelbrot set = new Mandelbrot(data, this.height, this.width, palette);
                    set.create();
                } else {
                    throw new RuntimeException("Unsupported pixel type for this pattern image type");
                }
            }
            return this.bi;
        }
    }

    private static class MandelbrotPatternCreator
    implements XpPatternCreator {
        private MandelbrotPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new MandelbrotPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class CheckerPatternImage
    extends XpPatternImage {
        public CheckerPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public double getDefaultWindowWidth() {
            switch (this.pixelFormat) {
                case 1: {
                    return 1024.0;
                }
                case 2: {
                    return 4096.0;
                }
                case 4: {
                    return 65536.0;
                }
                case 3: {
                    return 65536.0;
                }
                case 0: {
                    return 256.0;
                }
            }
            return 1200.0;
        }

        @Override
        public double getDefaultWindowLevel() {
            switch (this.pixelFormat) {
                case 1: {
                    return 512.0;
                }
                case 2: {
                    return 2048.0;
                }
                case 4: {
                    return 32768.0;
                }
                case 3: {
                    return 0.0;
                }
                case 0: {
                    return 128.0;
                }
            }
            return 600.0;
        }

        private void fillCheckerBoard(int minVal, int maxVal, Graphics g2, short[] data, int w2, int h2) {
            int y2;
            int nb_x = w2 / 64;
            int nb_y = h2 / 64;
            int nblocks = nb_x * nb_y;
            for (y2 = 0; y2 < h2; ++y2) {
                int yoffset = y2 * w2;
                int yb = y2 / 64;
                int yboffset = yb * nb_x;
                for (int x2 = 0; x2 < w2; ++x2) {
                    int xb = x2 / 64;
                    int block_offset = yboffset + xb;
                    double pct = (double)block_offset / (double)nblocks;
                    int pixVal = (int)((double)minVal + (double)(maxVal - minVal) * pct);
                    data[yoffset + x2] = (short)pixVal;
                }
            }
            for (y2 = 0; y2 < nb_y; ++y2) {
                int yy = 64 * y2;
                int yyoffset = yy * w2;
                for (int x3 = 0; x3 < nb_x; ++x3) {
                    int xx = 64 * x3;
                    double pct = (double)(y2 * nb_x + x3) / (double)nblocks;
                    Color c2 = Color.white;
                    if (pct > 0.5) {
                        c2 = Color.black;
                    }
                    int pixVal = (int)((double)minVal + (double)(maxVal - minVal) * pct);
                    g2.setColor(c2);
                    g2.drawString("" + pixVal, xx + 16, yy + 32);
                }
            }
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                if (this.pixelFormat == 2 || this.pixelFormat == 1 || this.pixelFormat == 4 || this.pixelFormat == 3) {
                    this.bi = new BufferedImage(this.width, this.height, 11);
                    Graphics g2 = this.bi.getGraphics();
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferUShort db = (DataBufferUShort)r2.getDataBuffer();
                    short[] data = db.getData();
                    int minVal = 0;
                    int maxVal = 16384;
                    switch (this.pixelFormat) {
                        case 2: {
                            minVal = 0;
                            maxVal = 4095;
                            break;
                        }
                        case 1: {
                            minVal = 0;
                            maxVal = 1023;
                            break;
                        }
                        case 4: {
                            minVal = 0;
                            maxVal = 65535;
                            break;
                        }
                        case 3: {
                            minVal = Short.MIN_VALUE;
                            maxVal = Short.MAX_VALUE;
                        }
                    }
                    this.fillCheckerBoard(minVal, maxVal, g2, data, this.width, this.height);
                } else if (this.pixelFormat == 0) {
                    this.bi = new BufferedImage(this.width, this.height, 10);
                    WritableRaster r3 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r3.getDataBuffer();
                    byte[] byArray = db.getData();
                }
            }
            return this.bi;
        }
    }

    private static class GvtkPatternImage
    extends XpPatternImage {
        public GvtkPatternImage(int w2, int h2, XpSlice theSlice, int pixelFormat, int imgNum) {
            super(w2, h2, theSlice, pixelFormat, imgNum);
        }

        @Override
        public RenderedImage getPixelData() {
            if (this.bi == null) {
                GVTK image = new GVTK();
                if (this.pixelFormat == 2 || this.pixelFormat == 1 || this.pixelFormat == 3 || this.pixelFormat == 4) {
                    this.bi = new BufferedImage(this.width, this.height, 11);
                    WritableRaster r2 = this.bi.getRaster();
                    DataBufferUShort db = (DataBufferUShort)r2.getDataBuffer();
                    short[] data = db.getData();
                    GVTK.fillWithTestPattern(data, this.width, this.height, this.pixelFormat, this.imageNumber);
                } else if (this.pixelFormat == 5) {
                    this.bi = new BufferedImage(this.width, this.height, 5);
                    WritableRaster r3 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r3.getDataBuffer();
                    byte[] data = db.getData();
                    GVTK.fillWithColorTestPattern(data, this.width, this.height, this.imageNumber);
                } else if (this.pixelFormat == 0) {
                    this.bi = new BufferedImage(this.width, this.height, 10);
                    WritableRaster r4 = this.bi.getRaster();
                    DataBufferByte db = (DataBufferByte)r4.getDataBuffer();
                    byte[] data = db.getData();
                    GVTK.fillWithTestPattern(data, this.width, this.height, this.imageNumber);
                } else {
                    this.bi = new BufferedImage(this.width, this.height, 1);
                    WritableRaster r5 = this.bi.getRaster();
                    DataBufferInt db = (DataBufferInt)r5.getDataBuffer();
                    int[] data = db.getData();
                    byte[] bdata = new byte[3 * this.width * this.height];
                    GVTK.fillWithColorTestPattern(bdata, this.width, this.height, this.imageNumber);
                    for (int i2 = 0; i2 < data.length; ++i2) {
                        data[i2] = 0xFF000000 | bdata[3 * i2] << 16 | bdata[3 * i2 + 1] << 8 | bdata[3 * i2 + 2];
                    }
                }
            }
            return this.bi;
        }
    }

    private static class CheckerPatternCreator
    implements XpPatternCreator {
        private CheckerPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new CheckerPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    private static class GvtkPatternCreator
    implements XpPatternCreator {
        private GvtkPatternCreator() {
        }

        @Override
        public XpMedicalImage createPatternImage(int w2, int h2, XpSlice slice, int pixelFormat, int imgNum) {
            return new GvtkPatternImage(w2, h2, slice, pixelFormat, imgNum);
        }
    }

    protected static interface XpPatternCreator {
        public XpMedicalImage createPatternImage(int var1, int var2, XpSlice var3, int var4, int var5);
    }
}

