/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

class ComplexNumber {
    protected double real;
    protected double complex;

    public ComplexNumber() {
        this(0.0, 0.0);
    }

    public ComplexNumber(ComplexNumber num) {
        this(num.real, num.complex);
    }

    public ComplexNumber(double real, double complex) {
        this.real = real;
        this.complex = complex;
    }

    public ComplexNumber add(ComplexNumber num) {
        ComplexNumber val = new ComplexNumber(num);
        val.real += this.real;
        val.complex += this.complex;
        return val;
    }

    public ComplexNumber sub(ComplexNumber num) {
        ComplexNumber val = new ComplexNumber(this);
        val.real -= num.real;
        val.complex -= num.complex;
        return val;
    }

    public ComplexNumber squared() {
        ComplexNumber val = new ComplexNumber();
        val.real = this.real * this.real - this.complex * this.complex;
        val.complex = 2.0 * this.real * this.complex;
        return val;
    }

    public String toString() {
        String val = "";
        val = val + "real: ";
        val = val + this.getRPart();
        val = val + "  complex: ";
        val = val + this.getCPart();
        return val;
    }

    public double magnitude() {
        return Math.sqrt(this.real * this.real + this.complex * this.complex);
    }

    public double getCPart() {
        return this.complex;
    }

    public double getRPart() {
        return this.real;
    }

    public void setCPart(double cpart) {
        this.complex = cpart;
    }

    public void setRPart(double rpart) {
        this.real = rpart;
    }
}

