/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import com.ge.med.terra.jami.XpLog;
import java.awt.Point;

public class ConeSlice {
    private int w;
    private int h;
    public static double ADJUSTED_DECAY = 0.0;
    private int maxpixel = 255;

    public void create(short[] d2, int w2, int h2, int solidR, int decayR, double decayX, boolean invert, int pixelFormat) {
        this.w = w2;
        this.h = h2;
        switch (pixelFormat) {
            case 0: {
                this.maxpixel = 255;
                break;
            }
            case 1: {
                this.maxpixel = 511;
                break;
            }
            case 2: {
                this.maxpixel = 4095;
                break;
            }
            case 3: {
                this.maxpixel = 32766;
                break;
            }
            case 4: {
                this.maxpixel = 65534;
                break;
            }
            default: {
                XpLog.logger().severe("XpPatternImage: probably cannot handle format " + pixelFormat);
            }
        }
        int bgcolor = invert ? this.maxpixel : 0;
        d2 = this.fillBackGround(d2, bgcolor);
        Point center = new Point(w2 / 2, h2 / 2);
        d2 = this.drawHazedCircle(d2, solidR, decayR, decayX, invert);
    }

    private short[] drawSolidCircle(short[] d2, int solidR, Point center, int color) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int ytop = y0 - solidR;
        int ybottom = y0 + solidR;
        if (ytop < 0) {
            ytop = 0;
        }
        if (ybottom > this.h) {
            ybottom = this.h;
        }
        for (int y2 = ytop; y2 < ybottom; ++y2) {
            int w2 = (int)Math.sqrt(Math.pow(solidR, 2.0) - Math.pow(y2 - y0, 2.0));
            if (w2 > this.w / 2) {
                w2 = this.w / 2;
            }
            int startPixel = y2 * this.w + (x0 - w2);
            int endPixel = startPixel + 2 * w2;
            for (int i2 = startPixel; i2 < endPixel; ++i2) {
                d2[i2] = (short)color;
            }
        }
        return d2;
    }

    private short[] drawHazedCircle(short[] d2, int solidR, int decayR, double decayX, boolean invert) {
        int x2 = decayR - solidR;
        Point center = new Point(this.w / 2, this.h / 2);
        boolean b2 = false;
        if (x2 < 0) {
            x2 = decayR;
        }
        for (int i2 = 0; i2 < x2; ++i2) {
            int color = invert ? (int)((double)this.maxpixel * (1.0 - Math.exp((double)(-(x2 - i2)) / decayX))) : (int)((double)this.maxpixel * Math.exp((double)(-(x2 - i2)) / decayX));
            d2 = this.drawSolidCircle(d2, solidR + (x2 - i2), center, color);
        }
        int centerColor = invert ? 0 : this.maxpixel;
        d2 = this.drawSolidCircle(d2, solidR, center, centerColor);
        return d2;
    }

    private short[] fillBackGround(short[] d2, int color) {
        for (int i2 = 0; i2 < d2.length; ++i2) {
            d2[i2] = (short)color;
        }
        return d2;
    }
}

