/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import com.ge.med.terra.jami.XpLog;
import java.text.DecimalFormat;

public class GVTK {
    private static final DecimalFormat df = new DecimalFormat("00000000");
    private static short MAXPIXEL = (short)2047;
    private static String[] digits = new String[]{"@@@@@  @@  @@  @@@@@@", "   @   @   @   @   @", "@@@@   @@@@@@   @@@@", "@@@@   @@@@@   @@@@@", "@  @@  @@@@@   @   @", "@@@@@   @@@@   @@@@@", "@   @   @@@@@  @@@@@", "@@@@   @   @   @   @", "@@@@@  @@@@@@  @@@@@", "@@@@@  @@@@@   @   @"};

    public static void fillWithTestPattern(short[] p2, int width, int height, int pixelFormat, int seq) {
        int x2;
        int y2;
        int maxpixel = MAXPIXEL;
        switch (pixelFormat) {
            case 1: {
                maxpixel = 511;
                break;
            }
            case 2: {
                maxpixel = 4095;
                break;
            }
            case 3: {
                maxpixel = Short.MAX_VALUE;
                break;
            }
            case 4: {
                maxpixel = 65535;
                break;
            }
            default: {
                XpLog.logger().warning("XpPatternImage: probably cannot handle format " + pixelFormat);
            }
        }
        int w2 = width / 2;
        int h2 = height / 2;
        int border = w2 / 7 + 2;
        short[] d2 = p2;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        for (y2 = 0; y2 < height; ++y2) {
            float frac = (float)y2 / (float)(height - 1);
            frac += fseq;
            while ((double)frac > 1.0) {
                frac = (float)((double)frac - 1.0);
            }
            while ((double)frac < 0.0) {
                frac = (float)((double)frac + 1.0);
            }
            int val = (int)(frac * (float)maxpixel);
            for (x2 = 0; x2 < width; ++x2) {
                d2[x2 + y2 * width] = (short)val;
            }
        }
        for (y2 = border; y2 < h2 - border; ++y2) {
            for (x2 = border; x2 < w2 - border; ++x2) {
                d2[y2 * width + x2] = (short)maxpixel;
            }
        }
        for (y2 = border; y2 < h2 - border; ++y2) {
            for (x2 = width - w2 + border; x2 < width - border; ++x2) {
                d2[y2 * width + x2] = 0;
            }
        }
        int lwidth = 1;
        x2 = border;
        while (x2 + lwidth < width) {
            for (y2 = h2 + border; y2 < height - border; ++y2) {
                for (int l2 = 0; l2 < lwidth; ++l2) {
                    d2[y2 * width + x2 + l2] = 0;
                }
            }
            x2 += 2 * (lwidth += 2);
        }
        int num_digits = (w2 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            String strBuff = df.format(seq);
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            strBuff.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                char charDig = sbuf[nd + max_digits - num_digits];
                int ix = charDig - 48;
                String digitStr = digits[ix];
                digitStr.getChars(0, digitStr.length() - 1, digit, 0);
                for (x2 = 0; x2 < 4; ++x2) {
                    for (y2 = 0; y2 < 5; ++y2) {
                        if (digit[x2 + y2 * 4] != '@') continue;
                        d2[x0 + x2 + (y2 + y0) * width] = 0;
                    }
                }
            }
        }
    }

    public static void fillWithTestPattern(byte[] p2, int width, int height, int seq) {
        int x2;
        int y2;
        int maxpixel = 255;
        int w2 = width / 2;
        int h2 = height / 2;
        int border = w2 / 7 + 2;
        byte[] d2 = p2;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        for (y2 = 0; y2 < height; ++y2) {
            float frac = (float)y2 / (float)(height - 1);
            frac += fseq;
            while ((double)frac > 1.0) {
                frac = (float)((double)frac - 1.0);
            }
            while ((double)frac < 0.0) {
                frac = (float)((double)frac + 1.0);
            }
            int val = (int)(frac * (float)maxpixel);
            for (x2 = 0; x2 < width; ++x2) {
                d2[x2 + y2 * width] = (byte)val;
            }
        }
        for (y2 = border; y2 < h2 - border; ++y2) {
            for (x2 = border; x2 < w2 - border; ++x2) {
                d2[x2 + y2 * width] = (byte)maxpixel;
            }
        }
        for (y2 = border; y2 < h2 - border; ++y2) {
            for (x2 = width - w2 + border; x2 < width - border; ++x2) {
                d2[x2 + y2 * width] = 0;
            }
        }
        int lwidth = 1;
        x2 = border;
        while (x2 + lwidth < width) {
            for (y2 = h2 + border; y2 < height - border; ++y2) {
                for (int l2 = 0; l2 < lwidth; ++l2) {
                    d2[x2 + l2 + y2 * width] = 0;
                }
            }
            x2 += 2 * (lwidth += 2);
        }
        int num_digits = (w2 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            String strBuff = df.format(seq);
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            strBuff.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                char charDig = sbuf[nd + max_digits - num_digits];
                int ix = charDig - 48;
                String digitStr = digits[ix];
                digitStr.getChars(0, digitStr.length() - 1, digit, 0);
                for (x2 = 0; x2 < 4; ++x2) {
                    for (y2 = 0; y2 < 5; ++y2) {
                        if (digit[x2 + y2 * 4] != '@') continue;
                        d2[x0 + x2 + (y2 + y0) * width] = 0;
                    }
                }
            }
        }
    }

    public static void fillWithColorTestPattern(byte[] p2, int width, int height, int seq) {
        int x2;
        int y2;
        int maxpixel = 255;
        int w2 = width;
        int h2 = height;
        int w22 = w2 / 2;
        int h22 = h2 / 2;
        int border = w22 / 7 + 2;
        float const1 = (float)(h2 - 1) / (float)(w2 - 1);
        float const2 = -const1;
        float const3 = h2 - 1;
        byte[] d2 = p2;
        float fseq = seq;
        fseq = (float)((double)fseq * 0.05);
        if (w2 <= 1 || h2 <= 1) {
            XpLog.logger().warning("Image size is too small.");
            return;
        }
        for (y2 = 0; y2 < h2; ++y2) {
            for (x2 = 0; x2 < w2; ++x2) {
                byte val;
                double frac;
                if ((float)y2 >= const1 * (float)x2) {
                    if ((float)y2 >= const2 * (float)x2 + const3) {
                        frac = (float)((double)h2 - 1.0 - (double)y2) / (float)h22;
                        d2[3 * (x2 + y2 * w2) + 2] = val = (byte)(frac * (double)maxpixel);
                        d2[3 * (x2 + y2 * w2) + 1] = val;
                        frac = 1.0 - ((double)x2 - (double)((float)((double)h2 - 1.0 - (double)y2)) * ((double)w2 - 1.0) / ((double)h2 - 1.0)) / ((double)w2 - 1.0);
                        d2[3 * (x2 + y2 * w2)] = val = (byte)(frac * (double)maxpixel);
                        continue;
                    }
                    frac = ((double)h2 - 1.0 - ((double)y2 - (double)x2 * ((double)h2 - 1.0) / ((double)w2 - 1.0))) / ((double)h2 - 1.0);
                    d2[3 * (x2 + y2 * w2) + 2] = val = (byte)(frac * (double)maxpixel);
                    frac = 2.0 * (double)x2 / ((double)w2 - 1.0);
                    d2[3 * (x2 + y2 * w2) + 1] = val = (byte)(frac * (double)maxpixel);
                    frac = ((double)y2 + (double)x2 * ((double)h2 - 1.0) / ((double)w2 - 1.0)) / ((double)w2 - 1.0);
                    d2[3 * (x2 + y2 * w2)] = val = (byte)(frac * (double)maxpixel);
                    continue;
                }
                if ((float)y2 >= const2 * (float)x2 + const3) {
                    frac = ((double)w2 - 1.0 - (double)x2) * 2.0 / ((double)w2 - 1.0);
                    d2[3 * (x2 + y2 * w2)] = val = (byte)(frac * (double)maxpixel);
                    d2[3 * (x2 + y2 * w2) + 2] = val;
                    frac = ((double)((float)((double)h2 - 1.0) - (float)y2) + (double)((float)((double)h2 - 1.0)) * ((double)w2 - 1.0 - (double)x2) / ((double)h2 - 1.0)) / ((double)h2 - 1.0);
                    d2[3 * (x2 + y2 * w2) + 1] = val = (byte)(frac * (double)maxpixel);
                    continue;
                }
                frac = ((double)w2 - 1.0 - (double)x2 + ((double)w2 - 1.0) * (double)y2 / ((double)h2 - 1.0)) / ((double)w2 - 1.0);
                d2[3 * (x2 + y2 * w2) + 2] = val = (byte)(frac * (double)maxpixel);
                frac = ((double)x2 + ((double)w2 - 1.0) * (double)y2 / ((double)h2 - 1.0)) / ((double)w2 - 1.0);
                d2[3 * (x2 + y2 * w2) + 1] = val = (byte)(frac * (double)maxpixel);
                frac = (float)y2 / (float)h22;
                d2[3 * (x2 + y2 * w2)] = val = (byte)(frac * (double)maxpixel);
            }
        }
        double x_center = (double)border + 3.0 * ((double)w22 - 2.0 * (double)border) / 4.0;
        double y_center = (double)border + 3.0 * ((double)h22 - 2.0 * (double)border) / 4.0;
        double radius_square = 9.0 * ((double)w22 - 2.0 * (double)border) * ((double)w22 - 2.0 * (double)border) / 256.0;
        double inner_radius_square = (3.0 * ((double)w22 - 2.0 * (double)border) / 16.0 - 0.5) * (3.0 * ((double)w22 - 2.0 * (double)border) / 16.0 - 0.5);
        double outer_radius_square = (3.0 * ((double)w22 - 2.0 * (double)border) / 16.0 + 0.5) * (3.0 * ((double)w22 - 2.0 * (double)border) / 16.0 + 0.5);
        for (y2 = border; y2 < h22 - border; ++y2) {
            for (x2 = border; x2 < w22 - border; ++x2) {
                if ((float)y2 <= (float)h22 * (1.0f - (float)x2 / (float)w22) - 1.0f) {
                    d2[3 * (x2 + y2 * w2)] = (byte)maxpixel;
                    d2[3 * (x2 + y2 * w2) + 1] = (byte)maxpixel;
                    d2[3 * (x2 + y2 * w2) + 2] = (byte)maxpixel;
                    continue;
                }
                d2[3 * (x2 + y2 * w2)] = 0;
                d2[3 * (x2 + y2 * w2) + 1] = (byte)maxpixel;
                d2[3 * (x2 + y2 * w2) + 2] = 0;
                if (!(((double)x2 - x_center) * ((double)x2 - x_center) + ((double)y2 - y_center) * ((double)y2 - y_center) <= radius_square)) continue;
                d2[3 * (x2 + y2 * w2)] = (byte)maxpixel;
                d2[3 * (x2 + y2 * w2) + 1] = 0;
                d2[3 * (x2 + y2 * w2) + 2] = 0;
            }
        }
        x_center = (double)(w2 - w22 + border) + 1.0 * ((double)w22 - 2.0 * (double)border) / 4.0 - 1.0;
        for (y2 = border; y2 < h22 - border; ++y2) {
            for (x2 = w2 - w22 + border; x2 < w2 - border; ++x2) {
                double radius_square_cur;
                d2[3 * (x2 + y2 * w2)] = 0;
                d2[3 * (x2 + y2 * w2) + 1] = 0;
                d2[3 * (x2 + y2 * w2) + 2] = 0;
                if ((double)y2 >= (double)((float)(h2 - h22) * ((float)x2 / (float)(w2 - w22) - 1.0f)) - 0.5 && (double)y2 < (double)((float)(h2 - h22) * ((float)x2 / (float)(w2 - w22) - 1.0f)) + 0.5) {
                    d2[3 * (x2 + y2 * w2)] = 0;
                    d2[3 * (x2 + y2 * w2) + 1] = (byte)maxpixel;
                    d2[3 * (x2 + y2 * w2) + 2] = (byte)maxpixel;
                }
                if (!((radius_square_cur = ((double)x2 - x_center) * ((double)x2 - x_center) + ((double)y2 - y_center) * ((double)y2 - y_center)) >= inner_radius_square) || !(radius_square_cur < outer_radius_square)) continue;
                d2[3 * (x2 + y2 * w2)] = 0;
                d2[3 * (x2 + y2 * w2) + 1] = 0;
                d2[3 * (x2 + y2 * w2) + 2] = (byte)maxpixel;
            }
        }
        int lwidth = 1;
        x2 = border;
        while (x2 + lwidth < width) {
            byte value_red;
            int quotient = lwidth / 8;
            int reminder = lwidth - quotient * 8;
            byte value_green = value_red = (byte)((float)quotient / (float)(quotient + 1) * (float)maxpixel);
            byte value_blue = value_red;
            switch (reminder) {
                case 1: 
                case 3: {
                    value_red = (byte)maxpixel;
                    break;
                }
                case 5: {
                    value_green = (byte)maxpixel;
                    break;
                }
                case 7: {
                    value_blue = (byte)maxpixel;
                    break;
                }
                default: {
                    XpLog.logger().severe("XpPatternImage: internal error");
                }
            }
            for (y2 = h22 + border; y2 < height - border; ++y2) {
                for (int l2 = 0; l2 < lwidth; ++l2) {
                    d2[3 * (x2 + l2 + y2 * w2) + 2] = value_red;
                    d2[3 * (x2 + l2 + y2 * w2) + 1] = value_green;
                    d2[3 * (x2 + l2 + y2 * w2)] = value_blue;
                }
            }
            x2 += 2 * (lwidth += 2);
        }
        int num_digits = (w22 - 1) / 5;
        int max_digits = 8;
        if (num_digits >= 1) {
            if (num_digits > max_digits) {
                num_digits = max_digits;
            }
            char[] sbuf = new char[32];
            char[] digit = new char[32];
            String strBuf = df.format(seq);
            strBuf.getChars(0, max_digits, sbuf, 0);
            for (int nd = 0; nd < num_digits; ++nd) {
                int x0 = border + 1 + 5 * nd;
                int y0 = border + 1;
                int ix = sbuf[nd + max_digits - num_digits] - 48;
                String strDigit = digits[ix];
                strDigit.getChars(0, strDigit.length() - 1, digit, 0);
                for (x2 = 0; x2 < 4; ++x2) {
                    for (y2 = 0; y2 < 5; ++y2) {
                        if (digit[x2 + y2 * 4] != '@') continue;
                        d2[3 * (x0 + x2 + (y2 + y0) * w2)] = 0;
                        d2[3 * (x0 + x2 + (y2 + y0) * w2) + 1] = 0;
                        d2[3 * (x0 + x2 + (y2 + y0) * w2) + 2] = 0;
                    }
                }
            }
        }
    }
}

