/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image.patterns;

import java.awt.Point;

public class Sphere {
    private int w;
    private int h;

    public void create(byte[] d2, int w2, int h2, int solidR, int decayR, double decayX, boolean invert) {
        this.w = w2;
        this.h = h2;
        int max = -1;
        boolean min = false;
        int bgcolor = 0xFFCCCC;
        d2 = this.fillBackGround(d2, bgcolor);
        Point center = new Point(w2 / 2, h2 / 2);
        d2 = this.drawSphere(d2, solidR, decayR, decayX, invert);
    }

    private byte[] drawSolidCircle(byte[] d2, int solidR, Point center, int color) {
        int x0 = (int)center.getX();
        int y0 = (int)center.getY();
        int ytop = y0 - solidR;
        int ybottom = y0 + solidR;
        for (int y2 = ytop; y2 < ybottom; ++y2) {
            int w2 = (int)Math.sqrt(Math.pow(solidR, 2.0) - Math.pow(y2 - y0, 2.0));
            int startPixel = y2 * this.w * 3 + (x0 - w2) * 3;
            int endPixel = startPixel + 2 * w2 * 3;
            for (int i2 = startPixel; i2 < endPixel; i2 += 3) {
                d2[i2] = (byte)(color >> 16 & 0xFF);
                d2[i2 + 1] = (byte)(color >> 8 & 0xFF);
                d2[i2 + 2] = (byte)(color >> 0 & 0xFF);
            }
        }
        return d2;
    }

    private byte[] drawSphere(byte[] d2, int solidR, int decayR, double decayX, boolean invert) {
        int x2 = decayR - solidR;
        Point center = new Point(this.w / 2, this.h / 2);
        int b2 = 0;
        if (x2 < 0) {
            x2 = decayR;
        }
        for (int i2 = 0; i2 < x2; ++i2) {
            b2 = invert ? (int)(255.0 * (1.0 - Math.exp((double)(-i2) / decayX))) & 0xFF : (int)(255.0 * Math.exp((double)(-i2) / decayX)) & 0xFF;
            int color = (b2 << 16) + (b2 << 8) + b2;
            d2 = this.drawSolidCircle(d2, solidR + (x2 - i2), center, color);
        }
        d2 = this.drawSolidCircle(d2, solidR, center, 0);
        return d2;
    }

    private byte[] fillBackGround(byte[] d2, int color) {
        for (int i2 = 0; i2 < d2.length; i2 += 3) {
            d2[i2] = (byte)(color >> 16 & 0xFF);
            d2[i2 + 1] = (byte)(color >> 8 & 0xFF);
            d2[i2 + 2] = (byte)(color >> 0 & 0xFF);
        }
        return d2;
    }
}

