/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnVector3i;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.ProgressiveAutoSelect;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;

public class AutoSelectVc
extends XpVisualComponent
implements MouseInputListener,
ActionListener {
    Thread growingThread;
    boolean growing;
    private XjVolumeInfo volume;
    private int[] dims;
    static final byte[] MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    ProgressiveAutoSelect pas = new ProgressiveAutoSelect();
    private Timer updateTimer;
    boolean notFirstTime = false;

    public AutoSelectVc() {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public boolean contains(int x2, int y2) {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        Container parent = this.getParent();
        SegmentationCapable vrc = null;
        T3DComponent tc = null;
        if (parent instanceof T3DComponent) {
            tc = (T3DComponent)parent;
            vrc = (VrCapable)tc.getCapable("com.ge.med.terra.jami.capable.VrCapable");
        }
        if (vrc != null) {
            vrc.setSegmentationVisible(true);
            vrc.setSegmentationColorMap(new int[]{new Color(0, 200, 0, 100).getRGB(), 0});
            this.volume = tc.getVolume();
            if (this.volume == null) {
                return;
            }
            this.dims = this.volume.getVolumeDimensions(null);
            JVolume.LinearShort jvol = (JVolume.LinearShort)((J3DVolumeModel)tc.getVolumeModel()).j_vol;
            this.pas.setData(jvol.volume, jvol.PAD, this.dims);
            System.out.println("volume padding = " + jvol.PAD);
            double[] seed = new double[3];
            System.out.println(e2.getPoint());
            double[] result = vrc.getVolumeCoords(e2.getX(), e2.getY(), seed);
            if (result != null) {
                System.out.println("volume = " + seed[0] + ", " + seed[1] + ", " + seed[2]);
                final int x2 = (int)Math.round(seed[0]);
                final int y2 = (int)Math.round(seed[1]);
                final int z2 = (int)Math.round(seed[2]);
                if (x2 >= 0 && x2 < this.dims[0] && y2 >= 0 && y2 < this.dims[1] && z2 >= 0 && z2 < this.dims[2]) {
                    new Thread(){

                        @Override
                        public void run() {
                            AutoSelectVc.this.pas.execute(new JnVector3i(x2, y2, z2));
                        }
                    }.start();
                    if (this.updateTimer == null) {
                        this.updateTimer = new Timer(100, this);
                    }
                    this.updateTimer.start();
                }
            }
        }
    }

    private static void setMask(int[] position, int[] dims, byte[] mask) {
        int off = position[0] + position[1] * dims[0] + position[2] * dims[0] * dims[1];
        int n2 = off >> 3;
        mask[n2] = (byte)(mask[n2] | MASK[off & 7]);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.growing = false;
        if (this.updateTimer != null && this.updateTimer.isRunning()) {
            this.updateTimer.stop();
        }
        this.pas.requestStop();
        this.notFirstTime = false;
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        JPanel main = new JPanel(new BorderLayout());
        final T3DViewport vp = new T3DViewport();
        vp.setRenderStyle("REFORMAT");
        vp.setPreferredSize(new Dimension(512, 512));
        final AutoSelectVc asv = new AutoSelectVc();
        vp.getT3DComponent().add(asv);
        JPanel vpp = new JPanel(new GridLayout(1, 0));
        vpp.add(vp);
        final T3DViewport vp2 = new T3DViewport();
        vp2.setPreferredSize(new Dimension(512, 512));
        vpp.add(vp2);
        main.add(vpp);
        JPanel control1 = new JPanel();
        final JComboBox<String> rsBox = new JComboBox<String>(vp.getSupportedRenderStyles());
        control1.add(rsBox);
        JToggleButton tgB = new JToggleButton("AutoSelect", true);
        tgB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AbstractButton b2 = (AbstractButton)e2.getSource();
                asv.setVisible(b2.isSelected());
            }
        });
        rsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                vp.setRenderStyle((String)rsBox.getSelectedItem());
            }
        });
        control1.add(tgB);
        JButton restoreButton = new JButton("Restore");
        restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VrCapable vrc = (VrCapable)vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                if (vrc != null) {
                    vrc.clearSegmentation();
                    vrc.setSegmentationVisible(false);
                }
            }
        });
        control1.add(restoreButton);
        main.add((Component)control1, "South");
        f2.setContentPane(main);
        f2.pack();
        f2.setVisible(true);
        DMSession dms = new DMSession("file", args[0], null);
        final DMVolume volume = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                vp.setVolume(volume);
                vp2.setVolumeModel(vp.getVolumeModel());
            }
        });
    }

    protected byte[] getSegmentation() {
        return this.pas.retrieveSegmentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        T3DComponent tc = (T3DComponent)this.getParent();
        VrCapable vrc = (VrCapable)tc.getCapable("com.ge.med.terra.jami.capable.VrCapable");
        if (vrc != null) {
            ProgressiveAutoSelect progressiveAutoSelect = this.pas;
            synchronized (progressiveAutoSelect) {
                if (this.pas.hasNewSegmentation()) {
                    if (this.notFirstTime) {
                        vrc.union(this.pas.retrieveSegmentation());
                    } else {
                        this.notFirstTime = true;
                        vrc.applySegmentation(this.pas.retrieveSegmentation());
                    }
                }
            }
        }
    }
}

