/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnQuaternion;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.XpVisualComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.event.MouseInputListener;

public class CubeTrackball
extends XpVisualComponent
implements MouseInputListener,
PropertyChangeListener {
    protected boolean initialized = false;
    protected JnVector3d[] handles = new JnVector3d[20];
    protected boolean[] handlesVisible = new boolean[20];
    protected double r;
    protected double inner_r;
    protected double outer_size;
    protected int cx;
    protected int cy;
    protected int deepZ = 0;
    protected int selectedHandle = 0;
    protected JnVector3d newVect = new JnVector3d();
    protected JnVector3d rotVect = new JnVector3d();
    protected JnQuaternion quat = new JnQuaternion();
    protected JnMatrix4d rotMat = new JnMatrix4d();
    protected JnMatrix3d prevCam = new JnMatrix3d();
    protected JnVector3d lookPoint = new JnVector3d();
    protected JnVector3d upVector = new JnVector3d();
    protected JnVector3d rightVector = new JnVector3d();
    protected JnVector3d eyeVector = new JnVector3d();
    protected double[] a_up = new double[3];
    protected double[] a_la = new double[3];
    protected double[] a_ep = new double[3];
    protected BufferedImage cornerImg = null;
    protected BufferedImage vertImg = null;
    protected BufferedImage horizImg = null;
    protected Color color = Color.red;
    protected boolean[] edgesVertical = new boolean[3];
    protected boolean handleVertical = false;
    protected Cursor handleCursor = new Cursor(12);
    protected boolean mouseDown = false;
    protected Stroke lineStroke = new BasicStroke(1.0f, 1, 1);
    protected T3DCapable t3dCapable = null;
    protected boolean backsideHandleVisible = false;
    private final int BACKSIDE_SENSITIVITY = -10;
    private JnMatrix4d tiltMat = new JnMatrix4d();

    public CubeTrackball() {
        this(0.8);
    }

    public CubeTrackball(double size) {
        this.setAutoRepaint(true);
        this.outer_size = size;
        this.tiltMat.setIdentity();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addPropertyChangeListener("eyePoint", this);
        this.addPropertyChangeListener("lookPoint", this);
        this.addPropertyChangeListener("up", this);
    }

    protected void init() {
        int i2;
        this.cx = this.getWidth() / 2;
        this.cy = this.getHeight() / 2;
        int shortDim = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
        this.r = (double)shortDim * this.outer_size / 2.0;
        this.inner_r = this.r * Math.sqrt(0.6666666666666666);
        if (this.handles[0] == null) {
            this.handles[0] = new JnVector3d();
        }
        this.handles[0].x = this.r * Math.sqrt(3.0) / 3.0;
        this.handles[0].y = this.r * Math.sqrt(3.0) / 3.0;
        this.handles[0].z = Math.sqrt(this.r * this.r - this.handles[0].x * this.handles[0].x - this.handles[0].y * this.handles[0].y);
        for (i2 = 1; i2 < 8; ++i2) {
            if (this.handles[i2] == null) {
                this.handles[i2] = new JnVector3d(this.handles[0].x, this.handles[0].y, this.handles[0].z);
                continue;
            }
            this.handles[i2].set(this.handles[0].x, this.handles[0].y, this.handles[0].z);
        }
        this.handles[1].x = -this.handles[0].x;
        this.handles[2].x = -this.handles[0].x;
        this.handles[5].x = -this.handles[0].x;
        this.handles[6].x = -this.handles[0].x;
        this.handles[2].y = -this.handles[0].y;
        this.handles[3].y = -this.handles[0].y;
        this.handles[6].y = -this.handles[0].y;
        this.handles[7].y = -this.handles[0].y;
        this.handles[4].z = -this.handles[0].z;
        this.handles[5].z = -this.handles[0].z;
        this.handles[6].z = -this.handles[0].z;
        this.handles[7].z = -this.handles[0].z;
        for (i2 = 8; i2 < 20; ++i2) {
            if (this.handles[i2] == null) {
                this.handles[i2] = new JnVector3d(0.0, 0.0, 0.0);
                continue;
            }
            this.handles[i2].set(0.0, 0.0, 0.0);
        }
        this.handles[8].x = this.handles[0].x;
        this.handles[11].x = this.handles[0].x;
        this.handles[16].x = this.handles[0].x;
        this.handles[19].x = this.handles[0].x;
        this.handles[9].x = -this.handles[0].x;
        this.handles[10].x = -this.handles[0].x;
        this.handles[17].x = -this.handles[0].x;
        this.handles[18].x = -this.handles[0].x;
        this.handles[12].y = this.handles[0].y;
        this.handles[15].y = this.handles[0].y;
        this.handles[16].y = this.handles[0].y;
        this.handles[17].y = this.handles[0].y;
        this.handles[13].y = -this.handles[0].y;
        this.handles[14].y = -this.handles[0].y;
        this.handles[18].y = -this.handles[0].y;
        this.handles[19].y = -this.handles[0].y;
        this.handles[8].z = this.handles[0].z;
        this.handles[9].z = this.handles[0].z;
        this.handles[12].z = this.handles[0].z;
        this.handles[13].z = this.handles[0].z;
        this.handles[10].z = -this.handles[0].z;
        this.handles[11].z = -this.handles[0].z;
        this.handles[14].z = -this.handles[0].z;
        this.handles[15].z = -this.handles[0].z;
        this.applyTiltMatrix();
        this.load();
        this.loadHandles();
        if (this.isAutoRepaint()) {
            this.repaint();
        }
    }

    public void setT3DCapable(T3DCapable t3dCapable) {
        if (this.t3dCapable != null) {
            this.t3dCapable.removePropertyChangeListener(this);
        }
        this.t3dCapable = t3dCapable;
        if (this.t3dCapable != null) {
            this.t3dCapable.addPropertyChangeListener(this);
        }
        this.init();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().compareTo("eyePoint") == 0) {
            if (!this.mouseDown) {
                this.initialized = false;
                if (this.isAutoRepaint()) {
                    this.repaint();
                }
            }
        } else if (evt.getPropertyName().compareTo("lookPoint") == 0) {
            if (!this.mouseDown) {
                this.initialized = false;
                if (this.isAutoRepaint()) {
                    this.repaint();
                }
            }
        } else if (evt.getPropertyName().compareTo("up") == 0 && !this.mouseDown) {
            this.initialized = false;
            if (this.isAutoRepaint()) {
                this.repaint();
            }
        }
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        if (this.mouseDown) {
            return true;
        }
        for (int i2 = 0; i2 < 20; ++i2) {
            if (!((double)x2 >= this.handles[i2].x + (double)this.cx - 9.0) || !((double)x2 <= this.handles[i2].x + (double)this.cx + 7.0) || !((double)y2 >= this.handles[i2].y + (double)this.cy - 6.0) || !((double)y2 <= this.handles[i2].y + (double)this.cy + 10.0) || !this.handlesVisible[i2]) continue;
            this.selectedHandle = i2;
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g2) {
        int i2;
        double dx;
        int i3;
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        Graphics2D g22 = (Graphics2D)g2;
        g22.setColor(this.color);
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (i3 = 0; i3 < 8; ++i3) {
            this.handlesVisible[i3] = Math.round(this.handles[i3].z) > (long)this.deepZ;
        }
        g22.setStroke(this.lineStroke);
        if (this.handlesVisible[0]) {
            if (this.handlesVisible[1]) {
                g22.drawLine((int)Math.round(this.handles[0].x + (double)this.cx), (int)Math.round(this.handles[0].y + (double)this.cy), (int)Math.round(this.handles[1].x + (double)this.cx), (int)Math.round(this.handles[1].y + (double)this.cy));
                this.handlesVisible[12] = true;
            } else {
                this.handlesVisible[12] = false;
            }
            if (this.handlesVisible[3]) {
                g22.drawLine((int)Math.round(this.handles[0].x + (double)this.cx), (int)Math.round(this.handles[0].y + (double)this.cy), (int)Math.round(this.handles[3].x + (double)this.cx), (int)Math.round(this.handles[3].y + (double)this.cy));
                this.handlesVisible[8] = true;
            } else {
                this.handlesVisible[8] = false;
            }
            if (this.handlesVisible[4]) {
                g22.drawLine((int)Math.round(this.handles[0].x + (double)this.cx), (int)Math.round(this.handles[0].y + (double)this.cy), (int)Math.round(this.handles[4].x + (double)this.cx), (int)Math.round(this.handles[4].y + (double)this.cy));
                this.handlesVisible[16] = true;
            } else {
                this.handlesVisible[16] = false;
            }
        } else {
            this.handlesVisible[12] = false;
            this.handlesVisible[8] = false;
            this.handlesVisible[16] = false;
        }
        if (this.handlesVisible[2]) {
            if (this.handlesVisible[1]) {
                g22.drawLine((int)Math.round(this.handles[2].x + (double)this.cx), (int)Math.round(this.handles[2].y + (double)this.cy), (int)Math.round(this.handles[1].x + (double)this.cx), (int)Math.round(this.handles[1].y + (double)this.cy));
                this.handlesVisible[9] = true;
            } else {
                this.handlesVisible[9] = false;
            }
            if (this.handlesVisible[3]) {
                g22.drawLine((int)Math.round(this.handles[2].x + (double)this.cx), (int)Math.round(this.handles[2].y + (double)this.cy), (int)Math.round(this.handles[3].x + (double)this.cx), (int)Math.round(this.handles[3].y + (double)this.cy));
                this.handlesVisible[13] = true;
            } else {
                this.handlesVisible[13] = false;
            }
            if (this.handlesVisible[6]) {
                g22.drawLine((int)Math.round(this.handles[2].x + (double)this.cx), (int)Math.round(this.handles[2].y + (double)this.cy), (int)Math.round(this.handles[6].x + (double)this.cx), (int)Math.round(this.handles[6].y + (double)this.cy));
                this.handlesVisible[18] = true;
            } else {
                this.handlesVisible[18] = false;
            }
        } else {
            this.handlesVisible[9] = false;
            this.handlesVisible[13] = false;
            this.handlesVisible[18] = false;
        }
        if (this.handlesVisible[5]) {
            if (this.handlesVisible[1]) {
                g22.drawLine((int)Math.round(this.handles[5].x + (double)this.cx), (int)Math.round(this.handles[5].y + (double)this.cy), (int)Math.round(this.handles[1].x + (double)this.cx), (int)Math.round(this.handles[1].y + (double)this.cy));
                this.handlesVisible[17] = true;
            } else {
                this.handlesVisible[17] = false;
            }
            if (this.handlesVisible[4]) {
                g22.drawLine((int)Math.round(this.handles[5].x + (double)this.cx), (int)Math.round(this.handles[5].y + (double)this.cy), (int)Math.round(this.handles[4].x + (double)this.cx), (int)Math.round(this.handles[4].y + (double)this.cy));
                this.handlesVisible[15] = true;
            } else {
                this.handlesVisible[15] = false;
            }
            if (this.handlesVisible[6]) {
                g22.drawLine((int)Math.round(this.handles[5].x + (double)this.cx), (int)Math.round(this.handles[5].y + (double)this.cy), (int)Math.round(this.handles[6].x + (double)this.cx), (int)Math.round(this.handles[6].y + (double)this.cy));
                this.handlesVisible[10] = true;
            } else {
                this.handlesVisible[10] = false;
            }
        } else {
            this.handlesVisible[17] = false;
            this.handlesVisible[15] = false;
            this.handlesVisible[10] = false;
        }
        if (this.handlesVisible[7]) {
            if (this.handlesVisible[3]) {
                g22.drawLine((int)Math.round(this.handles[7].x + (double)this.cx), (int)Math.round(this.handles[7].y + (double)this.cy), (int)Math.round(this.handles[3].x + (double)this.cx), (int)Math.round(this.handles[3].y + (double)this.cy));
                this.handlesVisible[19] = true;
            } else {
                this.handlesVisible[19] = false;
            }
            if (this.handlesVisible[4]) {
                g22.drawLine((int)Math.round(this.handles[7].x + (double)this.cx), (int)Math.round(this.handles[7].y + (double)this.cy), (int)Math.round(this.handles[4].x + (double)this.cx), (int)Math.round(this.handles[4].y + (double)this.cy));
                this.handlesVisible[11] = true;
            } else {
                this.handlesVisible[11] = false;
            }
            if (this.handlesVisible[6]) {
                g22.drawLine((int)Math.round(this.handles[7].x + (double)this.cx), (int)Math.round(this.handles[7].y + (double)this.cy), (int)Math.round(this.handles[6].x + (double)this.cx), (int)Math.round(this.handles[6].y + (double)this.cy));
                this.handlesVisible[14] = true;
            } else {
                this.handlesVisible[14] = false;
            }
        } else {
            this.handlesVisible[19] = false;
            this.handlesVisible[11] = false;
            this.handlesVisible[14] = false;
        }
        if (!this.backsideHandleVisible) {
            for (i3 = 0; i3 < this.handlesVisible.length; ++i3) {
                if (!(this.handles[i3].z < -10.0)) continue;
                this.handlesVisible[i3] = false;
            }
        }
        this.edgesVertical[0] = (dx = Math.abs(this.handles[0].x - this.handles[3].x)) < 1.0 ? true : Math.abs(this.handles[0].y - this.handles[3].y) > dx;
        dx = Math.abs(this.handles[0].x - this.handles[1].x);
        this.edgesVertical[1] = dx < 1.0 ? true : Math.abs(this.handles[0].y - this.handles[1].y) > dx;
        dx = Math.abs(this.handles[0].x - this.handles[4].x);
        this.edgesVertical[2] = dx < 1.0 ? true : Math.abs(this.handles[0].y - this.handles[4].y) > dx;
        BufferedImage img = this.cornerImg;
        for (i2 = 0; i2 < 8; ++i2) {
            if (!this.handlesVisible[i2]) continue;
            g22.drawImage((Image)img, (int)this.handles[i2].x + this.cx - 6, (int)this.handles[i2].y + this.cy - 9, null);
        }
        img = this.edgesVertical[0] ? this.horizImg : this.vertImg;
        for (i2 = 8; i2 < 12; ++i2) {
            if (!this.handlesVisible[i2]) continue;
            g22.drawImage((Image)img, (int)this.handles[i2].x + this.cx - 6, (int)this.handles[i2].y + this.cy - 9, null);
        }
        img = this.edgesVertical[1] ? this.horizImg : this.vertImg;
        for (i2 = 12; i2 < 16; ++i2) {
            if (!this.handlesVisible[i2]) continue;
            g22.drawImage((Image)img, (int)this.handles[i2].x + this.cx - 6, (int)this.handles[i2].y + this.cy - 9, null);
        }
        img = this.edgesVertical[2] ? this.horizImg : this.vertImg;
        for (i2 = 16; i2 < 20; ++i2) {
            if (!this.handlesVisible[i2]) continue;
            g22.drawImage((Image)img, (int)this.handles[i2].x + this.cx - 6, (int)this.handles[i2].y + this.cy - 9, null);
        }
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e2) {
        double py;
        double px;
        double radius;
        Point m2 = e2.getPoint();
        double mx = m2.x;
        double my = m2.y;
        if (this.selectedHandle < 8) {
            radius = this.r;
        } else {
            radius = this.inner_r;
            if (this.isHandleVertical()) {
                my = this.handles[this.selectedHandle].y + (double)this.cy;
            } else {
                mx = this.handles[this.selectedHandle].x + (double)this.cx;
            }
        }
        double m2c = Math.sqrt((mx - (double)this.cx) * (mx - (double)this.cx) + (my - (double)this.cy) * (my - (double)this.cy));
        if (m2c > radius) {
            if (this.selectedHandle < 8) {
                double factor = radius / m2c;
                px = factor * (mx - (double)this.cx) + (double)this.cx;
                if (px > radius + (double)this.cx) {
                    System.out.println("BAD");
                    px = radius + (double)this.cx;
                } else if (px < (double)this.cx - radius) {
                    System.out.println("BAD");
                    px = (double)this.cx - radius;
                }
                py = factor * (my - (double)this.cy) + (double)this.cy;
                if (py > radius + (double)this.cy) {
                    System.out.println("BAD");
                    py = radius + (double)this.cy;
                } else if (py < (double)this.cy - radius) {
                    System.out.println("BAD");
                    px = (double)this.cy - radius;
                }
            } else if (this.isHandleVertical()) {
                py = this.handles[this.selectedHandle].y + (double)this.cy;
                px = Math.sqrt(radius * radius - (my - (double)this.cy) * (my - (double)this.cy));
                if (this.handles[this.selectedHandle].x < -1.0) {
                    px = -px;
                }
                px += (double)this.cx;
            } else {
                px = this.handles[this.selectedHandle].x + (double)this.cx;
                py = Math.sqrt(radius * radius - (mx - (double)this.cx) * (mx - (double)this.cx));
                if (this.handles[this.selectedHandle].y < -1.0) {
                    py = -py;
                }
                py += (double)this.cy;
            }
        } else {
            px = mx;
            py = my;
        }
        this.newVect.x = px - (double)this.cx;
        this.newVect.y = py - (double)this.cy;
        if ((int)Math.round(this.newVect.x) != (int)Math.round(this.handles[this.selectedHandle].x) || (int)Math.round(this.newVect.y) != (int)Math.round(this.handles[this.selectedHandle].y)) {
            double pz;
            double pz2 = radius * radius - this.newVect.x * this.newVect.x - this.newVect.y * this.newVect.y;
            if (pz2 < 0.0 && pz2 > -1.0E-6) {
                pz = 0.0;
            } else if (pz2 < 0.0) {
                System.out.println("BAD");
                pz = 0.0;
            } else {
                pz = Math.sqrt(pz2);
            }
            if (this.handles[this.selectedHandle].z < -10.0) {
                pz = -pz;
            }
            this.newVect.z = pz;
            double phi = Math.acos(this.newVect.dot(this.handles[this.selectedHandle]) / (this.newVect.magnitude() * this.handles[this.selectedHandle].magnitude()));
            JnVector3d.cross(this.newVect, this.handles[this.selectedHandle], this.rotVect);
            if (this.selectedHandle >= 8) {
                if (this.isHandleVertical()) {
                    this.rotVect.set(0.0, this.rotVect.y, 0.0);
                } else {
                    this.rotVect.set(this.rotVect.x, 0.0, 0.0);
                }
            }
            this.quat.set(this.rotVect, phi);
            this.quat.build4dRotationMatrix(this.rotMat);
            this.deepZ = (int)radius + 100;
            for (int i2 = 0; i2 < 20; ++i2) {
                this.rotMat.transform(this.handles[i2]);
                if ((int)Math.round(this.handles[i2].z) >= this.deepZ) continue;
                this.deepZ = (int)Math.round(this.handles[i2].z);
            }
            if (this.t3dCapable == null) {
                return;
            }
            this.quat.y = -this.quat.y;
            this.quat.w = -this.quat.w;
            JnMatrix3d rotationMatrix = this.quat.build3dRotationMatrix();
            this.upVector.set(this.t3dCapable.getUp(this.a_up));
            this.lookPoint.set(this.t3dCapable.getLookPoint(this.a_la));
            this.eyeVector.set(this.t3dCapable.getEyePoint(this.a_ep));
            this.eyeVector.sub(this.lookPoint);
            JnVector3d.cross(this.upVector, this.eyeVector, this.rightVector);
            JnVector3d.cross(this.eyeVector, this.rightVector, this.upVector);
            this.rightVector.normalize();
            this.upVector.normalize();
            this.eyeVector.normalize();
            this.prevCam.set(this.rightVector.x, this.upVector.x, this.eyeVector.x, this.rightVector.y, this.upVector.y, this.eyeVector.y, this.rightVector.z, this.upVector.z, this.eyeVector.z);
            rotationMatrix.mul(this.prevCam);
            this.upVector.set(rotationMatrix.m01, rotationMatrix.m11, rotationMatrix.m21);
            this.eyeVector.set(rotationMatrix.m02, rotationMatrix.m12, rotationMatrix.m22);
            this.eyeVector.add(this.lookPoint);
            this.t3dCapable.setCamera(this.eyeVector.generateArray(), this.lookPoint.generateArray(), this.upVector.generateArray());
            if (this.isAutoRepaint()) {
                this.t3dCapable.repaint();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.isHandleVertical();
        this.mouseDown = true;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.mouseDown = false;
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.setCursor(this.handleCursor);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    protected boolean isHandleVertical() {
        if (this.mouseDown) {
            return this.handleVertical;
        }
        if (this.selectedHandle >= 16) {
            this.handleVertical = this.edgesVertical[2];
        } else if (this.selectedHandle >= 12) {
            this.handleVertical = this.edgesVertical[1];
        } else if (this.selectedHandle >= 8) {
            this.handleVertical = this.edgesVertical[0];
        }
        return this.handleVertical;
    }

    public void setTiltMatrix(JnMatrix4d tiltMat) {
        this.tiltMat.set(tiltMat);
    }

    protected void applyTiltMatrix() {
        if (this.t3dCapable == null && this.getXpVisualComponentParent() instanceof T3DCapable) {
            this.t3dCapable = (T3DCapable)((Object)this.getXpVisualComponentParent());
            this.t3dCapable.addPropertyChangeListener(this);
        }
        if (this.t3dCapable == null) {
            return;
        }
        for (int i2 = 0; i2 < this.handles.length; ++i2) {
            this.tiltMat.transform(this.handles[i2]);
        }
    }

    protected synchronized void load() {
        if (this.t3dCapable == null && this.getXpVisualComponentParent() instanceof T3DCapable) {
            this.t3dCapable = (T3DCapable)((Object)this.getXpVisualComponentParent());
            this.t3dCapable.addPropertyChangeListener(this);
        }
        if (this.t3dCapable == null) {
            return;
        }
        this.upVector.set(this.t3dCapable.getUp(this.a_up));
        this.lookPoint.set(this.t3dCapable.getLookPoint(this.a_la));
        this.eyeVector.set(this.t3dCapable.getEyePoint(this.a_ep));
        this.eyeVector.sub(this.lookPoint);
        JnVector3d.cross(this.upVector, this.eyeVector, this.rightVector);
        JnVector3d.cross(this.eyeVector, this.rightVector, this.upVector);
        this.rightVector.normalize();
        this.upVector.normalize();
        this.eyeVector.normalize();
        this.rotMat.set(this.rightVector.x, this.rightVector.y, this.rightVector.z, 0.0, -this.upVector.x, -this.upVector.y, -this.upVector.z, 0.0, this.eyeVector.x, this.eyeVector.y, this.eyeVector.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.deepZ = (int)this.r + 100;
        for (int i2 = 0; i2 < 20; ++i2) {
            this.rotMat.transform(this.handles[i2]);
            if ((int)Math.round(this.handles[i2].z) >= this.deepZ) continue;
            this.deepZ = (int)Math.round(this.handles[i2].z);
        }
    }

    protected void loadHandles() {
        try {
            if (this.cornerImg == null) {
                this.cornerImg = ImageIO.read(CubeTrackball.class.getResource("corner.gif"));
            }
            if (this.vertImg == null) {
                this.vertImg = ImageIO.read(CubeTrackball.class.getResource("vert.gif"));
            }
            if (this.horizImg == null) {
                this.horizImg = ImageIO.read(CubeTrackball.class.getResource("horiz.gif"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void componentResized(ComponentEvent e2) {
        this.init();
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    public void setBacksideHandleVisible(boolean visible) {
        this.backsideHandleVisible = visible;
    }

    public boolean isBacksideHandleVisible() {
        return this.backsideHandleVisible;
    }
}

