/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.T3DRenderedState;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolume;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.util.EventObject;
import javax.swing.event.MouseInputListener;

public class Cursor3DVc
extends XpVisualComponent
implements MouseInputListener {
    static Cursor3DVc activeVc = null;
    protected Cursor3DModel cursorModel_;
    private static final Color ON_PLANE_COLOR = Color.CYAN;
    private static final Color PROJECTION_COLOR = Color.RED;
    protected boolean enabled_;
    private static final Stroke STROKE_OUTER = new BasicStroke(3.0f);
    private static final Stroke STROKE_INNER = new BasicStroke(1.5f);
    private static final int CURSOR_JUMP_TOL = 5;
    private XjChangeListener cursorListener_;
    protected T3DCapable engine_;
    protected CPoint cursorPositionScreen = new CPoint(1);
    private boolean paintBounds_;
    boolean checkWorldBounds_ = true;
    boolean restrictToObject = false;
    int offsetX_;
    int offsetY_;
    boolean driving_ = false;
    static final Color SHADOW_COLOR = Color.BLACK;
    static final Color OOO_COLOR = new Color(255, 128, 64);
    protected int centerx_;
    protected int centery_;
    protected boolean fastPaint_;
    protected Color offPlaneCursorColor_ = PROJECTION_COLOR;
    CPoint delta_ = new CPoint();
    private Shape cursorShape_ = APERTURE_SHAPE;
    private Color color_ = ON_PLANE_COLOR;
    private boolean continuousUpdateEnabled_;
    protected boolean autoPage_;
    private static final GeneralPath CROSS_SHAPE = new GeneralPath();
    public static final Shape X_SHAPE = CROSS_SHAPE;
    private static final GeneralPath APERTURE;
    public static final Shape APERTURE_SHAPE;
    private static final int OUTER_RADIUS = 20;
    private static final int OUTER_STROKE = 6;
    private static final int INNER_STROKE = 4;
    private static final int INNER_HOLE = 4;
    private static final GeneralPath BULLS_EYE;
    public static final Shape TARGET_SHAPE;
    private static final int EYE_DIM = 8;
    private static final float HOLE_SIZE = 2.5f;
    private static final int EYE_RADIUS1 = 5;
    private static final int DOT_RADIUS = 2;
    private static final int DOT_DIM = 3;
    public static final Shape DOT_SHAPE;

    public Cursor3DVc(Cursor3DModel cursorModel, T3DCapable engine) {
        this.cursorModel_ = cursorModel;
        this.engine_ = engine;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.cursorModel_.addChangeListener(this.getCursorChangeListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Cursor3DVc.this.compute(Cursor3DVc.this.getWidth(), Cursor3DVc.this.getHeight());
                Cursor3DVc.this.repaint();
            }
        });
        this.enableMouse();
    }

    protected XjChangeListener getCursorChangeListener() {
        if (this.cursorListener_ == null) {
            this.cursorListener_ = new CursorChangeListener();
        }
        return this.cursorListener_;
    }

    private void updateCursor() {
        if (this.isAutoPage() && this.engine_ != null) {
            T3DRenderStyleCapable trc;
            if (this.engine_ instanceof T3DRenderStyleCapable && "VOLUME".equals((trc = (T3DRenderStyleCapable)((Object)this.engine_)).getRenderStyle())) {
                this.compute(this.getWidth(), this.getHeight());
                if (this.centerx_ < 5 || this.centerx_ >= this.getWidth() - 5 || this.centery_ < 5 || this.centery_ >= this.getHeight() - 5) {
                    double[] look = this.cursorModel_.getPoint(null).generateArray();
                    double[] oldlook = this.engine_.getLookPoint(null);
                    double[] oldeye = this.engine_.getEyePoint(null);
                    double[] view = new double[]{oldlook[0] - oldeye[0], oldlook[1] - oldeye[1], oldlook[2] - oldeye[2]};
                    oldeye[0] = look[0] - view[0];
                    oldeye[1] = look[1] - view[1];
                    oldeye[2] = look[2] - view[2];
                    this.engine_.setCamera(oldeye, look, this.engine_.getUp(null));
                }
                this.repaint();
                return;
            }
            JnVector3d displacement = new JnVector3d();
            displacement.set(this.cursorModel_.getPoint(null));
            JnVector3d look = new JnVector3d(this.engine_.getLookPoint(new double[3]));
            displacement.sub(look);
            JnVector3d viewVector = new JnVector3d();
            viewVector.set(look);
            JnVector3d eye = new JnVector3d(this.engine_.getEyePoint(new double[3]));
            viewVector.sub(eye);
            viewVector.normalize();
            double shift = displacement.dot(viewVector);
            look.scaleAdd(shift, viewVector);
            eye.scaleAdd(shift, viewVector);
            double[] up = this.engine_.getUp(new double[3]);
            this.compute(this.getWidth(), this.getHeight());
            if (this.centerx_ < 5 || this.centerx_ >= this.getWidth() - 5 || this.centery_ < 5 || this.centery_ >= this.getHeight() - 5) {
                look.set(this.cursorModel_.getPoint(null));
                eye.set(look);
                eye.scaleAdd(-1.0, viewVector);
            }
            this.engine_.setCamera(eye.generateArray(), look.generateArray(), up);
            this.repaint();
        } else {
            this.repaint();
        }
    }

    public final void disableMouse() {
        this.enabled_ = false;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public final void enableMouse() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enabled_ = true;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    protected CPoint computeNewCursorPosition(int scx, int scy, int w2, int h2) {
        T3DDepthCapable tdc = (T3DDepthCapable)((Object)this.engine_.getCapable("com.ge.med.idc.T3DDepthCapable"));
        if (tdc != null) {
            double[] ras = new double[3];
            double[] result = tdc.getRASCoords(scx, scy, ras);
            return result == null ? null : new CPoint(ras[0], ras[1], ras[2], 2);
        }
        double[] newCursorRAS = GeomUtils.DisplayToRAS(new int[]{scx, scy, 0}, this.engine_.getEyePoint(null), this.engine_.getLookPoint(null), this.engine_.getUp(null), this.engine_.getViewHeight(), w2, h2, new double[3]);
        return new CPoint(newCursorRAS, 2);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        int cx = e2.getX() - this.offsetX_;
        int cy = e2.getY() - this.offsetY_;
        if (cx < 0 || cx >= this.getWidth() || cy < 0 || cy >= this.getHeight()) {
            return;
        }
        if (this.engine_ != null && this.isRestrictToObject() && this.engine_ instanceof T3DDepthCapable) {
            return;
        }
        if (this.engine_ != null && this.isCheckingWorldBounds()) {
            double[] projectionRAS = GeomUtils.DisplayToRAS(new int[]{cx, cy, 0}, this.engine_.getEyePoint(null), this.engine_.getLookPoint(null), this.engine_.getUp(null), this.engine_.getViewHeight(), this.getWidth(), this.getHeight(), new double[3]);
            double[] ulc = new double[3];
            double[] xside = new double[3];
            double[] yside = new double[3];
            double[] zside = new double[3];
            this.engine_.getWorldBounds(ulc, xside, yside, zside);
            if (!GeomUtils.isInsideVolume(ulc, xside, yside, zside, projectionRAS)) {
                return;
            }
        }
        CPoint pt = this.computeNewCursorPosition(cx, cy, e2.getComponent().getWidth(), e2.getComponent().getHeight());
        if (this.isContinuousUpdateEnabled()) {
            if (pt == null) {
                XpLog.fine("Out of Object!!!!!!!!!!!");
                this.cursorModel_.setOutOfObject(true);
            } else {
                this.cursorModel_.setOutOfObject(false);
                this.cursorModel_.setPoint(new CPoint(pt.generateArray(), 2));
            }
        }
        this.centerx_ = cx;
        this.centery_ = cy;
        this.repaint();
    }

    public boolean isCheckingWorldBounds() {
        return this.checkWorldBounds_;
    }

    public boolean isRestrictToObject() {
        return this.restrictToObject;
    }

    public void setRestrictToObject(boolean restrictToObject) {
        this.restrictToObject = restrictToObject;
    }

    public void setCheckingWorldBounds(boolean b2) {
        this.checkWorldBounds_ = b2;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.offsetX_ = e2.getX() - this.centerx_;
        this.offsetY_ = e2.getY() - this.centery_;
        this.driving_ = true;
        this.cursorModel_.setValueIsAdjusting(true);
        activeVc = this;
        this.repaint();
    }

    public void setCursorModel(Cursor3DModel model) {
        this.cursorModel_ = model;
    }

    public Cursor3DModel getCursorModel() {
        return this.cursorModel_;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.isContinuousUpdateEnabled()) {
            CPoint pt = this.computeNewCursorPosition(this.centerx_, this.centery_, event.getComponent().getWidth(), event.getComponent().getHeight());
            if (pt != null) {
                this.cursorModel_.setPoint(new CPoint(pt.x, pt.y, pt.z, 2), false);
            }
            this.repaint();
        } else {
            this.cursorModel_.setValueIsAdjusting(false);
            this.compute(this.getWidth(), this.getHeight());
            this.repaint();
        }
        this.driving_ = false;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.driving_ && !this.cursorModel_.isOutOfObject()) {
            this.compute(this.getWidth(), this.getHeight());
        }
        if (this.driving_ || !this.cursorModel_.isOutOfObject() || activeVc == this) {
            T3DRenderStyleCapable trc;
            g2d.translate(this.centerx_, this.centery_);
            float s2 = this.computeScale();
            g2d.scale(s2, s2);
            g2d.setColor(SHADOW_COLOR);
            g2d.setStroke(new BasicStroke(3.0f / s2));
            g2d.draw(this.cursorShape_);
            double tol = 0.1;
            g2d.setColor(Math.abs(this.delta_.z * this.delta_.z) > 0.1 || !this.isContinuousUpdateEnabled() && this.driving_ ? this.offPlaneCursorColor_ : this.getCursorColor());
            if (this.engine_ instanceof T3DRenderStyleCapable && "VOLUME".equals((trc = (T3DRenderStyleCapable)((Object)this.engine_)).getRenderStyle())) {
                g2d.setColor(this.getCursorColor());
            }
            if (this.cursorModel_.isOutOfObject() && activeVc == this) {
                g2d.setColor(OOO_COLOR);
            }
            g2d.setStroke(new BasicStroke(1.5f / s2));
            g2d.draw(this.cursorShape_);
            g2d.scale(1.0f / s2, 1.0f / s2);
            g2d.translate(-this.centerx_, -this.centery_);
        } else if (activeVc != this) {
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected float computeScale() {
        return Math.min(Math.max((float)Math.min(this.getWidth(), this.getHeight()) / 512.0f, 0.7f), 1.0f);
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (!this.enabled_) {
            return false;
        }
        float scale = this.computeScale();
        if (!(this.cursorModel_ == null || activeVc != this && this.cursorModel_.isOutOfObject())) {
            return this.cursorShape_.getBounds2D().contains((float)(x2 - this.centerx_) / scale, (float)(y2 - this.centery_) / scale);
        }
        return false;
    }

    public JnVector3d getDelta() {
        return this.delta_;
    }

    protected void compute(int w2, int h2) {
        CPoint ras = this.cursorModel_.getPoint(null);
        T3DCapable vp = this.engine_;
        double[] eyePt = vp.getEyePoint(null);
        double[] lookPt = vp.getLookPoint(null);
        double[] up = vp.getUp(null);
        T3DRenderedState trs = (T3DRenderedState)((Object)vp.getCapable(T3DRenderedState.class.getCanonicalName()));
        if (trs != null) {
            eyePt = trs.getRenderedEyePoint(null);
            lookPt = trs.getRenderedLookPoint(null);
            up = trs.getRenderedUp(null);
        }
        double[] disp = GeomUtils.RAStoDisplay(ras.generateArray(), eyePt, lookPt, up, this.engine_.getViewHeight(), w2, h2, new double[3]);
        this.centerx_ = (int)disp[0];
        this.centery_ = (int)disp[1];
        this.delta_.set(disp);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    public void setVolume(XjVolume volume) {
    }

    public void setContinuousUpdateEnabled(boolean enabled) {
        this.continuousUpdateEnabled_ = enabled;
    }

    public void setAutoPage(boolean b2) {
        this.autoPage_ = b2;
    }

    public boolean isAutoPage() {
        return this.autoPage_;
    }

    public boolean isContinuousUpdateEnabled() {
        return this.continuousUpdateEnabled_;
    }

    public void setCursorShape(Shape s2) {
        this.cursorShape_ = s2;
        this.repaint();
    }

    public boolean isDriving() {
        return this.driving_;
    }

    public Shape getCursorShape() {
        return this.cursorShape_;
    }

    public void setCursorColor(Color c2) {
        this.color_ = c2;
        this.repaint();
    }

    public Color getCursorColor() {
        return this.color_;
    }

    public void setOffPlaneCursorColor(Color c2) {
        this.offPlaneCursorColor_ = c2;
        this.repaint();
    }

    public Color getOffPlaneCursorColor() {
        return this.offPlaneCursorColor_;
    }

    static {
        float[][] x2 = new float[][]{{-12.0f, -12.0f, -3.0f, -3.0f}, {12.0f, 12.0f, 3.0f, 3.0f}, {12.0f, -12.0f, 3.0f, -3.0f}, {-12.0f, 12.0f, -3.0f, 3.0f}};
        for (int i2 = 0; i2 < x2.length; ++i2) {
            CROSS_SHAPE.moveTo(x2[i2][0], x2[i2][1]);
            CROSS_SHAPE.lineTo(x2[i2][2], x2[i2][3]);
        }
        APERTURE = new GeneralPath();
        APERTURE_SHAPE = APERTURE;
        APERTURE.moveTo(-4.0f, 0.0f);
        APERTURE.lineTo(-8.0f, 0.0f);
        APERTURE.moveTo(-14.0f, 0.0f);
        APERTURE.lineTo(-19.0f, 0.0f);
        APERTURE.moveTo(4.0f, 0.0f);
        APERTURE.lineTo(8.0f, 0.0f);
        APERTURE.moveTo(14.0f, 0.0f);
        APERTURE.lineTo(19.0f, 0.0f);
        APERTURE.moveTo(0.0f, -4.0f);
        APERTURE.lineTo(0.0f, -8.0f);
        APERTURE.moveTo(0.0f, -14.0f);
        APERTURE.lineTo(0.0f, -19.0f);
        APERTURE.moveTo(0.0f, 4.0f);
        APERTURE.lineTo(0.0f, 8.0f);
        APERTURE.moveTo(0.0f, 14.0f);
        APERTURE.lineTo(0.0f, 19.0f);
        APERTURE.append(new Ellipse2D.Float(-20.0f, -20.0f, 40.0f, 40.0f), false);
        BULLS_EYE = new GeneralPath();
        TARGET_SHAPE = BULLS_EYE;
        BULLS_EYE.moveTo(-8.0f, 0.0f);
        BULLS_EYE.lineTo(-2.5f, 0.0f);
        BULLS_EYE.moveTo(2.5f, 0.0f);
        BULLS_EYE.lineTo(8.0f, 0.0f);
        BULLS_EYE.moveTo(0.0f, -8.0f);
        BULLS_EYE.lineTo(0.0f, -2.5f);
        BULLS_EYE.moveTo(0.0f, 2.5f);
        BULLS_EYE.lineTo(0.0f, 8.0f);
        BULLS_EYE.append(new RoundRectangle2D.Float(-5.0f, -5.0f, 10.0f, 10.0f, 8.0f, 8.0f), false);
        DOT_SHAPE = new RoundRectangle2D.Float(-2.0f, -2.0f, 4.0f, 4.0f, 3.0f, 3.0f);
    }

    protected class CursorChangeListener
    implements XjChangeListener {
        protected CursorChangeListener() {
        }

        @Override
        public void stateChanged(EventObject e2) {
            if (!Cursor3DVc.this.driving_) {
                Cursor3DVc.this.updateCursor();
            }
        }
    }
}

