/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector4d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class J3DBaseVolumeModel
implements XjVolumeModel,
Replicable,
XpDicomObject,
PropertyChangeListener {
    public XjVolumeInfo xj_vol = null;
    public Map user_data = new Hashtable(16);
    protected JnMatrix4d vox2ras = new JnMatrix4d();
    protected JnMatrix4d ras2vox = new JnMatrix4d();
    protected List listeners = new ArrayList();
    protected Hashtable ht = new Hashtable();
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    @Override
    public XjVolumeInfo getVolume() {
        return this.xj_vol;
    }

    public void setData(String dataName, Object value) {
        if (value != null) {
            this.user_data.put(dataName, value);
        } else {
            this.user_data.remove(dataName);
        }
    }

    public Object getData(String dataName) {
        return this.user_data.get(dataName);
    }

    protected void calcVox2RAS() {
        XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)this.xj_vol, this.vox2ras, this.ras2vox);
    }

    public void rasToVoxels(double[] lookpt, double[] xdir, double[] ydir, double[] zdir) {
        double[] zero_orig = new double[3];
        JnVector4d temp_v = new JnVector4d();
        JnVector4d zero_tx = new JnVector4d();
        temp_v.set(lookpt);
        this.ras2vox.transform(temp_v);
        temp_v.get(lookpt);
        zero_tx.set(zero_orig);
        this.ras2vox.transform(zero_tx);
        temp_v.set(xdir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(xdir);
        temp_v.set(ydir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(ydir);
        temp_v.set(zdir);
        this.ras2vox.transform(temp_v);
        temp_v.sub(zero_tx);
        temp_v.get(zdir);
    }

    public void voxelToRas(double[] voxCoords, double[] rasCoords) {
        JnVector4d temp_v = new JnVector4d();
        temp_v.set(voxCoords);
        this.vox2ras.transform(temp_v);
        temp_v.get(rasCoords);
    }

    public void rasToVoxels(double[] rasCoords, double[] voxCoords) {
        JnVector4d temp_v = new JnVector4d();
        temp_v.set(rasCoords);
        this.ras2vox.transform(temp_v);
        temp_v.get(voxCoords);
    }

    public JnMatrix4d getVoxel2RASTransform() {
        return this.vox2ras;
    }

    public JnMatrix4d getRAS2VoxelTransform() {
        return this.ras2vox;
    }

    public static double trilineard(double v000, double v100, double v010, double v110, double v001, double v101, double v011, double v111, double fx, double fy, double fz) {
        double px1 = v000 + (v100 - v000) * fx;
        double px2 = v010 + (v110 - v010) * fx;
        double py1 = px1 + (px2 - px1) * fy;
        px1 = v001 + (v101 - v001) * fx;
        px2 = v011 + (v111 - v011) * fx;
        double py2 = px1 + (px2 - px1) * fy;
        return py1 + (py2 - py1) * fz;
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        int notLoaded = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            int result = this.getValue(values[i2]);
            if (result != 1) continue;
            ++notLoaded;
        }
        return notLoaded;
    }

    @Override
    public int getValue(XpDicomElement value) {
        Object val = this.xj_vol.getValue(value.group, value.element);
        if (val != null) {
            value.value = val;
            return 0;
        }
        return 1;
    }

    @Override
    public void addChangeListener(XjChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    @Override
    public void removeChangeListener(XjChangeListener cl) {
        this.listeners.remove(cl);
    }

    public void notifyChangeListeners() {
        int len = this.listeners.size();
        EventObject ce = new EventObject(this);
        for (int i2 = 0; i2 < len; ++i2) {
            XjChangeListener cl = (XjChangeListener)this.listeners.get(i2);
            cl.stateChanged(ce);
        }
    }

    @Override
    public void putClientProperty(Object key, Object value) {
        if (value == null) {
            this.ht.remove(key);
        } else {
            this.ht.put(key, value);
        }
    }

    @Override
    public Object getClientProperty(Object key) {
        return this.ht.get(key);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propName, oldValue, newValue);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(l2);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(prop, l2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(l2);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(prop, l2);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException(this.getClass().getName() + " : Derived class must define clone method");
    }
}

