/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;

public class JDataLoader {
    private XjVolume vol = null;

    public JDataLoader(XjVolume vol) {
        this.vol = vol;
    }

    public J3DVolumeModel[] loadVolumeModels() {
        int[] channels = new int[]{0};
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            channels = new int[mvol.getNumChannels()];
            for (int i2 = 0; i2 < channels.length; ++i2) {
                channels[i2] = i2;
            }
        }
        return this.loadVolumeModels(channels);
    }

    public J3DVolumeModel[] loadVolumeModels(int[] channels) {
        J3DVolumeModel[] vm = new J3DVolumeModel[channels.length];
        if (channels.length == 1 && channels[0] == 0) {
            vm[0] = new J3DVolumeModel(this.vol);
        } else {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            int nchannels = channels.length;
            short[][] data = new short[nchannels][];
            int PAD = this.loadVoxelData(channels, data);
            for (int k2 = 0; k2 < nchannels; ++k2) {
                ChannelShortVolume memvolume = new ChannelShortVolume(mvol, channels[k2], PAD, data[k2]);
                vm[k2] = new J3DVolumeModel(memvolume);
            }
        }
        return vm;
    }

    private int loadVoxelData(int[] channels, short[][] data) {
        XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
        int[] dims = mvol.getVolumeDimensions(null);
        int sliceLen = dims[0] * dims[1];
        int PAD = 2 * sliceLen;
        int nchannels = channels.length;
        for (int i2 = 0; i2 < nchannels; ++i2) {
            data[i2] = new short[2 * PAD + dims[0] * dims[1] * dims[2]];
        }
        boolean[] normalize = new boolean[nchannels];
        double[] rSlope = new double[nchannels];
        double[] sliceRSlope = new double[nchannels];
        for (int k2 = 0; k2 < nchannels; ++k2) {
            normalize[k2] = false;
            sliceRSlope[k2] = Double.parseDouble("" + mvol.getVSliceValue(channels[k2], 0, 40, 4179));
        }
        for (int i3 = 0; i3 < dims[2]; ++i3) {
            for (int k3 = 0; k3 < nchannels; ++k3) {
                rSlope[k3] = Double.parseDouble("" + mvol.getVSliceValue(channels[k3], i3, 40, 4179));
            }
            JVolume.fillVolumeSlice(mvol, data, channels, sliceLen, PAD + i3 * sliceLen, i3, rSlope, sliceRSlope, normalize);
        }
        return PAD;
    }

    public J3DVolumeModel loadMultiChannelVolumeModel() {
        int[] channels = new int[]{0};
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            channels = new int[mvol.getNumChannels()];
            for (int i2 = 0; i2 < channels.length; ++i2) {
                channels[i2] = i2;
            }
        }
        return this.loadMultiChannelVolumeModel(channels);
    }

    public J3DVolumeModel loadMultiChannelVolumeModel(int[] channels) {
        if (this.vol instanceof XjMultiChannelVolume) {
            XjMultiChannelVolume mvol = (XjMultiChannelVolume)this.vol;
            int nchannels = channels.length;
            short[][] data = new short[nchannels][];
            int PAD = this.loadVoxelData(channels, data);
            int pixelType = mvol.getPixelType();
            int bpp = mvol.getBitsPerVoxel();
            ChannelShortVolume memvol = new ChannelShortVolume(mvol, channels[0], PAD, data[0]);
            J3DVolumeModel jvm = new J3DVolumeModel(memvol);
            JVolume.LinearVolume[] jvols = new JVolume.LinearVolume[nchannels - 1];
            System.err.println(">>> Channel[0] : " + jvm.j_vol.rescaleSlope + "  " + jvm.j_vol.rescaleIntercept);
            for (int k2 = 1; k2 < nchannels; ++k2) {
                ChannelShortVolume mv = new ChannelShortVolume(mvol, channels[k2], PAD, data[k2]);
                JVolume.LinearVolume j_vol = null;
                j_vol = pixelType != 2 && bpp == 8 ? new JVolume.LinearByte(mv) : new JVolume.LinearShort(mv);
                jvols[k2 - 1] = j_vol;
                System.err.println(">>> Channel[" + k2 + "] : " + j_vol.rescaleSlope + "  " + j_vol.rescaleIntercept);
            }
            if (jvols.length > 0) {
                jvm.attachAuxiliaryVolumes(jvols);
            }
            return jvm;
        }
        return new J3DVolumeModel(this.vol);
    }

    private static class ChannelShortVolume
    implements XjMemVolume {
        private int channelNo = -1;
        private XjMultiChannelVolume mvol = null;
        private short[] volData = null;
        private int PAD = 0;
        private int sliceLen = 0;

        public ChannelShortVolume(XjMultiChannelVolume mvol, int channelNo, int PAD, short[] volData) {
            this.mvol = mvol;
            this.channelNo = channelNo;
            this.PAD = PAD;
            this.volData = volData;
            int[] dims = this.mvol.getVolumeDimensions(null);
            this.sliceLen = dims[0] * dims[1];
        }

        @Override
        public Object getSliceData(int sliceNo) {
            return this.volData;
        }

        @Override
        public int getSliceOffset(int sliceNo) {
            return this.PAD + sliceNo * this.sliceLen;
        }

        @Override
        public boolean isContiguous() {
            return true;
        }

        @Override
        public int getBitsPerVoxel() {
            return this.mvol.getBitsPerVoxel();
        }

        @Override
        public int getPixelType() {
            return this.mvol.getPixelType();
        }

        @Override
        public Object getVSliceValue(int sliceNo, int group, int element) {
            return this.mvol.getVSliceValue(this.channelNo, sliceNo, group, element);
        }

        @Override
        public String getRelatedComposite() {
            return this.mvol.getVSlicePath(this.channelNo, 0);
        }

        @Override
        public Object getValue(int group, int element) {
            return this.getVSliceValue(0, group, element);
        }

        @Override
        public int getValues(XjTagValue[] tv) {
            int nvals = 0;
            for (int i2 = 0; i2 < tv.length; ++i2) {
                tv[i2].value = this.getValue(tv[i2].group, tv[i2].element);
                if (tv[i2].value == null) continue;
                ++nvals;
            }
            return nvals;
        }

        @Override
        public int[] getVolumeDimensions(int[] dims) {
            return this.mvol.getVolumeDimensions(dims);
        }

        @Override
        public double[] getRASOfOrigin(double[] ras_ulc) {
            return this.mvol.getRASOfOrigin(ras_ulc);
        }

        @Override
        public double[] getXDirectionRAS(double[] ras_dx) {
            return this.mvol.getXDirectionRAS(ras_dx);
        }

        @Override
        public double[] getYDirectionRAS(double[] ras_dy) {
            return this.mvol.getYDirectionRAS(ras_dy);
        }

        @Override
        public double[] getZDirectionRAS(double[] ras_dz) {
            return this.mvol.getZDirectionRAS(ras_dz);
        }
    }
}

