/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.jnu.geom.PatternVolumeData;
import java.util.HashMap;

public abstract class MemVolume
implements XjMemVolume {
    protected Object volData = null;
    protected int volDataOffset;
    protected int dx;
    protected int dy;
    protected int dz;
    protected int pixelType;
    protected double initWL = 0.0;
    protected double initWW = 0.0;
    protected double spx = 1.0;
    protected double spy = 1.0;
    protected double spz = 1.0;
    protected double origx = 0.0;
    protected double origy = 0.0;
    protected double origz = 0.0;
    protected double rescaleSlope = 1.0;
    protected double rescaleIntercept = 0.0;
    protected int PAD = 0;
    protected String modality = "NOMODALITY";
    protected String patname = "Unknown";
    protected HashMap dicomValues = new HashMap();

    @Override
    public Object getSliceData(int sliceNo) {
        return this.volData;
    }

    @Override
    public int getSliceOffset(int sliceNo) {
        return this.volDataOffset + sliceNo * this.dx * this.dy;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public abstract int getBitsPerVoxel();

    @Override
    public int getPixelType() {
        return this.pixelType;
    }

    @Override
    public String getRelatedComposite() {
        return "NoComposite";
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        String key = "" + group + "," + element;
        if (this.dicomValues.containsKey(key)) {
            return this.dicomValues.get(key);
        }
        if (group == 16 && element == 16) {
            return this.patname;
        }
        if (group == 40 && element == 4178) {
            return new Double(this.rescaleIntercept);
        }
        if (group == 40 && element == 4179) {
            return new Double(this.rescaleSlope);
        }
        if (group == 40 && element == 4176) {
            return new Double(this.initWL);
        }
        if (group == 40 && element == 4177) {
            return new Double(this.initWW);
        }
        if (group == 8 && element == 96) {
            return this.modality;
        }
        if (group == 24 && element == 4384) {
            return new Double(0.0);
        }
        if (group == 24 && element == 80) {
            return new Double(1.0);
        }
        return "XX";
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(0, group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        int nelements = 0;
        for (int i2 = 0; i2 < tv.length; ++i2) {
            tv[i2].value = this.getValue(tv[i2].group, tv[i2].element);
            if (tv[i2].value == null) continue;
            ++nelements;
        }
        return nelements;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        double[] arr = ras_ulc;
        if (arr == null) {
            arr = new double[]{this.origx, this.origy, this.origz};
        }
        return arr;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        int[] arr = dims;
        if (arr == null) {
            arr = new int[]{this.dx, this.dy, this.dz};
        }
        return arr;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        double[] arr = ras_dx;
        if (arr == null) {
            arr = new double[]{this.spx, 0.0, 0.0};
        }
        return arr;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        double[] arr = ras_dy;
        if (arr == null) {
            arr = new double[]{0.0, this.spy, 0.0};
        }
        return arr;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        double[] arr = ras_dz;
        if (arr == null) {
            arr = new double[]{0.0, 0.0, this.spz};
        }
        return arr;
    }

    public static MemVolume createSphereVolume(int dx, int dy, int dz, double radiusScale, short fillValue) {
        PatternVolumeData.SphereShort volData = new PatternVolumeData.SphereShort(dx, dy, dz, radiusScale, fillValue);
        return new Short(volData, 0);
    }

    public static MemVolume createCylinderVolume(int dx, int dy, int dz, double radiusScale, short fillValue) {
        PatternVolumeData.CylinderShort volData = new PatternVolumeData.CylinderShort(dx, dy, dz, radiusScale, fillValue);
        return new Short(volData, 0);
    }

    public static class Byte
    extends MemVolume {
        public Byte(byte[] volData, int volDataOffset, int dx, int dy, int dz, int pixelType) {
            this.volData = volData;
            this.volDataOffset = volDataOffset;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.pixelType = pixelType;
            this.initWL = 128.0;
            this.initWW = 256.0;
        }

        public Byte(PatternVolumeData.Byte volumeData, int pixelType) {
            this.volData = volumeData.volData;
            this.volDataOffset = volumeData.volDataOffset;
            this.dx = volumeData.dx;
            this.dy = volumeData.dy;
            this.dz = volumeData.dz;
            this.pixelType = pixelType;
            this.initWL = 128.0;
            this.initWW = 256.0;
        }

        @Override
        public int getBitsPerVoxel() {
            return 8;
        }
    }

    public static class Short
    extends MemVolume {
        public Short(short[] volData, int volDataOffset, int dx, int dy, int dz, int pixelType) {
            this.volData = volData;
            this.volDataOffset = volDataOffset;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.pixelType = pixelType;
        }

        public Short(PatternVolumeData.Short volumeData, int pixelType) {
            this.volData = volumeData.volData;
            this.volDataOffset = volumeData.volDataOffset;
            this.dx = volumeData.dx;
            this.dy = volumeData.dy;
            this.dz = volumeData.dz;
            this.pixelType = pixelType;
        }

        @Override
        public int getBitsPerVoxel() {
            return 16;
        }
    }

    public static class DummyBodyVolume
    extends MemVolume {
        private short[] _data;

        public static final double sigmoid(double v2) {
            return 2.0 / (1.0 + Math.exp(-v2 * 30.0)) - 1.0;
        }

        public DummyBodyVolume(int xdim, int ydim, int zdim) {
            this.dx = xdim;
            this.dy = ydim;
            this.dz = zdim;
            this.PAD = 2 * this.dx * this.dy;
            this.rescaleIntercept = -1024.0;
            this._data = new short[this.dx * this.dy * this.dz + 2 * this.PAD];
            for (int i2 = 0; i2 < this.dz; ++i2) {
                short[] slice = this.makeSlice(i2, null);
                System.arraycopy(slice, 0, this._data, i2 * this.dx * this.dy, slice.length);
            }
            this.volData = this._data;
            this.volDataOffset = this.PAD;
        }

        public short[] makeSlice(int z2, short[] data) {
            if (data == null || data.length < this.dx * this.dy) {
                data = new short[this.dx * this.dy];
            }
            double ctr = (double)this.dz * 0.5;
            double bodyz = ((double)z2 - ctr) * 0.8 / ctr;
            double legz = (double)(z2 - this.dz * 2 / 8) * 0.8 / ctr;
            double armz = (double)((z2 - this.dz * 5 / 8) * 4) / ctr;
            double headz = (double)(z2 - this.dz * 7 / 8) / ctr;
            double nz = (double)(z2 - this.dz) / ctr;
            int d2 = this.dx;
            double ddx = (double)this.dx * 0.5;
            double ddy = (double)this.dy * 0.5;
            for (int i2 = 0; i2 < data.length; ++i2) {
                double x2 = ((double)(i2 % d2) - ddx) / ddx;
                double y2 = ((double)(i2 / d2) - ddx) / ddy;
                double x22 = x2 * x2;
                double y22 = y2 * y2;
                double d22 = x22 + y22;
                double body = DummyBodyVolume.sigmoid(1.0 - 2.0 * Math.sqrt(x22 + y22 + bodyz * bodyz));
                double vain = DummyBodyVolume.sigmoid((1.0 + Math.sin(20.0 * x2 + 30.0 * nz)) * (1.0 - 1.9 * Math.sqrt(x2 * x2 + y2 * y2 + bodyz * bodyz)));
                double arms = DummyBodyVolume.sigmoid(1.0 - 1.0 * Math.sqrt(vain / 20.0 + x22 + y22 * 16.0 + armz * armz));
                double head = headz < -1.0 ? -100.0 : DummyBodyVolume.sigmoid(1.0 - 4.0 * Math.sqrt(x22 + y22 + headz * headz));
                double legs = DummyBodyVolume.sigmoid(1.0 - 4.0 * Math.sqrt((x22 - 0.25) * (x22 - 0.25) + y22 + legz * legz));
                double wave = 5.0 * (1.0 - nz * 2.0);
                int branch = (int)wave;
                double t2 = wave - (double)branch;
                int branch1 = (branch + 1) * (branch + 1);
                branch *= branch;
                double p1 = (Math.cos(0.2 * y2 * (double)branch) * (1.0 - t2) + t2 * Math.cos(0.2 * y2 * (double)branch1)) / (x22 + y22 + 1.0);
                p1 = (Math.cos(0.2 * x2 * (double)branch) * (1.0 - t2) + t2 * Math.cos(0.2 * x2 * (double)branch1)) / (x22 + y22 + 1.0) * p1 - 0.4;
                if ((double)z2 < ctr) {
                    p1 = -100.0;
                }
                double test = DummyBodyVolume.sigmoid(1.0 - 2.0 * Math.sqrt(d22 + bodyz * bodyz)) * (DummyBodyVolume.sigmoid(p1) + 1.0) / 2.0;
                double v2 = 0.0;
                v2 = head > 0.0 ? head * 900.0 : (arms > 0.0 ? arms * 250.0 : (body > 0.0 ? body * 2000.0 : (legs > 0.0 ? legs * 250.0 : vain * 220.0)));
                data[i2] = (short)(v2 + 1024.0);
                if (!(test > 0.0)) continue;
                data[i2] = (short)(test * 240.0 + 1024.0);
            }
            return data;
        }

        public DummyBodyVolume() {
            this(256);
        }

        public DummyBodyVolume(int size) {
            this(size, size, size);
        }

        @Override
        public int getBitsPerVoxel() {
            return 16;
        }
    }
}

