/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class PagingMouseController
extends MouseInputAdapter
implements XpMouseController {
    private Point prev_pt = new Point();
    private FramePositioningCapable viewport = null;
    private JComponent visualComponent = null;
    private double incrementFactor;
    private ViewPortResizeEventListener resizeEventListener = new ViewPortResizeEventListener();
    private static boolean loopMode = false;
    long wheelPrevTime_ = 0L;
    static final int WHEEL_SENSITIVITY = 500;
    static final int FAST_WHEEL_SCROLL_AMOUNT = 3;

    @Override
    public void setTarget(JComponent vc) {
        if (vc instanceof Capable) {
            this.viewport = (FramePositioningCapable)((Capable)((Object)vc)).getCapable(FramePositioningCapable.class.getName());
            this.visualComponent = vc;
            if (this.viewport != null) {
                this.incrementFactor = (double)this.viewport.getNumFrames() / (double)vc.getHeight();
            }
            this.visualComponent.addComponentListener(this.resizeEventListener);
        }
    }

    public static void setLoopMode(boolean loop) {
        loopMode = loop;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.prev_pt.setLocation(me.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        Point p2 = me.getPoint();
        double dy = p2.getY() - this.prev_pt.getY();
        this.page(dy);
        this.prev_pt.setLocation(p2);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent me) {
        if (me.getScrollType() == 0) {
            int sign = me.getWheelRotation() > 0 ? 1 : -1;
            long t2 = System.currentTimeMillis();
            int dy = t2 - this.wheelPrevTime_ > 500L ? 1 : 3;
            this.wheelPrevTime_ = t2;
            this.page(dy *= sign);
        }
    }

    private void page(double dy) {
        if (this.viewport != null) {
            int size = this.viewport.getNumFrames();
            int incrementStep = (int)Math.round(dy * this.incrementFactor);
            if (dy > 0.0) {
                if (incrementStep == 0) {
                    incrementStep = 1;
                }
                int newFrameIndex = this.viewport.getFrameIndex() + incrementStep;
                newFrameIndex = loopMode ? (newFrameIndex %= size) : Math.max(0, Math.min(newFrameIndex, size - 1));
                this.viewport.setFrameIndex(newFrameIndex);
            } else {
                if (incrementStep == 0) {
                    incrementStep = -1;
                }
                int newFrameIndex = this.viewport.getFrameIndex() + incrementStep;
                newFrameIndex = loopMode ? (newFrameIndex %= size) : Math.max(0, Math.min(newFrameIndex, size - 1));
                this.viewport.setFrameIndex(newFrameIndex);
            }
        }
    }

    private class ViewPortResizeEventListener
    extends ComponentAdapter {
        private ViewPortResizeEventListener() {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            if (PagingMouseController.this.viewport != null) {
                PagingMouseController.this.incrementFactor = (double)PagingMouseController.this.viewport.getNumFrames() / (double)e2.getComponent().getHeight();
            }
        }
    }
}

