/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import java.util.Arrays;

public class SegMask {
    private byte[] rle = new byte[16384];
    private int nbytes = 0;
    private int sizeuncompressed = 0;
    private RunToken rt = new RunToken();

    public SegMask(short[] data, int thresh1, int thresh2) {
        long t0 = System.currentTimeMillis();
        int crun = 0;
        boolean onerun = true;
        this.sizeuncompressed = data.length >> 3;
        if (data[0] >= thresh1 && data[0] <= thresh2) {
            this.rle[0] = 1;
            onerun = true;
        } else {
            this.rle[0] = 0;
            onerun = false;
        }
        ++this.nbytes;
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (onerun) {
                if (data[i2] >= thresh1 && data[i2] <= thresh2) {
                    ++crun;
                    continue;
                }
                this.encode(crun);
                onerun = false;
                crun = 1;
                continue;
            }
            if (data[i2] < thresh1 || data[i2] > thresh2) {
                ++crun;
                continue;
            }
            this.encode(crun);
            onerun = true;
            crun = 1;
        }
        if (crun != 0) {
            this.encode(crun);
        }
        long t2 = System.currentTimeMillis() - t0;
    }

    public SegMask(byte[] bitmap) {
        int runsym = 0;
        int crun = 0;
        this.sizeuncompressed = bitmap.length;
        if ((bitmap[0] & 1) != 0) {
            runsym = 1;
            this.rle[0] = 1;
        } else {
            runsym = 0;
            this.rle[0] = 0;
        }
        ++this.nbytes;
        for (int i2 = 0; i2 < bitmap.length; ++i2) {
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((bitmap[i2] & 1 << j2) >> j2 == runsym) {
                    ++crun;
                    continue;
                }
                this.encode(crun);
                crun = 1;
                runsym = runsym == 0 ? 1 : 0;
            }
        }
        if (crun != 0) {
            this.encode(crun);
        }
    }

    public SegMask(SegMask sm) {
        this.rle = new byte[sm.rle.length];
        this.nbytes = sm.nbytes;
        this.sizeuncompressed = sm.sizeuncompressed;
        System.arraycopy(sm.rle, 0, this.rle, 0, this.nbytes);
    }

    public Object clone() {
        return new SegMask(this);
    }

    public final int getNumBytes() {
        return this.nbytes;
    }

    private void encode(int run_val) {
        if (run_val < 256) {
            if (this.nbytes >= this.rle.length) {
                this.resize();
            }
            this.rle[this.nbytes++] = (byte)run_val;
        } else {
            if (this.nbytes >= this.rle.length - 4) {
                this.resize();
            }
            this.rle[this.nbytes++] = 0;
            this.rle[this.nbytes++] = (byte)(run_val >> 24 & 0xFF);
            this.rle[this.nbytes++] = (byte)(run_val >> 16 & 0xFF);
            this.rle[this.nbytes++] = (byte)(run_val >> 8 & 0xFF);
            this.rle[this.nbytes++] = (byte)(run_val & 0xFF);
        }
    }

    private void resize() {
        byte[] temp = new byte[this.rle.length << 1];
        System.arraycopy(this.rle, 0, temp, 0, this.nbytes);
        this.rle = temp;
    }

    public void invert() {
        byte initRun = this.rle[0];
        this.rle[0] = (byte)(initRun == 0 ? 1 : 0);
    }

    private final int decode(int idx, RunToken rt) {
        int l2;
        if ((l2 = this.rle[idx++] & 0xFF) == 0) {
            int b0 = this.rle[idx++] & 0xFF;
            int b1 = this.rle[idx++] & 0xFF;
            int b2 = this.rle[idx++] & 0xFF;
            int b3 = this.rle[idx++] & 0xFF;
            rt.value = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            rt.idx = idx;
        } else {
            rt.value = l2;
            rt.idx = idx;
        }
        return rt.value;
    }

    public final int getNumOnes() {
        int numones = 0;
        byte initrun = this.rle[0];
        this.rt.idx = 1;
        if (initrun != 0) {
            numones += this.decode(this.rt.idx, this.rt);
        }
        int idx = this.rt.idx;
        while (idx < this.nbytes) {
            this.decode(this.rt.idx, this.rt);
            idx = this.rt.idx;
            if (idx >= this.nbytes) continue;
            numones += this.decode(idx, this.rt);
            idx = this.rt.idx;
        }
        return numones;
    }

    public void getBitMap(byte[] bingrid) {
        long t0 = System.currentTimeMillis();
        byte runsym = this.rle[0];
        int nbits = 0;
        int i2 = 1;
        Arrays.fill(bingrid, (byte)0);
        while (i2 < this.nbytes) {
            int decodeVal = this.rle[i2++] & 0xFF;
            int runLen = 0;
            if (decodeVal > 0) {
                runLen = decodeVal;
            } else {
                int b0 = this.rle[i2++] & 0xFF;
                int b1 = this.rle[i2++] & 0xFF;
                int b2 = this.rle[i2++] & 0xFF;
                int b3 = this.rle[i2++] & 0xFF;
                runLen = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            }
            if (runsym == 1) {
                this.rledecode(bingrid, runLen, nbits);
            }
            nbits += runLen;
            runsym = runsym == 0 ? (byte)1 : 0;
        }
        long t2 = System.currentTimeMillis() - t0;
    }

    private void rledecode(byte[] bingrid, int run, int bitpos) {
        int byteidx = bitpos >> 3;
        int bitIdx = bitpos % 8;
        if (bitIdx != 0) {
            int numbits = Math.min(8 - bitIdx, run);
            int mask = (1 << numbits) - 1 << bitIdx;
            run -= numbits;
            int bgridVal = bingrid[byteidx];
            bingrid[byteidx++] = (byte)(bgridVal |= mask);
        }
        while (run > 7) {
            bingrid[byteidx++] = -1;
            run -= 8;
        }
        int mask = (1 << run) - 1;
        if (run > 0) {
            bingrid[byteidx++] = (byte)mask;
        }
    }

    private void rlezero(byte[] bingrid, int run, int bitpos) {
        int byteidx = bitpos >> 3;
        int bitIdx = bitpos % 8;
        if (bitIdx != 0) {
            int numbits = Math.min(bitIdx, run);
            int mask = (1 << bitIdx) - 1;
            run -= numbits;
            int bgridVal = bingrid[byteidx];
            bingrid[byteidx++] = (byte)(bgridVal &= mask);
        }
        while (run > 7) {
            bingrid[byteidx++] = 0;
            run -= 8;
        }
        if (run > 0) {
            int mask = 255 << run;
            int bgridVal = bingrid[byteidx];
            bgridVal &= mask;
            bingrid[byteidx++] = (byte)mask;
        }
    }

    public void getSlice(int idx, byte[] slice) {
        long t0 = System.currentTimeMillis();
        int BITSTOFILL = slice.length * 8;
        byte runsym = this.rle[0];
        int nbits = 0;
        int slicebits = 0;
        int i2 = 1;
        boolean start = true;
        Arrays.fill(slice, (byte)0);
        while (i2 < this.nbytes) {
            int decodeVal = this.rle[i2++] & 0xFF;
            int runLen = 0;
            if (decodeVal > 0) {
                runLen = decodeVal;
            } else {
                int b0 = this.rle[i2++] & 0xFF;
                int b1 = this.rle[i2++] & 0xFF;
                int b2 = this.rle[i2++] & 0xFF;
                int b3 = this.rle[i2++] & 0xFF;
                runLen = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            }
            nbits += runLen;
            if (start) {
                if (nbits >= idx) {
                    start = false;
                    slicebits += nbits - idx;
                    if (runsym == 1 && nbits > idx) {
                        int nones = nbits - idx;
                        this.rledecode(slice, nones, 0);
                    }
                }
            } else {
                int runval = Math.min(runLen, BITSTOFILL - slicebits);
                if (runsym == 1) {
                    this.rledecode(slice, runval, slicebits);
                }
                if ((slicebits += runval) >= BITSTOFILL) break;
            }
            runsym = runsym == 0 ? (byte)1 : 0;
        }
        long t2 = System.currentTimeMillis() - t0;
    }

    public void intersect(byte[] bingrid) {
        long t0 = System.currentTimeMillis();
        byte runsym = this.rle[0];
        int nbits = 0;
        int i2 = 1;
        while (i2 < this.nbytes) {
            int decodeVal = this.rle[i2++] & 0xFF;
            int runLen = 0;
            if (decodeVal > 0) {
                runLen = decodeVal;
            } else {
                int b0 = this.rle[i2++] & 0xFF;
                int b1 = this.rle[i2++] & 0xFF;
                int b2 = this.rle[i2++] & 0xFF;
                int b3 = this.rle[i2++] & 0xFF;
                runLen = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            }
            if (runsym == 0) {
                this.rlezero(bingrid, runLen, nbits);
            }
            nbits += runLen;
            runsym = runsym == 0 ? (byte)1 : 0;
        }
        long t2 = System.currentTimeMillis() - t0;
    }

    private static class RunToken {
        public int value;
        public int idx;

        private RunToken() {
        }
    }
}

