/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.T3DDepthBufferCapable;
import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.surface.JnSurface;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.surface.SurfaceRenderer;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;

public class SurfaceVc
extends XpVisualComponent
implements LinearTransformable,
T3DDepthCapable {
    private BufferedImage im;
    private SurfaceRenderer renderer = new SurfaceRenderer();
    protected JnMatrix4d additionalTransform = new JnMatrix4d();
    protected float lineWidth = 1.0f;
    private boolean dbg = true;
    private float[] zbuff;
    float[] depthBuf_;
    JnSurface surface_;
    private J3DVolumeModel volumeModel;
    String shadingStyle_ = "shading_volume";
    private int mode;
    public static final int ALPHA_BLEND_COMBINE_MODE = 0;
    public static final int DEPTH_BUFFER_COMBINE_MODE = 1;

    public SurfaceVc() {
        this.additionalTransform.setIdentity();
    }

    @Override
    public void paintComponent(Graphics g2) {
        XpVisualComponent vcParent;
        T3DDepthBufferCapable depthBufCapable;
        super.paintComponent(g2);
        if (this.volumeModel == null) {
            System.out.println("volume is null!!!");
            return;
        }
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.zbuff == null || this.zbuff.length != w2 * h2) {
            this.zbuff = new float[w2 * h2];
            this.im = new BufferedImage(w2, h2, 2);
        }
        DataBufferInt raster = (DataBufferInt)this.im.getRaster().getDataBuffer();
        int[] pix = raster.getData();
        XpVisualComponent t3d = this.getXpVisualComponentParent();
        CTransform ras2disp = t3d.getTransform((byte)2, (byte)1);
        double[] additionalXform = new double[16];
        this.additionalTransform.get(additionalXform);
        CTransform additionalTransformC = new CTransform();
        additionalTransformC.load(additionalXform);
        CTransform disp2vol = ras2disp.inverse().multiplyBy(t3d.getTransform((byte)2, (byte)5));
        ras2disp.multiplyBy(additionalTransformC);
        this.renderer.render(pix, this.zbuff, w2, h2, 0, 0, w2, h2, ras2disp.m, disp2vol.m, 0);
        if (this.mode == 1 && (depthBufCapable = (T3DDepthBufferCapable)((Object)(vcParent = this.getXpVisualComponentParent()).getCapable("com.ge.med.idc.T3DDepthBufferCapable"))) != null) {
            if (this.depthBuf_ == null || this.depthBuf_.length != w2 * h2) {
                this.depthBuf_ = new float[w2 * h2 * 3];
            }
            depthBufCapable.getDepthBuffer(this.depthBuf_);
            int iy = 0;
            double[] pt = new double[3];
            int yy = 0;
            while (yy < h2) {
                int iyoffset = iy * 3 * w2;
                int ix = 0;
                int xx = 0;
                while (xx < w2) {
                    pt[0] = this.depthBuf_[iyoffset + 3 * ix];
                    pt[1] = this.depthBuf_[iyoffset + 3 * ix + 1];
                    pt[2] = this.depthBuf_[iyoffset + 3 * ix + 2];
                    if (!(pt[0] <= -9999999.0)) {
                        ras2disp.transform(pt);
                        if (pt[2] < (double)this.zbuff[xx + yy * w2]) {
                            int n2 = xx + yy * w2;
                            pix[n2] = pix[n2] & 0xFFFFFF;
                        } else {
                            int n3 = xx + yy * w2;
                            pix[n3] = pix[n3] | 0xFF000000;
                        }
                    }
                    ++xx;
                    ++ix;
                }
                ++yy;
                ++iy;
            }
        }
        g2.drawImage(this.im, 0, 0, null);
    }

    @Override
    public double[] getLinearTransform(double[] returnTransform) {
        if (returnTransform == null) {
            returnTransform = new double[16];
        }
        this.additionalTransform.get(returnTransform);
        return returnTransform;
    }

    @Override
    public void setLinearTransform(double[] transformArray) {
        if (transformArray == null) {
            transformArray = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        }
        if (!this.additionalTransform.equals(transformArray)) {
            this.additionalTransform.set(transformArray);
            this.firePropertyChange("LINEAR_TRANSFORM_PROPERTY", null, transformArray);
        }
    }

    public void addTransformListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener("LINEAR_TRANSFORM_PROPERTY", listener);
    }

    public void removeTransformListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(listener);
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        if (lineWidth <= 0.0f) {
            String msg = "Invalid line width (" + lineWidth + ")." + "Line width must be greater than zero. Setting line width to 1.0";
            XpLog.logger().log(Level.WARNING, msg);
            this.lineWidth = 1.0f;
        } else {
            this.lineWidth = lineWidth;
        }
    }

    @Override
    public int getDepthStep(int x2, int y2) {
        return 0;
    }

    @Override
    public double[] getVolumeCoords(int x2, int y2, double[] volCoords) {
        return null;
    }

    @Override
    public double[] getRASCoords(int x2, int y2, double[] rasCoords) {
        XpVisualComponent t3d = this.getXpVisualComponentParent();
        CTransform ras2disp = t3d.getTransform((byte)2, (byte)1);
        return rasCoords;
    }

    @Override
    public double getValue(int x2, int y2) {
        return 0.0;
    }

    public void setVolumeModel(J3DVolumeModel vm) {
        this.volumeModel = vm;
        this.renderer.setVolumeModel(this.volumeModel);
    }

    public void setSurface(JnSurface surface) {
        this.renderer.setSurface(surface);
    }

    public void setAlpha(byte alpha) {
        this.renderer.setAlpha(alpha);
    }

    public void setRGB(int rgb) {
        this.renderer.setRGB(rgb);
    }

    public void setCombineMode(int mode) {
        this.mode = mode;
        this.repaint();
    }

    public JnSurface getSurface() {
        return this.surface_;
    }

    public void setShadingMode(String mode) {
        this.renderer.setShadingMode(mode);
        this.repaint();
    }
}

