/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSeriesDisplayer;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.DefaultObliqueController;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.OrientationCubeVc;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DCompositePort;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.VrApp;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import com.ge.med.terra.jami.remote.session.XmRenderSession;
import com.ge.med.terra.jami.roi.XpPolygonRoi;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.seg.BinGrid;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class T3DApp
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final JnVector3d S_VECTOR = new JnVector3d(0.0, 0.0, -1.0);
    public static final JnVector3d I_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
    public static final JnVector3d A_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
    public static final JnVector3d P_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
    public static final JnVector3d L_VECTOR = new JnVector3d(1.0, 0.0, 0.0);
    public static final JnVector3d R_VECTOR = new JnVector3d(-1.0, 0.0, 0.0);
    public static final JnVector3d S_UP_VECTOR = new JnVector3d(0.0, -1.0, 0.0);
    public static final JnVector3d I_UP_VECTOR = new JnVector3d(0.0, 1.0, 0.0);
    public static final JnVector3d A_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
    public static final JnVector3d P_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
    public static final JnVector3d L_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
    public static final JnVector3d R_UP_VECTOR = new JnVector3d(0.0, 0.0, 1.0);
    private static final String ROOT = "presets";
    private static String[] presets = new String[]{"Standard", "Solid Air", "Solid Vessel", "Color VR1", "Color VR2", "Color VR3", "B/W Veins", "Grey Skull", "Pet", "Pet1"};
    private static String[] paths = new String[]{null, "presets/HEAD/solid_air.vrp", "presets/HEAD/solid_vessel.vrp", "presets/HEAD/clr_c_of_w_1.vrp", "presets/HEAD/clr_c_of_w_2.vrp", "presets/HEAD/clr_c_of_w_3.vrp", "presets/HEAD/bw_c_of_w.vrp", "presets/HEAD/bw_facial.vrp", "presets/ABDOMEN/pet.vrp", "presets/ABDOMEN/pet1.vrp"};
    private static final int ITEM_PLAIN = 0;
    private static final int ITEM_CHECK = 1;
    private static final int ITEM_RADIO = 2;
    private String[] langs = new String[]{"English", "Spanish", "French", "German", "Italian", "Portuguese"};
    private String[] formats = new String[]{"1x1", "2x2", "3x3", "3x2"};
    private String[] i18n = new String[]{"en", "es", "fr", "de", "it", "pt"};
    private static final int VPDIM = 1024;
    private T3DCompositePort vp = null;
    private VrPresetsEditor pEditor = new VrPresetsEditor();
    private Preset preset = new Preset();
    private XpSeriesDisplayer sd = new XpSeriesDisplayer();
    private ControlPanel cp = new ControlPanel();
    private XjVolumeInfo vol = null;
    private JMenuBar menuBar = new JMenuBar();
    private boolean processUpdate = true;
    private Cursor3DModel cursor = null;
    private boolean remote = false;
    private JCheckBoxMenuItem bgridSegmentation = null;
    private JCheckBoxMenuItem cursor3D = null;
    private JCheckBoxMenuItem orientationCube = null;
    private JCheckBoxMenuItem valueInspect = null;
    private boolean init = true;
    private List cursor_vc = new Vector();
    private List ocube_vc = new Vector();
    private MouseMotionListener mml = null;
    private short[] labels = null;

    public T3DApp(String volpath) {
        if (this.remote) {
            final XmRenderSession serverSession = new XmRenderSession("localhost", 7483);
            this.vol = (XjVolumeInfo)serverSession.getRemoteData(new String[]{"volume", volpath});
            Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    System.err.println(">>> shutdown server...");
                    serverSession.close();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(r2){});
            this.vp = new T3DCompositePort(serverSession, J3DRenderEngine.class.getCanonicalName());
        } else {
            this.vol = this.loadVolume(volpath);
            this.vp = new T3DCompositePort();
        }
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        JPanel uiPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        uiPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.vp, "Center");
        uiPanel.add((Component)this.cp, "Center");
        JPanel pEditorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        this.pEditor.setPresets(this.preset);
        c2.gridx = 0;
        c2.gridy = 0;
        pEditorPanel.add((Component)this.pEditor, c2);
        JButton applyVrColors = new JButton("<html><center>Apply<br />VR<br />Colors<br />and<br />Opacity </html>");
        applyVrColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                T3DApp.this.applyPreset();
            }
        });
        JPanel vrPanel = new JPanel();
        vrPanel.add(applyVrColors);
        c2.gridx = 1;
        c2.gridy = 0;
        pEditorPanel.add((Component)vrPanel, c2);
        uiPanel.add((Component)pEditorPanel, "West");
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        this.add((Component)uiPanel, "South");
        this.vp.setPreferredSize(new Dimension(1024, 1024));
        this.vp.setVolume(this.vol);
        this.vp.setRenderStyle(0, "VOLUME");
        this.vp.setRenderStyle(1, "REFORMAT");
        this.vp.setRenderStyle(2, "REFORMAT");
        this.vp.setRenderStyle(3, "REFORMAT");
        WWWLActiveAnnotation wwaa = new WWWLActiveAnnotation();
        this.vp.setActiveAnnotationListener("AWindowWidth", wwaa, "Mouse Button 3: Edit WW/WL");
        this.vp.setActiveAnnotationListener("AWindowLevel", wwaa);
        this.pEditor.setPreferredSize(new Dimension(512, 256));
        this.cp.setPreferredSize(new Dimension(512, 256));
        this.cp.setBorder(BorderFactory.createEtchedBorder());
        this.sd.setPreferredSize(new Dimension(256, 1024));
        if (!this.remote) {
            this.sd.setVolumeModel(this.vp.getVolumeModel());
        }
        this.sd.setRowCol(4, 1);
        mainPanel.add((Component)this.sd, "East");
        this.createMenu();
        this.setupPresets(this.vp.getVolumeModel());
    }

    private void createMenu() {
        String[] asegments;
        ActionListener al2;
        String[] items;
        boolean tearOff = true;
        JMenu mfile = new JMenu("File", tearOff);
        JMenu mseg = new JMenu("Segmentation", tearOff);
        JMenu mvr = new JMenu("VR", tearOff);
        JMenu mvr_presets = new JMenu("Presets", tearOff);
        JMenu mtools = new JMenu("Tools", tearOff);
        JMenu mannot = new JMenu("Annotation", tearOff);
        JMenu mrowcol = new JMenu("Row/Column", tearOff);
        mfile.add(T3DApp.createMenuItem(mfile, 0, "Load Volume...", null, 76, "Load a new volume..", this));
        mfile.add(T3DApp.createMenuItem(mfile, 0, "Clear", null, 67, "Clears the loaded volume data", this));
        mfile.add(T3DApp.createMenuItem(mfile, 0, "Exit", null, 120, "Exits this sample application", this));
        this.bgridSegmentation = (JCheckBoxMenuItem)T3DApp.createMenuItem(mseg, 1, "Bingrid Segmentation", null, 66, "View bingrid segmentation", this);
        mseg.add(this.bgridSegmentation);
        mseg.add(T3DApp.createMenuItem(mseg, 0, "CT Table Removal", null, 84, "Remove table in a CT volume", this));
        mseg.add(T3DApp.createMenuItem(mseg, 0, "Reset Bingrid", null, 82, "Reset bingrid to default", this));
        mseg.add(T3DApp.createMenuItem(mvr, 1, "Volume Overlay", null, 86, "Display cylinder volume overlay.", this));
        mtools.add(T3DApp.createMenuItem(mtools, 0, "User Annotation", null, 85, "User annotation", this));
        this.cursor3D = (JCheckBoxMenuItem)T3DApp.createMenuItem(mtools, 1, "Cursor 3D", null, 67, "Cursor3DVc", this);
        mtools.add(this.cursor3D);
        this.orientationCube = (JCheckBoxMenuItem)T3DApp.createMenuItem(mtools, 1, "Orientation Cube", null, 79, "OrientationCubeVc", this);
        mtools.add(this.orientationCube);
        this.valueInspect = (JCheckBoxMenuItem)T3DApp.createMenuItem(mtools, 1, "Inspect Values", null, 73, "Inspect values", this);
        mtools.add(this.valueInspect);
        mtools.add(T3DApp.createMenuItem(mtools, 0, "Dup Volume", null, 68, "Duplication volume data", this));
        JMenu roiMenu = new JMenu("Rois");
        mtools.add(roiMenu);
        roiMenu.add(T3DApp.createMenuItem(mtools, 0, "Ellipse", null, 68, "2D Ellipse", this));
        roiMenu.add(T3DApp.createMenuItem(mtools, 0, "Rectangle", null, 68, "2D Rectangle", this));
        roiMenu.add(T3DApp.createMenuItem(mtools, 0, "Line", null, 68, "2D Line", this));
        mvr.add(mvr_presets);
        ButtonGroup bg = new ButtonGroup();
        for (int i2 = 0; i2 < presets.length; ++i2) {
            final int idx = i2;
            ActionListener al3 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    Runnable r2 = new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("Load: " + paths[idx]);
                            try {
                                VrPreset vrp = null;
                                if (paths[idx] != null) {
                                    InputStream is = VrApp.class.getResourceAsStream(paths[idx]);
                                    vrp = new VrPreset(is);
                                } else {
                                    vrp = new VrPreset();
                                }
                                VrCapable vrc = (VrCapable)T3DApp.this.vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                                if (vrc != null) {
                                    vrc.setPreset(vrp);
                                    vrc.repaint();
                                }
                            }
                            catch (FileNotFoundException ex) {
                                System.err.println("Cannot find file: " + paths[idx]);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                            }
                        }
                    };
                    new Thread(r2).start();
                }
            };
            JRadioButtonMenuItem bi = (JRadioButtonMenuItem)T3DApp.createMenuItem(mvr_presets, 2, presets[i2], null, 0, presets[i2], al3);
            if (i2 == 0) {
                bi.setSelected(true);
            }
            bg.add(bi);
            mvr_presets.add(bi);
        }
        mvr.add(T3DApp.createMenuItem(mvr, 0, "Apply VR Presets", null, 65, "Apply VR presets", this));
        ButtonGroup fgroup = new ButtonGroup();
        for (int i3 = 0; i3 < this.formats.length; ++i3) {
            JRadioButtonMenuItem bi = (JRadioButtonMenuItem)T3DApp.createMenuItem(mvr_presets, 2, this.formats[i3], null, 0, presets[i3], this);
            if (i3 == 1) {
                bi.setSelected(true);
            }
            fgroup.add(bi);
            mrowcol.add(bi);
        }
        JMenu mlangs = new JMenu("Languages", tearOff);
        JMenu mitems = new JMenu("Items", tearOff);
        JMenu mgroups = new JMenu("Groups", tearOff);
        JMenu msegments = new JMenu("Segments", tearOff);
        mannot.add(mlangs);
        mannot.add(mitems);
        mannot.add(mgroups);
        mannot.add(msegments);
        ButtonGroup bglang = new ButtonGroup();
        for (int i4 = 0; i4 < this.langs.length; ++i4) {
            final int idx = i4;
            ActionListener al4 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    T3DApp.this.vp.setAnnotationLanguage(T3DApp.this.i18n[idx]);
                    T3DApp.this.vp.repaint();
                }
            };
            JRadioButtonMenuItem bi = (JRadioButtonMenuItem)T3DApp.createMenuItem(mvr_presets, 2, this.langs[i4], null, 0, this.langs[i4], al4);
            if (i4 == 0) {
                bi.setSelected(true);
            }
            bglang.add(bi);
            mlangs.add(bi);
        }
        final T3DCompositePort acHandle = this.vp;
        final String[] groups = acHandle.getAnnotationGroups();
        ButtonGroup bggroup = new ButtonGroup();
        if (groups != null) {
            for (int i5 = 0; i5 < groups.length; ++i5) {
                final int idx = i5;
                ActionListener al5 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        String agName = groups[idx];
                        System.out.println("AG Name: " + agName);
                        acHandle.setAnnotationGroup(agName, true);
                        String[] items = acHandle.getAnnotationItems();
                        String[] agitems = acHandle.getAnnotationItems(agName);
                        T3DApp.this.vp.repaint();
                    }
                };
                JRadioButtonMenuItem bi = (JRadioButtonMenuItem)T3DApp.createMenuItem(mvr_presets, 2, groups[i5], null, 0, groups[i5], al5);
                if (i5 == 0) {
                    bi.setSelected(true);
                }
                bggroup.add(bi);
                mgroups.add(bi);
            }
        }
        if ((items = acHandle.getAnnotationItems()) != null) {
            for (int i6 = 0; i6 < items.length; ++i6) {
                int idx = i6;
                final String item = items[idx];
                al2 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        JCheckBoxMenuItem cb = (JCheckBoxMenuItem)e2.getSource();
                        T3DApp.this.vp.setAnnotationItems(new String[]{item}, cb.isSelected());
                        T3DApp.this.vp.repaint();
                    }
                };
                mitems.add(T3DApp.createMenuItem(mvr, 1, items[i6], null, 0, items[i6], this));
            }
        }
        if ((asegments = this.vp.getAnnotationSegments()) != null) {
            for (int i7 = 0; i7 < asegments.length; ++i7) {
                int idx = i7;
                al2 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                    }
                };
                msegments.add(T3DApp.createMenuItem(mvr, 1, asegments[i7], null, 0, asegments[i7], this));
            }
        }
        this.menuBar.add(mfile);
        this.menuBar.add(mseg);
        this.menuBar.add(mvr);
        this.menuBar.add(mtools);
        this.menuBar.add(mrowcol);
        this.menuBar.add(mannot);
    }

    private void setupPresets(XjVolumeModel vm) {
        if (vm instanceof J3DVolumeModel) {
            JVolume.LinearVolume jvol = ((J3DVolumeModel)vm).j_vol;
            VrHistogram h2 = new VrHistogram(0, 4095, jvol.rescaleSlope, jvol.rescaleIntercept);
            if (jvol instanceof JVolume.LinearShort) {
                short[] vox = ((JVolume.LinearShort)jvol).volume;
                for (int pix = jvol.PAD; pix < jvol.PAD + jvol.dx * jvol.dy * jvol.dz; ++pix) {
                    h2.incrementRaw(vox[pix]);
                }
            } else {
                byte[] vox = ((JVolume.LinearByte)jvol).volume;
                for (int pix = jvol.PAD; pix < jvol.PAD + jvol.dx * jvol.dy * jvol.dz; ++pix) {
                    h2.incrementRaw(vox[pix] & 0xFF);
                }
            }
            this.vp.putClientProperty("HIST_PROPERTY", h2);
            this.pEditor.setHistogram(h2);
        }
    }

    private static JMenuItem createMenuItem(JMenu menu, int iType, String sText, ImageIcon image, int acceleratorKey, String sToolTip, ActionListener al2) {
        JMenuItem menuItem;
        switch (iType) {
            case 2: {
                menuItem = new JRadioButtonMenuItem();
                break;
            }
            case 1: {
                menuItem = new JCheckBoxMenuItem();
                break;
            }
            default: {
                menuItem = new JMenuItem();
            }
        }
        menuItem.setText(sText);
        if (image != null) {
            menuItem.setIcon(image);
        }
        if (acceleratorKey > 0) {
            menuItem.setMnemonic(acceleratorKey);
        }
        if (sToolTip != null) {
            menuItem.setToolTipText(sToolTip);
        }
        menuItem.addActionListener(al2);
        menu.add(menuItem);
        return menuItem;
    }

    private void installMenuBar(JFrame jf) {
        jf.setJMenuBar(this.menuBar);
    }

    private XjVolume loadVolume(String volpath) {
        DMSession dms = new DMSession(new String[]{"file", volpath});
        DMObject[] dmo = dms.getRelated("series");
        return DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
    }

    private void loadFromDialog() {
        File f2 = new File("C:\\Images");
        String fpath = f2.getAbsolutePath();
        if (!f2.exists()) {
            fpath = "./";
        }
        JFileChooser chooser = new JFileChooser(fpath);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String dirname = "" + chooser.getSelectedFile();
            System.out.println("You chose to open this dir: " + dirname);
            this.vol = this.loadVolume(dirname);
            this.vp.setVolume(this.vol);
            XjVolumeModel vm = this.vp.getVolumeModel();
            this.sd.setVolumeModel(vm);
            this.vp.repaint();
        }
    }

    private void bingridSegmentation() {
        SegmentationCapable vrc = (SegmentationCapable)((Object)this.vp.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (vrc != null) {
            if (this.init) {
                int[] dims = this.vol.getVolumeDimensions(null);
                int blen = dims[0] * dims[1] * dims[2] >> 3;
                byte[] seg = new byte[blen];
                Arrays.fill(seg, (byte)-1);
                int lim = dims[0] >> 2;
                for (int z2 = 0; z2 < dims[2]; ++z2) {
                    for (int y2 = 0; y2 < dims[1]; ++y2) {
                        for (int x2 = 0; x2 < dims[0]; ++x2) {
                            if (x2 <= lim || y2 <= lim || x2 >= dims[0] - lim || y2 >= dims[1] - lim) continue;
                            int idx = z2 * dims[1] * dims[0] + y2 * dims[0] + x2;
                            int mod = idx % 8;
                            byte bval = seg[idx >>= 3];
                            seg[idx] = (byte)(bval & ~(1 << mod));
                        }
                    }
                }
                vrc.applySegmentation(seg);
                this.init = false;
            }
            vrc.setSegmentationVisible(this.bgridSegmentation.isSelected());
        }
    }

    private void ctTableRemoval() {
        Thread th = new Thread(){

            @Override
            public void run() {
                J3DRenderEngine jre = (J3DRenderEngine)T3DApp.this.vp.getSelectedPort().getT3DComponent().getT3DRenderEngine();
                if (jre != null) {
                    J3DVolumeModel vol_model = (J3DVolumeModel)jre.getVolumeModel();
                    JVolume.LinearVolume vol = vol_model.j_vol;
                    short[] voldata = ((JVolume.LinearShort)vol).volume;
                    BinGrid bg = new BinGrid(voldata, vol.PAD, vol.dx, vol.dy, vol.dz);
                    BinGrid.SegAlgorithm sa = BinGrid.createSegAlgorithm("com.ge.med.jip.voxtool.CTTableRemoval");
                    double[] ras_sp = new double[]{vol.ras_spx, vol.ras_spy, vol.ras_spz};
                    if (sa != null) {
                        BinGrid ctt = sa.segment(bg, new Object[]{ras_sp}, new VRTL());
                        byte[] bgrid = ctt.bingrid;
                        jre.applySegmentation(bgrid);
                        T3DApp.this.vp.repaint();
                    } else {
                        JOptionPane.showMessageDialog(T3DApp.this.vp, "CT Table Removal algorithm not available", "Warning", 2);
                    }
                }
            }
        };
        th.start();
    }

    private void resetBingrid() {
        VrCapable vrc = (VrCapable)this.vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
        if (vrc != null) {
            vrc.clearSegmentation();
            vrc.repaint();
        }
    }

    private void userAnnot() {
        int idx = 0;
        T3DViewport svp = this.vp.getPort(idx);
        int[] dims = this.vol.getVolumeDimensions(null);
        CPoint textAnchor = new CPoint(100, 100, 0, 1);
        CPoint target = new CPoint((double)dims[0] * 0.5, (double)dims[1] * 0.5, (double)dims[2] * 0.5, 5);
        XpUserAnnotationModel uam = new XpUserAnnotationModel("Demo Text", textAnchor, target);
        svp.add(uam);
    }

    public static final double[] computeVolumeCenter(double[] orig, double[] xv, double[] yv, double[] zv, int[] dims, double[] result) {
        if (result == null) {
            result = new double[]{orig[0] + xv[0] * (double)dims[0] / 2.0 + yv[0] * (double)dims[1] / 2.0 + zv[0] * (double)dims[2] / 2.0, orig[1] + xv[1] * (double)dims[0] / 2.0 + yv[1] * (double)dims[1] / 2.0 + zv[1] * (double)dims[2] / 2.0, orig[2] + xv[2] * (double)dims[0] / 2.0 + yv[2] * (double)dims[1] / 2.0 + zv[2] * (double)dims[2] / 2.0};
        }
        return result;
    }

    private void cursor3dModel() {
        double[] orig = this.vol.getRASOfOrigin(null);
        double[] xv = this.vol.getXDirectionRAS(null);
        double[] yv = this.vol.getYDirectionRAS(null);
        double[] zv = this.vol.getZDirectionRAS(null);
        int[] dims = this.vol.getVolumeDimensions(null);
        double[] center_ = new double[3];
        T3DApp.computeVolumeCenter(orig, xv, yv, zv, dims, center_);
        if (this.cursor == null) {
            this.cursor = new DefaultCursor3DModel();
            int nports = this.vp.getNumPorts();
            this.cursor.setPoint(new CPoint(center_[0], center_[1], center_[2], 2));
            for (int i2 = 0; i2 < nports; ++i2) {
                T3DViewport tvp = this.vp.getPort(i2);
                Cursor3DVc cursorVc = new Cursor3DVc(this.cursor, tvp);
                cursorVc.setName("Cursor3DVc");
                this.cursor_vc.add(cursorVc);
                cursorVc.setAutoPage(true);
                cursorVc.setContinuousUpdateEnabled(true);
                tvp.getT3DComponent().add(cursorVc);
                if (i2 != 0) {
                    DefaultObliqueController obliqueController = new DefaultObliqueController(tvp.getT3DComponent(), tvp.getT3DComponent(), this.cursor);
                    obliqueController.setName("DefaultObliqueControl");
                    obliqueController.setVisible(false);
                    tvp.getT3DComponent().add(obliqueController);
                }
                tvp.invalidate();
                tvp.validate();
                tvp.repaint();
            }
        } else {
            this.cursor.setPoint(new CPoint(center_[0], center_[1], center_[2], 2));
            for (int i3 = 0; i3 < this.cursor_vc.size(); ++i3) {
                Cursor3DVc cvc = (Cursor3DVc)this.cursor_vc.get(i3);
                cvc.setVisible(this.cursor3D.isSelected());
            }
        }
    }

    private void orientationCube() {
        if (this.ocube_vc.size() > 0) {
            for (int i2 = 0; i2 < this.ocube_vc.size(); ++i2) {
                OrientationCubeVc cube = (OrientationCubeVc)this.ocube_vc.get(i2);
                cube.setVisible(this.orientationCube.isSelected());
            }
        } else {
            int nports = this.vp.getNumPorts();
            for (int i3 = 0; i3 < nports; ++i3) {
                T3DViewport tvp = this.vp.getPort(i3);
                OrientationCubeVc cube = new OrientationCubeVc(tvp);
                this.ocube_vc.add(cube);
                tvp.getT3DComponent().add(cube);
                tvp.invalidate();
                tvp.validate();
                tvp.repaint();
            }
        }
    }

    private void pixelInspector() {
        if (this.mml != null) {
            int nports = this.vp.getNumPorts();
            for (int i2 = 0; i2 < nports; ++i2) {
                T3DViewport tvp = this.vp.getPort(i2);
                tvp.getT3DComponent().removeMouseMotionListener(this.mml);
            }
            this.mml = null;
        } else {
            int nports = this.vp.getNumPorts();
            this.mml = new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e2) {
                }

                @Override
                public void mouseMoved(MouseEvent e2) {
                    int x2 = e2.getX();
                    int y2 = e2.getY();
                    T3DComponent tc = (T3DComponent)e2.getSource();
                    XpMedicalImage mimg = tc.getMedicalImage();
                    double slope = mimg.getRescaleSlope();
                    double intercept = mimg.getRescaleIntercept();
                    BufferedImage bimg = (BufferedImage)mimg.getPixelData();
                    DataBuffer db = bimg.getRaster().getDataBuffer();
                    if (db instanceof DataBufferInt) {
                        int[] data = ((DataBufferInt)db).getData();
                    } else {
                        short[] data = ((DataBufferUShort)db).getData();
                        short rval = data[y2 * bimg.getWidth() + x2];
                        double mval = (double)rval * slope + intercept;
                        System.err.println("[Raw=" + rval + "  Mod=" + mval + "]");
                    }
                }
            };
            for (int i3 = 0; i3 < nports; ++i3) {
                T3DViewport tvp = this.vp.getPort(i3);
                tvp.getT3DComponent().addMouseMotionListener(this.mml);
            }
        }
    }

    private void applyPreset() {
        double deltax = this.preset.incr;
        double startx = this.preset.start;
        System.out.println("deltax=" + deltax);
        System.out.println("startx=" + startx);
        double[] opacity = this.preset.fillOpacity();
        double[] clut = this.preset.fillRGB();
        VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
        VrPreset p2 = new VrPreset("CT", vrcl, opacity, startx, deltax);
        T3DViewport iv = this.vp.getSelectedPort();
        iv.setProperty("PRESET_PROPERTY", p2);
        this.vp.repaint();
    }

    private void dupVol() {
        JFrame frame = new JFrame("New View of Duplicate Volume");
        J3DVolumeModel vm = (J3DVolumeModel)this.vp.getVolumeModel();
        J3DVolumeModel dupvm = (J3DVolumeModel)vm.dupvol();
        T3DViewport iv = new T3DViewport();
        iv.setPreferredSize(new Dimension(512, 512));
        JVolume.LinearShort jls = (JVolume.LinearShort)dupvm.j_vol;
        JVolume.LinearShort orig = (JVolume.LinearShort)vm.j_vol;
        for (int i2 = 0; i2 < jls.volume.length >> 1; ++i2) {
            jls.volume[jls.PAD + i2] = orig.volume[orig.PAD + i2];
        }
        iv.setVolumeModel(dupvm);
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(iv);
        frame.pack();
        frame.setVisible(true);
    }

    private void volumeOverlay(boolean display) {
        System.err.println(">>> volume overlay: " + display);
        final J3DVolumeModel jvm = (J3DVolumeModel)this.vp.getVolumeModel();
        int nports = this.vp.getNumPorts();
        if (display) {
            boolean init = false;
            if (this.labels == null) {
                init = true;
                JVolume.LinearShort jls = (JVolume.LinearShort)jvm.j_vol;
                int dx = jls.dx;
                int dy = jls.dy;
                int dz = jls.dz;
                this.labels = new short[jls.volume.length];
                double radius = (double)dx * 0.25 * ((double)dx * 0.25);
                for (int z2 = 0; z2 < dz; ++z2) {
                    for (int y2 = 0; y2 < dy; ++y2) {
                        for (int x2 = 0; x2 < dx; ++x2) {
                            int xx = x2 - (dx >> 1);
                            int yy = y2 - (dy >> 1);
                            double r2 = xx * xx + yy * yy;
                            if (!(r2 < radius)) continue;
                            this.labels[jls.PAD + z2 * (dx * dy) + y2 * dx + x2] = 1;
                        }
                    }
                }
            }
            jvm.setData("LABEL_VOLUME", this.labels);
            for (int i2 = 0; i2 < nports; ++i2) {
                T3DViewport tvp = this.vp.getPort(i2);
                if (!tvp.getRenderStyle().equalsIgnoreCase("REFORMAT")) continue;
                SegmentationCapable sc = (SegmentationCapable)((Object)tvp.getCapable(SegmentationCapable.class.getCanonicalName()));
                sc.setSegmentationColorMap(new int[]{2063532032, 2046885632});
                tvp.setRenderStyle("FUSED_REFORMAT");
                if (!init) continue;
                tvp.getT3DComponent().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e2) {
                        boolean b1;
                        super.mouseClicked(e2);
                        int modifier = e2.getModifiers();
                        boolean bl = b1 = (modifier & 0x10) != 0;
                        if ((modifier & 2) != 0) {
                            System.err.println(">>> Clicked b1=" + b1);
                            for (int i2 = jvm.j_vol.PAD; i2 < T3DApp.this.labels.length; ++i2) {
                                ((T3DApp)T3DApp.this).labels[i2] = T3DApp.this.labels[i2] == 0 ? (short)1 : 0;
                            }
                            T3DApp.this.vp.refreshContents();
                            T3DApp.this.vp.repaint();
                        }
                    }
                });
            }
        } else {
            jvm.setData("LABEL_VOLUME", null);
            for (int i3 = 0; i3 < nports; ++i3) {
                T3DViewport tvp = this.vp.getPort(i3);
                if (!tvp.getRenderStyle().equalsIgnoreCase("FUSED_REFORMAT")) continue;
                tvp.setRenderStyle("REFORMAT");
            }
        }
        this.vp.refreshContents();
        this.vp.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object src = e2.getSource();
        if (src instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)src;
            String item = mi.getText();
            System.err.println(">>> Option: " + item);
            if (item.equalsIgnoreCase("exit")) {
                System.exit(0);
            } else if (item.startsWith("Load Volume")) {
                this.loadFromDialog();
            } else if (item.equalsIgnoreCase("Clear")) {
                this.vp.setVolume(null);
                this.sd.setVolumeModel(null);
                this.vol = null;
                this.vp.repaint();
            } else if (item.equalsIgnoreCase("Bingrid Segmentation")) {
                this.bingridSegmentation();
            } else if (item.equalsIgnoreCase("CT Table Removal")) {
                this.ctTableRemoval();
            } else if (item.equalsIgnoreCase("Volume Overlay")) {
                JCheckBoxMenuItem vo_item = (JCheckBoxMenuItem)src;
                this.volumeOverlay(vo_item.isSelected());
            } else if (item.equalsIgnoreCase("Reset Bingrid")) {
                this.resetBingrid();
            } else if (item.equalsIgnoreCase("User Annotation")) {
                this.userAnnot();
            } else if (item.equalsIgnoreCase("Apply VR Presets")) {
                this.applyPreset();
            } else if (item.equalsIgnoreCase("Cursor 3D")) {
                this.cursor3dModel();
            } else if (item.equalsIgnoreCase("Orientation Cube")) {
                this.orientationCube();
            } else if (item.equalsIgnoreCase("Inspect Values")) {
                this.pixelInspector();
            } else if (item.equalsIgnoreCase("Dup Volume")) {
                this.dupVol();
            } else if (item.equalsIgnoreCase("1x1")) {
                this.vp.setRowCol(1, 1);
            } else if (item.equalsIgnoreCase("2x2")) {
                this.vp.setRowCol(2, 2);
            } else if (item.equalsIgnoreCase("3x3")) {
                this.vp.setRowCol(3, 3);
            } else if (item.equalsIgnoreCase("3x2")) {
                this.vp.setRowCol(3, 2);
            } else if (item.equalsIgnoreCase("Ellipse")) {
                System.err.println(">> ellipse");
                this.applyROI("" + item);
            } else if (item.equalsIgnoreCase("Rectangle")) {
                System.err.println(">> rectangle");
                this.applyROI("" + item);
            } else if (item.equalsIgnoreCase("Line")) {
                System.err.println(">> line");
                this.applyROI("" + item);
            }
        }
    }

    private void applyROI(String roiType) {
        T3DViewport port = this.vp.getSelectedPort();
        if (port != null) {
            XpStatisticsRoi ra = null;
            int w2 = port.getWidth();
            int h2 = port.getHeight();
            if (roiType.equalsIgnoreCase("ellipse")) {
                Ellipse2D.Double ell = new Ellipse2D.Double((double)w2 * 0.2, (double)h2 * 0.2, (double)w2 * 0.5, (double)h2 * 0.25);
                ra = new XpRectangularRoi(ell);
            } else if (roiType.equalsIgnoreCase("rectangle")) {
                Rectangle2D.Double rect = new Rectangle2D.Double((double)w2 * 0.2, (double)h2 * 0.2, (double)w2 * 0.5, (double)h2 * 0.25);
                ra = new XpRectangularRoi(rect);
            } else if (roiType.equalsIgnoreCase("line")) {
                Point2D[] pts = new Point2D[]{new Point2D.Double((double)w2 * 0.2, (double)h2 * 0.1), new Point2D.Double((double)w2 * 0.6, (double)h2 * 0.6)};
                ra = new XpPolygonRoi(pts);
            }
            port.add(ra);
            port.getT3DComponent().validate();
            port.getT3DComponent().invalidate();
            port.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("camera")) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("T3DApp");
        T3DApp app = new T3DApp(args[0]);
        jf.setContentPane(app);
        jf.pack();
        jf.setDefaultCloseOperation(3);
        app.installMenuBar(jf);
        jf.setVisible(true);
    }

    private class VRTL
    implements TaskMonitor {
        private VRTL() {
        }

        @Override
        public void taskBegin(String taskName, int totalWork) {
            if (T3DApp.this.processUpdate) {
                ((T3DApp)T3DApp.this).cp.vrprogressBar.setMinimum(0);
                ((T3DApp)T3DApp.this).cp.vrprogressBar.setMaximum(totalWork - 1);
                ((T3DApp)T3DApp.this).cp.vrprogressBar.setValue(0);
            }
        }

        @Override
        public void taskDone(String taskName) {
            if (T3DApp.this.processUpdate) {
                ((T3DApp)T3DApp.this).cp.vrprogressBar.setValue(((T3DApp)T3DApp.this).cp.vrprogressBar.getMaximum());
            }
        }

        @Override
        public void taskProgress(String taskName, int units) {
            if (T3DApp.this.processUpdate) {
                ((T3DApp)T3DApp.this).cp.vrprogressBar.setValue(units);
                ((T3DApp)T3DApp.this).cp.vrprogressBar.repaint();
            }
        }

        @Override
        public void taskFailed(String taskName, String reason, Exception e2) {
        }
    }

    private class WWWLActiveAnnotation
    implements MouseInputListener,
    ActionListener {
        private JPopupMenu popup = new JPopupMenu("Presets");

        public WWWLActiveAnnotation() {
            this.addMenuItem("Abdomen");
            this.addMenuItem("Head");
            this.addMenuItem("Lung");
            this.addMenuItem("Spine");
        }

        private void addMenuItem(String name) {
            JMenuItem menuItem = new JMenuItem(name);
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.maybeShowPopup(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.maybeShowPopup(e2);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JMenuItem mi = (JMenuItem)e2.getSource();
            String title = mi.getText();
            if (title.equals("Abdomen")) {
                T3DApp.this.vp.setWindowing(400.0, 40.0);
            } else if (title.equals("Head")) {
                T3DApp.this.vp.setWindowing(100.0, 35.0);
            } else if (title.equals("Lung")) {
                T3DApp.this.vp.setWindowing(1000.0, -700.0);
            } else if (title.equals("Spine")) {
                T3DApp.this.vp.setWindowing(300.0, 35.0);
            }
            T3DApp.this.vp.repaint();
        }

        private void maybeShowPopup(MouseEvent e2) {
            if (e2.isPopupTrigger()) {
                this.popup.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }
    }

    private class ControlPanel
    extends JPanel {
        private static final int SLIDER_RESOLUTION = 200;
        public JSlider thicknessSlider = new JSlider(0, 0, 200, 0);
        public JTextField thresh0 = new JTextField("0");
        public JTextField thresh1 = new JTextField("4096");
        public JButton applyThreshold = new JButton("Apply Threshold");
        public JProgressBar vrprogressBar = new JProgressBar();
        public T3DViewPanel viewPanel = new T3DViewPanel();

        public ControlPanel() {
            this.setLayout(new GridLayout(2, 2));
            JPanel threshPanel = new JPanel();
            this.thresh0.setPreferredSize(new Dimension(48, 26));
            this.thresh1.setPreferredSize(new Dimension(48, 26));
            threshPanel.add(new JLabel("Minimum: "));
            threshPanel.add(this.thresh0);
            threshPanel.add(new JLabel("Maximum: "));
            threshPanel.add(this.thresh1);
            threshPanel.setBorder(BorderFactory.createTitledBorder("Value Threshold"));
            threshPanel.add(this.applyThreshold);
            this.applyThreshold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    try {
                        BinGrid bg = null;
                        XjVolumeModel vm = T3DApp.this.vp.getVolumeModel();
                        double intercept = 0.0;
                        double slope = 1.0;
                        if (vm instanceof J3DVolumeModel) {
                            J3DVolumeModel j3dvm = (J3DVolumeModel)vm;
                            JVolume.LinearShort j_vol = (JVolume.LinearShort)j3dvm.j_vol;
                            intercept = j_vol.rescaleIntercept;
                            slope = j_vol.rescaleSlope;
                            slope = slope != 0.0 ? slope : 1.0;
                            bg = new BinGrid(j_vol.volume, j_vol.PAD, j_vol.dx, j_vol.dy, j_vol.dz);
                        }
                        int minv = Integer.parseInt(ControlPanel.this.thresh0.getText());
                        int maxv = Integer.parseInt(ControlPanel.this.thresh1.getText());
                        System.out.println("thresholding: " + minv + " " + maxv);
                        J3DRenderEngine jre = (J3DRenderEngine)T3DApp.this.vp.getSelectedPort().getT3DComponent().getT3DRenderEngine();
                        if (jre != null && bg != null) {
                            int minVS = (int)((double)minv / slope - intercept);
                            int maxVS = (int)((double)maxv / slope - intercept);
                            bg.threshold(minVS, maxVS);
                            byte[] th = bg.bingrid;
                            jre.applySegmentation(th);
                            T3DApp.this.vp.repaint();
                        }
                    }
                    catch (NumberFormatException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            JPanel thickPanel = new JPanel();
            thickPanel.add(this.thicknessSlider);
            thickPanel.setBorder(BorderFactory.createTitledBorder("Slice Thickness (mm)"));
            this.thicknessSlider.setPaintLabels(true);
            this.thicknessSlider.setPaintTrack(true);
            this.thicknessSlider.setMajorTickSpacing(40);
            this.thicknessSlider.setToolTipText("Slab Thickness (mm)");
            this.thicknessSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    int thick = ControlPanel.this.thicknessSlider.getValue();
                    double hthick = (double)thick * 0.5;
                    T3DApp.this.vp.setViewClip(new double[]{-hthick, hthick});
                    T3DApp.this.vp.repaint();
                }
            });
            JPanel progressPanel = new JPanel();
            progressPanel.setBorder(BorderFactory.createTitledBorder("Operation Progress"));
            progressPanel.add(this.vrprogressBar);
            this.add(threshPanel);
            this.add(thickPanel);
            this.add(progressPanel);
            this.add(this.viewPanel);
        }

        private class T3DViewPanel
        extends JPanel {
            public ButtonGroup button_group = new ButtonGroup();

            public T3DViewPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Views"));
                this.setLayout(new GridLayout(2, 3));
                JToggleButton anterior = new JToggleButton("A");
                JToggleButton posterior = new JToggleButton("P");
                JToggleButton right = new JToggleButton("R");
                JToggleButton left = new JToggleButton("L");
                JToggleButton superior = new JToggleButton("S");
                JToggleButton inferior = new JToggleButton("I");
                this.add(right);
                this.add(anterior);
                this.add(superior);
                this.add(left);
                this.add(posterior);
                this.add(inferior);
                this.button_group.add(anterior);
                this.button_group.add(posterior);
                this.button_group.add(superior);
                this.button_group.add(inferior);
                this.button_group.add(right);
                this.button_group.add(left);
                anterior.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, A_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, A_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
                posterior.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, P_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, P_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
                superior.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, S_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, S_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
                inferior.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, I_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, I_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
                right.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, R_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, R_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
                left.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        T3DViewport t3dref = T3DApp.this.vp.getPort(T3DApp.this.vp.getSelectedPortIndex());
                        double[] lookpt = t3dref.getLookPoint(null);
                        double[] eyept = new double[3];
                        JnVector3d.sub(lookpt, L_VECTOR.toArray(), eyept);
                        t3dref.setCamera(eyept, lookpt, L_UP_VECTOR.toArray());
                        t3dref.repaint();
                    }
                });
            }
        }
    }
}

