/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.Capable;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.T3DRenderEngineDefs;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.j3d.mprender.MultipassMap;
import com.ge.med.terra.jami.j3d.mprender.MultipassPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public abstract class T3DBaseRenderEngine
implements T3DRenderEngine,
T3DRenderEngineDefs,
PropertyChangeListener,
TaskMonitor {
    public static final int MAX_VOLUMES = 8;
    private List taskMonitors = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Set changeListeners = new HashSet();
    private boolean debug = false;
    private boolean t3dReady = false;
    private MultipassMap mpassMap = null;
    private int rstyle = -1;
    private String renderStyle = "";
    private JnRectangle dirtyRegion = new JnRectangle();
    private int[] rgb_buff = null;
    private short[] lum_buff = null;
    private short[] outoverlay = null;
    private short[] zbuffer = null;
    private int outWidth = 0;
    private int outHeight = 0;
    private Map props = new TreeMap();
    private int rgb_background = 0;
    private double[] initialUp = new double[3];
    private double[] initialView = new double[3];
    private double[] ulc = new double[3];
    private double[] xside = new double[3];
    private double[] yside = new double[3];
    private double[] zside = new double[3];
    private double[] lookPoint = new double[]{0.0, 0.0, 0.0};
    private double[] eyePoint = new double[]{0.0, 0.0, 100.0};
    private double[] upVector = new double[]{0.0, 1.0, 0.0};
    private double[] viewClip = new double[2];
    private double viewHeight = 1.0;
    private boolean perspective = false;
    private double[] oldEye_ = new double[3];
    private double[] oldLook_ = new double[3];
    private double[] oldUp_ = new double[3];
    private double[] oldCamera_ = new double[9];
    private double[] camera_ = new double[9];
    private JnMatrix3d rasCameraTx = new JnMatrix3d();
    private List<VolumeContext> vctxt = new Vector<VolumeContext>();

    public T3DBaseRenderEngine() {
        System.arraycopy(ViewResetAction.A_VECTOR.toArray(), 0, this.initialView, 0, 3);
        System.arraycopy(ViewResetAction.A_UP_VECTOR.toArray(), 0, this.initialUp, 0, 3);
    }

    @Override
    public void shutdown() {
        for (int i2 = 0; i2 < this.vctxt.size(); ++i2) {
            this.removeVolumeContext(i2);
        }
        this.mpassMap.clear();
    }

    protected void setMultipassMap(MultipassMap mpassMap) {
        this.mpassMap = mpassMap;
        this.mpassMap.setRenderStyle(this.getRenderStyle());
    }

    protected MultipassMap getMultipassMap() {
        return this.mpassMap;
    }

    @Override
    public void setVolume(XjVolumeInfo volume) {
        this.setVolume(volume, 0);
    }

    @Override
    public abstract void setVolume(XjVolumeInfo var1, int var2);

    @Override
    public XjVolumeInfo getVolume() {
        VolumeContext vc = this.getVolumeContext(0);
        if (vc != null) {
            return vc.volume;
        }
        return null;
    }

    @Override
    public void setVolumeModel(XjVolumeModel volumeModel) {
        this.setVolumeModel(volumeModel, 0);
    }

    @Override
    public void setVolumeModel(XjVolumeModel volumeModel, int vol_idx) {
        this.setT3DReady(false);
        this.cleanVolumeModel(vol_idx);
        this.loadVolumeModel(vol_idx, volumeModel);
        this.newVolumeModel(vol_idx);
        this.setT3DReady(true);
        this.firePropertyChange("VOLUME_PROPERTY", null, this.getVolumeModel(vol_idx));
    }

    @Override
    public XjVolumeModel getVolumeModel() {
        return this.getVolumeModel(0);
    }

    @Override
    public int addVolume(XjVolumeInfo vol) {
        int vidx = this.vctxt.size();
        this.setVolume(vol, vidx);
        return vidx;
    }

    @Override
    public int addVolumeModel(XjVolumeModel volumeModel) {
        int vidx = this.vctxt.size();
        this.setVolumeModel(volumeModel, vidx);
        return vidx;
    }

    @Override
    public int removeVolumeModel(int idx) {
        if (idx >= 0 && idx < this.vctxt.size()) {
            this.setVolumeModel(null, idx);
        }
        return this.vctxt.size();
    }

    @Override
    public int getNumVolumes() {
        return this.vctxt.size();
    }

    @Override
    public double getRescaleSlope(int renderOutputLayer) {
        XjVolumeInfo vol;
        XjVolumeModel vm = this.getVolumeModel(renderOutputLayer);
        if (vm != null && (vol = vm.getVolume()) != null) {
            double rescaleSlope = XjVolumeUtils.calcVolumeRescaleSlope(vol);
            return rescaleSlope;
        }
        return 1.0;
    }

    @Override
    public double getRescaleIntercept(int renderOutputLayer) {
        XjVolumeInfo vol;
        XjVolumeModel vm = this.getVolumeModel(renderOutputLayer);
        if (vm != null && (vol = vm.getVolume()) != null) {
            double rescaleIntercept = XjVolumeUtils.calcVolumeRescaleIntercept(vol);
            return rescaleIntercept;
        }
        return 0.0;
    }

    @Override
    public int getNumOutputs() {
        int nouts = 1;
        switch (this.rstyle) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                nouts = this.getNumVolumes();
            }
        }
        return nouts;
    }

    public int getNumOutputLayers() {
        return this.getNumOutputs();
    }

    @Override
    public XjVolumeModel getVolumeModel(int vol_idx) {
        VolumeContext vc = this.getVolumeContext(vol_idx);
        if (vc != null) {
            return vc.vol_model;
        }
        return null;
    }

    protected VolumeContext getVolumeContext(int vol_idx) {
        if (vol_idx >= 0 && vol_idx < this.vctxt.size()) {
            return this.vctxt.get(vol_idx);
        }
        return null;
    }

    public void cleanVolumeModel(int vol_idx) {
    }

    protected void newVolumeModel(int vol_idx) {
    }

    private void removeVolumeContext(int vol_idx) {
        VolumeContext vc = this.getVolumeContext(vol_idx);
        if (vc != null) {
            XjVolumeModel vol_model = vc.vol_model;
            if (vol_model != null) {
                vol_model.removePropertyChangeListener("VOLUME_SLICE", this);
                vol_model.removeChangeListener(this);
            }
            this.vctxt.remove(vol_idx);
        }
    }

    private void loadVolumeModel(int vol_idx, XjVolumeModel vm) {
        this.removeVolumeContext(vol_idx);
        if (vm != null) {
            VolumeContext vc = new VolumeContext();
            XjVolumeModel vol_model = vc.vol_model = vm;
            vc.volume = vol_model.getVolume();
            this.vctxt.add(vol_idx, vc);
            if (vol_idx == 0) {
                XjVolumeInfo xj_vol = vol_model.getVolume();
                this.configureInitialCamera(xj_vol);
                this.refreshWorldBounds(xj_vol);
            }
            vol_model.addChangeListener(this);
            vol_model.addPropertyChangeListener("VOLUME_SLICE", this);
        }
    }

    protected void configureInitialCamera(XjVolumeInfo xj_vol) {
        int[] dims = new int[3];
        double[] ulhc = new double[3];
        double[] rasX = new double[3];
        double[] rasY = new double[3];
        double[] rasZ = new double[3];
        xj_vol.getRASOfOrigin(ulhc);
        xj_vol.getXDirectionRAS(rasX);
        xj_vol.getYDirectionRAS(rasY);
        xj_vol.getZDirectionRAS(rasZ);
        xj_vol.getVolumeDimensions(dims);
        double ras_spx = JnVector3d.length(rasX);
        double ras_spy = JnVector3d.length(rasY);
        double ras_spz = JnVector3d.length(rasZ);
        double ras_dx = ras_spx * (double)dims[0];
        double ras_dy = ras_spy * (double)dims[1];
        double ras_dz = ras_spz * (double)dims[2];
        double tilt = Math.toRadians(XjVolumeUtils.calculateTilt(xj_vol));
        JnMatrix4d tiltmat = new JnMatrix4d();
        tiltmat.setRotate(-tilt, rasX[0], rasX[1], rasX[2]);
        double[] volcenter = new double[3];
        XjVolumeUtils.getVolumeCenterRAS(ulhc, rasX, rasY, rasZ, dims, volcenter);
        double[] look_pt = volcenter;
        double[] eye_pt = new double[3];
        double[] up_vec = this.getInitialUp();
        tiltmat.transform(up_vec);
        double w2 = ras_dx;
        double h2 = ras_dy;
        double[] viewVector = this.getInitialView();
        tiltmat.transform(viewVector);
        double focal_distance = w2 * 1.05;
        eye_pt[0] = look_pt[0] - viewVector[0] * focal_distance;
        eye_pt[1] = look_pt[1] - viewVector[1] * focal_distance;
        eye_pt[2] = look_pt[2] - viewVector[2] * focal_distance;
        if (h2 < ras_dz) {
            h2 = ras_dz;
        }
        h2 = Math.max(w2, h2);
        this.setViewHeight(h2);
        this.setCamera(eye_pt, look_pt, up_vec);
    }

    @Override
    public void clearPixels(int x0, int y0, int width, int height, int stepx, int stepy) {
        int w2 = this.getBufferWidth();
        int lum_background = this.getLuminanceBackground();
        switch (this.rstyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                for (int y2 = y0; y2 < height; y2 += stepy) {
                    int yoffset = y2 * w2;
                    for (int x2 = x0; x2 < width; x2 += stepx) {
                        this.lum_buff[yoffset + x2] = (short)lum_background;
                    }
                }
                break;
            }
            case 8: 
            case 25: 
            case 26: {
                for (int y3 = y0; y3 < y0 + height; y3 += stepy) {
                    int yoffset = y3 * w2;
                    for (int x3 = x0; x3 < x0 + width; x3 += stepx) {
                        this.rgb_buff[yoffset + x3] = this.rgb_background;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void setOutput(int[] rgbBuff, short[] luminanceBuff, int width, int height) {
        this.outWidth = width;
        this.outHeight = height;
        this.rgb_buff = rgbBuff;
        this.lum_buff = luminanceBuff;
        int zlen = width * height;
        if (this.zbuffer == null || this.zbuffer.length != zlen) {
            this.zbuffer = new short[zlen];
        }
        this.dirtyRegion.setBounds(0, 0, width, height);
    }

    @Override
    public void setOverlay(short[] overlayBuff) {
        this.outoverlay = overlayBuff;
    }

    protected short[] getOverlay() {
        return this.outoverlay;
    }

    protected short[] getLuminanceBuffer() {
        return this.lum_buff;
    }

    protected int[] getRGBBuffer() {
        return this.rgb_buff;
    }

    @Override
    public void clearBuffers() {
        int lum_background = this.getLuminanceBackground();
        if (this.lum_buff != null) {
            Arrays.fill(this.lum_buff, (short)lum_background);
        }
        if (this.rgb_buff != null) {
            Arrays.fill(this.rgb_buff, this.rgb_background);
        }
        if (this.outoverlay != null) {
            Arrays.fill(this.outoverlay, (short)-1);
        }
        if (this.zbuffer != null) {
            Arrays.fill(this.zbuffer, (short)8192);
        }
    }

    @Override
    public Object getPixelBuffer() {
        Object[] buff = null;
        switch (this.rstyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                buff = this.lum_buff;
                break;
            }
            case 8: 
            case 25: 
            case 26: {
                buff = this.rgb_buff;
            }
        }
        return buff;
    }

    @Override
    public int getBPP() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 8;
        }
        if (buff instanceof short[]) {
            String modality;
            XjVolumeInfo vol = this.getVolume();
            if (vol != null && (modality = ("" + vol.getValue(8, 96)).toUpperCase()).equals("CT")) {
                return 12;
            }
            return 16;
        }
        if (buff instanceof byte[]) {
            return 8;
        }
        return 0;
    }

    @Override
    public int getNumChannels() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getBufferWidth() {
        return this.outWidth;
    }

    @Override
    public int getBufferHeight() {
        return this.outHeight;
    }

    @Override
    public short[] getZBuffer() {
        return this.zbuffer;
    }

    @Override
    public void initRender() {
        this.updateVoxelCamera();
    }

    @Override
    public double[] getTransform(int srcCoords, int destCoords, double[] transform) {
        double[] res = transform;
        if (res == null) {
            res = new double[16];
        }
        if (srcCoords != destCoords) {
            VolumeContext vc = this.getVolumeContext(0);
            if (vc == null) {
                return res;
            }
            block0 : switch (srcCoords) {
                case 1000: {
                    switch (destCoords) {
                        case 1001: {
                            System.arraycopy(vc.jn_vox2ras.m, 0, res, 0, 16);
                            break block0;
                        }
                        case 1002: {
                            CTransform rmat = vc.jn_vox2ras.multiplyBy(vc.jn_ras2disp);
                            System.arraycopy(rmat.m, 0, res, 0, 16);
                        }
                    }
                    break;
                }
                case 1001: {
                    switch (destCoords) {
                        case 1000: {
                            System.arraycopy(vc.jn_ras2vox.m, 0, res, 0, 16);
                            break block0;
                        }
                        case 1002: {
                            System.arraycopy(vc.jn_ras2disp.m, 0, res, 0, 16);
                        }
                    }
                    break;
                }
                case 1002: {
                    switch (destCoords) {
                        case 1000: {
                            CTransform rmat = vc.jn_disp2ras.multiplyBy(vc.jn_ras2vox);
                            System.arraycopy(rmat.m, 0, res, 0, 16);
                            break block0;
                        }
                        case 1001: {
                            System.arraycopy(vc.jn_disp2ras.m, 0, res, 0, 16);
                        }
                    }
                }
            }
        } else {
            Arrays.fill(res, 0.0);
            res[15] = 1.0;
            res[10] = 1.0;
            res[5] = 1.0;
            res[0] = 1.0;
        }
        return res;
    }

    @Override
    public void transform(double[] src_pt, int srcCoords, double[] dest_pt, int destCoords) {
        VolumeContext vc;
        double[] dest = dest_pt;
        if (src_pt == dest_pt) {
            dest = new double[3];
        }
        if ((vc = this.getVolumeContext(0)) == null) {
            return;
        }
        if (srcCoords != destCoords) {
            block0 : switch (srcCoords) {
                case 1000: {
                    switch (destCoords) {
                        case 1001: {
                            vc.jn_vox2ras.transform(src_pt, dest);
                            break block0;
                        }
                        case 1002: {
                            double[] tempr = new double[4];
                            vc.jn_vox2ras.transform(src_pt, tempr);
                            vc.jn_ras2disp.transform(tempr, dest);
                        }
                    }
                    break;
                }
                case 1001: {
                    switch (destCoords) {
                        case 1000: {
                            vc.jn_ras2vox.transform(src_pt, dest);
                            break block0;
                        }
                        case 1002: {
                            vc.jn_ras2disp.transform(src_pt, dest);
                        }
                    }
                    break;
                }
                case 1002: {
                    switch (destCoords) {
                        case 1000: {
                            double[] tempv = new double[4];
                            vc.jn_disp2ras.transform(src_pt, tempv);
                            vc.jn_ras2vox.transform(tempv, dest);
                            break block0;
                        }
                        case 1001: {
                            vc.jn_disp2ras.transform(src_pt, dest);
                        }
                    }
                }
            }
        } else {
            System.arraycopy(src_pt, 0, dest, 0, 3);
        }
        if (dest != dest_pt) {
            System.arraycopy(dest, 0, dest_pt, 0, 3);
        }
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int renderOutputLayer) {
        int rstyle = this.getRenderStyleCode();
        int w2 = this.getBufferWidth();
        int h2 = this.getBufferHeight();
        double thickness = this.getNumSteps(0);
        if (this.mpassMap != null) {
            MultipassAlgorithm ma = this.mpassMap.getMultipassAlgorithm(w2, h2, thickness);
            return ma;
        }
        return null;
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        if (this.mpassMap != null) {
            return this.mpassMap.getSupportedMultipassAlgorithms();
        }
        return null;
    }

    @Override
    public void setProperty(String propName, Object value) {
        this.props.put(propName, value);
    }

    @Override
    public Object getProperty(String propName) {
        return this.props.get(propName);
    }

    @Override
    public void setBackground(int rgbbackground, int lumbackground) {
        this.rgb_background = rgbbackground;
        this.notifyChange();
    }

    public abstract String getModality(int var1);

    public int getLuminanceBackground() {
        return Commons3D.noContentPixel(this.getModality(0));
    }

    public int getRGBBackground() {
        return this.rgb_background;
    }

    @Override
    public int getBackgroundColor() {
        int bgcolor = 0;
        switch (this.rstyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                bgcolor = this.getLuminanceBackground();
                break;
            }
            case 8: 
            case 25: 
            case 26: {
                bgcolor = this.getRGBBackground();
            }
        }
        return bgcolor;
    }

    @Override
    public void setRenderStyle(String style) {
        if (this.mpassMap != null) {
            this.mpassMap.setRenderStyle(style);
        }
        if (!this.renderStyle.equals(style)) {
            String oldStyle = this.renderStyle;
            this.renderStyle = style;
            this.rstyle = this.getRenderStyleCode(this.renderStyle);
            this.firePropertyChange("renderStyle", oldStyle, style);
        }
    }

    @Override
    public String getRenderStyle() {
        return this.renderStyle;
    }

    protected int getRenderStyleCode() {
        return this.rstyle;
    }

    protected int getRenderStyleCode(String style) {
        return Commons3D.getRenderStyleCode(style);
    }

    @Override
    public void getWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        System.arraycopy(this.ulc, 0, ulc, 0, this.ulc.length);
        System.arraycopy(this.xside, 0, xside, 0, this.xside.length);
        System.arraycopy(this.yside, 0, yside, 0, this.yside.length);
        System.arraycopy(this.zside, 0, zside, 0, this.zside.length);
    }

    protected void refreshWorldBounds(XjVolumeInfo volume) {
        if (volume != null) {
            volume.getRASOfOrigin(this.ulc);
            volume.getXDirectionRAS(this.xside);
            volume.getYDirectionRAS(this.yside);
            volume.getZDirectionRAS(this.zside);
            int[] dims = volume.getVolumeDimensions(null);
            this.ulc[0] = this.ulc[0] - 0.5 * this.xside[0] - 0.5 * this.yside[0];
            this.ulc[1] = this.ulc[1] - 0.5 * this.xside[1] - 0.5 * this.yside[1];
            this.ulc[2] = this.ulc[2] - 0.5 * this.xside[2] - 0.5 * this.yside[2];
            this.xside[0] = this.xside[0] * (double)dims[0];
            this.xside[1] = this.xside[1] * (double)dims[0];
            this.xside[2] = this.xside[2] * (double)dims[0];
            this.yside[0] = this.yside[0] * (double)dims[1];
            this.yside[1] = this.yside[1] * (double)dims[1];
            this.yside[2] = this.yside[2] * (double)dims[1];
            this.zside[0] = this.zside[0] * (double)dims[2];
            this.zside[1] = this.zside[1] * (double)dims[2];
            this.zside[2] = this.zside[2] * (double)dims[2];
        } else {
            this.repaint();
        }
    }

    protected final void setWorldBounds(double[] ulc, double[] xside, double[] yside, double[] zside) {
        System.arraycopy(ulc, 0, this.ulc, 0, this.ulc.length);
        System.arraycopy(xside, 0, this.xside, 0, this.xside.length);
        System.arraycopy(yside, 0, this.yside, 0, this.yside.length);
        System.arraycopy(zside, 0, this.zside, 0, this.zside.length);
    }

    private void calc_cam() {
        JnVector3d r2 = new JnVector3d();
        JnVector3d u2 = new JnVector3d();
        JnVector3d v2 = new JnVector3d();
        double[] lookpoint = this.getLookPoint(null);
        double[] eyepoint = this.getEyePoint(null);
        double[] up = this.getUp(null);
        GeomUtils.calcDirectionVectors(lookpoint, eyepoint, up, r2, u2, v2);
        this.rasCameraTx.set(r2.x, r2.y, r2.z, u2.x, u2.y, u2.z, v2.x, v2.y, v2.z);
        this.dirtyRegion.setBounds(0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    protected JnMatrix3d getRASCameraMatrix() {
        return this.rasCameraTx;
    }

    protected abstract boolean calculateVoxelRASTransform(XjVolumeModel var1, CTransform var2, CTransform var3);

    private void calcVox2RAS(VolumeContext vc) {
        if (vc.vol_model != null) {
            XjVolumeModel vol_model = vc.vol_model;
            boolean bl = this.calculateVoxelRASTransform(vol_model, vc.jn_vox2ras, vc.jn_ras2vox);
        }
    }

    private double calcNumSteps(double[] ras_view) {
        double step_size = JnVector3d.length(ras_view);
        double nsteps = this.getThickness() / step_size;
        return nsteps;
    }

    protected void updateVoxelCamera() {
        int winWidth = this.getBufferWidth();
        int winHeight = this.getBufferHeight();
        double viewHeight = this.viewHeight;
        double aratio = this.getAspectRatio();
        double[] ras_lookpt = new double[3];
        double[] view = new double[3];
        double[] p1 = new double[3];
        JnVector3d r2 = new JnVector3d();
        JnVector3d u2 = new JnVector3d();
        JnVector3d v2 = new JnVector3d();
        double[] lookpoint = this.getLookPoint(null);
        double[] eyepoint = this.getEyePoint(null);
        double[] up = this.getUp(null);
        GeomUtils.calcDirectionVectors(lookpoint, eyepoint, up, r2, u2, v2);
        if (viewHeight <= 0.0) {
            return;
        }
        for (int i2 = 0; i2 < this.vctxt.size(); ++i2) {
            VolumeContext vc = this.getVolumeContext(i2);
            XjVolumeInfo vinfo = vc.vol_model.getVolume();
            if (vinfo == null) continue;
            this.calcVox2RAS(vc);
            double[] dir_x = vinfo.getXDirectionRAS(null);
            double[] dir_y = vinfo.getYDirectionRAS(null);
            double[] dir_z = vinfo.getZDirectionRAS(null);
            double ras_spx = JnVector3d.length(dir_x);
            double ras_spy = JnVector3d.length(dir_y);
            double ras_spz = JnVector3d.length(dir_z);
            double viewWidth = viewHeight * aratio;
            double view_spx = viewWidth / (double)winWidth;
            double view_spy = viewHeight / (double)winHeight;
            double view_spz = XjVolumeUtils.getViewStepSize(vc.jn_ras2vox, v2, ras_spx, ras_spy, ras_spz);
            vc.vox_xdir[0] = r2.x * view_spx;
            vc.vox_xdir[1] = r2.y * view_spx;
            vc.vox_xdir[2] = r2.z * view_spx;
            vc.vox_ydir[0] = u2.x * view_spy;
            vc.vox_ydir[1] = u2.y * view_spy;
            vc.vox_ydir[2] = u2.z * view_spy;
            vc.vox_zdir[0] = v2.x * view_spz;
            vc.vox_zdir[1] = v2.y * view_spz;
            vc.vox_zdir[2] = v2.z * view_spz;
            vc.nsteps = this.calcNumSteps(vc.vox_zdir);
            ras_lookpt[0] = vc.vox_lookpt[0] = this.lookPoint[0];
            ras_lookpt[1] = vc.vox_lookpt[1] = this.lookPoint[1];
            ras_lookpt[2] = vc.vox_lookpt[2] = this.lookPoint[2];
            vc.jn_disp2ras.set(vc.vox_xdir[0], vc.vox_ydir[0], vc.vox_zdir[0], vc.vox_lookpt[0] - vc.vox_xdir[0] * (double)winWidth * 0.5 - vc.vox_ydir[0] * (double)winHeight * 0.5, vc.vox_xdir[1], vc.vox_ydir[1], vc.vox_zdir[1], vc.vox_lookpt[1] - vc.vox_xdir[1] * (double)winWidth * 0.5 - vc.vox_ydir[1] * (double)winHeight * 0.5, vc.vox_xdir[2], vc.vox_ydir[2], vc.vox_zdir[2], vc.vox_lookpt[2] - vc.vox_xdir[2] * (double)winWidth * 0.5 - vc.vox_ydir[2] * (double)winHeight * 0.5, 0.0, 0.0, 0.0, 1.0);
            vc.jn_disp2ras.inverse(vc.jn_ras2disp);
            this.rasToVoxels(i2, vc.vox_lookpt, vc.vox_xdir, vc.vox_ydir, vc.vox_zdir);
            JnVector3d.sub(this.lookPoint, this.eyePoint, view);
            JnVector3d.normalize(view);
            JnVector3d.scaleAdd(ras_lookpt, view, this.viewClip[0], p1);
            vc.jn_ras2vox.transform(p1);
            vc.vox_clipoffsets[0] = JnVector3d.distance(vc.vox_lookpt, p1) * (double)(this.viewClip[0] < 0.0 ? -1 : 1);
            JnVector3d.scaleAdd(ras_lookpt, view, this.viewClip[1], p1);
            vc.jn_ras2vox.transform(p1);
            vc.vox_clipoffsets[1] = JnVector3d.distance(vc.vox_lookpt, p1) * (double)(this.viewClip[1] < 0.0 ? -1 : 1);
        }
    }

    protected double[] getVoxLookPoint() {
        return this.getVoxLookPoint(0);
    }

    protected double[] getVoxXDir() {
        return this.getVoxXDir(0);
    }

    protected double[] getVoxYDir() {
        return this.getVoxYDir(0);
    }

    protected double[] getVoxZDir() {
        return this.getVoxZDir(0);
    }

    protected double[] getVoxClipOffsets() {
        return this.getVoxClipOffsets(0);
    }

    protected double getNumSteps() {
        return this.getNumSteps(0);
    }

    protected double[] getVoxLookPoint(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).vox_lookpt;
    }

    protected double[] getVoxXDir(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).vox_xdir;
    }

    protected double[] getVoxYDir(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).vox_ydir;
    }

    protected double[] getVoxZDir(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).vox_zdir;
    }

    protected double[] getVoxClipOffsets(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).vox_clipoffsets;
    }

    protected double getNumSteps(int vol_idx) {
        return this.getVolumeContext((int)vol_idx).nsteps;
    }

    protected static void snap_voxelcoord(double[] v2) {
        double x2 = Math.ceil(v2[0]);
        double y2 = Math.ceil(v2[1]);
        double z2 = Math.ceil(v2[2]);
        if (x2 - v2[0] < 1.0E-10) {
            v2[0] = x2;
        }
        if (y2 - v2[1] < 1.0E-10) {
            v2[1] = y2;
        }
        if (z2 - v2[2] < 1.0E-10) {
            v2[2] = z2;
        }
    }

    protected void rasToVoxels(int vol_idx, double[] lookpt, double[] xdir, double[] ydir, double[] zdir) {
        VolumeContext vc = this.getVolumeContext(vol_idx);
        double[] zero_tx = new double[]{0.0, 0.0, 0.0};
        vc.jn_ras2vox.transform(lookpt);
        vc.jn_ras2vox.transform(zero_tx);
        T3DBaseRenderEngine.snap_voxelcoord(lookpt);
        vc.jn_ras2vox.transform(xdir);
        JnVector3d.sub(xdir, zero_tx, xdir);
        vc.jn_ras2vox.transform(ydir);
        JnVector3d.sub(ydir, zero_tx, ydir);
        vc.jn_ras2vox.transform(zdir);
        JnVector3d.sub(zdir, zero_tx, zdir);
    }

    @Override
    public void setLookPoint(double[] point) {
        double diffLook = T3DBaseRenderEngine.diffvec(point, this.lookPoint);
        if (diffLook > 1.0E-10) {
            System.arraycopy(this.eyePoint, 0, this.oldEye_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.oldLook_, 0, 3);
            System.arraycopy(this.upVector, 0, this.oldUp_, 0, 3);
            System.arraycopy(this.oldEye_, 0, this.oldCamera_, 0, 3);
            System.arraycopy(this.oldLook_, 0, this.oldCamera_, 3, 3);
            System.arraycopy(this.oldUp_, 0, this.oldCamera_, 6, 3);
            System.arraycopy(point, 0, this.lookPoint, 0, 3);
            System.arraycopy(this.eyePoint, 0, this.camera_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.camera_, 3, 3);
            System.arraycopy(this.upVector, 0, this.camera_, 6, 3);
            this.calc_cam();
            this.firePropertyChange("lookPoint", this.oldLook_, this.lookPoint);
            this.firePropertyChange("camera", this.oldCamera_, this.camera_);
        }
    }

    @Override
    public double[] getLookPoint(double[] look_pt) {
        double[] arr = look_pt;
        if (arr == null) {
            arr = new double[3];
        }
        System.arraycopy(this.lookPoint, 0, arr, 0, 3);
        return arr;
    }

    @Override
    public void setEyePoint(double[] point) {
        double diffEye = T3DBaseRenderEngine.diffvec(point, this.eyePoint);
        if (diffEye > 1.0E-10) {
            System.arraycopy(this.eyePoint, 0, this.oldEye_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.oldLook_, 0, 3);
            System.arraycopy(this.upVector, 0, this.oldUp_, 0, 3);
            System.arraycopy(this.oldEye_, 0, this.oldCamera_, 0, 3);
            System.arraycopy(this.oldLook_, 0, this.oldCamera_, 3, 3);
            System.arraycopy(this.oldUp_, 0, this.oldCamera_, 6, 3);
            System.arraycopy(point, 0, this.eyePoint, 0, 3);
            System.arraycopy(this.eyePoint, 0, this.camera_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.camera_, 3, 3);
            System.arraycopy(this.upVector, 0, this.camera_, 6, 3);
            this.calc_cam();
            this.firePropertyChange("eyePoint", this.oldEye_, this.eyePoint);
            this.firePropertyChange("camera", this.oldCamera_, this.camera_);
        }
    }

    @Override
    public double[] getEyePoint(double[] eye_pt) {
        double[] arr = eye_pt;
        if (arr == null) {
            arr = new double[3];
        }
        System.arraycopy(this.eyePoint, 0, arr, 0, 3);
        return arr;
    }

    @Override
    public void setUp(double[] vec) {
        double diffUp = T3DBaseRenderEngine.diffvec(vec, this.upVector);
        if (diffUp > 1.0E-10) {
            System.arraycopy(this.eyePoint, 0, this.oldEye_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.oldLook_, 0, 3);
            System.arraycopy(this.upVector, 0, this.oldUp_, 0, 3);
            System.arraycopy(this.oldEye_, 0, this.oldCamera_, 0, 3);
            System.arraycopy(this.oldLook_, 0, this.oldCamera_, 3, 3);
            System.arraycopy(this.oldUp_, 0, this.oldCamera_, 6, 3);
            System.arraycopy(vec, 0, this.upVector, 0, 3);
            System.arraycopy(this.eyePoint, 0, this.camera_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.camera_, 3, 3);
            System.arraycopy(this.upVector, 0, this.camera_, 6, 3);
            this.calc_cam();
            this.firePropertyChange("up", this.oldUp_, this.upVector);
            this.firePropertyChange("camera", this.oldCamera_, this.camera_);
        }
    }

    @Override
    public double[] getUp(double[] up_v) {
        double[] arr = up_v;
        if (arr == null) {
            arr = new double[3];
        }
        System.arraycopy(this.upVector, 0, arr, 0, 3);
        return arr;
    }

    private static double diffvec(double[] v1, double[] v2) {
        return Math.abs(v1[0] - v2[0]) + Math.abs(v1[1] - v2[1]) + Math.abs(v1[2] - v2[2]);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        double diffEye = T3DBaseRenderEngine.diffvec(eyepoint, this.eyePoint);
        double diffLook = T3DBaseRenderEngine.diffvec(lookpoint, this.lookPoint);
        double diffUp = T3DBaseRenderEngine.diffvec(up, this.upVector);
        System.arraycopy(this.eyePoint, 0, this.oldEye_, 0, 3);
        System.arraycopy(this.lookPoint, 0, this.oldLook_, 0, 3);
        System.arraycopy(this.upVector, 0, this.oldUp_, 0, 3);
        System.arraycopy(this.oldEye_, 0, this.oldCamera_, 0, 3);
        System.arraycopy(this.oldLook_, 0, this.oldCamera_, 3, 3);
        System.arraycopy(this.oldUp_, 0, this.oldCamera_, 6, 3);
        boolean cameraChanged = false;
        if (diffEye > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(eyepoint, 0, this.eyePoint, 0, 3);
            this.firePropertyChange("eyePoint", this.oldEye_, this.eyePoint);
        }
        if (diffLook > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(lookpoint, 0, this.lookPoint, 0, 3);
            this.firePropertyChange("lookPoint", this.oldLook_, this.lookPoint);
        }
        if (diffUp > 1.0E-10) {
            cameraChanged = true;
            System.arraycopy(up, 0, this.upVector, 0, 3);
            this.firePropertyChange("up", this.oldUp_, this.upVector);
        }
        if (cameraChanged) {
            System.arraycopy(this.eyePoint, 0, this.camera_, 0, 3);
            System.arraycopy(this.lookPoint, 0, this.camera_, 3, 3);
            System.arraycopy(this.upVector, 0, this.camera_, 6, 3);
            this.calc_cam();
            this.firePropertyChange("camera", this.oldCamera_, this.camera_);
        }
    }

    @Override
    public void setViewHeight(double height) {
        if (height != this.viewHeight) {
            double old = this.viewHeight;
            this.viewHeight = height;
            this.calc_cam();
            this.firePropertyChange("viewHeight", old, this.viewHeight);
        }
    }

    @Override
    public double getViewHeight() {
        return this.viewHeight;
    }

    @Override
    public void setAspectRatio(double aspect) {
        throw new UnsupportedOperationException("setAspectRatio not supported");
    }

    @Override
    public double getAspectRatio() {
        return (double)this.getBufferWidth() / (double)this.getBufferHeight();
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        if (clipOffsets[0] != this.viewClip[0] || clipOffsets[1] != this.viewClip[1]) {
            System.arraycopy(clipOffsets, 0, this.viewClip, 0, 2);
            this.firePropertyChange("viewClip", null, this.viewClip);
        }
    }

    public double getThickness() {
        return this.viewClip[1] - this.viewClip[0];
    }

    @Override
    public double[] getViewClip(double[] view_clip) {
        double[] arr = view_clip;
        if (arr == null) {
            arr = new double[2];
        }
        System.arraycopy(this.viewClip, 0, arr, 0, 2);
        return arr;
    }

    @Override
    public void setPerspective(boolean b2) {
        boolean old = this.perspective;
        this.perspective = b2;
        this.firePropertyChange("perspective", old, this.perspective);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isPerspective() {
        return this.perspective;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    @Override
    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    @Override
    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskProgress(String taskName, int units) {
        int len = this.taskMonitors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i2);
            tm.taskProgress(taskName, units);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(l2);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(propName, l2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(l2);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(prop, l2);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    @Override
    public void addChangeListener(XjChangeListener cl) {
        this.changeListeners.add(cl);
    }

    @Override
    public void removeChangeListener(XjChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    protected final void notifyChange() {
        EventObject ce = new EventObject(this);
        for (XjChangeListener cl : this.changeListeners) {
            cl.stateChanged(ce);
        }
    }

    @Override
    public void repaint() {
        this.notifyChange();
    }

    @Override
    public boolean isAutoRepaint() {
        return false;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
    }

    @Override
    public Capable getCapable(String capableIFName) {
        try {
            Class<?> cap = this.getClass();
            Class<?> cl = Class.forName(capableIFName);
            if (cl.isAssignableFrom(cap) && cl.isInstance(this)) {
                return this;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    protected final void setT3DReady(boolean ready) {
        this.t3dReady = ready;
    }

    public final boolean isT3DReady() {
        return this.t3dReady;
    }

    @Override
    public void stateChanged(EventObject e2) {
        this.notifyChange();
    }

    @Override
    public double[] getInitialUp() {
        double[] up = new double[3];
        System.arraycopy(this.initialUp, 0, up, 0, 3);
        return up;
    }

    @Override
    public void setInitialUp(double[] initialUp) {
        System.arraycopy(initialUp, 0, this.initialUp, 0, 3);
    }

    @Override
    public double[] getInitialView() {
        double[] view = new double[3];
        System.arraycopy(this.initialView, 0, view, 0, 3);
        return view;
    }

    @Override
    public void setInitialView(double[] initialView) {
        System.arraycopy(initialView, 0, this.initialView, 0, 3);
    }

    @Override
    public void getDepthBuffer(float[] depthbuffer) {
        this.getDepthBuffer(depthbuffer, 0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    @Override
    public void getDepthBuffer(float[] depthbuffer, int x2, int y2, int width, int height) {
        throw new UnsupportedOperationException("getDepthBuffer is not supported by this render-engine implementation.");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName.equals("VOLUME_SLICE")) {
            int[] slices = (int[])evt.getNewValue();
            XjVolumeInfo xj_vol = this.getVolume();
            if (slices != null && slices.length > 0 && xj_vol != null) {
                int width = this.getBufferWidth();
                int height = this.getBufferHeight();
                int minslice = slices[0];
                int maxslice = slices[slices.length - 1];
                int[] dims = xj_vol.getVolumeDimensions(null);
                double[] v0 = new double[]{0.0, 0.0, minslice, 1.0};
                double[] v1 = new double[]{dims[0], dims[1], maxslice, 1.0};
                double[] d0 = new double[4];
                double[] d1 = new double[4];
                this.transform(v0, 1000, d0, 1002);
                this.transform(v1, 1000, d1, 1002);
                double p0_x = Math.min(d0[0], d1[0]);
                double p0_y = Math.min(d0[1], d1[1]);
                double p1_x = Math.max(d0[0], d1[0]);
                double p1_y = Math.max(d0[1], d1[1]);
                this.dirtyRegion.x = (int)Math.floor(p0_x);
                this.dirtyRegion.y = (int)Math.floor(p0_y);
                int w2 = (int)Math.ceil(p1_x - p0_x + 4.0);
                int h2 = (int)Math.ceil(p1_y - p0_y + 4.0);
                int x1 = Math.min(this.dirtyRegion.x + w2, width);
                int y1 = Math.min(this.dirtyRegion.y + h2, height);
                this.dirtyRegion.width = x1 - this.dirtyRegion.x;
                this.dirtyRegion.height = y1 - this.dirtyRegion.y;
                this.firePropertyChange("OUTPUTBUFFER_PROPERTY", null, this.dirtyRegion);
            }
        }
    }

    protected JnRectangle getDirtyRegion() {
        return this.dirtyRegion;
    }

    @Override
    public void taskBegin(String taskName, int totalWork) {
    }

    @Override
    public void taskDone(String taskName) {
    }

    @Override
    public void taskProgress(String taskName, int units) {
    }

    @Override
    public void taskFailed(String taskName, String reason, Exception e2) {
    }

    protected static InputStream mpassInputStream(String propName) {
        StringTokenizer st = new StringTokenizer(propName, ",");
        String resourceType = st.nextToken();
        String resourceName = st.nextToken();
        InputStream policyStream = null;
        System.err.println("T3DBaseRenderEngine: Loading multipass policy=[" + resourceType + "," + resourceName + "]");
        if (resourceType.equalsIgnoreCase("profile")) {
            if (resourceName.equalsIgnoreCase("local")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("local_mpass.xml");
            } else if (resourceName.equalsIgnoreCase("localfaster")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("local_mpass.xml");
            } else if (resourceName.equalsIgnoreCase("remotefast")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("remotefast_mpass.xml");
            } else if (resourceName.equalsIgnoreCase("remoteslow")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("remoteslow_mpass.xml");
            }
        } else if (resourceType.equalsIgnoreCase("file")) {
            try {
                policyStream = new FileInputStream(resourceName);
            }
            catch (FileNotFoundException e2) {
                // empty catch block
            }
        }
        return policyStream;
    }

    protected static class VolumeContext {
        public XjVolumeInfo volume = null;
        public XjVolumeModel vol_model = null;
        public double[] vox_zdir = new double[3];
        public double[] vox_ydir = new double[3];
        public double[] vox_xdir = new double[3];
        public double[] vox_lookpt = new double[3];
        public double[] vox_clipoffsets = new double[2];
        public double nsteps = 0.0;
        public CTransform jn_vox2ras = new CTransform();
        public CTransform jn_ras2vox = new CTransform();
        public CTransform jn_disp2ras = new CTransform();
        public CTransform jn_ras2disp = new CTransform();
        private Map data = new HashMap();

        protected VolumeContext() {
        }

        public void clear() {
            this.data.clear();
        }

        public Object getData(String key) {
            return this.data.get(key);
        }

        public void setData(String key, Object value) {
            this.data.put(key, value);
        }
    }
}

