/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DStateCapable;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class T3DSerializer
implements T3DStateCapable {
    public static final String T3DSTATE_PROPERTY = "t3dstate";
    private T3DViewport vp_;
    double[] eye_ = new double[3];
    double[] look_ = new double[3];
    double[] up_ = new double[3];
    double[] viewClip_ = new double[2];
    boolean perspective_ = false;
    double viewHeight_ = 1.0;
    double aspectRatio_ = 1.0;
    String renderStyle_;
    Preset preset_ = new Preset();

    public T3DSerializer(T3DViewport viewport) {
        this.vp_ = viewport;
    }

    @Override
    public InputStream getT3DState() {
        return new ByteArrayInputStream(this.getStateString().getBytes());
    }

    String getStateString() {
        Preset pre;
        StringBuffer buf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        buf.append("<T3DState name = \"SampleT3DState\" date = \"Wed May 17 10:25:34 CDT 2006\">\n");
        buf.append("<T3DCapable perspective=\"" + this.vp_.isPerspective() + "\" viewHeight=\"" + this.vp_.getViewHeight() + "\" aspectRatio=\"" + this.vp_.getAspectRatio() + "\">\n");
        buf.append("<camera>\n");
        double[] look = this.vp_.getLookPoint(null);
        double[] eye = this.vp_.getEyePoint(null);
        double[] up = this.vp_.getUp(null);
        buf.append("<look x=\"" + look[0] + "\" y = \"" + look[1] + "\" z= \"" + look[2] + "\"/>\n");
        buf.append("<eye x=\"" + eye[0] + "\" y = \"" + eye[1] + "\" z= \"" + eye[2] + "\"/>\n");
        buf.append("<up x=\"" + up[0] + "\" y = \"" + up[1] + "\" z= \"" + up[2] + "\"/>\n");
        buf.append("</camera>\n");
        double[] vc = this.vp_.getViewClip(null);
        buf.append("<viewClip front=\"" + vc[0] + "\" back = \"" + vc[1] + "\"/>\n");
        buf.append("</T3DCapable>\n");
        buf.append("<T3DRenderStyleCapable value = \"" + this.vp_.getRenderStyle() + "\">\n");
        if ("VOLUME".equals(this.vp_.getRenderStyle()) && (pre = (Preset)this.vp_.getClientProperty("CNO_PROPERTY")) != null) {
            buf.append(pre.getXMLelement());
        }
        buf.append("</T3DRenderStyleCapable>\n");
        buf.append("</T3DState>\n");
        return buf.toString();
    }

    @Override
    public void setT3DState(InputStream t3dStateStream) {
        if (this.vp_ != null) {
            this.load(t3dStateStream);
            this.vp_.setCamera(this.eye_, this.look_, this.up_);
            this.vp_.setViewClip(this.viewClip_);
            this.vp_.setViewHeight(this.viewHeight_);
            this.vp_.setPerspective(this.perspective_);
            this.vp_.refreshContents();
        }
    }

    void load(InputStream t3dStateStream) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(t3dStateStream);
            doc.getDocumentElement().normalize();
            NodeList t3dcapablel = doc.getElementsByTagName("T3DCapable");
            Element t3dcapable = (Element)t3dcapablel.item(0);
            this.perspective_ = Boolean.valueOf(t3dcapable.getAttribute("perspective"));
            this.viewHeight_ = Double.parseDouble(t3dcapable.getAttribute("viewHeight"));
            this.aspectRatio_ = Double.parseDouble(t3dcapable.getAttribute("aspectRatio"));
            NodeList cameral = t3dcapable.getElementsByTagName("camera");
            Node camera = cameral.item(0);
            if (camera.getNodeType() == 1) {
                Element cameraElement = (Element)camera;
                NodeList eyel = cameraElement.getElementsByTagName("eye");
                Node eye = eyel.item(0);
                Element eyeElement = (Element)eye;
                this.fillVec(eyeElement, this.eye_);
                NodeList lookl = cameraElement.getElementsByTagName("look");
                Node look = lookl.item(0);
                Element lookElement = (Element)look;
                this.fillVec(lookElement, this.look_);
                NodeList upl = cameraElement.getElementsByTagName("up");
                Node up = upl.item(0);
                Element upElement = (Element)up;
                this.fillVec(upElement, this.up_);
            }
            NodeList viewclipl = t3dcapable.getElementsByTagName("viewClip");
            Element viewclipE = (Element)viewclipl.item(0);
            this.viewClip_[0] = Double.parseDouble(viewclipE.getAttribute("front"));
            this.viewClip_[1] = Double.parseDouble(viewclipE.getAttribute("back"));
            Element t3dRenderStyle = (Element)doc.getElementsByTagName("T3DRenderStyleCapable").item(0);
            this.renderStyle_ = t3dRenderStyle.getAttribute("value");
            if (this.vp_ != null) {
                this.vp_.setRenderStyle(this.renderStyle_);
            }
            if ("VOLUME".equals(this.renderStyle_) && this.vp_ != null) {
                Element item = (Element)t3dRenderStyle.getElementsByTagName("VRPresets").item(0);
                if (item != null) {
                    this.preset_.load(item);
                }
                double deltax = this.preset_.getDelta();
                double startx = this.preset_.getStartX();
                System.out.println("deltax=" + deltax);
                System.out.println("startx=" + startx);
                double[] opacity = this.preset_.fillOpacity();
                double[] clut = this.preset_.fillRGB();
                if (this.vp_ != null) {
                    VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
                    VrPreset p2 = new VrPreset("CT", vrcl, opacity, startx, deltax);
                    this.vp_.getT3DComponent().setProperty("PRESET_PROPERTY", p2);
                    this.vp_.getT3DComponent().setProperty("CNO_PROPERTY", this.preset_);
                }
            }
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
    }

    private void fillVec(Element vecElement, double[] vec) {
        vec[0] = Double.parseDouble(vecElement.getAttribute("x"));
        vec[1] = Double.parseDouble(vecElement.getAttribute("y"));
        vec[2] = Double.parseDouble(vecElement.getAttribute("z"));
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        JPanel p2 = new JPanel(new BorderLayout());
        final T3DViewport vp = new T3DViewport();
        vp.setPreferredSize(new Dimension(512, 512));
        p2.add(vp);
        JPanel ctrl = new JPanel();
        JButton saveB = new JButton("save");
        JButton loadB = new JButton("Load");
        ctrl.add(saveB);
        ctrl.add(loadB);
        p2.add((Component)ctrl, "South");
        f2.setContentPane(p2);
        f2.pack();
        f2.setVisible(true);
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                InputStream is = vp.getT3DState();
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream("temp.xml");
                    byte[] buf = new byte[1024];
                    int n2 = 0;
                    while ((n2 = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, n2);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        loadB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    FileInputStream is = new FileInputStream("temp.xml");
                    vp.setT3DState(is);
                    ((InputStream)is).close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        DMSession dms = new DMSession("file", args[0], null);
        DMVolume volume = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        vp.setVolume(volume);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Preset preset = new Preset();
        double deltax = preset.getDelta();
        double startx = preset.getStartX();
        System.out.println("deltax=" + deltax);
        System.out.println("startx=" + startx);
        double[] opacity = preset.fillOpacity();
        double[] clut = preset.fillRGB();
        VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
        VrPreset pp = new VrPreset("CT", vrcl, opacity, startx, deltax);
        vp.getT3DComponent().setProperty("PRESET_PROPERTY", pp);
        vp.getT3DComponent().setProperty("CNO_PROPERTY", preset);
    }
}

