/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.WindowLevelCapable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class WLPresetAction
extends AbstractAction {
    private JPopupMenu menu_ = null;
    private DefaultListModel presetList = new DefaultListModel();
    private WindowLevelCapable[] capables_;
    public static final WindowLevelPreset ABDOMEN1_PRESET = new WindowLevelPreset(400, 40, "Abdomen1");
    public static final WindowLevelPreset ABDOMEN2_PRESET = new WindowLevelPreset(600, 90, "Abdomen2");
    public static final WindowLevelPreset COW_PRESET = new WindowLevelPreset(450, 150, "COW");
    public static final WindowLevelPreset HEAD_PRESET = new WindowLevelPreset(150, 45, "Head");
    public static final WindowLevelPreset LIVER_PRESET = new WindowLevelPreset(150, 90, "Liver");
    public static final WindowLevelPreset LUNG_PRESET = new WindowLevelPreset(1500, -600, "Lung");
    public static final WindowLevelPreset MEDIASTINUM_PRESET = new WindowLevelPreset(350, 40, "Mediastinum");
    public static final WindowLevelPreset MIP_ABD_PRESET = new WindowLevelPreset(800, 70, "Mip Abdomen");
    public static final WindowLevelPreset PE_MIP_PRESET = new WindowLevelPreset(670, 70, "PE MIP");
    public static final WindowLevelPreset SPINE_ST_PRESET = new WindowLevelPreset(300, 35, "Spine ST");
    public static final WindowLevelPreset SPINE_BONE_PRESET = new WindowLevelPreset(2000, 350, "Spine Bone");
    public static final WindowLevelPreset PET1_PRESET = new WindowLevelPreset(0, 50, "PET1");
    public static final WindowLevelPreset PET2_PRESET = new WindowLevelPreset(0, 60, "PET2");
    public static final WindowLevelPreset PET3_PRESET = new WindowLevelPreset(0, 70, "PET3");
    public static final WindowLevelPreset MR_PRESET1 = new WindowLevelPreset(40, 20, "Preset 1");
    public static final WindowLevelPreset MR_PRESET2 = new WindowLevelPreset(100, 50, "Preset 2");
    public static final WindowLevelPreset MR_PRESET3 = new WindowLevelPreset(200, 100, "Preset 3");
    public static final WindowLevelPreset MR_PRESET4 = new WindowLevelPreset(1000, 500, "Preset 4");
    public static final WindowLevelPreset MR_PRESET5 = new WindowLevelPreset(2000, 1000, "Preset 5");
    public static final WindowLevelPreset MR_PRESET6 = new WindowLevelPreset(4000, 2000, "Preset 6");
    public static final WindowLevelPreset[] CT_PRESETS = new WindowLevelPreset[]{ABDOMEN1_PRESET, ABDOMEN2_PRESET, COW_PRESET, HEAD_PRESET, LIVER_PRESET, LUNG_PRESET, MEDIASTINUM_PRESET, MIP_ABD_PRESET, PE_MIP_PRESET, SPINE_ST_PRESET, SPINE_BONE_PRESET};
    public static final WindowLevelPreset[] PET_PRESETS = new WindowLevelPreset[]{PET1_PRESET, PET2_PRESET, PET3_PRESET};
    public static final WindowLevelPreset[] MR_PRESETS = new WindowLevelPreset[]{MR_PRESET1, MR_PRESET2, MR_PRESET3, MR_PRESET4, MR_PRESET5, MR_PRESET6};

    public WLPresetAction(WindowLevelCapable[] capables) {
        super("Set...");
        this.capables_ = capables;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
    }

    public JPopupMenu getPopupMenu() {
        System.out.print("TEST -- creating w/l presets menu ");
        if (this.menu_ == null) {
            int i2;
            this.menu_ = new JPopupMenu();
            if (this.presetList.isEmpty()) {
                for (i2 = 0; i2 < CT_PRESETS.length; ++i2) {
                    this.presetList.addElement(new WindowLevelSetAction(CT_PRESETS[i2]));
                }
            }
            for (i2 = 0; i2 < this.presetList.size(); ++i2) {
                Action wlAction = (Action)this.presetList.elementAt(i2);
                this.menu_.add(new JMenuItem(wlAction));
            }
        }
        return this.menu_;
    }

    private class WindowLevelSetAction
    extends AbstractAction {
        private WindowLevelPreset preset_;

        public WindowLevelSetAction(WindowLevelPreset preset) {
            super(preset.name);
            this.preset_ = preset;
            this.putValue("ShortDescription", "[w=" + this.preset_.window + ", l=" + this.preset_.level + "]");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (WLPresetAction.this.capables_ != null && WLPresetAction.this.capables_.length > 0) {
                for (int i2 = 0; i2 < WLPresetAction.this.capables_.length; ++i2) {
                    WLPresetAction.this.capables_[i2].setWinMinMax(this.preset_.level - this.preset_.window / 2, this.preset_.level + this.preset_.window / 2);
                }
            }
        }

        public String toString() {
            return this.preset_.name;
        }

        public int getWidth() {
            return this.preset_.window;
        }

        public void setNewValues(int newWidth, int newLevel) {
            this.preset_.window = newWidth;
            this.preset_.level = newLevel;
            this.putValue("ShortDescription", "[w=" + this.preset_.window + ", l=" + this.preset_.level + "]");
        }

        public int getLevel() {
            return this.preset_.level;
        }
    }

    private static class WindowLevelPreset {
        public int window;
        public int level;
        public String name;

        public WindowLevelPreset(int w2, int l2, String name) {
            this.window = w2;
            this.level = l2;
            this.name = name;
        }

        public WindowLevelPreset(int w2, int l2) {
            this(w2, l2, "w: " + w2 + ", l: " + l2);
        }

        public String toString() {
            return this.name;
        }

        public void setWindow(int newWindow) {
            this.window = newWindow;
        }

        public void setLevel(int newLevel) {
            this.level = newLevel;
        }
    }
}

