/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.RayBox;
import com.ge.med.terra.jami.j3d.Commons3D;

public abstract class VoxelSampler {
    public static final int INTERPOLATION_NN = 0;
    public static final int INTERPOLATION_LINEAR = 1;
    public static final int INTERPOLATION_CUBIC = 2;
    protected static final int SHIFT = 15;
    protected static final int SCALE = 32768;
    protected static final int FRAC_MASK = Short.MAX_VALUE;
    protected static final double ARITH_ROUND_CONST = 1.0E-6;
    private JnVector3d minb = new JnVector3d();
    private JnVector3d maxb = new JnVector3d();
    private JnVector3d delta_x = new JnVector3d();
    private JnVector3d delta_y = new JnVector3d();
    private JnVector3d rowPt = new JnVector3d();
    private RayBox rb = new RayBox();
    private int[][] tidx = null;
    private int ystart = 0;
    private int yend = 0;
    private int width = 0;
    private int height = 0;
    private double[] xstep = new double[3];
    private double[] ystep = new double[3];
    private double[] zstep = new double[3];
    private double[] lookpt = new double[3];
    private double nsteps = 0.0;
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private boolean majorAxisView = false;
    private int nocontentPixel = 0;
    private int scooch = -1;
    private int interpolation = 1;

    public VoxelSampler() {
    }

    public VoxelSampler(int scooch) {
        this.scooch = scooch;
    }

    public void setView(double[] lookpt, double[] xstep, double[] ystep, double[] zstep, double nsteps, int w2, int h2, int dx, int dy, int dz, int interpolation, int nocontentPix) {
        int xy_scooch;
        System.arraycopy(lookpt, 0, this.lookpt, 0, 3);
        System.arraycopy(xstep, 0, this.xstep, 0, 3);
        System.arraycopy(ystep, 0, this.ystep, 0, 3);
        System.arraycopy(zstep, 0, this.zstep, 0, 3);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.width = w2;
        this.height = h2;
        this.nsteps = nsteps;
        this.nocontentPixel = nocontentPix;
        this.interpolation = interpolation;
        this.majorAxisView = Commons3D.isMajorAxis(xstep, ystep, zstep);
        int n2 = xy_scooch = this.majorAxisView ? 1 : 2;
        if (this.scooch > 0) {
            this.minb.set(this.scooch, this.scooch, this.scooch);
            this.maxb.set(dx - this.scooch, dy - this.scooch, dz - this.scooch);
        } else {
            this.minb.set(0.0, 0.0, 0.0);
            this.maxb.set(dx - xy_scooch, dy - xy_scooch, (double)dz - 0.5);
        }
        double startX = VoxelSampler.getViewStartCoord(0, w2, h2, lookpt, xstep, ystep, dx);
        double startY = VoxelSampler.getViewStartCoord(1, w2, h2, lookpt, xstep, ystep, dy);
        double startZ = VoxelSampler.getViewStartCoord(2, w2, h2, lookpt, xstep, ystep, dz);
        this.rowPt.set(startX, startY, startZ);
        this.delta_x.set(xstep);
        this.delta_y.set(ystep);
        if (this.tidx == null || this.tidx.length != h2) {
            this.tidx = new int[h2][2];
        }
        boolean first = true;
        for (int i2 = 0; i2 < h2; ++i2) {
            boolean hit = this.rb.hitScanLine(this.minb, this.maxb, this.rowPt, this.delta_x, w2, this.tidx[i2]);
            if (hit && first && this.tidx[i2][0] < this.tidx[i2][1]) {
                this.ystart = i2;
                first = false;
            }
            if (hit && this.tidx[i2][0] < this.tidx[i2][1]) {
                this.yend = i2;
            }
            this.rowPt.add(this.delta_y);
        }
    }

    protected static final double getViewStartCoord(int coord, int w2, int h2, double[] lookpt, double[] xstep, double[] ystep, int dim) {
        double startCoord = lookpt[coord] - (double)(w2 - 1) * 0.5 * xstep[coord] - (double)(h2 - 1) * 0.5 * ystep[coord];
        startCoord = VoxelSampler.nudgeStartCoord(dim, startCoord);
        return startCoord;
    }

    protected static final double nudgeStartCoord(int dim, double value) {
        double diffBelow = Math.abs(value);
        double diffAbove = Math.abs(value - (double)(dim - 1));
        if (value < 0.0 && diffBelow <= 1.0E-6) {
            return value + 1.0E-6;
        }
        if (value > (double)(dim - 1) && diffAbove <= 1.0E-6) {
            return value - 1.0E-6;
        }
        return value;
    }

    protected final int getYStart() {
        return this.ystart;
    }

    protected final int getYEnd() {
        return this.yend;
    }

    protected final int[][] getViewPlaneIntersectBounds() {
        return this.tidx;
    }

    protected final int getInterpolation() {
        return this.interpolation;
    }

    public double getNumSteps() {
        return this.nsteps;
    }

    public int getVolDimX() {
        return this.dx;
    }

    public int getVolDimY() {
        return this.dy;
    }

    public int getVolDimZ() {
        return this.dz;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNoContentPixel() {
        return this.nocontentPixel;
    }

    public boolean isMajorAxisView() {
        return this.majorAxisView;
    }

    public double[] getXStep() {
        return this.xstep;
    }

    public double[] getYStep() {
        return this.ystep;
    }

    public double[] getZStep() {
        return this.zstep;
    }

    public double[] getLookPt() {
        return this.lookpt;
    }
}

