/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.j3d.mprender.IRenderer;
import com.ge.med.terra.jami.j3d.mprender.IterativeRenderEngine;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public class ImmediateIRE
implements IterativeRenderEngine {
    public static final int NOT = Integer.parseInt(System.getProperty("not", Runtime.getRuntime().availableProcessors() + ""));
    private RenderWorker[] rworkers = null;
    private ParallelTaskManager ptm = new ParallelTaskManager();
    private Object[] thread_data = new Object[NOT];
    private Component c = null;
    private IRenderer renderer = null;
    private boolean paintIt = true;
    private BufferedImage scr = null;
    private int[] scrbuff = null;
    private BufferedImage scr_back = null;
    private int[] scrbuff_back = null;

    public ImmediateIRE() {
        this.rworkers = new RenderWorker[NOT];
        for (int i2 = 0; i2 < NOT; ++i2) {
            this.rworkers[i2] = new RenderWorker(this.ptm, i2);
        }
        this.ptm.setWorkers(this.rworkers);
    }

    @Override
    public BufferedImage getDisplayBuffer() {
        return this.scr_back;
    }

    @Override
    public int getRenderMode() {
        return 0;
    }

    @Override
    public void imageChange(String renderStyle, byte[] ray_mask) {
        this.paintIt = true;
        if (this.c != null) {
            this.c.repaint();
        }
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isRendered(int x2, int y2) {
        return true;
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.c != null && this.renderer != null && this.paintIt) {
            if (this.scr == null || this.scr.getWidth() != this.c.getWidth() || this.scr.getHeight() != this.c.getHeight()) {
                this.scr = new BufferedImage(this.c.getWidth(), this.c.getHeight(), 1);
                this.scrbuff = ((DataBufferInt)this.scr.getRaster().getDataBuffer()).getData();
                this.scr_back = new BufferedImage(this.c.getWidth(), this.c.getHeight(), 1);
                this.scrbuff_back = ((DataBufferInt)this.scr_back.getRaster().getDataBuffer()).getData();
                this.renderer.setDisplayBuffer(this.scrbuff, this.scr.getWidth(), this.scr.getHeight());
            }
            Arrays.fill(this.scrbuff, 0);
            this.renderer.updateWorld();
            this.ptm.launch(new Object());
            System.arraycopy(this.scrbuff, 0, this.scrbuff_back, 0, this.scrbuff.length);
            this.paintIt = false;
        }
        g22.drawRenderedImage(this.scr_back, null);
    }

    @Override
    public void setComponent(Component c2) {
        this.c = c2;
    }

    @Override
    public void setRenderMode(int renderMode) {
    }

    @Override
    public void setRenderable(IRenderer r2) {
        this.renderer = r2;
        for (int i2 = 0; i2 < NOT; ++i2) {
            this.thread_data[i2] = r2.createThreadData();
        }
    }

    @Override
    public void shutdown() {
    }

    private class RenderWorker
    extends Worker {
        public RenderWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            Rectangle r2 = new Rectangle(0, workerId, ImmediateIRE.this.c.getWidth(), ImmediateIRE.this.c.getHeight());
            ImmediateIRE.this.renderer.castRays(r2, 1, 2, 0, 1, ImmediateIRE.this.thread_data[workerId]);
        }
    }
}

