/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

public class MPFillerStrategy {
    public static void fill1x2(int k2, int nworkers, int[] scrbuff, int w2, int h2) {
        int IROW = 2;
        for (int y2 = 0; y2 < h2 - 2; y2 += 2) {
            int yoffset = y2 * w2;
            for (int x2 = k2; x2 < w2; x2 += nworkers) {
                int i2 = x2 + yoffset;
                int v00 = scrbuff[i2] >> 1 & 0x7F7F7F;
                int v20 = scrbuff[i2 + 2 * w2] >> 1 & 0x7F7F7F;
                scrbuff[i2 + w2] = v00 + v20;
            }
        }
    }

    public static void fill1x2s(int k2, int nworkers, short[] scrbuff, int w2, int h2) {
        int IROW = 2;
        for (int y2 = 0; y2 < h2 - 2; y2 += 2) {
            int yoffset = y2 * w2;
            for (int x2 = k2; x2 < w2; x2 += nworkers) {
                int i2 = x2 + yoffset;
                short v00 = scrbuff[i2];
                short v20 = scrbuff[i2 + 2 * w2];
                scrbuff[i2 + w2] = (short)(v00 + v20 >> 1);
            }
        }
    }

    public static void fill2x2(int k2, int nworkers, int[] scrbuff, int w2, int h2) {
        int lastX = w2 - 2;
        for (int y2 = 0; y2 < h2 - 2; y2 += 2) {
            for (int x2 = k2 * 2; x2 < w2 - 2; x2 += 2 * nworkers) {
                int v21;
                int v01;
                int i2 = x2 + y2 * w2;
                int v00 = scrbuff[i2] >> 1 & 0x7F7F7F;
                int v02 = scrbuff[i2 + 2] >> 1 & 0x7F7F7F;
                scrbuff[i2 + 1] = v01 = v00 + v02;
                int v20 = scrbuff[i2 + 2 * w2] >> 1 & 0x7F7F7F;
                scrbuff[i2 + w2] = v00 + v20;
                int v22 = scrbuff[i2 + 2 * w2 + 2] >> 1 & 0x7F7F7F;
                scrbuff[i2 + w2 * 2 + 1] = v21 = v20 + v22;
                scrbuff[i2 + w2 + 2] = v02 + v22;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                scrbuff[i2 + w2 + 1] = v01 + v21;
                lastX = x2;
            }
        }
        int x3 = lastX + 2 * nworkers;
        boolean pixelEdge = false;
        if (x3 < w2) {
            for (int y3 = 0; y3 < h2 - 2; y3 += 2) {
                int i3 = x3 + y3 * w2;
                int v00 = scrbuff[i3] >> 1 & 0x7F7F7F;
                boolean v02 = false;
                int v01 = v00 + 0;
                int v20 = scrbuff[i3 + 2 * w2] >> 1 & 0x7F7F7F;
                scrbuff[i3 + w2] = v00 + v20;
                boolean v22 = false;
                int v21 = v20 + 0;
                if (x3 < w2 - 1) {
                    scrbuff[i3 + 1] = v01;
                    scrbuff[i3 + w2 * 2 + 1] = v21;
                    v01 = v01 >> 1 & 0x7F7F7F;
                    v21 = v21 >> 1 & 0x7F7F7F;
                    scrbuff[i3 + w2 + 1] = v01 + v21;
                }
                if (x3 >= w2 - 2) continue;
                scrbuff[i3 + w2 + 2] = 0;
            }
        }
    }

    public static void fill2x2s(int k2, int nworkers, short[] scrbuff, int w2, int h2) {
        int lastX = w2 - 2;
        for (int y2 = 0; y2 < h2 - 2; y2 += 2) {
            for (int x2 = k2 * 2; x2 < w2 - 2; x2 += 2 * nworkers) {
                int i2 = x2 + y2 * w2;
                short v00 = scrbuff[i2];
                short v02 = scrbuff[i2 + 2];
                int v01 = v00 + v02 >> 1;
                scrbuff[i2 + 1] = (short)v01;
                short v20 = scrbuff[i2 + 2 * w2];
                scrbuff[i2 + w2] = (short)(v00 + v20 >> 1);
                short v22 = scrbuff[i2 + 2 * w2 + 2];
                int v21 = v20 + v22 >> 1;
                scrbuff[i2 + w2 * 2 + 1] = (short)v21;
                scrbuff[i2 + w2 + 2] = (short)(v02 + v22 >> 1);
                scrbuff[i2 + w2 + 1] = (short)(v01 + v21 >> 1);
                lastX = x2;
            }
        }
        int x3 = lastX + 2 * nworkers;
        boolean pixelEdge = false;
        if (x3 < w2) {
            for (int y3 = 0; y3 < h2 - 2; y3 += 2) {
                int i3 = x3 + y3 * w2;
                short v00 = scrbuff[i3];
                boolean v02 = false;
                int v01 = v00 + 0 >> 1;
                short v20 = scrbuff[i3 + 2 * w2];
                scrbuff[i3 + w2] = (short)(v00 + v20 >> 1);
                boolean v22 = false;
                int v21 = v20 + 0 >> 1;
                if (x3 < w2 - 1) {
                    scrbuff[i3 + 1] = (short)v01;
                    scrbuff[i3 + w2 * 2 + 1] = (short)v21;
                    scrbuff[i3 + w2 + 1] = (short)(v01 + v21 >> 1);
                }
                if (x3 >= w2 - 2) continue;
                scrbuff[i3 + w2 + 2] = 0;
            }
        }
    }

    public static void fill4x2(int k2, int nworkers, int[] buff, int w2, int h2) {
        int BASERESX = 4;
        int BASERESY = 2;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 2; y2 += 2) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                int p0 = buff[y0offset + x2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x2 + 4] >> 1 & 0x7F7F7F;
                int n2 = p0 + p1;
                buff[y0offset + x2 + 2] = n2;
                int p01 = n2;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y2offset + x2] >> 1 & 0x7F7F7F;
                int p3 = buff[y2offset + x2 + 4] >> 1 & 0x7F7F7F;
                int n3 = p0 + p2;
                buff[y1offset + x2] = n3;
                int p02 = n3;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                buff[y0offset + x2 + 1] = p0 + p01;
                buff[y0offset + x2 + 3] = p1 + p01;
                int n4 = p01 + p23;
                buff[y1offset + x2 + 2] = n4;
                int c2 = n4;
                c2 = c2 >> 1 & 0x7F7F7F;
                buff[y1offset + x2 + 1] = p02 + c2;
                buff[y1offset + x2 + 3] = p13 + c2;
            }
        }
    }

    public static void fill4x2s(int k2, int nworkers, short[] buff, int w2, int h2) {
        int BASERESX = 4;
        int BASERESY = 2;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 2; y2 += 2) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                short p0 = buff[y0offset + x2];
                short p1 = buff[y0offset + x2 + 4];
                short s2 = (short)(p0 + p1 >> 1);
                buff[y0offset + x2 + 2] = s2;
                short p01 = s2;
                short p2 = buff[y2offset + x2];
                short p3 = buff[y2offset + x2 + 4];
                short s3 = (short)(p0 + p2 >> 1);
                buff[y1offset + x2] = s3;
                short p02 = s3;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                buff[y0offset + x2 + 1] = (short)(p0 + p01 >> 1);
                buff[y0offset + x2 + 3] = (short)(p1 + p01 >> 1);
                short s4 = (short)(p01 + p23 >> 1);
                buff[y1offset + x2 + 2] = s4;
                short c2 = s4;
                buff[y1offset + x2 + 1] = (short)(p02 + c2 >> 1);
                buff[y1offset + x2 + 3] = (short)(p13 + c2 >> 1);
            }
        }
    }

    public static void fill4x4_0(int k2, int nworkers, int[] buff, int w2, int h2) {
        int BASERES = 4;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                int p0 = buff[y0offset + x2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x2 + 4] >> 1 & 0x7F7F7F;
                int n2 = p0 + p1;
                buff[y0offset + x2 + 2] = n2;
                int p01 = n2;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x2] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x2 + 4] >> 1 & 0x7F7F7F;
                int n3 = p0 + p2;
                buff[y2offset + x2] = n3;
                int p02 = n3;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                int n4 = p0 + p01;
                buff[y0offset + x2 + 1] = n4;
                int a2 = n4;
                int n5 = p1 + p01;
                buff[y0offset + x2 + 3] = n5;
                int b2 = n5;
                int n6 = p23 + p01;
                buff[y2offset + x2 + 2] = n6;
                int pmid = n6;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n7 = p02 + pmid;
                buff[y2offset + x2 + 1] = n7;
                int c2 = n7;
                int n8 = p13 + pmid;
                buff[y2offset + x2 + 3] = n8;
                int d2 = n8;
                a2 = a2 >> 1 & 0x7F7F7F;
                b2 = b2 >> 1 & 0x7F7F7F;
                c2 = c2 >> 1 & 0x7F7F7F;
                d2 = d2 >> 1 & 0x7F7F7F;
                int pa = p2 + p23 >> 1 & 0x7F7F7F;
                int pb = p3 + p23 >> 1 & 0x7F7F7F;
                buff[y1offset + x2] = p0 + p02;
                buff[y1offset + x2 + 1] = a2 + c2;
                buff[y1offset + x2 + 2] = p01 + pmid;
                buff[y1offset + x2 + 3] = b2 + d2;
                buff[y3offset + x2] = p2 + p02;
                buff[y3offset + x2 + 1] = pa + c2;
                buff[y3offset + x2 + 2] = p23 + pmid;
                buff[y3offset + x2 + 3] = pb + d2;
            }
        }
    }

    public static void fill4x4_0s(int k2, int nworkers, short[] buff, int w2, int h2) {
        int BASERES = 4;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                short p0 = buff[y0offset + x2];
                short p1 = buff[y0offset + x2 + 4];
                short s2 = (short)(p0 + p1 >> 1);
                buff[y0offset + x2 + 2] = s2;
                short p01 = s2;
                short p2 = buff[y4offset + x2];
                short p3 = buff[y4offset + x2 + 4];
                short s3 = (short)(p0 + p2 >> 1);
                buff[y2offset + x2] = s3;
                short p02 = s3;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                short s4 = (short)(p0 + p01 >> 1);
                buff[y0offset + x2 + 1] = s4;
                short a2 = s4;
                short s5 = (short)(p1 + p01 >> 1);
                buff[y0offset + x2 + 3] = s5;
                short b2 = s5;
                short s6 = (short)(p23 + p01 >> 1);
                buff[y2offset + x2 + 2] = s6;
                short pmid = s6;
                short s7 = (short)(p02 + pmid >> 1);
                buff[y2offset + x2 + 1] = s7;
                short c2 = s7;
                short s8 = (short)(p13 + pmid >> 1);
                buff[y2offset + x2 + 3] = s8;
                short d2 = s8;
                int pa = p2 + p23 >> 1;
                int pb = p3 + p23 >> 1;
                buff[y1offset + x2] = (short)(p0 + p02 >> 1);
                buff[y1offset + x2 + 1] = (short)(a2 + c2 >> 1);
                buff[y1offset + x2 + 2] = (short)(p01 + pmid >> 1);
                buff[y1offset + x2 + 3] = (short)(b2 + d2 >> 1);
                buff[y3offset + x2] = (short)(p2 + p02 >> 1);
                buff[y3offset + x2 + 1] = (short)(pa + c2 >> 1);
                buff[y3offset + x2 + 2] = (short)(p23 + pmid >> 1);
                buff[y3offset + x2 + 3] = (short)(pb + d2 >> 1);
            }
        }
    }

    public static void fill4x4_1(int k2, int nworkers, int[] buff, int w2, int h2) {
        int BASERES = 4;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                int p0 = buff[y0offset + x2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x2 + 4] >> 1 & 0x7F7F7F;
                int p02 = buff[y2offset + x2] >> 1 & 0x7F7F7F;
                int p13 = buff[y2offset + x2 + 4] >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x2] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x2 + 4] >> 1 & 0x7F7F7F;
                int n2 = p0 + p1;
                buff[y0offset + x2 + 2] = n2;
                int p01 = n2;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                p01 = p01 >> 1 & 0x7F7F7F;
                int n3 = p02 + p13;
                buff[y2offset + x2 + 2] = n3;
                int pmid = n3;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n4 = p0 + p01;
                buff[y0offset + x2 + 1] = n4;
                int a2 = n4;
                int n5 = p1 + p01;
                buff[y0offset + x2 + 3] = n5;
                int b2 = n5;
                int n6 = p02 + pmid;
                buff[y2offset + x2 + 1] = n6;
                int c2 = n6;
                int n7 = p13 + pmid;
                buff[y2offset + x2 + 3] = n7;
                int d2 = n7;
                a2 = a2 >> 1 & 0x7F7F7F;
                b2 = b2 >> 1 & 0x7F7F7F;
                c2 = c2 >> 1 & 0x7F7F7F;
                d2 = d2 >> 1 & 0x7F7F7F;
                buff[y1offset + x2] = p0 + p02;
                buff[y1offset + x2 + 1] = a2 + c2;
                buff[y1offset + x2 + 2] = p01 + pmid;
                buff[y1offset + x2 + 3] = b2 + d2;
                buff[y3offset + x2] = p2 + p02;
                buff[y3offset + x2 + 1] = p2 + c2;
                buff[y3offset + x2 + 2] = p23 + pmid;
                buff[y3offset + x2 + 3] = p3 + d2;
            }
        }
    }

    public static void fill4x4_2(int k2, int nworkers, int[] buff, int w2, int h2) {
        int BASERES = 4;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                int p0 = buff[y0offset + x2] >> 1 & 0x7F7F7F;
                int p01 = buff[y0offset + x2 + 2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x2 + 4] >> 1 & 0x7F7F7F;
                int p02 = buff[y2offset + x2] >> 1 & 0x7F7F7F;
                int p13 = buff[y2offset + x2 + 4] >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x2] >> 1 & 0x7F7F7F;
                int p23 = buff[y4offset + x2 + 2] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x2 + 4] >> 1 & 0x7F7F7F;
                int k0 = p01 + p23 >> 1 & 0x7F7F7F;
                int k1 = p02 + p13 >> 1 & 0x7F7F7F;
                int n2 = k0 + k1;
                buff[y2offset + x2 + 2] = n2;
                int pmid = n2;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n3 = p0 + p01;
                buff[y0offset + x2 + 1] = n3;
                int a2 = n3;
                int n4 = p1 + p01;
                buff[y0offset + x2 + 3] = n4;
                int b2 = n4;
                int n5 = p02 + pmid;
                buff[y2offset + x2 + 1] = n5;
                int c2 = n5;
                int n6 = p13 + pmid;
                buff[y2offset + x2 + 3] = n6;
                int d2 = n6;
                a2 = a2 >> 1 & 0x7F7F7F;
                b2 = b2 >> 1 & 0x7F7F7F;
                c2 = c2 >> 1 & 0x7F7F7F;
                d2 = d2 >> 1 & 0x7F7F7F;
                buff[y1offset + x2] = p0 + p02;
                buff[y1offset + x2 + 1] = a2 + c2;
                buff[y1offset + x2 + 2] = p01 + pmid;
                buff[y1offset + x2 + 3] = b2 + d2;
                buff[y3offset + x2] = p2 + p02;
                buff[y3offset + x2 + 1] = p2 + c2;
                buff[y3offset + x2 + 2] = p23 + pmid;
                buff[y3offset + x2 + 3] = p3 + d2;
            }
        }
    }

    public static void fill4x4_2s(int k2, int nworkers, short[] buff, int w2, int h2) {
        int BASERES = 4;
        int width = w2;
        int height = h2;
        int xstep = 4 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 4; x2 < width - 4; x2 += xstep) {
                short p0 = buff[y0offset + x2];
                short p01 = buff[y0offset + x2 + 2];
                short p1 = buff[y0offset + x2 + 4];
                short p02 = buff[y2offset + x2];
                short p13 = buff[y2offset + x2 + 4];
                short p2 = buff[y4offset + x2];
                short p23 = buff[y4offset + x2 + 2];
                short p3 = buff[y4offset + x2 + 4];
                int k0 = p01 + p23 >> 1;
                int k1 = p02 + p13 >> 1;
                short s2 = (short)(k0 + k1 >> 1);
                buff[y2offset + x2 + 2] = s2;
                short pmid = s2;
                short s3 = (short)(p0 + p01 >> 1);
                buff[y0offset + x2 + 1] = s3;
                short a2 = s3;
                short s4 = (short)(p1 + p01 >> 1);
                buff[y0offset + x2 + 3] = s4;
                short b2 = s4;
                short s5 = (short)(p02 + pmid >> 1);
                buff[y2offset + x2 + 1] = s5;
                short c2 = s5;
                short s6 = (short)(p13 + pmid >> 1);
                buff[y2offset + x2 + 3] = s6;
                short d2 = s6;
                buff[y1offset + x2] = (short)(p0 + p02 >> 1);
                buff[y1offset + x2 + 1] = (short)(a2 + c2 >> 1);
                buff[y1offset + x2 + 2] = (short)(p01 + pmid >> 1);
                buff[y1offset + x2 + 3] = (short)(b2 + d2 >> 1);
                buff[y3offset + x2] = (short)(p2 + p02 >> 1);
                buff[y3offset + x2 + 1] = (short)(p2 + c2 >> 1);
                buff[y3offset + x2 + 2] = (short)(p23 + pmid >> 1);
                buff[y3offset + x2 + 3] = (short)(p3 + d2 >> 1);
            }
        }
    }

    public static void fill8x4_0(int k2, int nworkers, int[] buff, int w2, int h2) {
        int BASERESX = 8;
        int BASERESY = 4;
        int width = w2;
        int height = h2;
        int xstep = 8 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 8; x2 < width - 8; x2 += xstep) {
                int p0 = buff[y0offset + x2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x2 + 8] >> 1 & 0x7F7F7F;
                int n2 = p0 + p1;
                buff[y0offset + x2 + 4] = n2;
                int p01 = n2;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x2] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x2 + 8] >> 1 & 0x7F7F7F;
                int n3 = p0 + p2;
                buff[y2offset + x2] = n3;
                int p02 = n3;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                int n4 = p0 + p01;
                buff[y0offset + x2 + 2] = n4;
                int a2 = n4;
                int n5 = p1 + p01;
                buff[y0offset + x2 + 6] = n5;
                int b2 = n5;
                a2 = a2 >> 1 & 0x7F7F7F;
                b2 = b2 >> 1 & 0x7F7F7F;
                int n6 = p0 + a2;
                buff[y0offset + x2 + 1] = n6;
                int y0_1 = n6;
                int n7 = p01 + a2;
                buff[y0offset + x2 + 3] = n7;
                int y0_3 = n7;
                int n8 = p01 + b2;
                buff[y0offset + x2 + 5] = n8;
                int y0_5 = n8;
                int n9 = b2 + p1;
                buff[y0offset + x2 + 7] = n9;
                int y0_7 = n9;
                y0_1 = y0_1 >> 1 & 0x7F7F7F;
                y0_3 = y0_3 >> 1 & 0x7F7F7F;
                y0_5 = y0_5 >> 1 & 0x7F7F7F;
                y0_7 = y0_7 >> 1 & 0x7F7F7F;
                int n10 = p23 + p01;
                buff[y2offset + x2 + 4] = n10;
                int pmid = n10;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n11 = p02 + pmid;
                buff[y2offset + x2 + 2] = n11;
                int c2 = n11;
                int n12 = p13 + pmid;
                buff[y2offset + x2 + 6] = n12;
                int d2 = n12;
                c2 = c2 >> 1 & 0x7F7F7F;
                d2 = d2 >> 1 & 0x7F7F7F;
                int n13 = p02 + c2;
                buff[y2offset + x2 + 1] = n13;
                int y2_1 = n13;
                int n14 = c2 + pmid;
                buff[y2offset + x2 + 3] = n14;
                int y2_3 = n14;
                int n15 = d2 + pmid;
                buff[y2offset + x2 + 5] = n15;
                int y2_5 = n15;
                int n16 = d2 + p13;
                buff[y2offset + x2 + 7] = n16;
                int y2_7 = n16;
                y2_1 = y2_1 >> 1 & 0x7F7F7F;
                y2_3 = y2_3 >> 1 & 0x7F7F7F;
                y2_5 = y2_5 >> 1 & 0x7F7F7F;
                y2_7 = y2_7 >> 1 & 0x7F7F7F;
                int pa = p2 + p23 >> 1 & 0x7F7F7F;
                int pb = p3 + p23 >> 1 & 0x7F7F7F;
                buff[y1offset + x2] = p0 + p02;
                buff[y1offset + x2 + 1] = y0_1 + y2_1;
                buff[y1offset + x2 + 2] = a2 + c2;
                buff[y1offset + x2 + 3] = y0_3 + y2_3;
                buff[y1offset + x2 + 4] = p01 + pmid;
                buff[y1offset + x2 + 5] = y0_5 + y2_5;
                buff[y1offset + x2 + 6] = b2 + d2;
                buff[y1offset + x2 + 7] = y0_7 + y2_7;
                int n17 = p2 + p02;
                buff[y3offset + x2] = n17;
                int y3_0 = n17;
                int n18 = pa + c2;
                buff[y3offset + x2 + 2] = n18;
                int y3_2 = n18;
                int n19 = p23 + pmid;
                buff[y3offset + x2 + 4] = n19;
                int y3_4 = n19;
                int n20 = pb + d2;
                buff[y3offset + x2 + 6] = n20;
                int y3_6 = n20;
                y3_0 = y3_0 >> 1 & 0x7F7F7F;
                y3_2 = y3_2 >> 1 & 0x7F7F7F;
                y3_4 = y3_4 >> 1 & 0x7F7F7F;
                y3_6 = y3_6 >> 1 & 0x7F7F7F;
                buff[y3offset + x2 + 1] = y3_0 + y3_2;
                buff[y3offset + x2 + 3] = y3_4 + y3_2;
                buff[y3offset + x2 + 5] = y3_4 + y3_6;
                buff[y3offset + x2 + 7] = y2_7 + y3_6;
            }
        }
    }

    public static void fill8x4_0s(int k2, int nworkers, short[] buff, int w2, int h2) {
        int BASERESX = 8;
        int BASERESY = 4;
        int width = w2;
        int height = h2;
        int xstep = 8 * nworkers;
        for (int y2 = 0; y2 < height - 4; y2 += 4) {
            int y0offset = y2 * w2;
            int y1offset = y0offset + w2;
            int y2offset = y1offset + w2;
            int y3offset = y2offset + w2;
            int y4offset = y3offset + w2;
            for (int x2 = k2 * 8; x2 < width - 8; x2 += xstep) {
                short p0 = buff[y0offset + x2];
                short p1 = buff[y0offset + x2 + 8];
                short s2 = (short)(p0 + p1 >> 1);
                buff[y0offset + x2 + 4] = s2;
                short p01 = s2;
                short p2 = buff[y4offset + x2];
                short p3 = buff[y4offset + x2 + 8];
                short s3 = (short)(p0 + p2 >> 1);
                buff[y2offset + x2] = s3;
                short p02 = s3;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                short s4 = (short)(p0 + p01 >> 1);
                buff[y0offset + x2 + 2] = s4;
                short a2 = s4;
                short s5 = (short)(p1 + p01 >> 1);
                buff[y0offset + x2 + 6] = s5;
                short b2 = s5;
                short s6 = (short)(p0 + a2 >> 1);
                buff[y0offset + x2 + 1] = s6;
                short y0_1 = s6;
                short s7 = (short)(p01 + a2 >> 1);
                buff[y0offset + x2 + 3] = s7;
                short y0_3 = s7;
                short s8 = (short)(p01 + b2 >> 1);
                buff[y0offset + x2 + 5] = s8;
                short y0_5 = s8;
                short s9 = (short)(b2 + p1 >> 1);
                buff[y0offset + x2 + 7] = s9;
                short y0_7 = s9;
                short s10 = (short)(p23 + p01 >> 1);
                buff[y2offset + x2 + 4] = s10;
                short pmid = s10;
                short s11 = (short)(p02 + pmid >> 1);
                buff[y2offset + x2 + 2] = s11;
                short c2 = s11;
                short s12 = (short)(p13 + pmid >> 1);
                buff[y2offset + x2 + 6] = s12;
                short d2 = s12;
                short s13 = (short)(p02 + c2 >> 1);
                buff[y2offset + x2 + 1] = s13;
                short y2_1 = s13;
                short s14 = (short)(c2 + pmid >> 1);
                buff[y2offset + x2 + 3] = s14;
                short y2_3 = s14;
                short s15 = (short)(d2 + pmid >> 1);
                buff[y2offset + x2 + 5] = s15;
                short y2_5 = s15;
                short s16 = (short)(d2 + p13 >> 1);
                buff[y2offset + x2 + 7] = s16;
                short y2_7 = s16;
                int pa = p2 + p23 >> 1;
                int pb = p3 + p23 >> 1;
                buff[y1offset + x2] = (short)(p0 + p02 >> 1);
                buff[y1offset + x2 + 1] = (short)(y0_1 + y2_1 >> 1);
                buff[y1offset + x2 + 2] = (short)(a2 + c2 >> 1);
                buff[y1offset + x2 + 3] = (short)(y0_3 + y2_3 >> 1);
                buff[y1offset + x2 + 4] = (short)(p01 + pmid >> 1);
                buff[y1offset + x2 + 5] = (short)(y0_5 + y2_5 >> 1);
                buff[y1offset + x2 + 6] = (short)(b2 + d2 >> 1);
                buff[y1offset + x2 + 7] = (short)(y0_7 + y2_7 >> 1);
                short s17 = (short)(p2 + p02 >> 1);
                buff[y3offset + x2] = s17;
                short y3_0 = s17;
                short s18 = (short)(pa + c2 >> 1);
                buff[y3offset + x2 + 2] = s18;
                short y3_2 = s18;
                short s19 = (short)(p23 + pmid >> 1);
                buff[y3offset + x2 + 4] = s19;
                short y3_4 = s19;
                short s20 = (short)(pb + d2 >> 1);
                buff[y3offset + x2 + 6] = s20;
                short y3_6 = s20;
                buff[y3offset + x2 + 1] = (short)(y3_0 + y3_2 >> 1);
                buff[y3offset + x2 + 3] = (short)(y3_4 + y3_2 >> 1);
                buff[y3offset + x2 + 5] = (short)(y3_4 + y3_6 >> 1);
                buff[y3offset + x2 + 7] = (short)(y2_7 + y3_6 >> 1);
            }
        }
    }
}

