/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.mprender.MultipassMap;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MultipassPolicy {
    public static final String ALL_RENDERSTYLES = "ALL_RENDERSTYLES";
    private static final double DEFAULT_THICKNESS = 9.99999999E8;
    private static final int DEFAULT_DIM = 999999999;
    private Map policyMap = new HashMap();
    private Set mpassAlgorithms = new HashSet();

    public MultipassPolicy(String filePath) throws FileNotFoundException {
        this(new FileInputStream(filePath));
    }

    public MultipassPolicy(InputStream is) {
        boolean isclosed = false;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            doc.getDocumentElement().normalize();
            Node[] policy = MultipassPolicy.getNodes(doc.getChildNodes(), "multipass:policy");
            for (int i2 = 0; i2 < policy.length; ++i2) {
                Node[] rules = MultipassPolicy.getNodes(policy[i2].getChildNodes(), "multipass:rule");
                for (int j2 = 0; j2 < rules.length; ++j2) {
                    int k2;
                    Node ruleNode = rules[j2];
                    NamedNodeMap ruleAttrs = ruleNode.getAttributes();
                    String rstyles = MultipassPolicy.getString(ruleAttrs, "renderStyles", ALL_RENDERSTYLES);
                    String[] renderStyles = MultipassPolicy.toArray(rstyles);
                    Node[] algorithms = MultipassPolicy.getNodes(ruleNode.getChildNodes(), "multipass:algorithm");
                    MultipassRule[] mprules = new MultipassRule[algorithms.length];
                    for (k2 = 0; k2 < algorithms.length; ++k2) {
                        Node algNode = algorithms[k2];
                        NamedNodeMap algAttrs = algNode.getAttributes();
                        int width = MultipassPolicy.parseInt(algAttrs, "width", 999999999);
                        int height = MultipassPolicy.parseInt(algAttrs, "height", 999999999);
                        double thickness = MultipassPolicy.parseDouble(algAttrs, "thickness", 9.99999999E8);
                        String mpassName = MultipassPolicy.getString(algAttrs, "name", null);
                        if (mpassName == null) continue;
                        this.mpassAlgorithms.add(mpassName);
                        mprules[k2] = new MultipassRule(mpassName, width, height, thickness);
                    }
                    for (k2 = 0; k2 < renderStyles.length; ++k2) {
                        String rstyle = renderStyles[k2];
                        ArrayList<MultipassRule> rulesList = (ArrayList<MultipassRule>)this.policyMap.get(rstyle);
                        if (rulesList == null) {
                            rulesList = new ArrayList<MultipassRule>();
                            this.policyMap.put(rstyle, rulesList);
                        }
                        for (int l2 = 0; l2 < mprules.length; ++l2) {
                            if (mprules[l2] == null) continue;
                            rulesList.add(mprules[l2]);
                        }
                    }
                }
            }
            is.close();
            isclosed = true;
            Set s2 = this.policyMap.entrySet();
            for (Map.Entry me : s2) {
                String rstyle = (String)me.getKey();
                List l3 = (List)me.getValue();
                Collections.sort(l3, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        MultipassRule rule1 = (MultipassRule)o1;
                        MultipassRule rule2 = (MultipassRule)o2;
                        if (rule1.thickness < rule2.thickness) {
                            return -1;
                        }
                        if (rule1.thickness > rule2.thickness) {
                            return 1;
                        }
                        if (rule1.width < rule2.width) {
                            return -1;
                        }
                        if (rule1.width > rule2.width) {
                            return 1;
                        }
                        if (rule1.height < rule2.height) {
                            return -1;
                        }
                        if (rule1.height > rule2.height) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (SAXException e3) {
            e3.printStackTrace();
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
        if (!isclosed) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MultipassMap createMultipassMap(IterativeRenderer irenderer, ParallelTaskManager ptm) {
        return this.createMultipassMap(irenderer, ptm, true);
    }

    public MultipassMap createMultipassMap(IterativeRenderer irenderer, boolean parallelRender) {
        return this.createMultipassMap(irenderer, null, parallelRender);
    }

    private MultipassMap createMultipassMap(IterativeRenderer irenderer, ParallelTaskManager ptm, boolean parallelRender) {
        HashMap<String, MultipassAlgorithm> mpassMap = new HashMap<String, MultipassAlgorithm>();
        boolean success = true;
        for (String mpassName : this.mpassAlgorithms) {
            MultipassAlgorithm mpAlg = MultipassPolicy.createMultipassAlgorithm(mpassName, irenderer, ptm, parallelRender);
            if (mpAlg != null) {
                mpassMap.put(mpassName, mpAlg);
                continue;
            }
            success = false;
            break;
        }
        MPMap mpmap = null;
        if (success) {
            mpmap = new MPMap(mpassMap, this);
        }
        return mpmap;
    }

    private static MultipassAlgorithm createMultipassAlgorithm(String name, IterativeRenderer ir, ParallelTaskManager ptm, boolean parallelRender) {
        MultipassAlgorithm ma = null;
        try {
            Class<?> cl = Class.forName(name);
            if (cl != null) {
                Constructor<?> c2;
                if (ptm != null) {
                    try {
                        c2 = cl.getConstructor(ParallelTaskManager.class);
                        ma = (MultipassAlgorithm)c2.newInstance(ptm);
                    }
                    catch (NoSuchMethodException e2) {}
                } else if (ptm == null) {
                    try {
                        c2 = cl.getConstructor(Boolean.TYPE);
                        ma = (MultipassAlgorithm)c2.newInstance(Boolean.FALSE);
                    }
                    catch (NoSuchMethodException e3) {
                        // empty catch block
                    }
                }
                if (ma == null) {
                    try {
                        c2 = cl.getConstructor(new Class[0]);
                        ma = (MultipassAlgorithm)c2.newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e4) {
                        // empty catch block
                    }
                }
            }
            if (ma != null) {
                ma.setT3DIRenderer(ir);
            }
        }
        catch (IllegalArgumentException e5) {
            e5.printStackTrace();
        }
        catch (SecurityException e6) {
        }
        catch (ClassNotFoundException e7) {
            e7.printStackTrace();
        }
        catch (InstantiationException e8) {
            e8.printStackTrace();
        }
        catch (IllegalAccessException e9) {
            e9.printStackTrace();
        }
        catch (InvocationTargetException e10) {
            e10.printStackTrace();
        }
        return ma;
    }

    private static Node[] getNodes(NodeList nl, String nodeName) {
        ArrayList<Node> al2 = new ArrayList<Node>();
        for (int i2 = 0; i2 < nl.getLength(); ++i2) {
            String name = nl.item(i2).getNodeName();
            if (!name.equals(nodeName)) continue;
            al2.add(nl.item(i2));
        }
        Node[] nodes = new Node[al2.size()];
        for (int i3 = 0; i3 < nodes.length; ++i3) {
            nodes[i3] = (Node)al2.get(i3);
        }
        return nodes;
    }

    private static int parseInt(NamedNodeMap nnm, String attributeName, int defValue) {
        String intval;
        Node n2 = nnm.getNamedItem(attributeName);
        if (n2 != null && (intval = n2.getNodeValue()) != null) {
            return Integer.parseInt(intval);
        }
        return defValue;
    }

    private static double parseDouble(NamedNodeMap nnm, String attributeName, double defValue) {
        String dval;
        Node n2 = nnm.getNamedItem(attributeName);
        if (n2 != null && (dval = n2.getNodeValue()) != null) {
            return Double.parseDouble(dval);
        }
        return defValue;
    }

    private static String getString(NamedNodeMap nnm, String attributeName, String defValue) {
        Node n2 = nnm.getNamedItem(attributeName);
        if (n2 != null) {
            String val = n2.getNodeValue();
            return val;
        }
        return defValue;
    }

    private static String[] toArray(String sepList) {
        ArrayList<String> al2 = new ArrayList<String>();
        if (sepList != null) {
            StringTokenizer st = new StringTokenizer(sepList, " ,");
            while (st.hasMoreTokens()) {
                al2.add(st.nextToken());
            }
        }
        String[] arr = new String[al2.size()];
        for (int i2 = 0; i2 < al2.size(); ++i2) {
            arr[i2] = (String)al2.get(i2);
        }
        return arr;
    }

    public Set getAvailableMultipassAlgorithms() {
        return this.mpassAlgorithms;
    }

    public Map getPolicyMap() {
        return this.policyMap;
    }

    public static void main(String[] args) {
        InputStream is = MultipassPolicy.class.getResourceAsStream("local_mpass.xml");
        MultipassPolicy mpp = new MultipassPolicy(is);
        J3DRenderEngine jre = new J3DRenderEngine();
        System.err.println("----------------------------------------------------------");
        mpp.createMultipassMap((IterativeRenderer)jre, new ParallelTaskManager());
    }

    private static class MPMap
    implements MultipassMap {
        private String renderStyle = null;
        private int rstyle = -1;
        private MultipassPolicy mp = null;
        private Map mpassMap = null;
        private MultipassAlgorithm[] suppmpass = null;

        public MPMap(Map mpassMap, MultipassPolicy mp) {
            this.mp = mp;
            this.mpassMap = mpassMap;
            this.suppmpass = new MultipassAlgorithm[mpassMap.size()];
            int idx = 0;
            for (Map.Entry me : mpassMap.entrySet()) {
                this.suppmpass[idx] = (MultipassAlgorithm)me.getValue();
                ++idx;
            }
        }

        @Override
        public void clear() {
            if (null != this.mpassMap) {
                this.mpassMap.clear();
            }
            for (MultipassAlgorithm multipassAlgorithm : this.suppmpass) {
                if (null == multipassAlgorithm) continue;
                multipassAlgorithm.shutdown();
            }
        }

        @Override
        public MultipassAlgorithm getMultipassAlgorithm(int width, int height, double thickness) {
            List l2 = (List)this.mp.policyMap.get(this.renderStyle);
            if (l2 == null) {
                l2 = (List)this.mp.policyMap.get(MultipassPolicy.ALL_RENDERSTYLES);
            }
            if (l2 != null) {
                for (int i2 = 0; i2 < l2.size(); ++i2) {
                    String mpassName;
                    MultipassAlgorithm ma;
                    MultipassRule mprule = (MultipassRule)l2.get(i2);
                    if (width > mprule.width || height > mprule.height || !(thickness <= mprule.thickness) || (ma = (MultipassAlgorithm)this.mpassMap.get(mpassName = mprule.mpassName)) == null) continue;
                    return ma;
                }
            }
            return null;
        }

        @Override
        public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
            return this.suppmpass;
        }

        @Override
        public void setRenderStyle(String renderStyle) {
            this.renderStyle = renderStyle;
            this.rstyle = Commons3D.getRenderStyleCode(renderStyle);
        }

        @Override
        public String getRenderStyle() {
            return this.renderStyle;
        }
    }

    public static class MultipassRule {
        public int width = 0;
        public int height = 0;
        public double thickness = 0.0;
        public String mpassName = null;

        public MultipassRule(String mpassName, int width, int height, double thickness) {
            this.mpassName = mpassName;
            this.width = width;
            this.height = height;
            this.thickness = thickness;
        }

        public String toString() {
            String str = "MultipassRule: [alg= " + this.mpassName + " width=" + this.width + " height=" + this.height + " thickness=" + this.thickness + "]";
            return str;
        }
    }
}

