/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.j3d.mprender.BaseIRE;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;

public class NearestIRE
extends BaseIRE {
    Rectangle r = new Rectangle(0, 0, 0, 0);
    int[][] searchTable;
    int level = 3;
    int skip = 8;
    int[] mask = new int[this.skip * this.skip];
    int[] jumpx = new int[this.skip * this.skip];
    int[] jumpy = new int[this.skip * this.skip];
    int[][] pattern = this.buildPatern(this.level);

    public NearestIRE() {
        this.buildNearestSearch(this.skip);
    }

    public int[][] buildPatern(int level) {
        int[][] tab = new int[][]{{0, 0}, {1, 1}, {1, 0}, {0, 1}};
        int no_of_steps = 1 << 2 * level;
        int[][] ret = new int[no_of_steps][2];
        System.out.println("no_of_steps=" + no_of_steps);
        for (int i2 = 0; i2 < no_of_steps; ++i2) {
            int p2 = i2;
            int x2 = 0;
            int y2 = 0;
            for (int k2 = 0; k2 < level; ++k2) {
                int index = p2 & 3;
                int mult = 1 << level - (k2 + 1);
                x2 += tab[index][0] * mult;
                y2 += tab[index][1] * mult;
                p2 >>= 2;
            }
            ret[i2][0] = x2;
            ret[i2][1] = y2;
        }
        return ret;
    }

    public void buiildLookup(int[] mask, int w2, int[] jumpx, int[] jumpy) {
        for (int y2 = 0; y2 < w2; ++y2) {
            block1: for (int x2 = 0; x2 < w2; ++x2) {
                if (mask[x2 + y2 * w2] != -1) continue;
                for (int k2 = 0; k2 < this.searchTable.length; ++k2) {
                    int nx = this.searchTable[k2][0] + x2;
                    int ny = this.searchTable[k2][1] + y2;
                    if (nx < 0 || nx >= w2 || ny < 0 || ny >= w2 || mask[nx + ny * w2] != 0) continue;
                    jumpx[x2 + y2 * w2] = nx - x2;
                    jumpy[x2 + y2 * w2] = ny - y2;
                    continue block1;
                }
            }
        }
    }

    public void buildNearestSearch(int dim) {
        this.searchTable = new int[(dim * 2 + 1) * (dim * 2 + 1)][3];
        int k2 = 0;
        for (int y2 = -dim; y2 <= dim; ++y2) {
            for (int x2 = -dim; x2 <= dim; ++x2) {
                this.searchTable[k2][0] = x2;
                this.searchTable[k2][1] = y2;
                this.searchTable[k2][2] = x2 * x2 + y2 * y2;
                ++k2;
            }
        }
        Arrays.sort(this.searchTable, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((int[])o1)[2] - ((int[])o2)[2];
            }
        });
        for (int i2 = 0; i2 < this.searchTable.length; ++i2) {
            this.searchTable[i2][2] = this.searchTable[i2][0] + this.searchTable[i2][1] * dim;
        }
    }

    @Override
    public void multiPassRender() {
        int i2;
        int image_width;
        if (this.scr == null) {
            return;
        }
        for (int i3 = 0; i3 < this.scrbuff.length; ++i3) {
            this.scrbuff[i3] = 0;
        }
        int image_height = this.scr.getHeight();
        this.r.width = image_width = this.scr.getWidth();
        this.r.height = image_height;
        for (i2 = 0; i2 < this.mask.length; ++i2) {
            this.mask[i2] = -1;
        }
        for (i2 = 0; i2 < this.pattern.length; ++i2) {
            this.r.x = this.pattern[i2][0];
            this.r.y = this.pattern[i2][1];
            this.r.width = image_width - this.r.x;
            this.r.height = image_height - this.r.y;
            this.ren.castRays(this.r, this.skip, this.skip, 0, 1, null);
            this.mask[this.r.x + this.r.y * this.skip] = 0;
            this.buiildLookup(this.mask, this.skip, this.jumpx, this.jumpy);
            Thread.yield();
            if ((i2 + 1) % 1 != 0) continue;
            for (int y2 = 0; y2 < image_height; ++y2) {
                for (int x2 = 0; x2 < image_width; ++x2) {
                    int getfrom_y;
                    int getfrom_x;
                    int y1 = y2 % this.skip;
                    int x1 = x2 % this.skip;
                    int p2 = x2 + y2 * image_width;
                    int mp = y1 * this.skip + x1;
                    if (this.mask[mp] == 0 || (getfrom_x = x2 + this.jumpx[mp]) >= image_width || (getfrom_y = y2 + this.jumpy[mp]) >= image_height) continue;
                    this.scrbuff[p2] = this.scrbuff[getfrom_x + getfrom_y * image_width];
                }
            }
            this.copyToBackBuff();
            this.scrcomp.repaint();
            if (this.noChange) continue;
            this.ren.updateWorld();
            return;
        }
    }
}

