/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.jnu.geom.JnRectangle;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.mprender.BaseGridMultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.BaseMultipassAlgorithm;

public class OnepassAlgorithm
extends BaseGridMultipassAlgorithm {
    protected BaseMultipassAlgorithm.Runner[] r;

    public OnepassAlgorithm(ParallelTaskManager ptm, boolean parallelRender) {
        super(ptm, parallelRender);
        this.r = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.init();
    }

    public OnepassAlgorithm(boolean parallelRender) {
        super(parallelRender);
        this.r = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.init();
    }

    public OnepassAlgorithm(ParallelTaskManager ptm) {
        this(ptm, true);
    }

    public OnepassAlgorithm() {
        this(true);
    }

    protected void init() {
        for (int i2 = 0; i2 < this.NOT; ++i2) {
            this.r[i2] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k2, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    BaseMultipassAlgorithm.RenderData rd = (BaseMultipassAlgorithm.RenderData)global_data;
                    int renderOutputLayer = rd.outLayer;
                    int w2 = rd.outputArea.width;
                    int h2 = rd.outputArea.height;
                    int x2 = rd.outputArea.x + k2;
                    int y2 = rd.outputArea.y;
                    int width = w2 - k2;
                    int height = h2;
                    ren.renderPixels(k2, renderOutputLayer, x2, y2, width, height, OnepassAlgorithm.this.NOT, 1, thread_data);
                }
            };
        }
    }

    @Override
    public int renderMPass(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
        if (this.isParallelRendering()) {
            BaseMultipassAlgorithm.RenderData rd = new BaseMultipassAlgorithm.RenderData();
            rd.outLayer = renderOutputLayer;
            rd.outputArea = new JnRectangle(x2, y2, w2, h2);
            this.launch(this.r, rd);
            this.markallbits();
        } else {
            IterativeRenderer ren = this.getT3DIRenderer();
            int width = w2;
            int height = h2;
            int xstep = this.getXStep(passno);
            int ystep = this.getYStep(passno);
            int x0 = x2 + this.getXStart(passno);
            int y0 = y2 + this.getYStart(passno);
            ren.renderPixels(0, renderOutputLayer, x0, y0, width, height, xstep, ystep, ren.createThreadData());
        }
        return 0;
    }

    @Override
    public void fillMPass(int x2, int y2, int w2, int h2, int renderOutputLayer, int passno) {
    }

    @Override
    public int getXStep(int passno) {
        return 1;
    }

    @Override
    public int getYStep(int passno) {
        return 1;
    }

    @Override
    public int getXStart(int passno) {
        return 0;
    }

    @Override
    public int getYStart(int passno) {
        return 0;
    }
}

