/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.j3d.mprender.BaseIRE;
import com.ge.med.terra.jami.j3d.mprender.ThreadPool;
import java.awt.Rectangle;

public class SamplingMtIRE
extends BaseIRE {
    public static final int QUALITY = 40;
    private final int baseRes = 16;
    private final int baseSteps = 3;
    private ThreadPool tp = new ThreadPool(this.NOT - 1);
    private int[] hist = new int[24576];
    private Rectangle r = new Rectangle(0, 0, 0, 0);
    private int scrh;
    private int scrw;
    private final int highbyte = -16777216;
    private int[] levels = new int[16];
    private Rectangle origRectangle = new Rectangle();
    private Runnable[] linerunners4 = null;
    private Runnable[] linerunners8 = null;
    private Runnable[] mresrunners2_8 = null;

    public void SamplingMtIRE() {
        this.blue = true;
    }

    private final int diff(int a2, int b2) {
        int pne1 = a2 & 0xFF;
        int pne2 = a2 >> 8 & 0xFF;
        int pne3 = a2 >> 16 & 0xFF;
        int pse1 = b2 & 0xFF;
        int pse2 = b2 >> 8 & 0xFF;
        int pse3 = b2 >> 16 & 0xFF;
        int d1 = pne1 - pse1;
        int d2 = pne2 - pse2;
        int d3 = pne3 - pse3;
        return d1 * d1 + d2 * d2 + d3 * d3 >> 5;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tp.destroy();
        this.tp = null;
    }

    public void setPriority(int p2) {
        Thread.currentThread().setPriority(p2);
        this.tp.setPriority(p2);
    }

    @Override
    public void multiPassRender() {
        this.setPriority(5);
        int renderMode = this.getRenderMode();
        switch (renderMode) {
            case 0: {
                this.defaultMultiPassRender();
                break;
            }
            case 1: {
                this.lineMultiPassRender();
                break;
            }
            case 2: {
                this.mresMultiPassRender();
            }
        }
    }

    public static void markTime(String str) {
    }

    private void defaultMultiPassRender() {
        int i2;
        int k2;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("start");
        int i3 = 1;
        while (i3 < this.NOT) {
            k2 = i3++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i2 = k2; i2 < SamplingMtIRE.this.scrbuff.length; i2 += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i2] = SamplingMtIRE.this.bgColor;
                    }
                }
            });
        }
        for (i3 = 0; i3 < this.scrbuff.length; i3 += this.NOT) {
            this.scrbuff[i3] = this.bgColor;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("start");
        i3 = 1;
        while (i3 < this.NOT) {
            k2 = i3++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                    r2.x += k2 * 16;
                    r2.width -= k2 * 16;
                    SamplingMtIRE.this.ren.castRays(r2, 16 * SamplingMtIRE.this.NOT, 16, 0, 1, SamplingMtIRE.this.thread_data[k2]);
                    SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 16 * SamplingMtIRE.this.NOT, 16);
                }
            });
        }
        this.ren.castRays(this.r, 16 * this.NOT, 16, 0, 1, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, this.r, 16 * this.NOT, 16);
        this.tp.waitfordone();
        SamplingMtIRE.markTime("pass 1");
        long phase1 = System.currentTimeMillis();
        final int speed = (int)(phase1 - start);
        if (phase1 - start < 0L) {
            for (i2 = 0; i2 < 4; ++i2) {
                this.mtBulkRay(i2 / 2, i2 % 2, 0, 1);
                if (i2 == 0) {
                    this.mtFill2x2();
                }
                if (!this.noChange) {
                    this.ren.updateWorld();
                    return;
                }
                this.tp.waitfordone();
                phase1 = System.currentTimeMillis();
                if (phase1 - start > 30L || i2 == 3) {
                    Thread.yield();
                    this.copyToBackBuff();
                    this.scrcomp.repaint();
                    if (phase1 - start > 100L) break;
                    if (i2 == 3) {
                        return;
                    }
                }
                if (this.noChange) continue;
                this.ren.updateWorld();
                return;
            }
        }
        i2 = 1;
        while (i2 < this.NOT) {
            final int k3 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.lightBasedPass(k3, speed, 0, 1);
                }
            });
        }
        this.lightBasedPass(0, speed, 0, 1);
        this.tp.waitfordone();
        SamplingMtIRE.markTime("done light base ");
        for (i2 = 0; i2 < this.hist.length; ++i2) {
            this.hist[i2] = 0;
        }
        for (int y2 = 16; y2 < this.scrh; y2 += 32) {
            for (int x2 = 16; x2 < this.scrw; x2 += 32) {
                int i4 = x2 + y2 * this.scrw;
                int n2 = this.diff(this.scrbuff[i4], this.scrbuff[i4 - 16]);
                this.hist[n2] = this.hist[n2] + 1;
                int n3 = this.diff(this.scrbuff[i4], this.scrbuff[i4 - 16 * this.scrw]);
                this.hist[n3] = this.hist[n3] + 1;
            }
        }
        int max = 0;
        int sum = 1;
        int thresh = 100;
        for (int i5 = 0; i5 < this.hist.length; ++i5) {
            sum += this.hist[i5];
            if (this.hist[i5] <= 0) continue;
            max = i5;
        }
        int v2 = 0;
        int i6 = this.hist.length - 1;
        while (i6 > 0) {
            this.levels[(v2 += this.hist[i6]) * this.levels.length / sum] = i6--;
        }
        start = 0L;
        for (int pas = 0; pas < this.levels.length && thresh != 0; ++pas) {
            final int fthresh = thresh = this.levels[pas];
            int i7 = 1;
            while (i7 < this.NOT) {
                final int k4 = i7++;
                this.tp.add(new Runnable(){

                    @Override
                    public void run() {
                        SamplingMtIRE.this.edgeBasedPass(fthresh, k4, 0, 1);
                    }
                });
            }
            this.edgeBasedPass(thresh, 0, 0, 1);
            this.tp.waitfordone();
            SamplingMtIRE.markTime("done edge " + pas);
            long nextPaint = System.currentTimeMillis();
            if (nextPaint - start > 100L) {
                this.mtFill2x2();
                Thread.yield();
                this.copyToBackBuff();
                this.scrcomp.repaint();
                start = nextPaint;
            }
            if (this.noChange) continue;
            this.ren.updateWorld();
            return;
        }
        this.setPriority(1);
        this.mtRay(1, 1, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        this.mtRay(1, 0, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.copyToBackBuff();
        Thread.yield();
        this.scrcomp.repaint();
        this.mtRay(0, 1, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.copyToBackBuff();
        this.scrcomp.repaint();
        i6 = 1;
        while (i6 < this.NOT) {
            final int k5 = i6++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.finalfill(k5, 0, 1);
                }
            });
        }
        this.finalfill(0, 0, 1);
        this.tp.waitfordone();
        Thread.yield();
        this.copyToBackBuff();
        this.done = true;
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
    }

    private void finalfill(int t2, int zoff, int zstep) {
        for (int i2 = t2; i2 < this.scrbuff.length; i2 += this.NOT) {
            if (this.scrbuff[i2] < 0) continue;
            this.scrbuff[i2] = this.ren.castRay(i2 % this.scrw, i2 / this.scrw, zoff, zstep, this.thread_data[t2]);
        }
    }

    private void mtFill2x2() {
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.fill2x2(k2);
                }
            });
        }
        this.fill2x2(0);
        this.tp.waitfordone();
    }

    private void mtRay(final int dx, final int dy, final int zoff, final int zstep) {
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(dx, dy, SamplingMtIRE.this.scrw - dx, SamplingMtIRE.this.scrh - dy);
                    tr.x += k2 * 2;
                    tr.width -= k2 * 2;
                    int height = SamplingMtIRE.this.scrh;
                    int ystep = height / 32;
                    if (ystep == 0) {
                        ystep = 1;
                    }
                    for (int y2 = tr.y; y2 < height; y2 += ystep) {
                        if (!SamplingMtIRE.this.noChange) {
                            return;
                        }
                        tr.y = y2;
                        tr.height = y2 + ystep > height ? height - y2 : ystep;
                        SamplingMtIRE.this.ren.castRays(tr, 2 * SamplingMtIRE.this.NOT, 2, zoff, zstep, SamplingMtIRE.this.thread_data[k2]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, 2 * SamplingMtIRE.this.NOT, 2);
                    }
                }
            });
        }
        Rectangle tr = new Rectangle(dx, dy, this.scrw - dx, this.scrh - dy);
        int height = this.scrh;
        int ystep = height / 32;
        if (ystep == 0) {
            ystep = 1;
        }
        for (int y2 = tr.y; y2 < height && this.noChange; y2 += ystep) {
            tr.y = y2;
            tr.height = y2 + ystep > height ? height - y2 : ystep;
            this.ren.castRays(tr, 2 * this.NOT, 2, zoff, zstep, this.thread_data[0]);
            this.highbit(this.scrbuff, this.scrw, tr, 2 * this.NOT, 2);
        }
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void mtBulkRay(final int dx, final int dy, final int zoff, final int zstep) {
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(dx, dy, SamplingMtIRE.this.scrw - dx, SamplingMtIRE.this.scrh - dy);
                    tr.x += k2 * 2;
                    tr.width -= k2 * 2;
                    SamplingMtIRE.this.ren.castRays(tr, 2 * SamplingMtIRE.this.NOT, 2, zoff, zstep, SamplingMtIRE.this.thread_data[k2]);
                    SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, 2 * SamplingMtIRE.this.NOT, 2);
                }
            });
        }
        Rectangle tr = new Rectangle(dx, dy, this.scrw - dx, this.scrh - dy);
        this.ren.castRays(tr, 2 * this.NOT, 2, zoff, zstep, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, tr, 2 * this.NOT, 2);
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void fullRay(final int zoff, final int zstep) {
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(0, 0, SamplingMtIRE.this.scrw, SamplingMtIRE.this.scrh);
                    tr.x += k2;
                    tr.width -= k2;
                    int height = SamplingMtIRE.this.scrh;
                    int ystep = height / 32;
                    if (ystep == 0) {
                        ystep = 1;
                    }
                    for (int y2 = tr.y; y2 < height; y2 += ystep) {
                        tr.y = y2;
                        tr.height = y2 + ystep > height ? height - y2 : ystep;
                        SamplingMtIRE.this.ren.castRays(tr, SamplingMtIRE.this.NOT, 1, zoff, zstep, SamplingMtIRE.this.thread_data[k2]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, SamplingMtIRE.this.NOT, 1);
                    }
                }
            });
        }
        Rectangle tr = new Rectangle(0, 0, this.scrw, this.scrh);
        this.ren.castRays(tr, this.NOT, 1, zoff, zstep, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, tr, this.NOT, 1);
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void fill2x2(int t2) {
        for (int y2 = 0; y2 < this.r.height - 2; y2 += 2) {
            for (int x2 = t2 * 2; x2 < this.r.width - 2; x2 += 2 * this.NOT) {
                int v21;
                int v01;
                int i2 = x2 + y2 * this.scrw;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i2 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + 1] = v01 = v00 + v02;
                int v20 = this.scrbuff[i2 + 2 * this.scrw] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + this.scrw] = v00 + v20;
                int v22 = this.scrbuff[i2 + 2 * this.scrw + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + this.scrw * 2 + 1] = v21 = v20 + v22;
                this.scrbuff[i2 + this.scrw + 2] = v02 + v22;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + this.scrw + 1] = v01 + v21;
            }
        }
    }

    private void edgeBasedPass(int thresh, int t2, int zoff, int zstep) {
        int xstart = t2 * (this.scrw / this.NOT & 0xFFFFFFF0);
        int xend = (1 + t2) * (this.scrw / this.NOT & 0xFFFFFFF0) + 1;
        int toggle = 0;
        if (t2 == this.NOT - 1) {
            xend = this.scrw;
        }
        for (int res = 0; res < 3; ++res) {
            int b2;
            int a2;
            int diff;
            int d3;
            int d2;
            int d1;
            int pb3;
            int pb2;
            int pb1;
            int pb;
            int test;
            int step = 16 >> res;
            int hstep = step / 2;
            int pa = this.scrbuff[0];
            int pa1 = pa & 0xFF;
            int pa2 = pa >> 8 & 0xFF;
            int pa3 = pa >> 16 & 0xFF;
            for (int x2 = xstart; x2 < xend; x2 += step) {
                test = x2 + hstep;
                pb = this.scrbuff[test + hstep];
                pb1 = pb & 0xFF;
                pb2 = pb >> 8 & 0xFF;
                pb3 = pb >> 16 & 0xFF;
                if (this.scrbuff[test] >= 0) {
                    d1 = pa1 - pb1;
                    d2 = pa2 - pb2;
                    d3 = pa3 - pb3;
                    diff = d1 * d1 + d2 * d2 + d3 * d3 >> 5;
                    if (thresh < diff) {
                        this.scrbuff[test] = this.ren.castRay(test % this.scrw, test / this.scrw, zoff, zstep, this.thread_data[t2]) | 0xFF000000;
                    } else {
                        a2 = pa >> 1 & 0x7F7F7F;
                        b2 = pb >> 1 & 0x7F7F7F;
                        this.scrbuff[test] = a2 + b2;
                    }
                }
                pa = pb;
                pa1 = pb1;
                pa2 = pb2;
                pa3 = pb3;
            }
            pa = this.scrbuff[0];
            pa1 = pa & 0xFF;
            pa2 = pa >> 8 & 0xFF;
            pa3 = pa >> 16 & 0xFF;
            for (int y2 = this.r.y; y2 < this.r.height - step; y2 += step) {
                test = xstart + y2 * this.scrw + hstep * this.scrw;
                if (this.scrbuff[test] < 0) continue;
                pb = this.scrbuff[test + hstep * this.scrw];
                pb1 = pb & 0xFF;
                d1 = pa1 - pb1;
                pb2 = pb >> 8 & 0xFF;
                d2 = pa2 - pb2;
                pb3 = pb >> 16 & 0xFF;
                d3 = pa3 - pb3;
                diff = d1 * d1 + d2 * d2 + d3 * d3 >> 5;
                if (thresh < diff) {
                    this.scrbuff[test] = this.ren.castRay(test % this.scrw, test / this.scrw, zoff, zstep, this.thread_data[t2]) | 0xFF000000;
                } else {
                    a2 = pa >> 1 & 0x7F7F7F;
                    b2 = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test] = a2 + b2;
                }
                pa = pb;
                pa1 = pb1;
                pa2 = pb2;
                pa3 = pb3;
            }
            for (int y3 = this.r.y + hstep; y3 < this.r.height - step; y3 += step) {
                for (int x3 = xstart + hstep; x3 < xend; x3 += step) {
                    int b3;
                    int a3;
                    int diff2;
                    int pa4;
                    int off;
                    int i2 = y3 * this.scrw + x3;
                    int test2 = i2 + hstep;
                    if (this.scrbuff[test2] >= 0) {
                        off = hstep * this.scrw;
                        pa4 = this.scrbuff[test2 - off];
                        pb = this.scrbuff[test2 + off];
                        diff2 = this.diff(pa4, pb);
                        if (thresh < diff2) {
                            this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t2]) | 0xFF000000;
                        } else {
                            a3 = pa4 >> 1 & 0x7F7F7F;
                            b3 = pb >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a3 + b3;
                        }
                    }
                    if (this.scrbuff[test2 = i2 + hstep * this.scrw] >= 0) {
                        int pa5 = this.scrbuff[test2 - hstep];
                        int pb4 = this.scrbuff[test2 + hstep];
                        int diff3 = this.diff(pa5, pb4);
                        if (thresh < diff3) {
                            this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t2]) | 0xFF000000;
                        } else {
                            int a4 = pa5 >> 1 & 0x7F7F7F;
                            int b4 = pb4 >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a4 + b4;
                        }
                    }
                    if (this.scrbuff[test2 = i2] < 0) continue;
                    off = hstep;
                    if ((toggle = toggle + 1 & 1) == 0) {
                        off *= this.scrw;
                    }
                    if (thresh < (diff2 = this.diff(pa4 = this.scrbuff[test2 - off], pb = this.scrbuff[test2 + off]))) {
                        this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t2]) | 0xFF000000;
                        continue;
                    }
                    a3 = pa4 >> 1 & 0x7F7F7F;
                    b3 = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test2] = a3 + b3;
                }
            }
        }
    }

    private void lightBasedPass(int thread, int speed, int zoff, int zstep) {
        if (speed > 40) {
            return;
        }
        int halfPass = 16 / (speed < 20 ? 4 : 2);
        int mask = -16;
        int xskip = halfPass * this.NOT;
        int xstart = thread * halfPass;
        for (int y2 = 0; y2 < this.scrh; y2 += halfPass) {
            int yp = y2 + 8 & mask;
            yp = yp < this.scrh ? (yp *= this.scrw) : (this.scrh - 1 & mask) * this.scrw;
            for (int x2 = xstart; x2 < this.scrw; x2 += xskip) {
                if (x2 % 16 == 0 && y2 % 16 == 0) continue;
                int p2 = x2 + 8 & mask;
                p2 = p2 < this.scrw ? (p2 += yp) : this.scrw - 1 & mask + yp;
                int k2 = this.scrbuff[p2] & 0xFFFFFF;
                k2 = (k2 & 0xFF) + (k2 >> 8 & 0xFF) + (k2 >> 16 & 0xFF);
                if (k2 < 40) continue;
                int i2 = y2 * this.scrw + x2;
                this.scrbuff[i2] = this.ren.castRay(x2, y2, zoff, zstep, this.thread_data[thread]) | 0xFF000000;
            }
        }
    }

    protected void display() {
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
    }

    private void lineMultiPassRender() {
        int k2;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        this.origRectangle.setBounds(this.r);
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("LINERENDER_START");
        int i2 = 1;
        while (i2 < this.NOT) {
            k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i2 = k2; i2 < SamplingMtIRE.this.scrbuff.length; i2 += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i2] = SamplingMtIRE.this.bgColor;
                    }
                }
            });
        }
        for (i2 = 0; i2 < this.scrbuff.length; i2 += this.NOT) {
            this.scrbuff[i2] = this.bgColor;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("LINERENDER_PASS1");
        if (this.linerunners8 == null) {
            this.linerunners8 = new Runnable[this.NOT];
            for (i2 = 0; i2 < this.NOT; ++i2) {
                k2 = i2;
                this.linerunners8[i2] = new Runnable(){

                    @Override
                    public void run() {
                        int LINESKIP_PASS = 8;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.y += k2 * 8;
                        r2.height -= k2 * 8;
                        SamplingMtIRE.this.ren.castRays(r2, 1, 8 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k2]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 1, 8 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.linerunners8[i2]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        this.mtFillLines8();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.r.y = this.origRectangle.y + 4;
        this.r.height = this.origRectangle.height - 8;
        SamplingMtIRE.markTime("LINERENDER_PASS2");
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.linerunners8[i2]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines4();
        this.display();
        this.r.y = this.origRectangle.y + 2;
        this.r.height = this.origRectangle.height - 4;
        SamplingMtIRE.markTime("LINERENDER_PASS3");
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.linerunners8[i2]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines2();
        this.display();
        this.r.y = this.origRectangle.y + 6;
        this.r.height = this.origRectangle.height - 12;
        SamplingMtIRE.markTime("LINERENDER_PASS4");
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.linerunners8[i2]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.r.y = this.origRectangle.y + 1;
        this.r.height = this.origRectangle.height - 1;
        if (this.linerunners4 == null) {
            this.linerunners4 = new Runnable[this.NOT];
            for (i2 = 0; i2 < this.NOT; ++i2) {
                k2 = i2;
                this.linerunners4[i2] = new Runnable(){

                    @Override
                    public void run() {
                        int LINESKIP_PASS = 4;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.y += k2 * 4;
                        r2.height -= k2 * 4;
                        SamplingMtIRE.this.ren.castRays(r2, 1, 4 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k2]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 1, 4 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.linerunners4[i2]);
        }
        this.linerunners4[0].run();
        this.tp.waitfordone();
        this.display();
        this.done = true;
    }

    private void mtFillLines8() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 8;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 8);
                    SamplingMtIRE.this.fillLines8(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines8(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFillLines4() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 4;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 4);
                    SamplingMtIRE.this.fillLines4(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines4(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFillLines2() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 2;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 2);
                    SamplingMtIRE.this.fillLines2(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines2(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void fillLines2(int ystart, int yend, int nproc) {
        int linestep = 2 * nproc;
        int line2 = this.scrw << 1;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = 0; x2 < this.r.width; ++x2) {
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v20 = this.scrbuff[i2 + line2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + this.scrw] = v00 + v20;
            }
        }
    }

    private void fillLines4(int ystart, int yend, int nproc) {
        int linestep = 4 * nproc;
        int line1 = this.scrw;
        int line2 = this.scrw * 2;
        int line3 = this.scrw * 3;
        int line4 = this.scrw * 4;
        int v20 = 0;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = 0; x2 < this.r.width; ++x2) {
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v40 = this.scrbuff[i2 + line4] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line2] = v20 = v00 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1] = v00 + v20;
                this.scrbuff[i2 + line3] = v20 + v40;
            }
        }
    }

    private void fillLines8(int ystart, int yend, int nproc) {
        int linestep = 8 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int line5 = 5 * this.scrw;
        int line6 = 6 * this.scrw;
        int line7 = 7 * this.scrw;
        int line8 = 8 * this.scrw;
        int v60 = 0;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = 0; x2 < this.r.width; ++x2) {
                int v20;
                int v40;
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v80 = this.scrbuff[i2 + line8] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line4] = v40 = v00 + v80;
                v40 = v40 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line2] = v20 = v00 + v40;
                this.scrbuff[i2 + line6] = v60 = v80 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                v60 = v60 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1] = v00 + v20;
                this.scrbuff[i2 + line3] = v20 + v40;
                this.scrbuff[i2 + line5] = v40 + v60;
                this.scrbuff[i2 + line7] = v80 + v60;
            }
        }
    }

    private void mresMultiPassRender() {
        int k2;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        this.origRectangle.setBounds(this.r);
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("MULTIRES_START");
        int i2 = 1;
        while (i2 < this.NOT) {
            k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i2 = k2; i2 < SamplingMtIRE.this.scrbuff.length; i2 += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i2] = 0;
                    }
                }
            });
        }
        for (i2 = 0; i2 < this.scrbuff.length; i2 += this.NOT) {
            this.scrbuff[i2] = 0;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("MULTIRES_PASS1");
        if (this.mresrunners2_8 == null) {
            this.mresrunners2_8 = new Runnable[this.NOT];
            for (i2 = 0; i2 < this.NOT; ++i2) {
                k2 = i2;
                this.mresrunners2_8[i2] = new Runnable(){

                    @Override
                    public void run() {
                        int COLSKIP_PASS = 2;
                        int LINESKIP_PASS = 8;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.x += k2 * 2;
                        r2.width -= k2 * 2;
                        r2.y += k2 * 8;
                        r2.height -= k2 * 8;
                        SamplingMtIRE.this.ren.castRays(r2, 2 * SamplingMtIRE.this.NOT, 8 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k2]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 2 * SamplingMtIRE.this.NOT, 8 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(this.mresrunners2_8[i2]);
        }
        this.mresrunners2_8[0].run();
        this.tp.waitfordone();
        this.mtFill2_8();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS2", this.mresrunners2_8, 4)) {
            return;
        }
        this.mtFill2_4();
        this.display();
        if (!this.castRunners("MULTIRES_PASS3", this.mresrunners2_8, 2)) {
            return;
        }
        this.mtFill2_2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS4", this.mresrunners2_8, 6)) {
            return;
        }
        this.mtFill2_2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS5", this.mresrunners2_8, 1)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS6", this.mresrunners2_8, 3)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS7", this.mresrunners2_8, 5)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS8", this.mresrunners2_8, 7)) {
            return;
        }
        this.origRectangle.x = 1;
        if (!this.castRunners("MULTIRES_PASS9", this.mresrunners2_8, 0)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS10", this.mresrunners2_8, 4)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS11", this.mresrunners2_8, 1)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS12", this.mresrunners2_8, 5)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS13", this.mresrunners2_8, 2)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS14", this.mresrunners2_8, 6)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS15", this.mresrunners2_8, 3)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS16", this.mresrunners2_8, 7)) {
            return;
        }
        this.done = true;
    }

    private boolean castRunners(String passName, Runnable[] runners, int offset) {
        this.r.x = this.origRectangle.x;
        this.r.y = this.origRectangle.y + offset;
        this.r.width = this.origRectangle.width;
        this.r.height = this.origRectangle.height - (offset << 1);
        SamplingMtIRE.markTime(passName);
        for (int i2 = 1; i2 < this.NOT; ++i2) {
            this.tp.add(runners[i2]);
        }
        runners[0].run();
        this.tp.waitfordone();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return false;
        }
        return true;
    }

    private void mtFill2_8() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k2 * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k2 * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 8;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 8);
                    SamplingMtIRE.this.fill2_8(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_8(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFill2_4() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k2 * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k2 * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 4;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 4);
                    SamplingMtIRE.this.fill2_4(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_4(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFill2_2() {
        this.ren.prePaint();
        int i2 = 1;
        while (i2 < this.NOT) {
            final int k2 = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k2 * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k2 * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k2 * 2;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k2 * 2);
                    SamplingMtIRE.this.fill2_2(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_2(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void fill2_8(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 8 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int line5 = 5 * this.scrw;
        int line6 = 6 * this.scrw;
        int line7 = 7 * this.scrw;
        int line8 = 8 * this.scrw;
        int v60 = 0;
        int v81 = 0;
        int v61 = 0;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = xstart; x2 < xend - colstep; x2 += colstep) {
                int v21;
                int v41;
                int v20;
                int v40;
                int v01;
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i2 + 2] >> 1 & 0x7F7F7F;
                int v80 = this.scrbuff[i2 + line8] >> 1 & 0x7F7F7F;
                int v82 = this.scrbuff[i2 + line8 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + 1] = v01 = v00 + v02;
                this.scrbuff[i2 + line8 + 1] = v81 = v80 + v82;
                this.scrbuff[i2 + line4] = v40 = v00 + v80;
                v40 = v40 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line2] = v20 = v00 + v40;
                this.scrbuff[i2 + line6] = v60 = v80 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                v60 = v60 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1] = v00 + v20;
                this.scrbuff[i2 + line3] = v20 + v40;
                this.scrbuff[i2 + line5] = v40 + v60;
                this.scrbuff[i2 + line7] = v80 + v60;
                v01 = v01 >> 1 & 0x7F7F7F;
                v81 = v81 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line4 + 1] = v41 = v01 + v81;
                v41 = v41 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line2 + 1] = v21 = v01 + v41;
                this.scrbuff[i2 + line6 + 1] = v61 = v41 + v81;
                v21 = v21 >> 1 & 0x7F7F7F;
                v61 = v61 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1 + 1] = v01 + v21;
                this.scrbuff[i2 + line3 + 1] = v21 + v41;
                this.scrbuff[i2 + line5 + 1] = v41 + v61;
                this.scrbuff[i2 + line7 + 1] = v61 + v81;
            }
        }
    }

    private void fill2_4(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 4 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int v20 = 0;
        int v41 = 0;
        int v21 = 0;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = xstart; x2 < xend - colstep; x2 += colstep) {
                int v01;
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i2 + 2] >> 1 & 0x7F7F7F;
                int v40 = this.scrbuff[i2 + line4] >> 1 & 0x7F7F7F;
                int v42 = this.scrbuff[i2 + line4 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + 1] = v01 = v00 + v02;
                this.scrbuff[i2 + line4 + 1] = v41 = v40 + v42;
                this.scrbuff[i2 + line2] = v20 = v00 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1] = v00 + v20;
                this.scrbuff[i2 + line3] = v20 + v40;
                v01 = v01 >> 1 & 0x7F7F7F;
                v41 = v41 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line2 + 1] = v21 = v01 + v41;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1 + 1] = v01 + v21;
                this.scrbuff[i2 + line3 + 1] = v21 + v41;
            }
        }
    }

    private void fill2_2(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 2 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int v01 = 0;
        int v21 = 0;
        for (int y2 = ystart; y2 < yend - linestep; y2 += linestep) {
            int yoffset = y2 * this.scrw;
            for (int x2 = xstart; x2 < xend - colstep; x2 += colstep) {
                int i2 = x2 + yoffset;
                int v00 = this.scrbuff[i2] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i2 + 2] >> 1 & 0x7F7F7F;
                int v20 = this.scrbuff[i2 + line2] >> 1 & 0x7F7F7F;
                int v22 = this.scrbuff[i2 + line2 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + 1] = v01 = v00 + v02;
                this.scrbuff[i2 + line2 + 1] = v21 = v20 + v22;
                this.scrbuff[i2 + line1] = v00 + v20;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i2 + line1 + 1] = v01 + v21;
            }
        }
    }
}

