/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.registration;

import com.ge.med.idc.Fusion3DCapable;
import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.ViewResetAction;
import com.ge.med.terra.jami.j3d.registration.RegistrationMouseController;
import com.ge.med.terra.jami.j3d.registration.TransformableVolume;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RegistrationViewer
extends JPanel
implements LinearTransformable {
    protected XjVolumeModel backgroundVolumeModel = null;
    protected LinearTransformable foregroundTransformCapable = null;
    protected XjVolumeModel foregroundVolumeModel = null;
    public T3DViewport[] backgroundViewports = null;
    public T3DViewport[] foregroundViewports = null;
    public T3DViewport[] fusionViewports = null;
    public T3DViewport[] viewports = null;
    protected DefaultCursor3DModel cursorModel = null;
    protected boolean cursorVisible = true;
    protected Cursor3DVc[] cursors = null;
    protected int[] dims = new int[3];
    protected double[] rasOrigin = new double[3];
    protected double[] dx = new double[3];
    protected double[] dy = new double[3];
    protected double[] dz = new double[3];
    protected double[] worldAxis = new double[3];
    protected double[] worldCenter = new double[3];
    protected static boolean syncWL = false;

    public RegistrationViewer() {
        this.initUI();
    }

    public XjVolumeModel getBackgroundVolumeModel() {
        return this.backgroundVolumeModel;
    }

    public void setBackgroundVolumeModel(XjVolumeModel backgroundVolumeModel) {
        boolean reloadForeground = false;
        if (this.backgroundVolumeModel == null) {
            reloadForeground = true;
        }
        this.backgroundVolumeModel = backgroundVolumeModel;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.backgroundViewports[i2].setVolumeModel(backgroundVolumeModel);
            this.fusionViewports[i2].setVolumeModel(backgroundVolumeModel);
            if (!reloadForeground || this.foregroundVolumeModel == null) continue;
            Fusion3DCapable f3d = (Fusion3DCapable)this.fusionViewports[i2].getCapable(Fusion3DCapable.class.getCanonicalName());
            f3d.addVolumeLayer(this.foregroundVolumeModel);
        }
        this.calculateVolumeGeometry();
        this.resetViews();
    }

    public XjVolumeModel getForegroundVolumeModel() {
        return this.foregroundVolumeModel;
    }

    public void setForegroundVolume(XjVolumeInfo foregroundVolume) {
        if (foregroundVolume instanceof LinearTransformable) {
            this.foregroundTransformCapable = (LinearTransformable)((Object)foregroundVolume);
        } else {
            TransformableVolume transformableVolume = TransformableVolume.createTransformableVolume(foregroundVolume);
            foregroundVolume = transformableVolume;
            this.foregroundTransformCapable = transformableVolume;
        }
        this.foregroundTransformCapable.addPropertyChangeListener("LINEAR_TRANSFORM_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RegistrationViewer.this.firePropertyChange("LINEAR_TRANSFORM_PROPERTY", null, evt.getNewValue());
                RegistrationViewer.this.refreshViewports();
            }
        });
        this.foregroundVolumeModel = new J3DVolumeModel(foregroundVolume);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.foregroundViewports[i2].setVolumeModel(this.foregroundVolumeModel);
            Fusion3DCapable f3d = (Fusion3DCapable)this.fusionViewports[i2].getCapable(Fusion3DCapable.class.getCanonicalName());
            if (f3d.getNumVolumeLayers() > 1) {
                f3d.removeVolumeLayer(1);
            }
            if (this.backgroundVolumeModel == null) continue;
            f3d.addVolumeLayer(this.foregroundVolumeModel);
        }
        this.initMouseControllers();
        if (this.backgroundVolumeModel != null) {
            this.resetViews();
        }
    }

    protected void initUI() {
        this.initViewports();
        this.initPixelCombiner();
    }

    protected void initViewports() {
        this.setLayout(new GridLayout(3, 3));
        this.backgroundViewports = new T3DViewport[3];
        this.foregroundViewports = new T3DViewport[3];
        this.fusionViewports = new T3DViewport[3];
        this.viewports = new T3DViewport[9];
        int allIndex = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            this.backgroundViewports[i2] = new T3DViewport();
            this.foregroundViewports[i2] = new T3DViewport();
            this.fusionViewports[i2] = new T3DViewport();
            this.add(this.backgroundViewports[i2]);
            this.add(this.foregroundViewports[i2]);
            this.add(this.fusionViewports[i2]);
            this.viewports[allIndex++] = this.backgroundViewports[i2];
            this.viewports[allIndex++] = this.foregroundViewports[i2];
            this.viewports[allIndex++] = this.fusionViewports[i2];
        }
        this.syncWindowLevel();
        this.syncViewportCameras();
    }

    protected void syncWindowLevel() {
        int i2;
        WindowLevelListener wlListener = new WindowLevelListener(0);
        for (i2 = 0; i2 < 3; ++i2) {
            this.backgroundViewports[i2].addPropertyChangeListener("winMin", wlListener);
            this.backgroundViewports[i2].addPropertyChangeListener("winMax", wlListener);
        }
        wlListener = new WindowLevelListener(1);
        for (i2 = 0; i2 < 3; ++i2) {
            this.foregroundViewports[i2].addPropertyChangeListener("winMin", wlListener);
            this.foregroundViewports[i2].addPropertyChangeListener("winMax", wlListener);
        }
        wlListener = new WindowLevelListener(2);
        for (i2 = 0; i2 < 3; ++i2) {
            this.fusionViewports[i2].addPropertyChangeListener("winMin", wlListener);
            this.fusionViewports[i2].addPropertyChangeListener("winMax", wlListener);
        }
    }

    protected void syncViewportCameras() {
        for (int i2 = 0; i2 < 3; ++i2) {
            CameraListener cameraListener = new CameraListener(i2);
            this.backgroundViewports[i2].addPropertyChangeListener("camera", cameraListener);
            this.foregroundViewports[i2].addPropertyChangeListener("camera", cameraListener);
            this.fusionViewports[i2].addPropertyChangeListener("camera", cameraListener);
            this.backgroundViewports[i2].addPropertyChangeListener("viewHeight", cameraListener);
            this.foregroundViewports[i2].addPropertyChangeListener("viewHeight", cameraListener);
            this.fusionViewports[i2].addPropertyChangeListener("viewHeight", cameraListener);
        }
    }

    protected void setViewportCamera(int viewportRowIndex, double[] eyepoint, double[] lookpoint, double[] up) {
        this.backgroundViewports[viewportRowIndex].setCamera(eyepoint, lookpoint, up);
        this.foregroundViewports[viewportRowIndex].setCamera(eyepoint, lookpoint, up);
        this.fusionViewports[viewportRowIndex].setCamera(eyepoint, lookpoint, up);
        this.repaint();
    }

    protected void setViewHeight(int viewportRowIndex, double viewHeight) {
        this.backgroundViewports[viewportRowIndex].setViewHeight(viewHeight);
        this.foregroundViewports[viewportRowIndex].setViewHeight(viewHeight);
        this.fusionViewports[viewportRowIndex].setViewHeight(viewHeight);
        this.repaint();
    }

    protected void initMouseControllers() {
        for (int i2 = 0; i2 < 3; ++i2) {
            RegistrationMouseController mc = new RegistrationMouseController(this.foregroundTransformCapable);
            this.foregroundViewports[i2].setMouseController(mc);
            RegistrationMouseController mc2 = new RegistrationMouseController(this.foregroundTransformCapable);
            this.fusionViewports[i2].setMouseController(mc2);
        }
    }

    protected void initPixelCombiner() {
        DefaultPixelCombiner pc = new DefaultPixelCombiner();
        for (int i2 = 0; i2 < this.fusionViewports.length; ++i2) {
            Fusion3DCapable f3d = (Fusion3DCapable)this.fusionViewports[i2].getCapable("com.ge.med.idc.Fusion3DCapable");
            f3d.setPixelCombiner(pc);
        }
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public void setCursorVisible(boolean cursorVisible) {
        this.cursorVisible = cursorVisible;
        if (this.cursors != null) {
            for (int i2 = 0; i2 < this.cursors.length; ++i2) {
                this.cursors[i2].setVisible(cursorVisible);
            }
        }
        this.repaint();
    }

    protected void calculateVolumeGeometry() {
        XjVolumeInfo volume = this.backgroundVolumeModel.getVolume();
        volume.getVolumeDimensions(this.dims);
        volume.getRASOfOrigin(this.rasOrigin);
        volume.getXDirectionRAS(this.dx);
        volume.getYDirectionRAS(this.dy);
        volume.getZDirectionRAS(this.dz);
        this.worldAxis[0] = this.dx[0] * (double)(this.dims[0] - 1) + this.dy[0] * (double)(this.dims[1] - 1) + this.dz[0] * (double)(this.dims[2] - 1);
        this.worldAxis[1] = this.dx[1] * (double)(this.dims[0] - 1) + this.dy[1] * (double)(this.dims[1] - 1) + this.dz[1] * (double)(this.dims[2] - 1);
        this.worldAxis[2] = this.dx[2] * (double)(this.dims[0] - 1) + this.dy[2] * (double)(this.dims[1] - 1) + this.dz[2] * (double)(this.dims[2] - 1);
        this.worldCenter[0] = this.rasOrigin[0] + this.worldAxis[0] / 2.0;
        this.worldCenter[1] = this.rasOrigin[1] + this.worldAxis[1] / 2.0;
        this.worldCenter[2] = this.rasOrigin[2] + this.worldAxis[2] / 2.0;
        if (this.cursorModel == null) {
            this.cursorModel = new DefaultCursor3DModel();
            this.cursors = new Cursor3DVc[this.viewports.length];
            for (int i2 = 0; i2 < this.viewports.length; ++i2) {
                Cursor3DVc cursorVc = new Cursor3DVc(this.cursorModel, this.viewports[i2]);
                cursorVc.setName("Cursor3DVc");
                cursorVc.setAutoPage(true);
                cursorVc.setContinuousUpdateEnabled(true);
                cursorVc.setVisible(this.cursorVisible);
                cursorVc.setCursorShape(Cursor3DVc.X_SHAPE);
                this.viewports[i2].getT3DComponent().add(cursorVc);
                this.cursors[i2] = cursorVc;
            }
        }
    }

    public void resetViews() {
        JnVector3d[] viewVectors = new JnVector3d[]{ViewResetAction.I_VECTOR, ViewResetAction.A_VECTOR, ViewResetAction.L_VECTOR};
        JnVector3d[] upVectors = new JnVector3d[]{ViewResetAction.I_UP_VECTOR, ViewResetAction.A_UP_VECTOR, ViewResetAction.L_UP_VECTOR};
        double[] viewHeights = new double[]{Math.max(Math.abs(this.worldAxis[0]), Math.abs(this.worldAxis[1])), Math.max(Math.abs(this.worldAxis[0]), Math.abs(this.worldAxis[2])), Math.max(Math.abs(this.worldAxis[1]), Math.abs(this.worldAxis[2]))};
        double[] eye = new double[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            this.backgroundViewports[i2].setRenderStyle("REFORMAT");
            this.foregroundViewports[i2].setRenderStyle("REFORMAT");
            this.fusionViewports[i2].setRenderStyle("REFORMAT");
            this.setViewHeight(i2, viewHeights[i2]);
            JnVector3d viewVector = viewVectors[i2];
            eye[0] = this.worldCenter[0] - viewVector.x;
            eye[1] = this.worldCenter[1] - viewVector.y;
            eye[2] = this.worldCenter[2] - viewVector.z;
            double[] up = upVectors[i2].generateArray();
            this.setViewportCamera(i2, eye, this.worldCenter, up);
        }
        this.cursorModel.setPoint(new CPoint(this.worldCenter[0], this.worldCenter[1], this.worldCenter[2], 2));
    }

    public void resetTransform() {
        double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.setLinearTransform(identity);
    }

    @Override
    public void setLinearTransform(double[] transform) {
        this.foregroundTransformCapable.setLinearTransform(transform);
        this.refreshViewports();
    }

    @Override
    public double[] getLinearTransform(double[] transform) {
        return this.foregroundTransformCapable.getLinearTransform(transform);
    }

    public void refreshViewports() {
        for (int i2 = 0; i2 < this.viewports.length; ++i2) {
            this.viewports[i2].refreshContents();
        }
        this.repaint();
    }

    public void setBackgroundColorMap(int[] colorMap) {
        for (int i2 = 0; i2 < 3; ++i2) {
            this.backgroundViewports[i2].setColorMap(colorMap);
            Fusion3DCapable f3d = (Fusion3DCapable)this.fusionViewports[i2].getCapable(Fusion3DCapable.class.getCanonicalName());
            if (f3d.getNumVolumeLayers() <= 1) continue;
            int storedVolumeLayer = f3d.getVolumeLayer();
            f3d.selectVolumeLayer(0);
            this.fusionViewports[i2].setColorMap(colorMap);
            f3d.selectVolumeLayer(storedVolumeLayer);
        }
    }

    public void setForegroundColorMap(int[] colorMap) {
        for (int i2 = 0; i2 < 3; ++i2) {
            this.foregroundViewports[i2].setColorMap(colorMap);
            Fusion3DCapable f3d = (Fusion3DCapable)this.fusionViewports[i2].getCapable(Fusion3DCapable.class.getCanonicalName());
            if (f3d.getNumVolumeLayers() <= 1) continue;
            int storedVolumeLayer = f3d.getVolumeLayer();
            f3d.selectVolumeLayer(1);
            this.fusionViewports[i2].setColorMap(colorMap);
            f3d.selectVolumeLayer(storedVolumeLayer);
        }
    }

    public static void main(String[] args) {
        XjVolumeInfo bgVol = RegistrationViewer.loadVolume(args[0]);
        J3DVolumeModel bgVolModel = new J3DVolumeModel(bgVol);
        XjVolumeInfo fgVol = RegistrationViewer.loadVolume(args[1]);
        RegistrationViewer viewer = new RegistrationViewer();
        viewer.setBackgroundVolumeModel(bgVolModel);
        viewer.setForegroundVolume(fgVol);
        JCheckBox cursorCheckBox = new JCheckBox("Cursor Visible");
        cursorCheckBox.addActionListener(new DemoActionListener(viewer, 1));
        cursorCheckBox.setSelected(viewer.isCursorVisible());
        JButton resetViewsButton = new JButton("Reset Views");
        resetViewsButton.addActionListener(new DemoActionListener(viewer, 2));
        JButton resetTransformButton = new JButton("Reset Transform");
        resetTransformButton.addActionListener(new DemoActionListener(viewer, 3));
        String instructions = "<html><p>To adjust the registration transform, hold SHIFT and then drag with:<br><li>Left Mouse Button: Rotate<br><li>Middle Mouse Button: Scale<br><li>Right Mouse Button: Pan</html>";
        JLabel instructionsLabel = new JLabel(instructions);
        JPanel controlPanel = new JPanel();
        controlPanel.add(cursorCheckBox);
        controlPanel.add(resetViewsButton);
        controlPanel.add(resetTransformButton);
        controlPanel.add(instructionsLabel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)viewer, "Center");
        mainPanel.add((Component)controlPanel, "South");
        mainPanel.setPreferredSize(new Dimension(1000, 1000));
        viewer.addPropertyChangeListener("LINEAR_TRANSFORM_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        JFrame frame = new JFrame("RegistrationViewer");
        frame.setLocation(70, 40);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(mainPanel);
        frame.pack();
        frame.setVisible(true);
    }

    private static XjVolumeInfo loadVolume(String volpath) {
        DMSession dms = new DMSession(new String[]{"file", volpath});
        DMObject[] dmo = dms.getRelated("series");
        return DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
    }

    private static class DemoActionListener
    implements ActionListener {
        public static final int CURSOR_VISIBLE = 1;
        public static final int RESET_VIEWS = 2;
        public static final int RESET_TRANSFORM = 3;
        private RegistrationViewer viewer = null;
        private int mode;

        public DemoActionListener(RegistrationViewer viewer, int mode) {
            this.viewer = viewer;
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            switch (this.mode) {
                case 1: {
                    this.viewer.setCursorVisible(((JCheckBox)e2.getSource()).isSelected());
                    break;
                }
                case 2: {
                    this.viewer.resetViews();
                    break;
                }
                case 3: {
                    this.viewer.resetTransform();
                }
            }
        }
    }

    protected class WindowLevelListener
    implements PropertyChangeListener {
        public static final int BACKGROUND = 0;
        public static final int FOREGROUND = 1;
        public static final int FUSION = 2;
        protected int viewportType = 0;

        public WindowLevelListener(int listeningViewport) {
            this.viewportType = listeningViewport;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int layer;
            T3DViewport[] basicViewports;
            WindowLevelCapable wlc = (WindowLevelCapable)evt.getSource();
            double min = wlc.getWinMin();
            double max = wlc.getWinMax();
            if (this.viewportType == 0) {
                basicViewports = RegistrationViewer.this.backgroundViewports;
                layer = 0;
            } else if (this.viewportType == 1) {
                basicViewports = RegistrationViewer.this.foregroundViewports;
                layer = 1;
            } else {
                Fusion3DCapable fc = (Fusion3DCapable)((T3DViewport)evt.getSource()).getCapable(Fusion3DCapable.class.getCanonicalName());
                layer = fc.getVolumeLayer();
                basicViewports = layer == 0 ? RegistrationViewer.this.backgroundViewports : RegistrationViewer.this.foregroundViewports;
            }
            if (!syncWL) {
                syncWL = true;
                for (int i2 = 0; i2 < basicViewports.length; ++i2) {
                    basicViewports[i2].setWinMinMax(min, max);
                }
                syncWL = false;
            }
            for (int i3 = 0; i3 < RegistrationViewer.this.fusionViewports.length; ++i3) {
                Fusion3DCapable fc = (Fusion3DCapable)RegistrationViewer.this.fusionViewports[i3].getCapable(Fusion3DCapable.class.getCanonicalName());
                int savedLayer = fc.getVolumeLayer();
                fc.selectVolumeLayer(layer);
                RegistrationViewer.this.fusionViewports[i3].setWinMinMax(min, max);
                fc.selectVolumeLayer(savedLayer);
            }
            RegistrationViewer.this.refreshViewports();
        }
    }

    public static class DefaultPixelCombiner
    implements XjFusionPixelCombiner {
        protected static final int SHIFT = 12;
        protected static final int SCALE = 4096;
        protected double alpha = 0.5;

        public void setAlpha(double alpha) {
            this.alpha = alpha;
        }

        @Override
        public void blendRGB(int[][] pixels, int width, int height, int[] result) {
            int ialpha = (int)(this.alpha * 4096.0);
            int len = width * height;
            int D = 4096 - ialpha;
            for (int i2 = 0; i2 < len; ++i2) {
                int pixel1 = pixels[0][i2];
                int pixel2 = pixels[1][i2];
                if (pixel2 == -16777216) {
                    result[i2] = pixel1;
                    continue;
                }
                int bval1 = pixel1 & 0xFF;
                int gval1 = (pixel1 & 0xFF00) >> 8;
                int rval1 = (pixel1 & 0xFF0000) >> 16;
                int bval2 = pixel2 & 0xFF;
                int gval2 = (pixel2 & 0xFF00) >> 8;
                int rval2 = (pixel2 & 0xFF0000) >> 16;
                int rval = rval2 * ialpha + rval1 * D >> 12;
                int gval = gval2 * ialpha + gval1 * D >> 12;
                int bval = bval2 * ialpha + bval1 * D >> 12;
                result[i2] = 0xFF000000 | rval << 16 | gval << 8 | bval;
            }
        }
    }

    protected class CameraListener
    implements PropertyChangeListener {
        protected int viewportRowIndex;
        protected double[] eyepoint = new double[3];
        protected double[] lookpoint = new double[3];
        protected double[] up = new double[3];

        public CameraListener(int viewportRowIndex) {
            this.viewportRowIndex = viewportRowIndex;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            T3DCapable t3d = (T3DCapable)evt.getSource();
            if (evt.getPropertyName().equals("camera")) {
                t3d.getEyePoint(this.eyepoint);
                t3d.getLookPoint(this.lookpoint);
                t3d.getUp(this.up);
                RegistrationViewer.this.setViewportCamera(this.viewportRowIndex, this.eyepoint, this.lookpoint, this.up);
            } else if (evt.getPropertyName().equals("viewHeight")) {
                double viewHeight = t3d.getViewHeight();
                RegistrationViewer.this.setViewHeight(this.viewportRowIndex, viewHeight);
            }
        }
    }
}

