/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.registration;

import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class RotateTransformMouseController
extends MouseInputAdapter
implements XpMouseController {
    protected int prevX;
    protected T3DCapable t3d;
    protected double[] lookPoint = new double[3];
    protected double[] eyePoint = new double[3];
    protected double[] transformArray = new double[16];
    protected JnMatrix4d transform = new JnMatrix4d();
    protected JnMatrix4d rotateTransform = new JnMatrix4d();
    protected LinearTransformable transformObject = null;

    public void setLinearTransformable(LinearTransformable transformObject) {
        this.transformObject = transformObject;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.t3d == null) {
            return;
        }
        int x2 = e2.getX();
        double angle = (double)(180 * (this.prevX - x2)) * 1.0 / (double)e2.getComponent().getWidth();
        angle = Math.toRadians(angle);
        this.t3d.getLookPoint(this.lookPoint);
        this.t3d.getEyePoint(this.eyePoint);
        this.transformObject.getLinearTransform(this.transformArray);
        this.transform.set(this.transformArray);
        this.transform.translate(-this.lookPoint[0], -this.lookPoint[1], -this.lookPoint[2]);
        this.rotateTransform.setRotate(angle, this.eyePoint[0] - this.lookPoint[0], this.eyePoint[1] - this.lookPoint[1], this.eyePoint[2] - this.lookPoint[2]);
        this.transform.mul(this.rotateTransform);
        this.transform.translate(this.lookPoint[0], this.lookPoint[1], this.lookPoint[2]);
        this.transform.get(this.transformArray);
        this.transformObject.setLinearTransform(this.transformArray);
        this.t3d.repaint();
        this.prevX = x2;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.prevX = e2.getX();
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof T3DCapable) {
            this.t3d = (T3DCapable)((Object)jc);
        }
    }
}

