/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.remote;

import com.ge.med.idc.XjChangeListener;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;

public class RmVolumeModel
implements XjVolumeModel,
XpDicomObject {
    private XjVolumeInfo rm_vol = null;
    private JnMatrix4d vox2ras = new JnMatrix4d();
    private JnMatrix4d ras2vox = new JnMatrix4d();
    private int rmvolmodelId = -1;
    private List listeners = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Hashtable ht = new Hashtable();

    public RmVolumeModel(XjVolumeInfo rm_vol, int rmvolId) {
        this.rm_vol = rm_vol;
        XjVolumeUtils.calculateVoxelRASTransform((XjVolumeGeometry)this.rm_vol, this.vox2ras, this.ras2vox);
        this.rmvolmodelId = rmvolId;
    }

    public int getVolModelId() {
        return this.rmvolmodelId;
    }

    @Override
    public XjVolumeInfo getVolume() {
        return this.rm_vol;
    }

    @Override
    public void voxelsChanged() {
        this.pcs.firePropertyChange("VOXELS_PROPERTY", null, this.rm_vol);
    }

    @Override
    public void addChangeListener(XjChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    @Override
    public void removeChangeListener(XjChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void notifyChangeListeners() {
        int len = this.listeners.size();
        EventObject ce = new EventObject(this);
        for (int i2 = 0; i2 < len; ++i2) {
            XjChangeListener cl = (XjChangeListener)this.listeners.get(i2);
            cl.stateChanged(ce);
        }
    }

    public JnMatrix4d getVoxel2RASTransform() {
        return this.vox2ras;
    }

    public JnMatrix4d getRAS2VoxelTransform() {
        return this.ras2vox;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(l2);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(l2);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.removePropertyChangeListener(prop, l2);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l2) {
        this.pcs.addPropertyChangeListener(prop, l2);
    }

    @Override
    public void putClientProperty(Object key, Object value) {
        if (value == null) {
            this.ht.remove(key);
        } else {
            this.ht.put(key, value);
        }
    }

    @Override
    public Object getClientProperty(Object key) {
        return this.ht.get(key);
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        int notLoaded = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            int result = this.getValue(values[i2]);
            if (result != 1) continue;
            ++notLoaded;
        }
        return notLoaded;
    }

    @Override
    public int getValue(XpDicomElement value) {
        Object val = this.rm_vol.getValue(value.group, value.element);
        if (val != null) {
            value.value = val;
            return 0;
        }
        return 1;
    }
}

