/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.surface;

import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnTupleArrayFloat;
import com.ge.med.jnu.JnTupleArrayInt;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.surface.JnSurface;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.surface.TriangleRasterizer;
import java.util.Arrays;

public class SurfaceRenderer {
    public static final float AMBIENT_LIGHT = 0.4f;
    public static final float DIRECTIONAL_LIGHT = 0.2f;
    private XjVolumeModel vol;
    private String shadingMode = "shading_volume";
    private JnSurface surface_;
    private byte alpha = (byte)-1;
    private int rgb = 65793;

    public static final float vec3Len(float[] v2) {
        return v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2];
    }

    public SurfaceRenderer() {
        this(null);
    }

    public SurfaceRenderer(XjVolumeModel vol) {
        this.vol = vol;
    }

    public void render(int[] rgb_outbuffer, float[] zbuffer, int bufw, int bufh, int x0, int y0, int width, int height, double[] ras2display, double[] display2vol, int thread_id) {
        JnSurface surface;
        if (this.vol == null && "shading_volume".equals(this.shadingMode)) {
            return;
        }
        Object object = this.surface_ == null ? (this.vol != null ? (JnSurface)this.vol.getClientProperty("surface") : null) : (surface = this.surface_);
        if (surface == null) {
            return;
        }
        JnTupleArrayInt triangles = surface.getTriangles();
        int ntriangles = triangles.getNumTuples();
        JnTupleArrayFloat normals = surface.getPointNormals();
        JnTupleArrayFloat trianglePts = surface.getPoints();
        float[] pt1 = new float[3];
        float[] pt2 = new float[3];
        float[] pt3 = new float[3];
        float[] norm1 = new float[3];
        float[] norm2 = new float[3];
        float[] norm3 = new float[3];
        float[] normbuff = null;
        if ("shading_gouraud".equals(this.shadingMode)) {
            normbuff = new float[bufw * bufh * 3];
        }
        int yy = y0;
        int off = y0 * bufw;
        while (yy < y0 + height) {
            for (int xx = x0; xx < x0 + width; ++xx) {
                zbuffer[off + xx] = Float.MAX_VALUE;
            }
            ++yy;
            off += bufw;
        }
        if ("shading_gouraud".equals(this.shadingMode)) {
            Arrays.fill(normbuff, 0.0f);
        }
        int[] ptIndex = new int[3];
        for (int i2 = 0; i2 < ntriangles; ++i2) {
            triangles.get(i2, ptIndex);
            trianglePts.get(ptIndex[0], pt1);
            trianglePts.get(ptIndex[1], pt2);
            trianglePts.get(ptIndex[2], pt3);
            SurfaceRenderer.transform4_3(ras2display, pt1);
            SurfaceRenderer.transform4_3(ras2display, pt2);
            SurfaceRenderer.transform4_3(ras2display, pt3);
            if (SurfaceRenderer.backfacing(pt1, pt2, pt3)) continue;
            if ("shading_gouraud".equals(this.shadingMode)) {
                normals.get(ptIndex[0], norm1);
                normals.get(ptIndex[1], norm2);
                normals.get(ptIndex[2], norm3);
                SurfaceRenderer.transform4_3_0(ras2display, norm1);
                SurfaceRenderer.transform4_3_0(ras2display, norm2);
                SurfaceRenderer.transform4_3_0(ras2display, norm3);
            }
            int xmin = (int)pt1[0];
            int ymin = (int)pt1[1];
            int xmax = xmin;
            int ymax = ymin;
            xmin = (int)Math.min((float)xmin, pt2[0]);
            xmin = (int)Math.min((float)xmin, pt3[0]);
            ymin = (int)Math.min((float)ymin, pt2[1]);
            ymin = (int)Math.min((float)ymin, pt3[1]);
            xmax = (int)Math.max((float)xmax, pt2[0]);
            xmax = (int)Math.max((float)xmax, pt3[0]);
            ymax = (int)Math.max((float)ymax, pt2[1]);
            ymax = (int)Math.max((float)ymax, pt3[1]);
            if (xmax < x0 || xmin > x0 + width || ymax < y0 || ymin > y0 + height) continue;
            if ("shading_gouraud".equals(this.shadingMode)) {
                if ((pt2[0] - pt1[0]) * (pt3[1] - pt1[1]) - (pt3[0] - pt1[0]) * (pt2[1] - pt1[1]) > 0.0f) {
                    TriangleRasterizer.triangleGouraud(zbuffer, normbuff, bufw, bufh, x0, y0, width, height, pt2[0], pt2[1], pt2[2], pt1[0], pt1[1], pt1[2], pt3[0], pt3[1], pt3[2], norm2[0], norm2[1], norm2[2], norm1[0], norm1[1], norm1[2], norm3[0], norm3[1], norm3[2]);
                    continue;
                }
                TriangleRasterizer.triangleGouraud(zbuffer, normbuff, bufw, bufh, x0, y0, width, height, pt1[0], pt1[1], pt1[2], pt2[0], pt2[1], pt2[2], pt3[0], pt3[1], pt3[2], norm1[0], norm1[1], norm1[2], norm2[0], norm2[1], norm2[2], norm3[0], norm3[1], norm3[2]);
                continue;
            }
            if (!"shading_volume".equals(this.shadingMode)) continue;
            if ((pt2[0] - pt1[0]) * (pt3[1] - pt1[1]) - (pt3[0] - pt1[0]) * (pt2[1] - pt1[1]) > 0.0f) {
                TriangleRasterizer.triangle(zbuffer, bufw, bufh, x0, y0, width, height, pt2[0], pt2[1], pt2[2], pt1[0], pt1[1], pt1[2], pt3[0], pt3[1], pt3[2]);
                continue;
            }
            TriangleRasterizer.triangle(zbuffer, bufw, bufh, x0, y0, width, height, pt1[0], pt1[1], pt1[2], pt2[0], pt2[1], pt2[2], pt3[0], pt3[1], pt3[2]);
        }
        int[] pix = rgb_outbuffer;
        JnVector3d volpt = new JnVector3d();
        int ind = y0 * bufw;
        JnMatrix4d disp2volM = new JnMatrix4d(display2vol);
        int[] dims = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        J3DVolumeModel vm = (J3DVolumeModel)this.vol;
        dims = vm.getVolume().getVolumeDimensions(null);
        short[] voldata = (short[])vm.getJVolume().getVolumeData();
        int row = y0;
        while (row < y0 + height) {
            for (int col = x0; col < x0 + width; ++col) {
                if (zbuffer[ind + col] >= Float.MAX_VALUE) {
                    pix[ind + col] = 0;
                    continue;
                }
                volpt.x = col;
                volpt.y = row;
                volpt.z = zbuffer[ind + col];
                disp2volM.transform(volpt);
                if (volpt.x < 0.0 || volpt.x >= (double)dims[0] || volpt.y < 0.0 || volpt.y >= (double)dims[1] || volpt.z < 0.0 || volpt.z >= (double)dims[2]) {
                    pix[ind + col] = 0;
                    continue;
                }
                if ("shading_volume".equals(this.shadingMode)) {
                    int pad = vm.getJVolume().PAD;
                    float fx = (float)(volpt.x - (double)((int)volpt.x));
                    float fy = (float)(volpt.y - (double)((int)volpt.y));
                    float fz = (float)(volpt.z - (double)((int)volpt.z));
                    float _fx = 1.0f - fx;
                    float _fy = 1.0f - fy;
                    float _fz = 1.0f - fz;
                    int ix = (int)volpt.x;
                    int iz = (int)volpt.z;
                    int iy = (int)volpt.y;
                    int iy_0 = iy * dims[0];
                    int iy_down = (iy + 1) * dims[0];
                    int iy_downdown = (iy + 2) * dims[0];
                    int iy_up = (iy - 1) * dims[0];
                    int pg_size = dims[0] * dims[1];
                    int BASE_PG_1 = pad + iz * pg_size;
                    float v4 = voldata[BASE_PG_1 + iy_up + ix];
                    float v5 = voldata[BASE_PG_1 + iy_up + ix + 1];
                    float v6 = voldata[BASE_PG_1 + iy_0 + ix - 1];
                    float v7 = voldata[BASE_PG_1 + iy_0 + ix];
                    float v8 = voldata[BASE_PG_1 + iy_0 + ix + 1];
                    float v9 = voldata[BASE_PG_1 + iy_0 + ix + 2];
                    float v10 = voldata[BASE_PG_1 + iy_down + ix - 1];
                    float v11 = voldata[BASE_PG_1 + iy_down + ix];
                    float v12 = voldata[BASE_PG_1 + iy_down + ix + 1];
                    float v13 = voldata[BASE_PG_1 + iy_down + ix + 2];
                    float v14 = voldata[BASE_PG_1 + iy_downdown + ix];
                    float v15 = voldata[BASE_PG_1 + iy_downdown + ix + 1];
                    int BASE_PG_2 = BASE_PG_1 + pg_size;
                    float v16 = voldata[BASE_PG_2 + iy_up + ix];
                    float v17 = voldata[BASE_PG_2 + iy_up + ix + 1];
                    float v18 = voldata[BASE_PG_2 + iy_0 + ix - 1];
                    float v19 = voldata[BASE_PG_2 + iy_0 + ix];
                    float v20 = voldata[BASE_PG_2 + iy_0 + ix + 1];
                    float v21 = voldata[BASE_PG_2 + iy_0 + ix + 2];
                    float v22 = voldata[BASE_PG_2 + iy_down + ix - 1];
                    float v23 = voldata[BASE_PG_2 + iy_down + ix];
                    float v24 = voldata[BASE_PG_2 + iy_down + ix + 1];
                    float val = SurfaceRenderer.trilinearf(v7, v8, v11, v12, v19, v20, v23, v24, fx, fy, fz, _fx, _fy, _fz);
                    int dt = (int)val;
                    if ((dt /= 3) <= 0) {
                        dt = 0;
                    }
                    if (dt > 255) {
                        dt = 255;
                    }
                    int r2 = dt;
                    pix[ind + col] = this.rgb * r2 | this.alpha << 24;
                    continue;
                }
                double DOT = -(normbuff[(ind + col) * 3] * 1.0f + normbuff[(ind + col) * 3 + 1] * 1.0f + 0.0f);
                double lightval = (double)0.4f + (double)0.2f * DOT / Math.sqrt(normbuff[(ind + col) * 3] * normbuff[(ind + col) * 3] + normbuff[(ind + col) * 3 + 1] * normbuff[(ind + col) * 3 + 1] + normbuff[(ind + col) * 3 + 2] * normbuff[(ind + col) * 3 + 2]);
                int r3 = (int)(lightval * 255.0);
                if (r3 < 0) {
                    r3 = 0;
                }
                if (r3 > 255) {
                    r3 = 255;
                }
                pix[ind + col] = this.rgb * r3 | this.alpha << 24;
            }
            ++row;
            ind += bufw;
        }
    }

    public static boolean backfacing(float[] pt1, float[] pt2, float[] pt3) {
        float x1 = pt2[0] - pt1[0];
        float y2 = pt3[1] - pt2[1];
        float y1 = pt2[1] - pt1[1];
        float x2 = pt3[0] - pt2[0];
        float rz = x1 * y2 - y1 * x2;
        return rz > 0.0f;
    }

    private static float trilinearf(float v000, float v100, float v010, float v110, float v001, float v101, float v011, float v111, float fx, float fy, float fz, float _fx, float _fy, float _fz) {
        float px1 = v000 * _fx + v100 * fx;
        float px2 = v010 * _fx + v110 * fx;
        float py1 = px1 * _fy + px2 * fy;
        px1 = v001 * _fx + v101 * fx;
        px2 = v011 * _fx + v111 * fx;
        float py2 = px1 * _fy + px2 * fy;
        return py1 * _fz + py2 * fz;
    }

    public static final void transform4_3(double[] matrix, float[] pt) {
        double x2 = matrix[0] * (double)pt[0] + matrix[1] * (double)pt[1] + matrix[2] * (double)pt[2] + matrix[3];
        double y2 = matrix[4] * (double)pt[0] + matrix[5] * (double)pt[1] + matrix[6] * (double)pt[2] + matrix[7];
        double z2 = matrix[8] * (double)pt[0] + matrix[9] * (double)pt[1] + matrix[10] * (double)pt[2] + matrix[11];
        pt[0] = (float)x2;
        pt[1] = (float)y2;
        pt[2] = (float)z2;
    }

    public static final void transform4_3_0(double[] matrix, float[] pt) {
        double x2 = matrix[0] * (double)pt[0] + matrix[1] * (double)pt[1] + matrix[2] * (double)pt[2];
        double y2 = matrix[4] * (double)pt[0] + matrix[5] * (double)pt[1] + matrix[6] * (double)pt[2];
        double z2 = matrix[8] * (double)pt[0] + matrix[9] * (double)pt[1] + matrix[10] * (double)pt[2];
        pt[0] = (float)x2;
        pt[1] = (float)y2;
        pt[2] = (float)z2;
    }

    public void setVolumeModel(J3DVolumeModel j3dvm) {
        this.vol = j3dvm;
    }

    public void setShadingMode(String mode) {
        this.shadingMode = mode;
    }

    public void setSurface(JnSurface surface) {
        this.surface_ = surface;
    }

    public void setAlpha(byte alpha) {
        this.alpha = alpha;
    }

    public void setRGB(int rgb) {
        this.rgb = rgb;
    }
}

