/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.surface;

import com.ge.med.idc.XjVolume;
import com.ge.med.jnu.JnTupleArrayFloat;
import com.ge.med.jnu.JnTupleArrayInt;
import com.ge.med.jnu.surface.JnSurface;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.capable.SurfaceRenderingCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.SurfaceVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.XjVolumeUtils;
import com.ge.med.terra.jami.j3d.surface.RectSubVolumeRayTracer;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SurfaceSWRenderingDemo
extends JPanel {
    T3DViewport left_ = new T3DViewport();
    T3DViewport right_ = new T3DViewport();
    JCheckBox vcCheck_ = new JCheckBox("VC", true);
    SurfaceVc vc = new SurfaceVc();
    JSlider alphaSlider = new JSlider(0, 255);
    JCheckBox useDepthCheck_ = new JCheckBox("Use depth buffer");
    JRadioButton depthRadio = new JRadioButton("Use Depth Buffer", false);
    JRadioButton blendRadio = new JRadioButton("Alpha-blend", true);
    JRadioButton volumeRadio = new JRadioButton("Volume", true);
    JRadioButton gouraudRadio = new JRadioButton("Gouraud", false);

    public SurfaceSWRenderingDemo(String[] args) {
        this.setLayout(new BorderLayout());
        JPanel vp = new JPanel(new GridLayout(1, 2, 2, 0));
        vp.add(this.left_);
        vp.add(this.right_);
        this.add(vp);
        JPanel cp = new JPanel();
        cp.add(this.vcCheck_);
        cp.add(new JLabel("Shading Mode:"));
        cp.add(this.volumeRadio);
        cp.add(this.gouraudRadio);
        cp.add(new JLabel("Combine Mode:"));
        cp.add(this.depthRadio);
        cp.add(this.blendRadio);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.depthRadio);
        bg.add(this.blendRadio);
        bg = new ButtonGroup();
        bg.add(this.volumeRadio);
        bg.add(this.gouraudRadio);
        cp.add(new JLabel(" alpha: "));
        cp.add(this.alphaSlider);
        this.add((Component)cp, "South");
        this.vcCheck_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SurfaceSWRenderingDemo.this.vc.setVisible(SurfaceSWRenderingDemo.this.vcCheck_.isSelected());
                SurfaceSWRenderingDemo.this.left_.refreshContents();
            }
        });
        this.left_.setPreferredSize(new Dimension(512, 512));
        this.right_.setPreferredSize(new Dimension(512, 512));
        XjVolume vol = SurfaceSWRenderingDemo.loadVolume(args[0]);
        if (vol != null) {
            this.left_.setVolume(vol);
            this.left_.setRenderStyle("VOLUME");
            VrCapable vrc = (VrCapable)this.left_.getCapable(VrCapable.class.getCanonicalName());
            vrc.setRayTracer(new RectSubVolumeRayTracer());
            this.right_.setVolumeModel(this.left_.getVolumeModel());
        }
        this.depthRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SurfaceSWRenderingDemo.this.updateButtonAppearance();
                if (SurfaceSWRenderingDemo.this.depthRadio.isSelected()) {
                    SurfaceSWRenderingDemo.this.vc.setCombineMode(1);
                }
            }
        });
        this.blendRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SurfaceSWRenderingDemo.this.updateButtonAppearance();
                if (SurfaceSWRenderingDemo.this.blendRadio.isSelected()) {
                    SurfaceSWRenderingDemo.this.vc.setCombineMode(0);
                }
            }
        });
        this.volumeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SurfaceRenderingCapable src;
                if (SurfaceSWRenderingDemo.this.volumeRadio.isSelected() && (src = (SurfaceRenderingCapable)((Object)SurfaceSWRenderingDemo.this.left_.getCapable("com.ge.med.terra.jami.capable.SurfaceRenderingCapable"))) != null) {
                    src.setSurfaceRenderAttribute("shading_mode", "shading_volume");
                    SurfaceSWRenderingDemo.this.left_.refreshContents();
                }
            }
        });
        this.gouraudRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SurfaceRenderingCapable src;
                if (SurfaceSWRenderingDemo.this.gouraudRadio.isSelected() && (src = (SurfaceRenderingCapable)((Object)SurfaceSWRenderingDemo.this.left_.getCapable("com.ge.med.terra.jami.capable.SurfaceRenderingCapable"))) != null) {
                    src.setSurfaceRenderAttribute("shading_mode", "shading_gouraud");
                    SurfaceSWRenderingDemo.this.left_.refreshContents();
                }
            }
        });
        double[] center = XjVolumeUtils.getVolumeCenterRAS(vol.getRASOfOrigin(null), vol.getXDirectionRAS(null), vol.getYDirectionRAS(null), vol.getZDirectionRAS(null), vol.getVolumeDimensions(null), null);
        DefaultCursor3DModel cursor = new DefaultCursor3DModel();
        cursor.setPoint(new CPoint(center, 2));
        Cursor3DVc vcl = new Cursor3DVc(cursor, this.left_.getT3DComponent());
        vcl.setContinuousUpdateEnabled(true);
        vcl.setAutoPage(true);
        this.left_.getT3DComponent().add(vcl);
        Cursor3DVc vcr = new Cursor3DVc(cursor, this.right_.getT3DComponent());
        vcr.setContinuousUpdateEnabled(true);
        vcr.setAutoPage(true);
        this.right_.getT3DComponent().add(vcr);
        this.vc.setVolumeModel((J3DVolumeModel)this.left_.getVolumeModel());
        this.left_.getT3DComponent().add(this.vc);
        this.vc.setVisible(this.vcCheck_.isSelected());
        this.vc.setRGB(65792);
        this.vc.setAlpha((byte)this.alphaSlider.getValue());
        try {
            this.vc.setSurface(SurfaceSWRenderingDemo.loadSurface("213mesh.txt"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.alphaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                SurfaceSWRenderingDemo.this.vc.setAlpha((byte)SurfaceSWRenderingDemo.this.alphaSlider.getValue());
                SurfaceSWRenderingDemo.this.vc.repaint();
            }
        });
    }

    protected void updateButtonAppearance() {
        this.alphaSlider.setEnabled(this.blendRadio.isSelected());
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        f2.setDefaultCloseOperation(3);
        f2.setContentPane(new SurfaceSWRenderingDemo(args));
        f2.pack();
        f2.setVisible(true);
    }

    public static XjVolume loadVolume(String path) {
        DMVolume volume = null;
        if (path != null) {
            long t2 = System.currentTimeMillis();
            DMSession dms = new DMSession("file", path, null);
            volume = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        }
        return volume;
    }

    public static JnSurface loadSurface(String filepath) throws IOException {
        float[] pts = SurfaceSWRenderingDemo.readPoints(filepath, null);
        double[] t2 = new double[3];
        int numPoints = pts.length / 3;
        JnSurface surf = new JnSurface();
        JnTupleArrayFloat trianglepts = new JnTupleArrayFloat(3, pts, numPoints);
        surf.setPoints(trianglepts);
        JnTupleArrayInt triangles = SurfaceSWRenderingDemo.loadTriangles();
        surf.setTriangles(triangles);
        System.out.println("Loaded " + triangles.getNumTuples() + " triangles in " + trianglepts.getNumTuples() + " pts");
        return surf;
    }

    private static JnTupleArrayInt loadTriangles() {
        int numTriangles = 20480;
        int[] triangleData = new int[numTriangles * 3];
        try {
            SurfaceSWRenderingDemo.readFaceTable(triangleData, numTriangles);
        }
        catch (IOException e2) {
            System.err.println("Error reading face table file.");
            e2.printStackTrace();
            throw new RuntimeException("Error reading face table file");
        }
        JnTupleArrayInt triangles = new JnTupleArrayInt(3, triangleData, numTriangles);
        return triangles;
    }

    public static void readFaceTable(int[] faces, int n_faces) throws IOException {
        System.out.println("Input face table ...");
        String dat_file = "faces.dat";
        BufferedReader reader = new BufferedReader(new InputStreamReader(SurfaceSWRenderingDemo.class.getResourceAsStream(dat_file)));
        for (int p2 = 0; p2 < n_faces; ++p2) {
            String line = reader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int x2 = Integer.parseInt(tokenizer.nextToken());
            int y2 = Integer.parseInt(tokenizer.nextToken());
            int z2 = Integer.parseInt(tokenizer.nextToken());
            faces[3 * p2] = x2;
            faces[3 * p2 + 1] = y2;
            faces[3 * p2 + 2] = z2;
        }
        reader.close();
    }

    public static float[] readPoints(String filepath, float[] points) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(SurfaceSWRenderingDemo.class.getResourceAsStream(filepath)));
        String line = reader.readLine();
        int numPoints = Integer.parseInt(line);
        if (points == null || points.length < numPoints * 3) {
            points = new float[numPoints * 3];
        }
        int index = 0;
        int i2 = 0;
        while (i2 < numPoints) {
            line = reader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            points[index] = Float.parseFloat(tokenizer.nextToken());
            points[index + 1] = Float.parseFloat(tokenizer.nextToken());
            points[index + 2] = Float.parseFloat(tokenizer.nextToken());
            ++i2;
            index += 3;
        }
        reader.close();
        return points;
    }
}

