/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPresetCurves;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class VrPreset {
    public static final String PRESET_PROPERTY = "PRESET_PROPERTY";
    public String name = "";
    public String modality = "";
    public double level = 0.0;
    public double width = 0.0;
    public String anatomy = "";
    public String comment = "";
    public String curvetype = "up";
    public int thresh1 = 0;
    public int thresh2 = 0;
    public double attenuation = 1.0;
    public double brightness = 0.0;
    private double contrast = 0.0;
    public String luttype = "ramp";
    public String enhancetype = "none";
    public boolean normalization = false;
    private boolean partialcomp = false;
    private boolean contourmode = false;
    private boolean docolor = false;
    public List colors = new ArrayList();
    public VrColorLut colorlut = null;
    public double[] opacity_lut = null;
    public double startOpacity = 0.0;
    public double deltaOpacity = 1.0;
    private InputStreamReader isr = null;
    private LineNumberReader lnr = null;
    private StringTokenizer st = null;
    private static final int externalVMin = 0;
    private static final int externalVMax = 32768;

    public VrPreset() {
        this.name = "PMV";
        this.modality = "CT";
        this.comment = "Default presets, gives good CT data views !!!";
        this.thresh1 = 103;
        this.thresh2 = 603;
        this.attenuation = 1.0;
        Color c0 = new Color(255.0, 150.0, 127.0, -179.0);
        Color c1 = new Color(169.0, 255.0, 250.0, 121.0);
        Color c2 = new Color(255.0, 78.0, 80.0, 146.0);
        Color c3 = new Color(255.0, 201.0, 113.0, 221.0);
        Color c4 = new Color(255.0, 254.0, 243.0, 452.0);
        this.colors.add(c0);
        this.colors.add(c1);
        this.colors.add(c2);
        this.colors.add(c3);
        this.colors.add(c4);
        this.buildModalityTables();
    }

    public VrPreset(VrPreset preset) {
        this.name = preset.name;
        this.modality = preset.modality;
        this.comment = preset.comment;
        this.thresh1 = preset.thresh1;
        this.thresh2 = preset.thresh2;
        this.attenuation = preset.attenuation;
        this.brightness = preset.brightness;
        this.startOpacity = preset.startOpacity;
        this.deltaOpacity = preset.deltaOpacity;
        this.contourmode = preset.contourmode;
        this.contrast = preset.contrast;
        this.normalization = preset.normalization;
        this.enhancetype = preset.enhancetype;
        this.curvetype = preset.curvetype;
        this.luttype = preset.luttype;
        this.opacity_lut = new double[preset.opacity_lut.length];
        System.arraycopy(preset.opacity_lut, 0, this.opacity_lut, 0, preset.opacity_lut.length);
        this.colorlut = (VrColorLut)preset.colorlut.clone();
    }

    public VrPreset(InputStream is) throws IOException {
        this.init(is);
    }

    public VrPreset(String fileName) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(fileName);
        this.init(fis);
    }

    public VrPreset(String modality, VrColorLut clut, double[] opacity, double startOpacity, double deltaOpacity) {
        this.modality = modality;
        this.opacity_lut = opacity;
        this.colorlut = clut;
        this.startOpacity = startOpacity;
        this.deltaOpacity = deltaOpacity;
        this.curvetype = "custom";
        this.luttype = "custom";
    }

    public Object clone() {
        return new VrPreset(this);
    }

    private void init(InputStream is) throws IOException {
        this.parseFile(is);
        this.buildModalityTables();
    }

    private void buildModalityTables() {
        this.opacity_lut = new double[40960];
        double[] clutarr = new double[122880];
        this.colorlut = new VrColorLut(clutarr, -4096.0, 1.0);
        this.startOpacity = -4096.0;
        this.deltaOpacity = 1.0;
        double max_opacity = this.attenuation;
        double norm_factor = 1.0;
        String t2 = this.curvetype.toUpperCase();
        if (t2.equals("UP")) {
            VrPresetCurves.build_opacity_up(max_opacity, this.thresh1, this.thresh2, norm_factor, this.opacity_lut);
        } else if (t2.equals("DOWN")) {
            VrPresetCurves.build_opacity_down(max_opacity, this.thresh1, this.thresh2, norm_factor, this.opacity_lut);
        } else if (t2.equals("BELL")) {
            VrPresetCurves.build_opacity_bell(max_opacity, this.thresh1, this.thresh2, norm_factor, this.opacity_lut);
        } else if (t2.equals("REVBELL")) {
            VrPresetCurves.build_opacity_reverse_bell(max_opacity, this.thresh1, this.thresh2, norm_factor, this.opacity_lut);
        }
        int ltype = 300;
        if (this.luttype.toLowerCase().equals("ramp")) {
            ltype = 301;
        }
        this.build_colortable(ltype, this.colors, this.colorlut.colorlut);
    }

    private void setSource(InputStream is) {
        this.isr = new InputStreamReader(is);
        this.lnr = new LineNumberReader(this.isr);
        try {
            String input = this.lnr.readLine();
            this.st = new StringTokenizer(input, " \t\n\r\f");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private String nextToken() {
        try {
            while (true) {
                if (this.st.hasMoreTokens()) {
                    String nextToken = this.st.nextToken();
                    return nextToken;
                }
                String input = this.lnr.readLine();
                if (input != null) {
                    this.st = new StringTokenizer(input, " \t\n\r\f");
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    private String readString(String val) throws IOException {
        String k2 = this.nextToken();
        if (k2 == null) {
            throw new IOException("VRP Parse Error: Unexpected EOF.");
        }
        if (!val.equals(k2)) {
            throw new IOException("VRP Parse Error: Expected [" + val + "] but got " + k2 + ".");
        }
        return val;
    }

    private String readStringPair(String key) throws IOException {
        String k2 = this.nextToken();
        String v2 = this.nextToken();
        if (k2 == null || v2 == null) {
            throw new IOException("VRP Parse Error: Unexpected EOF.");
        }
        if (!key.toLowerCase().equals(k2.toLowerCase())) {
            throw new IOException("VRP Parse Error: Expected [" + key + "] but got " + k2 + ".");
        }
        return v2;
    }

    private void parseFile(InputStream is) throws IOException {
        String token;
        this.setSource(is);
        this.name = this.readStringPair("name");
        this.readString("(");
        block0: while ((token = this.nextToken()) != null) {
            String bval;
            String val = token.toLowerCase();
            if (val.equals("modality")) {
                this.modality = this.nextToken();
                continue;
            }
            if (val.equals("comment")) {
                this.comment = this.nextToken();
                if (this.comment.equals("\"\"")) {
                    this.comment = "";
                    continue;
                }
                this.comment = this.comment.substring(1);
                while (!this.comment.endsWith("\"")) {
                    String item = " " + this.nextToken();
                    this.comment = this.comment + item;
                }
                this.comment = this.comment.substring(0, this.comment.length() - 2);
                continue;
            }
            if (val.equals("anatomy")) {
                this.anatomy = this.nextToken();
                continue;
            }
            if (val.equals("enhancetype")) {
                this.enhancetype = this.nextToken();
                continue;
            }
            if (val.equals("level")) {
                this.level = Double.parseDouble(this.nextToken());
                continue;
            }
            if (val.equals("width")) {
                this.width = Double.parseDouble(this.nextToken());
                continue;
            }
            if (val.equals("brightness")) {
                this.brightness = Double.parseDouble(this.nextToken());
                continue;
            }
            if (val.equals("contrast")) {
                this.contrast = Double.parseDouble(this.nextToken());
                continue;
            }
            if (val.equals("low")) {
                this.thresh1 = Integer.parseInt(this.nextToken());
                continue;
            }
            if (val.equals("high")) {
                this.thresh2 = Integer.parseInt(this.nextToken());
                continue;
            }
            if (val.equals("attenuation")) {
                this.attenuation = Double.parseDouble(this.nextToken());
                continue;
            }
            if (val.equals("curvetype")) {
                this.curvetype = this.nextToken();
                continue;
            }
            if (val.equals("luttype")) {
                this.luttype = this.nextToken();
                continue;
            }
            if (val.equals("normalization")) {
                bval = this.nextToken().toLowerCase();
                this.normalization = bval.equals("on");
                continue;
            }
            if (val.equals("partialcomp")) {
                bval = this.nextToken().toLowerCase();
                this.partialcomp = bval.equals("on");
                continue;
            }
            if (val.equals("contourmode")) {
                bval = this.nextToken().toLowerCase();
                this.contourmode = bval.equals("on");
                continue;
            }
            if (val.equals("color")) {
                bval = this.nextToken().toLowerCase();
                this.docolor = bval.equals("on");
                continue;
            }
            if (!val.equals("subcolor")) continue;
            this.readString("(");
            Color c2 = new Color();
            while (true) {
                String item;
                if ((item = this.nextToken().toLowerCase()).equals(")")) {
                    this.colors.add(c2);
                    continue block0;
                }
                if (item.equals("red")) {
                    c2.red = Double.parseDouble(this.nextToken());
                    continue;
                }
                if (item.equals("green")) {
                    c2.green = Double.parseDouble(this.nextToken());
                    continue;
                }
                if (item.equals("blue")) {
                    c2.blue = Double.parseDouble(this.nextToken());
                    continue;
                }
                if (item.equals("level")) {
                    c2.level = Double.parseDouble(this.nextToken());
                    continue;
                }
                if (item.equals("issubobj")) {
                    String valstr = this.nextToken().toLowerCase();
                    c2.issubobj = valstr.equals("on");
                    continue;
                }
                if (!item.equals("weight")) continue;
                c2.weight = Double.parseDouble(this.nextToken());
            }
        }
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        String str = "";
        str = str + "=======================================================\n";
        str = "VRPreset   = [" + this.name + "]\n";
        str = str + "=======================================================\n";
        str = str + "modality   =" + this.modality + "\n";
        str = str + "anatomy    =" + this.anatomy + "\n";
        str = str + "comment    =" + this.comment + "\n";
        str = str + "color      =" + this.docolor + "\n";
        str = str + "enhancetype=" + this.enhancetype + "\n";
        str = str + "curvetype  =" + this.curvetype + "\n";
        str = str + "threshold1 =" + this.thresh1 + "\n";
        str = str + "threshold2 =" + this.thresh2 + "\n";
        str = str + "attenuation=" + this.attenuation + "\n";
        str = str + "Level      =" + this.level + "\n";
        str = str + "Width      =" + this.width + "\n";
        str = str + "brightness =" + this.brightness + "\n";
        str = str + "contrast   =" + this.contrast + "\n";
        str = str + "luttype    =" + this.luttype + "\n";
        str = str + "normalize  =" + this.normalization + "\n";
        str = str + "partialcomp=" + this.partialcomp + "\n";
        str = str + "contourmode=" + this.contourmode + "\n";
        str = str + "Color Ranges\n-----------------\n";
        int len = this.colors.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Color c2 = (Color)this.colors.get(i2);
            str = str + "[" + i2 + "]: (" + c2.red + "," + c2.green + "," + "," + c2.blue + ")  level=" + c2.level + "\n";
        }
        str = str + "=======================================================\n";
        return str;
    }

    private void build_colortable(int lutType, List clist, double[] lutrgb) {
        int len = clist.size();
        Color cfirst = (Color)clist.get(0);
        Color clast = (Color)clist.get(len - 1);
        double firstlevel = cfirst.level;
        double lastlevel = clast.level;
        switch (lutType) {
            case 301: {
                for (int i2 = 0; i2 < 32768; ++i2) {
                    double r2 = 0.0;
                    double g2 = 0.0;
                    double b2 = 0.0;
                    boolean fill = false;
                    for (int j2 = 0; j2 < len - 1; ++j2) {
                        Color c1 = (Color)clist.get(j2);
                        Color c2 = (Color)clist.get(j2 + 1);
                        double level1 = c1.level;
                        double level2 = c2.level;
                        if (!((double)i2 >= level1) || !((double)i2 <= level2)) continue;
                        double k2 = ((double)i2 - level1) / (level2 - level1);
                        r2 = c1.red + k2 * (c2.red - c1.red);
                        g2 = c1.green + k2 * (c2.green - c1.green);
                        b2 = c1.blue + k2 * (c2.blue - c1.blue);
                        fill = true;
                        break;
                    }
                    if (!fill) {
                        if ((double)i2 <= firstlevel) {
                            r2 = cfirst.red;
                            g2 = cfirst.green;
                            b2 = cfirst.blue;
                        } else if ((double)i2 >= lastlevel) {
                            r2 = clast.red;
                            g2 = clast.green;
                            b2 = clast.blue;
                        }
                    }
                    int rgbidx = 3 * (i2 + 8192);
                    lutrgb[rgbidx] = r2 / 255.0;
                    lutrgb[rgbidx + 1] = g2 / 255.0;
                    lutrgb[rgbidx + 2] = b2 / 255.0;
                }
                break;
            }
            default: {
                System.out.println("*** Unrecognized lutType: " + lutType);
            }
        }
    }

    public int toBytes(byte[] buffer, int offset) {
        int i2;
        int writeOffset = offset;
        CodecUtils.putString(buffer, writeOffset, this.name);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.name), this.modality);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.modality), this.anatomy);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.anatomy), this.comment);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.comment), this.curvetype);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.curvetype), this.enhancetype);
        CodecUtils.putString(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.enhancetype), this.luttype);
        CodecUtils.putBoolean(buffer, writeOffset += CodecUtils.getStringLengthInBytes(this.luttype), this.normalization);
        CodecUtils.putBoolean(buffer, ++writeOffset, this.partialcomp);
        CodecUtils.putBoolean(buffer, ++writeOffset, this.contourmode);
        int color_len = this.colors.size();
        CodecUtils.putInt(buffer, ++writeOffset, color_len);
        writeOffset += 4;
        for (i2 = 0; i2 < color_len; ++i2) {
            Color c2 = (Color)this.colors.get(i2);
            CodecUtils.putFloat(buffer, writeOffset, (float)c2.red);
            CodecUtils.putFloat(buffer, writeOffset += 4, (float)c2.green);
            CodecUtils.putFloat(buffer, writeOffset += 4, (float)c2.blue);
            CodecUtils.putFloat(buffer, writeOffset += 4, (float)c2.level);
            writeOffset += 4;
        }
        CodecUtils.putFloat(buffer, writeOffset, (float)this.level);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.width);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.attenuation);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.brightness);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.contrast);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.deltaOpacity);
        CodecUtils.putFloat(buffer, writeOffset += 4, (float)this.startOpacity);
        CodecUtils.putInt(buffer, writeOffset += 4, this.thresh1);
        CodecUtils.putInt(buffer, writeOffset += 4, this.thresh2);
        CodecUtils.putInt(buffer, writeOffset += 4, this.opacity_lut.length);
        writeOffset += 4;
        for (i2 = 0; i2 < this.opacity_lut.length; ++i2) {
            CodecUtils.putFloat(buffer, writeOffset, (float)this.opacity_lut[i2]);
            writeOffset += 4;
        }
        writeOffset = this.colorlut.toBytes(buffer, writeOffset);
        return writeOffset;
    }

    public static Object createFromBytes(byte[] buffer, int offset, int[] length) {
        String luttype;
        int readOffset = offset;
        String name = CodecUtils.getString(buffer, readOffset);
        String modality = CodecUtils.getString(buffer, readOffset += CodecUtils.getStringLengthInBytes(name));
        String anatomy = CodecUtils.getString(buffer, readOffset += CodecUtils.getStringLengthInBytes(modality));
        String comment = CodecUtils.getString(buffer, readOffset += CodecUtils.getStringLengthInBytes(anatomy));
        String curvetype = CodecUtils.getString(buffer, readOffset += CodecUtils.getStringLengthInBytes(comment));
        String enhancetype = CodecUtils.getString(buffer, readOffset += CodecUtils.getStringLengthInBytes(curvetype));
        readOffset += CodecUtils.getStringLengthInBytes(enhancetype);
        boolean normalize = buffer[readOffset += CodecUtils.getStringLengthInBytes(luttype = CodecUtils.getString(buffer, readOffset))] != 0;
        boolean partialcomp = buffer[++readOffset] != 0;
        boolean contourmode = buffer[++readOffset] != 0;
        int color_len = CodecUtils.getInt(buffer, ++readOffset);
        readOffset += 4;
        Color[] cols = new Color[color_len];
        for (int i2 = 0; i2 < color_len; ++i2) {
            double red = CodecUtils.getFloat(buffer, readOffset);
            double green = CodecUtils.getFloat(buffer, readOffset += 4);
            double blue = CodecUtils.getFloat(buffer, readOffset += 4);
            double level = CodecUtils.getFloat(buffer, readOffset += 4);
            readOffset += 4;
            cols[i2] = new Color(red, green, blue, level);
        }
        double level = CodecUtils.getFloat(buffer, readOffset);
        double width = CodecUtils.getFloat(buffer, readOffset += 4);
        double attenuation = CodecUtils.getFloat(buffer, readOffset += 4);
        double brightness = CodecUtils.getFloat(buffer, readOffset += 4);
        double contrast = CodecUtils.getFloat(buffer, readOffset += 4);
        double deltaOpacity = CodecUtils.getFloat(buffer, readOffset += 4);
        double startOpacity = CodecUtils.getFloat(buffer, readOffset += 4);
        int thresh1 = CodecUtils.getInt(buffer, readOffset += 4);
        int thresh2 = CodecUtils.getInt(buffer, readOffset += 4);
        int len = CodecUtils.getInt(buffer, readOffset += 4);
        readOffset += 4;
        double[] oplut = new double[len];
        for (int i3 = 0; i3 < len; ++i3) {
            oplut[i3] = CodecUtils.getFloat(buffer, readOffset);
            readOffset += 4;
        }
        int[] rlen = new int[1];
        VrColorLut clut = (VrColorLut)VrColorLut.createFromBytes(buffer, readOffset, rlen);
        VrPreset preset = new VrPreset(modality, clut, oplut, startOpacity, deltaOpacity);
        preset.name = name;
        preset.comment = comment;
        preset.anatomy = anatomy;
        preset.level = level;
        preset.width = width;
        preset.attenuation = attenuation;
        preset.brightness = brightness;
        preset.contrast = contrast;
        preset.thresh1 = thresh1;
        preset.thresh2 = thresh2;
        preset.normalization = normalize;
        preset.partialcomp = partialcomp;
        preset.contourmode = contourmode;
        preset.curvetype = curvetype;
        preset.luttype = luttype;
        for (int i4 = 0; i4 < cols.length; ++i4) {
            preset.colors.add(cols[i4]);
        }
        return preset;
    }

    public static void main(String[] args) {
        try {
            VrPreset vrp = new VrPreset("/thesource/developer/espinal/AW/protocols/ABDOMEN/625_aorta.vrp");
            System.out.println("" + vrp);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static class Color {
        public double level;
        public double red;
        public double green;
        public double blue;
        public boolean issubobj = false;
        public double weight = 1.0;

        public Color() {
        }

        public Color(double red, double green, double blue, double level) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.level = level;
        }
    }
}

