/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.CNOplot;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorEditor;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.HistogramUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.OpacityMapUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.TickMarksUI;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;

class CNOscrollview
extends JPanel {
    JDialog dialog = null;
    OverlayLayout olay = new OverlayLayout(this);
    ActionListener actionhandle = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e2) {
            String action = e2.getActionCommand();
            CNOscrollview.this.ms.repaint();
            if ("zoom_down".equals(action)) {
                CNOscrollview.this.setZoom(1.1 * CNOscrollview.this.getZoom());
            } else if ("zoom_up".equals(action)) {
                CNOscrollview.this.setZoom(0.9 * CNOscrollview.this.getZoom());
            } else if ("show_wheel".equals(action)) {
                Frame frame;
                if (CNOscrollview.this.dialog == null && (frame = CNOscrollview.this.getTopFrame()) != null) {
                    CNOscrollview.this.dialog = new JDialog(frame, "Preset Color Editor", false);
                    CNOscrollview.this.dialog.setContentPane(CNOscrollview.this.colorEdit);
                    CNOscrollview.this.colorEdit.setPreferredSize(new Dimension(356, 256));
                    int mw = frame.getWidth() >> 1;
                    int mh = frame.getHeight() >> 1;
                    int cw = CNOscrollview.this.colorEdit.getWidth() >> 1;
                    int ch = CNOscrollview.this.colorEdit.getHeight() >> 1;
                    CNOscrollview.this.dialog.setLocation(frame.getX() + mw - cw, frame.getY() + mh - ch);
                    CNOscrollview.this.dialog.pack();
                }
                CNOscrollview.this.dialog.setVisible(!CNOscrollview.this.dialog.isVisible());
            } else if ("add_col_at".equals(action)) {
                Point p2 = (Point)e2.getSource();
                System.out.println("....=" + p2.x);
                CNOscrollview.this.plot.preset.addNewColor(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), p2.x));
                CNOscrollview.this.plot.preset.putProperty("paintCache", null);
                CNOscrollview.this.repaint();
            } else if ("add_col".equals(action)) {
                Rectangle r2 = CNOscrollview.this.plot.getVisibleRect();
                CNOscrollview.this.plot.preset.addNewColor(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), r2.x + r2.width / 2));
                CNOscrollview.this.repaint();
            } else if ("remove_col".equals(action)) {
                if (CNOscrollview.this.plot.preset.rgbSelected == -1) {
                    return;
                }
                CNOscrollview.this.plot.preset.removeSelectedColor();
                CNOscrollview.this.repaint();
            } else if ("color_changed".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("bwmode".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("attach_object".equals(action)) {
                CNOscrollview.this.plot.preset.attachObjectAt(CNOscrollview.this.plot.preset.rgbSelected);
                CNOscrollview.this.repaint();
            } else if ("detach_object".equals(action)) {
                CNOscrollview.this.plot.preset.detachObjectAt(CNOscrollview.this.plot.preset.rgbSelected);
                CNOscrollview.this.repaint();
            } else if ("rgbmode_changed".equals(action)) {
                CNOscrollview.this.repaint();
            } else if ("add_op".equals(action)) {
                Rectangle r3 = CNOscrollview.this.plot.getVisibleRect();
                CNOscrollview.this.plot.preset.addNewOpacity(CNOscrollview.this.plot.layout.getVfromX(CNOscrollview.this.plot.getWidth(), r3.x + r3.width / 2));
                CNOscrollview.this.repaint();
            } else if ("remove_op".equals(action)) {
                CNOscrollview.this.plot.preset.removeSelectedOpacity();
                CNOscrollview.this.repaint();
            }
        }
    };
    boolean secondTime = false;
    ColorEditor colorEdit = new ColorEditor();
    JScrollPane plotScrollPane = new JScrollPane();
    CNOplot plot = new CNOplot();
    MyScroll ms = new MyScroll();
    transient Vector actionListeners;

    public CNOscrollview() {
        if (Beans.isDesignTime()) {
            this.setPresets(new Preset());
        }
        this.setLayout(this.olay);
        this.plotScrollPane.setHorizontalScrollBarPolicy(32);
        this.plotScrollPane.setBounds(0, 0, 100, 100);
        this.colorEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (CNOscrollview.this.dialog != null) {
                    CNOscrollview.this.dialog.setVisible(false);
                } else {
                    CNOscrollview.this.colorEdit.setVisible(false);
                }
            }
        });
        this.add(this.plotScrollPane);
        this.plotScrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.plotScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.BLACK, 0));
        this.plotScrollPane.getViewport().add(this.plot);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                System.out.println("componentResized this.getWidth()=" + CNOscrollview.this.getWidth());
                if (CNOscrollview.this.secondTime) {
                    return;
                }
                CNOscrollview.this.setZoom(10.0);
                int x2 = CNOscrollview.this.plot.layout.getXpos(CNOscrollview.this.plot.getWidth(), CNOscrollview.this.plot.preset.opacityPos[0]);
                Rectangle r2 = new Rectangle(x2 - 20, 0, CNOscrollview.this.getWidth(), 0);
                CNOscrollview.this.plot.scrollRectToVisible(r2);
                CNOscrollview.this.secondTime = true;
            }
        });
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.plotScrollPane.setHorizontalScrollBar(this.ms);
    }

    private Frame getTopFrame() {
        Frame topWindow = null;
        Container c2 = this.getParent();
        while (true) {
            if (c2 instanceof Frame || c2 == null) break;
            c2 = c2.getParent();
        }
        topWindow = (Frame)c2;
        return topWindow;
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("CNOscrollview.java");
        CNOscrollview p2 = new CNOscrollview();
        p2.setPresets(new Preset());
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 512, 512);
        f2.setDefaultCloseOperation(3);
        f2.setVisible(true);
    }

    public void setPresets(Preset p2) {
        this.plot.setPresets(p2);
        this.colorEdit.setPreset(p2);
        p2.addActionListener(this.actionhandle);
        int x2 = this.plot.layout.getXpos(this.plot.getWidth(), p2.opacityPos[0]);
        Rectangle r2 = new Rectangle(x2, 0, this.getWidth(), 0);
        this.plot.scrollRectToVisible(r2);
    }

    public double getZoom() {
        return this.plot.getZoom();
    }

    public void setZoom(double zoom) {
        this.plot.setZoom(zoom);
    }

    public synchronized void addActionListener(ActionListener l2) {
    }

    public synchronized void removeActionListener(ActionListener l2) {
    }

    protected void fireActionPerformed(ActionEvent e2) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((ActionListener)listeners.elementAt(i2)).actionPerformed(e2);
            }
        }
    }

    private void jbInit() throws Exception {
    }

    public void setCursorValue(double value) {
        this.plot.setCursorValue(value);
        this.ms.setCursroValue(this.plot.layout.getNormalizedPosition(value));
    }

    public void setCursorColor(Color c2) {
        this.plot.setCursorColor(c2);
    }

    public void setHistogram(VrHistogram h2) {
        this.plot.setHistogram(h2);
        this.plot.resetPanZoom();
    }

    public void setDataRange(double min, double max, String unit) {
        Layout.MIN = min;
        Layout.MAX = max;
        TickMarksUI.UNIT = unit;
        this.plot.resetPanZoom();
    }

    public void setMousePan(boolean b2) {
        System.out.println("CNOscrollview.setMousePan()" + b2);
        this.plot.setMousePan(b2);
    }

    public VrHistogram getHistogram() {
        return this.plot.getHistogram();
    }

    class MyScroll
    extends JScrollBar {
        OpacityMapUI umu;
        HistogramUI histogramUI;
        Rectangle r;
        double cv;
        BufferedImage img;
        int[] data;
        Graphics ig;

        public MyScroll() {
            super.setOrientation(0);
            this.umu = null;
            this.histogramUI = null;
            this.r = new Rectangle();
            this.cv = 0.5;
            this.img = new BufferedImage(1, 1, 2);
            this.data = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
            this.ig = this.img.getGraphics();
            for (int i2 = 0; i2 < CNOscrollview.this.plot.ui.length; ++i2) {
                if (CNOscrollview.this.plot.ui[i2] instanceof OpacityMapUI) {
                    this.umu = (OpacityMapUI)CNOscrollview.this.plot.ui[i2];
                    continue;
                }
                if (!(CNOscrollview.this.plot.ui[i2] instanceof HistogramUI)) continue;
                this.histogramUI = (HistogramUI)CNOscrollview.this.plot.ui[i2];
            }
        }

        public void setCursroValue(double f2) {
            this.cv = f2;
        }

        @Override
        public void paint(Graphics g2) {
            int w2 = this.getWidth();
            int h2 = this.getHeight();
            Color c2 = this.getBackground();
            g2.setColor(c2);
            g2.fillRect(0, 0, w2, h2);
            this.r.width = w2;
            this.r.height = h2;
            this.umu.paintSbar(g2, 16, 0, w2 - 32, h2);
            this.histogramUI.drawHistogram(g2, new Rectangle(16, 0, w2 - 32, h2), false, true);
            g2.setColor(Color.GREEN);
            g2.drawLine((int)((double)w2 * this.cv), 0, (int)((double)w2 * this.cv), this.getHeight());
            if (this.img.getWidth() != w2 || this.img.getHeight() != h2) {
                this.img = new BufferedImage(w2, h2, 2);
                this.data = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
                this.ig = this.img.getGraphics();
            }
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                this.data[0] = 0;
            }
            super.paint(this.ig);
            int bg = c2.getRGB();
            for (int y2 = 0; y2 < h2; ++y2) {
                for (int x2 = 0; x2 < w2; ++x2) {
                    int i3 = x2 + y2 * w2;
                    if (x2 < 16 || x2 > w2 - 17) continue;
                    if (this.data[i3] == bg) {
                        this.data[i3] = 0;
                        continue;
                    }
                    int n2 = i3;
                    this.data[n2] = this.data[n2] & 0xFFFFFF;
                    int n3 = i3;
                    this.data[n3] = this.data[n3] | 0xD0000000;
                }
            }
            g2.drawImage(this.img, 0, 0, null);
        }
    }
}

