/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorMenu;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

class ColorCTL
implements UIcontrol {
    static final int CTRL_SIZE = 14;
    static final int NUDGE_FACTOR = 2;
    Preset p;
    Layout l;
    public boolean mousePressed = false;
    static DecimalFormat format = new DecimalFormat("#####.##");
    ColorMenu colMenu = new ColorMenu();
    JComponent source;

    public ColorCTL() {
        this.colMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ColorCTL.this.p.fireActionPerformed(e2);
            }
        });
    }

    @Override
    public boolean mousePressed(MouseEvent e2) {
        this.source = (JComponent)e2.getSource();
        if (this.p.blackwhitemode) {
            return false;
        }
        int temp = this.getMouseOver(e2);
        if (temp == -1) {
            int y2 = e2.getY();
            return y2 > this.l.color_top && y2 < this.l.color_bottom;
        }
        this.p.setRGBselected(temp);
        this.mousePressed = true;
        e2.getComponent().repaint();
        if (e2.getClickCount() == 2) {
            this.p.fireActionPerformed(new ActionEvent(this, 0, "show_wheel"));
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        this.mousePressed = false;
        if (e2.isPopupTrigger()) {
            System.out.println("popup trigger");
            this.colMenu.show(e2.getComponent(), e2.getX(), e2.getY());
            this.colMenu.setPosition(e2.getPoint());
        }
        e2.getComponent().repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "color_mouseReleased"));
    }

    int getMouseOver(MouseEvent e2) {
        Component c2 = e2.getComponent();
        int w2 = c2.getWidth();
        int h2 = c2.getHeight();
        this.l.setHeight(h2);
        int yp = (int)((double)this.l.color_bottom + 10.5 - 2.0);
        int x2 = e2.getX();
        int y2 = e2.getY();
        for (int i2 = 0; i2 < this.p.rgbPos.length; ++i2) {
            double pos = this.p.rgbPos[i2];
            int xp = this.l.getXpos(w2, pos);
            if (Math.abs(xp - x2) > 7 || !((double)Math.abs(yp - y2) <= 10.5)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean mouseMoved(MouseEvent e2) {
        if (this.p.blackwhitemode) {
            return false;
        }
        if (this.getMouseOver(e2) != -1) {
            e2.getComponent().setCursor(new Cursor(11));
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.p.rgbSelected == -1) {
            return;
        }
        Component c2 = e2.getComponent();
        this.p.rgbPos[this.p.rgbSelected] = this.l.getVfromX(c2.getWidth(), e2.getX());
        this.p.sortColor();
        if (this.p.opacityMode == 6) {
            this.p.updateOpacityPts();
        }
        this.p.putProperty("paintCache", null);
        c2.repaint();
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void paint(Graphics g2, int w2, int h2, Rectangle r2) {
        if (this.p.blackwhitemode) {
            return;
        }
        this.l.setHeight(h2);
        int y2 = this.l.getColorY();
        int[] xpts = new int[5];
        int[] ypts = new int[5];
        int[] xspts = new int[4];
        int[] yspts = new int[4];
        int[] xtpts = new int[3];
        int[] ytpts = new int[3];
        for (int i2 = 0; i2 < this.p.rgbPos.length; ++i2) {
            int rgb = this.p.rgbValue[i2];
            double pos = this.p.rgbPos[i2];
            int x2 = this.l.getXpos(w2, pos);
            if (this.p.rgbSelected == i2) {
                g2.setColor(Color.lightGray);
                if (this.mousePressed) {
                    g2.draw3DRect(x2, this.l.op_bottom + 1, 1, this.l.color_bottom - this.l.op_bottom - 1, true);
                    String s2 = format.format(pos);
                    FontMetrics f2 = g2.getFontMetrics();
                    Rectangle2D rect = f2.getStringBounds(s2, g2);
                    int off = 0;
                    int rwidth = 5 + (int)rect.getWidth();
                    if (r2.x + r2.width <= x2 + 1 + rwidth) {
                        off = -rwidth;
                    }
                    g2.setColor(UIManager.getColor("ToolTip.background"));
                    g2.fillRect(x2 + 1 + off, this.l.tick_bottom - f2.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                    Border ttborder = UIManager.getBorder("ToolTip.border");
                    ttborder.paintBorder(this.source, g2, x2 + 1 + off, this.l.tick_bottom - f2.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                    g2.setColor(Color.black);
                    int colorTextPos = this.l.tick_bottom - 2;
                    g2.drawString(s2, x2 + 4 + off, colorTextPos);
                }
            }
            xpts[0] = x2 - 7;
            ypts[0] = this.l.color_bottom - 2;
            xpts[1] = x2 - 7;
            ypts[1] = this.l.color_bottom + 14 - 2;
            xpts[2] = x2 + 7;
            ypts[2] = this.l.color_bottom + 14 - 2;
            xpts[3] = x2 + 7;
            ypts[3] = this.l.color_bottom - 2;
            xpts[4] = x2;
            ypts[4] = this.l.color_bottom - 7 - 2;
            g2.setColor(Color.BLACK);
            g2.drawPolygon(xpts, ypts, 5);
            g2.setColor(Color.WHITE);
            g2.fillPolygon(xpts, ypts, 5);
            int margin = this.p.rgbSelected == i2 ? 2 : 1;
            xtpts[0] = xpts[0] + margin;
            ytpts[0] = ypts[0];
            xtpts[1] = xpts[3] - margin;
            ytpts[1] = ypts[3];
            xtpts[2] = xpts[4];
            ytpts[2] = ypts[4] + margin;
            g2.setColor(UIManager.getColor("P3"));
            g2.fillPolygon(xtpts, ytpts, 3);
            xspts[0] = xpts[0] + margin;
            yspts[0] = ypts[0] + margin;
            xspts[1] = xpts[1] + margin;
            yspts[1] = ypts[1] - margin;
            xspts[2] = xpts[2] - margin;
            yspts[2] = ypts[2] - margin;
            xspts[3] = xpts[3] - margin;
            yspts[3] = ypts[3] + margin;
            g2.setColor(new Color(~rgb));
            g2.drawPolygon(xspts, yspts, 4);
            g2.setColor(new Color(rgb));
            g2.fillPolygon(xspts, yspts, 4);
        }
    }

    @Override
    public void setPresets(Preset p2) {
        this.p = p2;
    }
}

