/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JFrame;
import javax.swing.JPanel;

class Sphere
extends JPanel {
    BufferedImage backImg = null;
    boolean recalc = false;

    public Sphere() {
        this.setForeground(Color.CYAN);
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("Sphere");
        Sphere p2 = new Sphere();
        f2.setContentPane(p2);
        f2.setDefaultCloseOperation(3);
        f2.setBounds(10, 10, 512, 512);
        f2.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        if (this.backImg == null || this.backImg.getWidth() != w2 || this.backImg.getHeight() != h2) {
            this.backImg = new BufferedImage(w2, h2, 2);
            this.recalc = true;
        }
        if (this.recalc) {
            this.renderSphere();
        }
        g2.drawImage(this.backImg, 0, 0, null);
    }

    public void renderSphere() {
        int w2 = this.backImg.getWidth();
        int h2 = this.backImg.getHeight();
        int rc = this.getForeground().getRed();
        int gc = this.getForeground().getGreen();
        int bc = this.getForeground().getBlue();
        int[] buff = ((DataBufferInt)this.backImg.getRaster().getDataBuffer()).getData();
        double rad = w2 > h2 ? (double)h2 / 2.0 : (double)w2 / 2.0;
        double radsq = (rad -= 2.0) * rad;
        for (int i2 = 0; i2 < buff.length; ++i2) {
            double x2 = (double)(i2 % w2) - (double)w2 / 2.0;
            double y2 = (double)h2 / 2.0 - (double)(i2 / w2);
            double d2 = x2 * x2 + y2 * y2;
            if (d2 > radsq) {
                buff[i2] = 0;
                continue;
            }
            double v2 = 0.2 + 0.8 * Math.sqrt(radsq - d2) / rad;
            buff[i2] = ((int)(v2 * (double)rc) << 16) + ((int)(v2 * (double)gc) << 8) + (int)(v2 * (double)bc) + -16777216;
        }
    }

    @Override
    public void setForeground(Color c2) {
        super.setForeground(c2);
        this.recalc = true;
        this.repaint();
    }
}

