/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import java.util.Arrays;

public class VrHistogram {
    public double intercept;
    public double slope;
    public int max;
    public int min;
    public int[] count;

    public VrHistogram(int min, int max, double slope, double intercept) {
        this.min = min;
        this.max = max;
        this.slope = slope;
        this.intercept = intercept;
        this.count = new int[max - min + 1];
    }

    public void incrementRaw(int raw) {
        if (raw >= this.min && raw <= this.max) {
            int n2 = raw - this.min;
            this.count[n2] = this.count[n2] + 1;
        }
    }

    public void incrementValueAt(double value) {
        int raw = (int)Math.round((value - this.intercept) / this.slope);
        this.incrementRaw(raw);
    }

    public void reset() {
        if (this.count != null && this.count.length > 0) {
            Arrays.fill(this.count, 0);
        }
    }

    public static VrHistogram generateFakeHistogram() {
        VrHistogram h2 = new VrHistogram(-1000, 3071, 1.0, 0.0);
        double mu = 300.0;
        double sigma = h2.max - h2.min;
        for (int i2 = h2.min; i2 < h2.max; ++i2) {
            h2.count[i2 - h2.min] = (int)(Math.exp(-((double)i2 - 300.0) * ((double)i2 - 300.0) * 600.0 / (sigma * sigma)) * 1000.0);
        }
        return h2;
    }
}

