/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.idc.XjChangeListener;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrPresetsEditor;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class VrPresetsEditorDemo
extends JPanel {
    Preset preset = new Preset();
    private Cursor3DModel cursorModel_;
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    T3DViewport port = new T3DViewport();
    VrPresetsEditor cno = new VrPresetsEditor();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Component component1 = Box.createHorizontalStrut(8);
    JPanel jPanel2 = new JPanel();
    JButton jBapply = new JButton();
    JButton jBsave = new JButton();
    JButton jBload = new JButton();

    public VrPresetsEditorDemo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cno.setPresets(this.preset);
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("CNOandVRdemo.java");
        final VrPresetsEditorDemo p2 = new VrPresetsEditorDemo();
        f2.setContentPane(p2);
        f2.setBounds(100, 100, 512, 512);
        f2.setDefaultCloseOperation(3);
        String dir = args.length > 0 ? args[0] : "C:\\dev\\dicom\\pesi\\p2";
        DMSession dms = new DMSession("file", dir, null);
        f2.setVisible(true);
        DMVolume dmv = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        p2.port.setVolume(dmv);
        final DefaultCursor3DModel cursorModel = new DefaultCursor3DModel(p2.port);
        final Cursor3DVc cvc = new Cursor3DVc(cursorModel, p2.port);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                p2.port.getT3DComponent().add(cvc);
                p2.port.validate();
                cvc.setContinuousUpdateEnabled(true);
                p2.setCursorModel(cursorModel);
            }
        });
        JVolume.LinearShort jvol = (JVolume.LinearShort)((J3DVolumeModel)p2.port.getVolumeModel()).j_vol;
        short[] pixels = jvol.volume;
        int[] dims = dmv.getVolumeDimensions(null);
        final VrHistogram h2 = new VrHistogram(0, 4095, 1.0, -1024.0);
        long t2 = System.currentTimeMillis();
        for (int i2 = 0; i2 < dims[0] * dims[1] * dims[2]; i2 += 7) {
            h2.incrementRaw(pixels[i2 + jvol.PAD]);
        }
        System.out.println("histogram takes " + (System.currentTimeMillis() - t2));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                p2.setHistogram(h2);
            }
        });
    }

    protected void setHistogram(VrHistogram h2) {
        this.cno.setHistogram(h2);
    }

    private void setCursorModel(Cursor3DModel cursorModel) {
        this.cursorModel_ = cursorModel;
        cursorModel.addChangeListener(new XjChangeListener(){

            @Override
            public void stateChanged(EventObject e2) {
                CPoint pt = VrPresetsEditorDemo.this.cursorModel_.getPoint(null);
                CTransform xform = VrPresetsEditorDemo.this.port.getT3DComponent().getTransform((byte)2, (byte)1);
                xform.transform(pt);
                VrCapable vrc = (VrCapable)VrPresetsEditorDemo.this.port.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                double value = vrc.getValue((int)pt.x, (int)pt.y);
                if (value != -9999999.0) {
                    System.out.println("value set to " + value);
                    VrPresetsEditorDemo.this.cno.setCursorValue(value - 1024.0);
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jBapply.setText("Apply");
        this.jBapply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VrPresetsEditorDemo.this.jBapply_actionPerformed(e2);
            }
        });
        this.jBsave.setText("Save...");
        this.jBsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VrPresetsEditorDemo.this.jBsave_actionPerformed(e2);
            }
        });
        this.jBload.setText("Load...");
        this.jBload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VrPresetsEditorDemo.this.jBload_actionPerformed(e2);
            }
        });
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "left");
        this.jSplitPane1.add((Component)this.port, "right");
        this.jPanel1.add(this.component1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add(this.jBapply);
        this.jPanel2.add(this.jBsave);
        this.jPanel2.add(this.jBload);
        this.jPanel1.add((Component)this.cno, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 1, new Insets(5, 2, 0, 2), 0, 200));
    }

    private void print(double[] a2) {
        double old = Double.NaN;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (old == a2[i2]) {
                System.out.print("-");
            } else {
                System.out.print((i2 == 0 ? "" : ",") + a2[i2]);
            }
            if (i2 % 20 == 19) {
                System.out.println("");
            }
            old = a2[i2];
        }
    }

    public void jBsave_actionPerformed(ActionEvent e2) {
        JFileChooser fc = new JFileChooser();
        int ret = fc.showSaveDialog(this);
        if (ret == 1) {
            return;
        }
        File f2 = fc.getSelectedFile();
        this.preset.save(f2.getName(), f2.getPath());
    }

    public void jBload_actionPerformed(ActionEvent e2) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f2) {
                return f2.getName().endsWith(".vrpreset");
            }

            @Override
            public String getDescription() {
                return "preset files";
            }
        });
        int ret = fc.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File f2 = fc.getSelectedFile();
        try {
            System.out.println(f2.getAbsolutePath());
            this.preset.load(f2.getAbsolutePath());
            this.preset.print();
            this.repaint();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e22) {
            e22.printStackTrace();
        }
    }

    public void jBapply_actionPerformed(ActionEvent e2) {
        double deltax = this.preset.incr;
        double startx = this.preset.start;
        System.out.println("deltax=" + deltax);
        System.out.println("startx=" + startx);
        double[] opacity = this.preset.fillOpacity();
        double[] clut = this.preset.fillRGB();
        VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
        VrPreset p2 = new VrPreset("CT", vrcl, opacity, startx, deltax);
        VrPreset p22 = new VrPreset();
        p22.thresh1 = 140;
        p22.thresh2 = 500;
        this.port.setProperty("PRESET_PROPERTY", p2);
        this.port.repaint();
    }
}

