/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class GraphPlotter
extends JPanel {
    private static final DecimalFormat df = new DecimalFormat("##.##");
    private static final String fontFamily = "Helvetica";
    private static Font[] fonts = new Font[]{new Font("Helvetica", 0, 8), new Font("Helvetica", 0, 10), new Font("Helvetica", 0, 12), new Font("Helvetica", 0, 14)};
    private static final int MAX_GRAPHSCENES = 16;
    private static final int MAX_GRAPHTYPES = 2;
    private static Stroke[] strokeDictionary = new Stroke[2];
    private static Paint[] paintDictionary = new Paint[2];
    public static final int CUBIC_INTERPOLATION = 0;
    public static final int LINEAR_INTERPOLATION = 1;
    private int numPlotId = 0;
    private int majorTicks = 5;
    private int minorTicks = 4;
    private boolean dynamicRangeX = true;
    private boolean dynamicRangeY = true;
    private double rangeX = -99999.0;
    private double rangeY = -99999.0;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private boolean xaxisVisible = true;
    private boolean yaxisVisible = true;
    private PlotScene[] pscenes = new PlotScene[16];
    private AffineTransform displayToPlot = new AffineTransform();
    private AffineTransform plotToDisplay = new AffineTransform();
    private Point2D srcpoint = new Point2D.Double();
    private Point2D point0 = new Point2D.Double();
    private Point2D point1 = new Point2D.Double();
    private Point2D plotMargins = new Point2D.Double(0.15, 0.15);
    private Rectangle2D fillRect = new Rectangle2D.Double();
    private Line2D axisLine = new Line2D.Double();
    private Line2D majorTick = new Line2D.Double();
    private Line2D minorTick = new Line2D.Double();

    public GraphPlotter() {
        this.setForeground(Color.white);
        this.displayToPlot.setToIdentity();
        this.plotToDisplay.setToIdentity();
        MouseController mc = new MouseController();
        this.addMouseListener(mc);
        this.addMouseMotionListener(mc);
    }

    private void transformLine(double x0, double y0, double x1, double y1, Line2D l2) {
        this.srcpoint.setLocation(x0, y0);
        this.plotToDisplay.transform(this.srcpoint, this.point0);
        this.srcpoint.setLocation(x1, y1);
        this.plotToDisplay.transform(this.srcpoint, this.point1);
        l2.setLine(this.point0, this.point1);
    }

    private void syncTransform() {
        try {
            int w2 = this.getWidth();
            int h2 = this.getHeight();
            double plotX = (double)w2 * this.plotMargins.getX() * 0.5;
            double plotY = (double)h2 * this.plotMargins.getY() * 0.5;
            double plotW = (double)w2 - (double)w2 * this.plotMargins.getX();
            double plotH = (double)h2 - (double)h2 * this.plotMargins.getY();
            double minX = this.centerX - this.rangeX * 0.5;
            double maxX = this.centerX + this.rangeX * 0.5;
            double minY = this.centerY - this.rangeY * 0.5;
            double maxY = this.centerY + this.rangeY * 0.5;
            double spx = (maxX - minX) / plotW;
            double spy = (minY - maxY) / plotH;
            this.displayToPlot.setTransform(spx, 0.0, 0.0, spy, minX - plotX * spx, maxY - plotY * spy);
            AffineTransform inv = this.displayToPlot.createInverse();
            this.plotToDisplay.setTransform(inv);
        }
        catch (NoninvertibleTransformException e2) {
            e2.printStackTrace();
        }
    }

    public void setPlotMargins(double xRatio, double yRatio) {
        this.plotMargins.setLocation(xRatio, yRatio);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int i2;
        Graphics2D g22 = (Graphics2D)g2;
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        double plotX = (double)w2 * this.plotMargins.getX() * 0.5;
        double plotY = (double)h2 * this.plotMargins.getY() * 0.5;
        double plotW = (double)w2 - (double)w2 * this.plotMargins.getX();
        double plotH = (double)h2 - (double)h2 * this.plotMargins.getY();
        Stroke defaultStroke = g22.getStroke();
        double minX = this.centerX - this.rangeX * 0.5;
        double maxX = this.centerX + this.rangeX * 0.5;
        double minY = this.centerY - this.rangeY * 0.5;
        double maxY = this.centerY + this.rangeY * 0.5;
        this.syncTransform();
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fillRect.setFrame(0.0, 0.0, w2, h2);
        g22.setColor(this.getBackground());
        g22.fill(this.fillRect);
        this.fillRect.setFrame(plotX, plotY, plotW, plotH);
        g22.setColor(this.getForeground());
        g22.fill(this.fillRect);
        g22.setColor(Color.black);
        g22.draw(this.fillRect);
        double deltax = plotW / (double)this.majorTicks;
        double deltay = plotH / (double)this.majorTicks;
        double mdeltax = deltax / (double)this.minorTicks;
        double mdeltay = deltay / (double)this.minorTicks;
        double majorTickLenX = plotH * 0.02;
        double majorTickLenY = plotW * 0.02;
        double minorTickLenX = plotH * 0.01;
        double minorTickLenY = plotW * 0.01;
        Font labelFont = fonts[2];
        boolean inside = false;
        if (w2 < 150 || h2 < 150) {
            labelFont = fonts[0];
            inside = true;
        } else if (w2 < 200 || h2 < 200) {
            labelFont = fonts[1];
            inside = true;
        } else if (w2 > 512 || h2 > 512) {
            labelFont = fonts[3];
        }
        g22.setFont(labelFont);
        FontRenderContext frc = g22.getFontRenderContext();
        for (int i3 = 0; i3 < this.majorTicks; ++i3) {
            float labely;
            float labelx;
            double offset;
            double tickx = plotX + deltax * (double)i3;
            double ticky = plotY + deltay * (double)i3;
            String ltickx = df.format(minX + (maxX - minX) / (double)this.majorTicks * (double)i3);
            String lticky = df.format(maxY - (maxY - minY) / (double)this.majorTicks * (double)i3);
            this.majorTick.setLine(tickx, plotY + plotH, tickx, plotY + plotH - majorTickLenX);
            g22.draw(this.majorTick);
            if (i3 != 0) {
                Rectangle2D r0 = labelFont.getStringBounds(ltickx, frc);
                offset = inside ? -r0.getHeight() : r0.getHeight();
                labelx = (float)(tickx - r0.getWidth() * 0.5);
                labely = (float)(plotY + plotH + offset);
                g22.drawString(ltickx, labelx, labely);
            }
            this.majorTick.setLine(plotX, ticky, plotX + majorTickLenY, ticky);
            g22.draw(this.majorTick);
            if (i3 != 0) {
                Rectangle2D r1 = labelFont.getStringBounds(lticky, frc);
                offset = inside ? r1.getWidth() * 0.5 : -r1.getWidth();
                labelx = (float)(this.majorTick.getP1().getX() + offset);
                labely = (float)(this.majorTick.getP1().getY() + r1.getHeight() * 0.25);
                g22.drawString(lticky, labelx, labely);
            }
            for (int j2 = 1; j2 < this.minorTicks; ++j2) {
                this.minorTick.setLine(tickx + mdeltax * (double)j2, plotY + plotH, tickx + mdeltax * (double)j2, plotY + plotH - minorTickLenX);
                g22.draw(this.minorTick);
                this.minorTick.setLine(plotX, ticky + mdeltay * (double)j2, plotX + minorTickLenY, ticky + mdeltay * (double)j2);
                g22.draw(this.minorTick);
            }
        }
        g22.clip(this.fillRect);
        this.transformLine(minX, 0.0, maxX, 0.0, this.axisLine);
        g22.draw(this.axisLine);
        this.transformLine(0.0, minY, 0.0, maxY, this.axisLine);
        g22.draw(this.axisLine);
        int NGRIDXLINES = 10;
        int NGRIDYLINES = 10;
        double deltagX = (maxX - minX) / 10.0;
        double deltagY = (maxY - minY) / 10.0;
        g22.setColor(new Color(25, 25, 25, 10));
        for (i2 = 0; i2 < 10; ++i2) {
            double axis_x = minX + (double)i2 * deltagX;
            this.transformLine(axis_x, minY, axis_x, maxY, this.axisLine);
            g22.draw(this.axisLine);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            double axis_y = minY + (double)i2 * deltagY;
            this.transformLine(minX, axis_y, maxX, axis_y, this.axisLine);
            g22.draw(this.axisLine);
        }
        g22.transform(this.plotToDisplay);
        for (i2 = 0; i2 < this.pscenes.length; ++i2) {
            if (this.pscenes[i2] == null) continue;
            PlotScene ps = this.pscenes[i2];
            g22.setStroke(ps.stroke);
            g22.setColor(Color.red);
            g22.draw(ps.path);
        }
        g22.transform(this.displayToPlot);
        g22.setStroke(defaultStroke);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = centerY;
    }

    public boolean isDynamicRangeX() {
        return this.dynamicRangeX;
    }

    public void setDynamicRangeX(boolean dynamicRangeX) {
        this.dynamicRangeX = dynamicRangeX;
    }

    public boolean isDynamicRangeY() {
        return this.dynamicRangeY;
    }

    public void setDynamicRangeY(boolean dynamicRangeY) {
        this.dynamicRangeY = dynamicRangeY;
    }

    public double getRangeX() {
        return this.rangeX;
    }

    public void setRangeX(double rangeX) {
        this.rangeX = rangeX;
    }

    public double getRangeY() {
        return this.rangeY;
    }

    public void setRangeY(double rangeY) {
        this.rangeY = rangeY;
    }

    public void setMinMaxX(double minX, double maxX) {
        this.centerX = (minX + maxX) * 0.5;
        this.rangeX = maxX - minX;
    }

    public void setMinMaxY(double minY, double maxY) {
        this.centerY = (minY + maxY) * 0.5;
        this.rangeY = maxY - minY;
    }

    public AffineTransform getDisplayToPlot() {
        return this.displayToPlot;
    }

    public AffineTransform getPlotToDisplay() {
        return this.plotToDisplay;
    }

    public int getNumPlots() {
        int nplots = 0;
        for (int i2 = 0; i2 < this.pscenes.length; ++i2) {
            if (this.pscenes[i2] == null) continue;
            ++nplots;
        }
        return nplots;
    }

    private void updateRange(List l2) {
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        if (this.numPlotId == 0) {
            minX = 9.9999999E7;
            maxX = -9.9999999E7;
            minY = 9.9999999E7;
            maxY = -9.9999999E7;
        } else {
            minX = this.centerX - this.rangeX * 0.5;
            maxX = this.centerX + this.rangeX * 0.5;
            minY = this.centerY - this.rangeY * 0.5;
            maxY = this.centerY + this.rangeY * 0.5;
        }
        for (int i2 = 0; i2 < l2.size(); ++i2) {
            Point2D p2 = (Point2D)l2.get(i2);
            if (minX > p2.getX()) {
                minX = p2.getX();
            }
            if (maxX < p2.getX()) {
                maxX = p2.getX();
            }
            if (minY > p2.getY()) {
                minY = p2.getY();
            }
            if (!(maxY < p2.getY())) continue;
            maxY = p2.getY();
        }
        int nplots = this.getNumPlots();
        if (this.dynamicRangeX || nplots == 0) {
            this.setMinMaxX(minX, maxX);
        }
        if (this.dynamicRangeY || nplots == 0) {
            this.setMinMaxY(minY, maxY);
        }
    }

    private void updatePlot(int plotid, List l2) {
        this.pscenes[plotid].setPlot(l2);
        this.updateRange(l2);
    }

    public int addPlot(List plot) {
        int newid;
        boolean valid;
        if (!(valid = this.setPlot(newid = this.numPlotId++, plot))) {
            newid = -1;
        }
        return newid;
    }

    public void removePlot(int plotId) {
        this.pscenes[plotId] = null;
    }

    public int addPdf(int[] pdf) {
        int i2;
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        int ntotal = 0;
        for (i2 = 0; i2 < pdf.length; ++i2) {
            ntotal += pdf[i2];
        }
        for (i2 = 0; i2 < pdf.length; ++i2) {
            pts.add(new Point2D.Double(i2, (double)pdf[i2] / (double)ntotal));
        }
        return this.addPlot(pts);
    }

    public int addPlot(int[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.addPlot(pts);
    }

    public int addPlot(short[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.addPlot(pts);
    }

    public int addPlot(float[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.addPlot(pts);
    }

    public int addPlot(double[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.addPlot(pts);
    }

    public int addPlot(byte[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.addPlot(pts);
    }

    public int addPlot(boolean[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2] ? 1.0 : 0.0));
        }
        return this.addPlot(pts);
    }

    public int addPlot(Number[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2].doubleValue()));
        }
        return this.addPlot(pts);
    }

    public int addPlot(Point2D[] plot) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(plot[i2]);
        }
        return this.addPlot(pts);
    }

    public boolean setPlot(int plotid, List plot) {
        if (plot.size() > 0) {
            boolean validPlot = false;
            ArrayList<Point2D.Double> l2 = plot;
            if (plot.get(0) instanceof Point2D) {
                validPlot = true;
            } else if (plot.get(0) instanceof Number) {
                l2 = new ArrayList<Point2D.Double>();
                for (int i2 = 0; i2 < plot.size(); ++i2) {
                    Number n2 = (Number)plot.get(i2);
                    l2.add(new Point2D.Double(i2, n2.doubleValue()));
                }
                validPlot = true;
            } else if (plot.get(0) instanceof Boolean) {
                l2 = new ArrayList();
                for (int i3 = 0; i3 < plot.size(); ++i3) {
                    Boolean b2 = (Boolean)plot.get(i3);
                    l2.add(new Point2D.Double(i3, b2 != false ? 1.0 : 0.0));
                }
                validPlot = true;
            }
            if (validPlot) {
                if (this.pscenes[plotid] == null) {
                    this.pscenes[plotid] = new PlotScene();
                }
                this.updatePlot(plotid, l2);
                return true;
            }
        }
        return false;
    }

    public boolean setPlot(int plotid, int[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, float[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, double[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, byte[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2]));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, boolean[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2] ? 1.0 : 0.0));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, Number[] plot) {
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(new Point2D.Double(i2, plot[i2].doubleValue()));
        }
        return this.setPlot(plotid, pts);
    }

    public boolean setPlot(int plotid, Point2D[] plot) {
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        for (int i2 = 0; i2 < plot.length; ++i2) {
            pts.add(plot[i2]);
        }
        return this.setPlot(plotid, pts);
    }

    public boolean isXaxisVisible() {
        return this.xaxisVisible;
    }

    public void setXaxisVisible(boolean xaxisVisible) {
        this.xaxisVisible = xaxisVisible;
    }

    public boolean isYaxisVisible() {
        return this.yaxisVisible;
    }

    public void setYaxisVisible(boolean yaxisVisible) {
        this.yaxisVisible = yaxisVisible;
    }

    public void fitToPlotArea() {
        double minX = 9.9999999E7;
        double maxX = -9.9999999E7;
        double minY = 9.9999999E7;
        double maxY = -9.9999999E7;
        for (int i2 = 0; i2 < this.pscenes.length; ++i2) {
            if (this.pscenes[i2] == null) continue;
            List l2 = this.pscenes[i2].pts;
            for (int j2 = 0; j2 < l2.size(); ++j2) {
                Point2D p2 = (Point2D)l2.get(j2);
                if (minX > p2.getX()) {
                    minX = p2.getX();
                }
                if (maxX < p2.getX()) {
                    maxX = p2.getX();
                }
                if (minY > p2.getY()) {
                    minY = p2.getY();
                }
                if (!(maxY < p2.getY())) continue;
                maxY = p2.getY();
            }
        }
        this.setMinMaxX(minX, maxX);
        this.setMinMaxY(minY, maxY);
    }

    public void fit() {
        double minX = 9.9999999E7;
        double maxX = -9.9999999E7;
        double minY = 9.9999999E7;
        double maxY = -9.9999999E7;
        boolean fitit = false;
        for (int i2 = 0; i2 < this.pscenes.length; ++i2) {
            if (this.pscenes[i2] == null) continue;
            List l2 = this.pscenes[i2].pts;
            for (int j2 = 0; j2 < l2.size(); ++j2) {
                Point2D p2 = (Point2D)l2.get(j2);
                if (!(Math.abs(p2.getY()) > 10.0)) continue;
                if (minX > p2.getX()) {
                    minX = p2.getX();
                }
                if (maxX < p2.getX()) {
                    maxX = p2.getX();
                }
                if (minY > p2.getY()) {
                    minY = p2.getY();
                }
                if (maxY < p2.getY()) {
                    maxY = p2.getY();
                }
                fitit = true;
            }
        }
        if (fitit) {
            this.setMinMaxX(minX, maxX);
            this.setMinMaxY(minY, maxY);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("SimplePlotter");
        GraphPlotter gp = new GraphPlotter();
        double[] data = new double[4096];
        double[] data2 = new double[4096];
        double[] data3 = new double[4096];
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = Math.sin((double)i2 / (double)data.length * Math.PI * 2.0);
            data2[i2] = Math.cos((double)i2 / (double)data.length * Math.PI * 2.0);
            data3[i2] = (data[i2] + data2[i2]) / 2.0;
        }
        gp.addPlot(data);
        gp.addPlot(data2);
        gp.addPlot(data3);
        gp.fit();
        gp.removePlot(0);
        gp.removePlot(1);
        gp.setPreferredSize(new Dimension(512, 256));
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(gp);
        frame.pack();
        frame.setVisible(true);
    }

    static /* synthetic */ Paint[] access$200() {
        return paintDictionary;
    }

    static {
        float[] dashPattern = new float[]{30.0f, 10.0f, 10.0f, 10.0f};
        GraphPlotter.strokeDictionary[0] = new BasicStroke(0.0f);
        GraphPlotter.strokeDictionary[1] = new BasicStroke(0.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        GraphPlotter.paintDictionary[0] = new Color(245, 128, 0, 100);
        GraphPlotter.paintDictionary[1] = new Color(50, 198, 28, 100);
    }

    private static class MouseController
    extends MouseInputAdapter {
        private double origRangeX = 0.0;
        private double origRangeY = 0.0;
        private double origCenterX = 0.0;
        private double origCenterY = 0.0;
        private Point2D start = new Point2D.Double();
        private Point2D plotStart = new Point2D.Double();
        private AffineTransform disp2plot = new AffineTransform();

        private MouseController() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            GraphPlotter gp = (GraphPlotter)me.getSource();
            this.origRangeX = gp.getRangeX();
            this.origRangeY = gp.getRangeY();
            this.origCenterX = gp.getCenterX();
            this.origCenterY = gp.getCenterY();
            this.start.setLocation(me.getPoint());
            AffineTransform d2p = gp.getDisplayToPlot();
            this.disp2plot.setTransform(d2p);
            this.disp2plot.transform(this.start, this.plotStart);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            GraphPlotter gp = (GraphPlotter)me.getSource();
            int mod = me.getModifiers();
            boolean b1 = 0 != (mod & 0x10);
            int clickcnt = me.getClickCount();
            if (b1 && clickcnt > 1) {
                gp.fitToPlotArea();
                gp.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            GraphPlotter gp = (GraphPlotter)me.getSource();
            int x2 = me.getX();
            int y2 = me.getY();
            int mod = me.getModifiers();
            boolean b1 = 0 != (mod & 0x10);
            boolean b3 = 0 != (mod & 4);
            Point2D.Double currpoint = new Point2D.Double();
            this.disp2plot.transform(new Point2D.Double(x2, y2), currpoint);
            double deltaX = ((Point2D)currpoint).getX() - this.plotStart.getX();
            double deltaY = ((Point2D)currpoint).getY() - this.plotStart.getY();
            if (b1) {
                gp.setCenterX(this.origCenterX - deltaX);
                gp.setCenterY(this.origCenterY - deltaY);
                gp.repaint();
            } else if (b3) {
                gp.setRangeX(this.origRangeX - deltaX);
                gp.setRangeY(this.origRangeY - deltaY);
                gp.repaint();
            }
        }
    }

    private static class PlotRegion {
        private static int nregions = 0;
        public double x0 = 0.0;
        public double x1 = 0.0;
        public Paint paint = GraphPlotter.access$200()[nregions];

        public PlotRegion() {
            nregions = (nregions + 1) % 2;
        }
    }

    private static class PlotScene {
        private static int nscenes = 0;
        public static final int MAX_REGIONS = 8;
        private List pts = new ArrayList();
        public int interpolation = 1;
        public Stroke stroke = null;
        public Color color = Color.black;
        public PlotRegion[] pregions = new PlotRegion[8];
        public GeneralPath path = new GeneralPath();

        public PlotScene() {
            this.stroke = strokeDictionary[nscenes];
            nscenes = (nscenes + 1) % 2;
        }

        public List getPlot() {
            return this.pts;
        }

        public void setPlot(List pts) {
            this.pts = pts;
            this.syncPlot();
        }

        public final double getValue(double x2, int interpolation) {
            int idx = -1;
            Point2D pt0 = null;
            Point2D pt1 = null;
            double value = 0.0;
            for (int i2 = 0; i2 < this.pts.size() - 1; ++i2) {
                pt0 = (Point2D)this.pts.get(i2);
                pt1 = (Point2D)this.pts.get(i2 + 1);
                if (!(x2 >= pt0.getX()) || !(x2 < pt1.getX())) continue;
                idx = i2;
                break;
            }
            if (idx != -1) {
                double deltax = pt1.getX() - pt0.getX();
                double deltay = pt1.getY() - pt0.getY();
                switch (interpolation) {
                    case 1: {
                        value = pt0.getY() + (x2 - pt0.getX()) / deltax * deltay;
                        break;
                    }
                    case 0: {
                        value = pt0.getY() + (x2 - pt0.getX()) / deltax * deltay;
                    }
                }
            }
            return value;
        }

        private void syncPlot() {
            this.path.reset();
            if (this.interpolation == 1) {
                for (int i2 = 0; i2 < this.pts.size(); ++i2) {
                    Point2D p2 = (Point2D)this.pts.get(i2);
                    if (i2 == 0) {
                        this.path.moveTo((float)p2.getX(), (float)p2.getY());
                        continue;
                    }
                    this.path.lineTo((float)p2.getX(), (float)p2.getY());
                }
            } else {
                for (int i3 = 0; i3 < this.pts.size(); ++i3) {
                    Point2D p3 = (Point2D)this.pts.get(i3);
                    if (i3 == 0) {
                        this.path.moveTo((float)p3.getX(), (float)p3.getY());
                        continue;
                    }
                    this.path.lineTo((float)p3.getX(), (float)p3.getY());
                }
            }
        }
    }
}

