/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.plot.XpWaveform;
import com.ge.med.terra.jami.plot.XpWaveformSource;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class XpDynamicWaveform
extends XpWaveformSource {
    private static final int POINT_LEEWAY = 50;
    private XpWaveform theWaveform = null;
    private float timeWindowLength = (float)Math.PI * 3;
    private int dataPointWindow = 512;
    private boolean playing = false;
    private WaveformGenerator wg = null;

    private XpDynamicWaveform(String name) {
        super(name);
        this.theWaveform = new XpWaveform(name);
        this.wg = new DemoWaveformGenerator();
    }

    private XpDynamicWaveform(String name, String URLAddress) {
        this(name);
        this.wg = new URLWaveformGenerator(URLAddress);
    }

    public static XpDynamicWaveform getDemoDynamicWaveform() {
        XpDynamicWaveform dw = new XpDynamicWaveform("Sine Wave");
        dw.startGenerator();
        return dw;
    }

    public static XpDynamicWaveform getURLDynamicWaveform(String name, String source) {
        XpDynamicWaveform dw = new XpDynamicWaveform(name, source);
        dw.startGenerator();
        return dw;
    }

    @Override
    public Shape getWaveform() {
        return this.theWaveform.getWaveform();
    }

    @Override
    public float getValue(float x2) {
        return this.theWaveform.getValue(x2);
    }

    @Override
    public final float getMinX() {
        return this.getMinActiveX();
    }

    @Override
    public final float getMaxX() {
        return this.getMaxActiveX();
    }

    @Override
    public final float getMinY() {
        return this.theWaveform.getMinY();
    }

    @Override
    public final float getMaxY() {
        return this.theWaveform.getMaxY();
    }

    @Override
    public Stroke getStroke() {
        return this.theWaveform.getStroke();
    }

    @Override
    public void setStroke(Stroke newStroke) {
        this.theWaveform.setStroke(newStroke);
    }

    @Override
    public Color getColor() {
        return this.theWaveform.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.theWaveform.setColor(color);
    }

    private float getMinActiveX() {
        float maxT = this.theWaveform.getMaxX();
        float minT = this.theWaveform.getMinX();
        float min = maxT - this.timeWindowLength;
        if (!this.playing) {
            return minT;
        }
        if (min < 0.0f) {
            return minT;
        }
        return min;
    }

    private float getMaxActiveX() {
        float maxT = this.theWaveform.getMaxX();
        float minT = this.theWaveform.getMinX();
        float max = minT + this.timeWindowLength;
        if (!this.playing) {
            return maxT;
        }
        if (max > maxT) {
            return max;
        }
        return maxT;
    }

    private void startGenerator() {
        if (this.wg != null) {
            this.wg.start();
        }
    }

    protected class DemoWaveformGenerator
    extends WaveformGenerator {
        private float currTime;
        private final float dT = 0.15707964f;

        public DemoWaveformGenerator() {
            this.currTime = 0.0f;
            this.dT = 0.15707964f;
        }

        @Override
        public void run() {
            float amplitude = 0.0f;
            while (this.keepRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                amplitude = (float)Math.cos(this.currTime);
                this.currTime += 0.15707964f;
                this.addPoint(this.currTime, amplitude);
                XpDynamicWaveform.this.playing = true;
                XpDynamicWaveform.this.notifyListeners();
            }
        }
    }

    protected class URLWaveformGenerator
    extends WaveformGenerator {
        private BufferedReader dataReader;

        public URLWaveformGenerator(String urlAddr) {
            this.dataReader = null;
            if (urlAddr != null) {
                try {
                    URL url = new URL(urlAddr);
                    InputStream dataStream = url.openStream();
                    this.dataReader = new BufferedReader(new InputStreamReader(dataStream), 100);
                    if (this.dataReader != null) {
                        XpLog.logger().fine("CONNECTION: " + url);
                    }
                }
                catch (MalformedURLException e2) {
                    XpLog.logger().warning("XpDynamicWaveform::EXCEPTION: " + e2);
                }
                catch (IOException ioe) {
                    XpLog.logger().warning("XpDynamicWaveform::EXCEPTION: " + ioe);
                }
            }
        }

        @Override
        public void run() {
            float amplitude = 0.0f;
            float currTime = 0.0f;
            while (this.keepRunning) {
                block8: {
                    if (this.dataReader != null) {
                        try {
                            String s2 = this.dataReader.readLine();
                            if (s2 != null) {
                                StringTokenizer st = new StringTokenizer(s2);
                                String sx = st.nextToken();
                                String sy = st.nextToken();
                                Float fx = new Float(sx);
                                Float fy = new Float(sy);
                                amplitude = fy.floatValue();
                                currTime = fx.floatValue();
                                break block8;
                            }
                            this.keepRunning = false;
                            break;
                        }
                        catch (IOException ioe) {
                            XpLog.logger().warning("XpDynamicWaveform::EXCEPTION: " + ioe);
                            break block8;
                        }
                    }
                    currTime = (float)((double)currTime + 0.1);
                }
                this.addPoint(currTime, amplitude);
                XpDynamicWaveform.this.playing = true;
                XpDynamicWaveform.this.notifyListeners();
            }
            if (this.dataReader != null) {
                try {
                    this.dataReader.close();
                }
                catch (IOException ioe) {
                    XpLog.logger().warning("XpDynamicWaveform::EXCEPTION: " + ioe);
                }
            }
        }
    }

    protected abstract class WaveformGenerator
    extends Thread {
        protected boolean keepRunning = true;

        protected WaveformGenerator() {
        }

        @Override
        public abstract void run();

        protected final void addPoint(float x2, float y2) {
            XpDynamicWaveform.this.theWaveform.addPoint(x2, y2);
            if (XpDynamicWaveform.this.theWaveform.size() > 50 + XpDynamicWaveform.this.dataPointWindow) {
                XpDynamicWaveform.this.theWaveform.deletePoints(0, 50);
            }
        }

        public void pleaseStop() {
            this.keepRunning = false;
        }
    }
}

