/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import com.ge.med.terra.jami.plot.XpDynamicWaveform;
import com.ge.med.terra.jami.plot.XpWaveform;
import com.ge.med.terra.jami.plot.XpWaveformSource;
import com.ge.med.terra.jami.plot.XpWaveformValuePair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XpPlotModel
implements PropertyChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private List waveforms;
    private float minDataX = Float.POSITIVE_INFINITY;
    private float maxDataX = Float.NEGATIVE_INFINITY;
    private float minDataY = Float.POSITIVE_INFINITY;
    private float maxDataY = Float.NEGATIVE_INFINITY;
    private float dashVal = 6.0f;
    private int colorIndex = 0;
    private Color[] colorPalette = new Color[]{Color.red, Color.magenta, Color.green, Color.blue, Color.black, Color.cyan};
    private boolean manualNotify = false;

    public XpPlotModel() {
        this.waveforms = new ArrayList();
    }

    public static XpPlotModel getDemoModel() {
        int nPts = 80;
        float x2 = 0.0f;
        float dx = (float)(Math.PI * 2 / (double)nPts);
        ArrayList<Point2D.Float> pts = new ArrayList<Point2D.Float>();
        ArrayList<Point2D.Float> pts2 = new ArrayList<Point2D.Float>();
        x2 = 0.0f;
        while ((double)x2 < Math.PI * 2) {
            Point2D.Float ps = new Point2D.Float(x2, (float)Math.sin(x2) - 2.0f);
            pts.add(ps);
            Point2D.Float pc = new Point2D.Float(x2, (float)Math.cos(x2));
            pts2.add(pc);
            x2 += dx;
        }
        XpPlotModel newPM = new XpPlotModel();
        newPM.addWaveform(pts, "Sine  ");
        newPM.addWaveform(pts2, "Cosine");
        return newPM;
    }

    public static XpPlotModel getDynamicDemoModel() {
        XpPlotModel newPM = new XpPlotModel();
        newPM.addWaveform(XpDynamicWaveform.getDemoDynamicWaveform());
        return newPM;
    }

    public static XpPlotModel getDynamicURLModel(String name, String urlAddr) {
        XpPlotModel newPM = new XpPlotModel();
        newPM.addWaveform(XpDynamicWaveform.getURLDynamicWaveform(name, urlAddr));
        return newPM;
    }

    public Iterator getWaveforms() {
        return this.waveforms.iterator();
    }

    public void addWaveform(XpWaveformSource mw) {
        this.waveforms.add(mw);
        this.globalLimits();
        float[] dash = new float[2];
        BasicStroke newStroke = null;
        if (this.waveforms.size() > 1) {
            dash[0] = this.dashVal;
            dash[1] = this.dashVal;
            this.dashVal += 6.0f;
            newStroke = new BasicStroke(1.0f, 0, 2, 1.0f, dash, 0.0f);
        } else {
            newStroke = new BasicStroke();
        }
        mw.setStroke(newStroke);
        mw.setColor(this.colorPalette[this.colorIndex]);
        if (++this.colorIndex == this.colorPalette.length) {
            this.colorIndex = 0;
        }
        mw.addPropertyChangeListener(this);
        this.notifyChange();
    }

    public void addWaveform(List waveform, String name) {
        XpWaveform mw = new XpWaveform(waveform, name);
        this.addWaveform(mw);
    }

    private void globalLimits() {
        this.minDataX = Float.POSITIVE_INFINITY;
        this.maxDataX = Float.NEGATIVE_INFINITY;
        this.minDataY = Float.POSITIVE_INFINITY;
        this.maxDataY = Float.NEGATIVE_INFINITY;
        Iterator i2 = this.getWaveforms();
        while (i2.hasNext()) {
            XpWaveformSource mw = (XpWaveformSource)i2.next();
            this.updateLimits(mw);
        }
    }

    private void updateLimits(XpWaveformSource mw) {
        float maxX = mw.getMaxX();
        if (mw.getMinX() < this.minDataX) {
            this.minDataX = mw.getMinX();
        }
        if (maxX > this.maxDataX) {
            this.maxDataX = maxX;
        }
        if (mw.getMinY() < this.minDataY) {
            this.minDataY = mw.getMinY();
        }
        if (mw.getMaxY() > this.maxDataY) {
            this.maxDataY = mw.getMaxY();
        }
    }

    public void clearWaveforms() {
        this.colorIndex = 0;
        this.waveforms.clear();
        this.notifyChange();
    }

    private void notifyChange() {
        if (!this.manualNotify) {
            this.notifyListeners();
        }
    }

    public final void notifyListeners() {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "ModelProperty", null, null));
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public float getMinX() {
        return this.minDataX;
    }

    public void setMinX(float _minX) {
        this.minDataX = _minX;
    }

    public float getMaxX() {
        return this.maxDataX;
    }

    public void setMaxX(float _maxX) {
        this.maxDataX = _maxX;
    }

    public void setXRange(float _minX, float _maxX) {
        this.setMinX(_minX);
        this.setMaxX(_maxX);
        this.notifyChange();
    }

    public float getMinY() {
        return this.minDataY;
    }

    public void setMinY(float _minY) {
        this.minDataY = _minY;
    }

    public float getMaxY() {
        return this.maxDataY;
    }

    public void setMaxY(float _maxY) {
        this.maxDataY = _maxY;
    }

    public void setYRange(float _minY, float _maxY) {
        this.setMinY(_minY);
        this.setMaxY(_maxY);
        this.notifyChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.globalLimits();
        this.notifyChange();
    }

    public Iterator valueAt(double xDomain) {
        ArrayList<XpWaveformValuePair> l2 = new ArrayList<XpWaveformValuePair>();
        int index = 0;
        Iterator i2 = this.getWaveforms();
        while (i2.hasNext()) {
            XpWaveformSource ws = (XpWaveformSource)i2.next();
            double theValue = ws.getValue((float)xDomain);
            l2.add(new XpWaveformValuePair(ws.getWaveformName(), xDomain, theValue));
            ++index;
        }
        return l2.iterator();
    }

    public final boolean getManualNotify() {
        return this.manualNotify;
    }

    public final void setManualNotify(boolean notifyVal) {
        this.manualNotify = notifyVal;
    }
}

