/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.codec;

import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmPixelBufferCodec;
import com.ge.med.terra.tap.util.clientServer.Utils;

public class PassThruPBCodec
implements RmPixelBufferCodec {
    private RmPixelBuffer return_rpb = new RmPixelBuffer();
    private short[] spixbuff = null;
    private int[] ipixbuff = null;

    @Override
    public String getName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public int encode(RmPixelBuffer pb, byte[] pbstream, int pboffset) {
        int newOffset = this.encodePixelBuffer(pb, pbstream, pboffset);
        return newOffset - pboffset;
    }

    @Override
    public RmPixelBuffer decode(byte[] pbstream, int pboffset, int pblength) {
        int newOffset = this.decodePixelBuffer(pbstream, pboffset, this.return_rpb);
        return this.return_rpb;
    }

    private int decodePixelBuffer(byte[] in, int buff_offset, RmPixelBuffer rpb) {
        int offset = buff_offset;
        rpb.x0 = Utils.getInt(in, offset);
        rpb.y0 = Utils.getInt(in, offset += 4);
        rpb.pixBufferWidth = Utils.getInt(in, offset += 4);
        rpb.pixBufferHeight = Utils.getInt(in, offset += 4);
        rpb.xstep = Utils.getInt(in, offset += 4);
        rpb.ystep = Utils.getInt(in, offset += 4);
        rpb.nchannels = Utils.getInt(in, offset += 4);
        rpb.remainingPasses = Utils.getInt(in, offset += 4);
        rpb.mpAlgorithmId = Utils.getInt(in, offset += 4);
        byte type = in[offset += 4];
        ++offset;
        int len = rpb.pixBufferWidth * rpb.pixBufferHeight;
        switch (type) {
            case 2: {
                if (this.spixbuff == null || this.spixbuff.length < len) {
                    this.spixbuff = new short[len];
                }
                int spix_len = len - len % 2;
                int i2 = 0;
                while (i2 < spix_len) {
                    int A2 = in[offset + 0] & 0xFF;
                    int B = in[offset + 1] & 0xFF;
                    int C = in[offset + 2] & 0xFF;
                    int val0 = A2 << 4 | C & 0xF;
                    int val1 = B << 4 | C >> 4;
                    this.spixbuff[i2] = (short)val0;
                    this.spixbuff[i2 + 1] = (short)val1;
                    i2 += 2;
                    offset += 3;
                }
                rpb.pixBuffer = this.spixbuff;
                break;
            }
            case 0: {
                if (this.spixbuff == null || this.spixbuff.length < len) {
                    this.spixbuff = new short[len];
                }
                int i3 = 0;
                while (i3 < len) {
                    short val;
                    this.spixbuff[i3] = val = (short)(((in[offset + 1] & 0xFF) << 0) + ((in[offset + 0] & 0xFF) << 8));
                    ++i3;
                    offset += 2;
                }
                rpb.pixBuffer = this.spixbuff;
                break;
            }
            case 1: {
                if (this.ipixbuff == null || this.ipixbuff.length < len) {
                    this.ipixbuff = new int[len];
                }
                int i4 = 0;
                while (i4 < len) {
                    int val;
                    this.ipixbuff[i4] = val = ((in[offset + 2] & 0xFF) << 0) + ((in[offset + 1] & 0xFF) << 8) + ((in[offset + 0] & 0xFF) << 16) + -16777216;
                    ++i4;
                    offset += 3;
                }
                rpb.pixBuffer = this.ipixbuff;
            }
        }
        return offset;
    }

    private int encodePixelBuffer(RmPixelBuffer rpb, byte[] out, int buff_offset) {
        int offset;
        block8: {
            int pixbuffOffset;
            int len;
            Object pixbuff;
            block7: {
                offset = buff_offset;
                Utils.putInt(out, offset, rpb.x0);
                Utils.putInt(out, offset += 4, rpb.y0);
                Utils.putInt(out, offset += 4, rpb.pixBufferWidth);
                Utils.putInt(out, offset += 4, rpb.pixBufferHeight);
                Utils.putInt(out, offset += 4, rpb.xstep);
                Utils.putInt(out, offset += 4, rpb.ystep);
                Utils.putInt(out, offset += 4, rpb.nchannels);
                Utils.putInt(out, offset += 4, rpb.remainingPasses);
                Utils.putInt(out, offset += 4, rpb.mpAlgorithmId);
                offset += 4;
                pixbuff = rpb.pixBuffer;
                len = rpb.pixBufferWidth * rpb.pixBufferHeight;
                pixbuffOffset = rpb.pixBufferOffset;
                if (!(pixbuff instanceof short[])) break block7;
                short[] spixbuff = (short[])pixbuff;
                switch (rpb.bpp) {
                    case 12: {
                        out[offset++] = 2;
                        int i2 = pixbuffOffset;
                        while (i2 < pixbuffOffset + len) {
                            short v0 = spixbuff[i2];
                            short v1 = spixbuff[i2 + 1];
                            short val0 = v0 < 0 ? (short)0 : v0;
                            short val1 = v1 < 0 ? (short)0 : v1;
                            int p0_0 = (val0 & 0xFF0) >> 4;
                            int p0_1 = val0 & 0xF;
                            int p1_0 = (val1 & 0xFF0) >> 4;
                            int p1_1 = (val1 & 0xF) << 4;
                            out[offset + 0] = (byte)p0_0;
                            out[offset + 1] = (byte)p1_0;
                            out[offset + 2] = (byte)(p0_1 | p1_1);
                            i2 += 2;
                            offset += 3;
                        }
                        break block8;
                    }
                    case 16: {
                        out[offset++] = 0;
                        int i3 = pixbuffOffset;
                        while (i3 < pixbuffOffset + len) {
                            short val = spixbuff[i3];
                            out[offset + 1] = (byte)(val >> 0);
                            out[offset + 0] = (byte)(val >> 8);
                            ++i3;
                            offset += 2;
                        }
                        break;
                    }
                }
                break block8;
            }
            out[offset] = 1;
            ++offset;
            int[] ipixbuff = (int[])pixbuff;
            int i4 = pixbuffOffset;
            while (i4 < pixbuffOffset + len) {
                int val = ipixbuff[i4];
                out[offset + 2] = (byte)(val >> 0);
                out[offset + 1] = (byte)(val >> 8);
                out[offset + 0] = (byte)(val >> 16);
                ++i4;
                offset += 3;
            }
        }
        return offset;
    }
}

