/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.remote.session;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.remote.session.TermService;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmBasicService;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.logging.Level;

public class ForkXMS
extends XmBasicService {
    private static final byte CREATE_SERVER = 0;
    private static final byte NUM_METHODS = 1;
    private static final String[] methodNames = new String[1];
    private XmSession xms_;
    private TermService ts;
    private transient boolean ready_;

    public ForkXMS(XmSession xms) {
        ForkXMS.methodNames[0] = "createRenderServer";
        this.setMethods(methodNames);
        this.ready_ = false;
        super.installInto(xms);
        try {
            byte[] result = this.callSync((byte)0, null);
            int port = Utils.getInt(result, 0);
            System.err.println("$$$$$$$$$$$$port after callsync = " + port + " @ " + xms.getHostAddress());
            this.xms_ = XmSession.factory("" + xms.getHostAddress() + ":" + port);
            this.ts = new TermService(this.xms_);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void connectionList() {
        super.connectionLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createRenderServer(byte[] data) {
        int port = 7851;
        Level level = XpLog.logger().getLevel();
        XpLog.logger().setLevel(Level.INFO);
        try {
            while (true) {
                XmSession ses = new XmSession("127.0.0.1", port);
                ses.close();
                ++port;
            }
        }
        catch (Exception ex) {
            final int portno = port;
            byte[] ret = new byte[4];
            Utils.putInt(ret, 0, portno);
            ForkXMS forkXMS = this;
            synchronized (forkXMS) {
                this.ready_ = false;
            }
            String notificationMsg = "okey dokey server started";
            new Thread(){

                @Override
                public void run() {
                    try {
                        XpLog.logger().info("Forking new XmServer on port=" + portno);
                        String renderserverArg = XpPropertiesManager.getProperty("jami.rendersession.arg");
                        String[] xmserverArgs = new String[]{"-Xmx784M", "-Dtap.server.port=" + portno, "-Dtap.server.startmsg=okey dokey server started", "-Dcom.ge.med.idc.mprender.MultipassPolicy=profile,remotefast"};
                        if (renderserverArg != null) {
                            String[] tmpArgs = new String[xmserverArgs.length + 1];
                            System.arraycopy(xmserverArgs, 0, tmpArgs, 0, xmserverArgs.length);
                            tmpArgs[tmpArgs.length - 1] = renderserverArg;
                            xmserverArgs = tmpArgs;
                        }
                        Process proc = SimpleUtilities.callInNewJVM(xmserverArgs, "com.ge.med.terra.tap.util.clientServer.XmServer", new String[0]);
                        File logFile = File.createTempFile("xjt_rendersession", ".tmp");
                        if (logFile.exists()) {
                            logFile.delete();
                        }
                        XpLog.logger().info("Logging xmserver output to: " + logFile);
                        logFile.deleteOnExit();
                        PrintStream ps = new PrintStream(logFile);
                        SimpleUtilities.map(ps, proc.getErrorStream());
                        ForkXMS.map(ForkXMS.this, proc.getInputStream(), ps, "okey dokey server started");
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }.start();
            ForkXMS forkXMS2 = this;
            synchronized (forkXMS2) {
                while (!this.ready_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            XpLog.logger().info("Forked XmServer listening on port=" + portno);
            XpLog.logger().setLevel(level);
            return ret;
        }
    }

    public ForkXMS() {
        ForkXMS.methodNames[0] = "createRenderServer";
        this.setMethods(methodNames);
        this.ready_ = false;
    }

    public XmSession getXmSession() {
        return this.xms_;
    }

    public void terminate() {
        this.ts.terminate();
    }

    private static void map(final ForkXMS fxms, final InputStream is, final OutputStream os, final String pattern) {
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                byte[] buff;
                block10: {
                    try {
                        if (pattern == null) {
                            buff = new byte[1024];
                            break block10;
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
                        while (true) {
                            String line;
                            if ((line = reader.readLine()) == null) {
                                continue;
                            }
                            writer.write(line);
                            writer.newLine();
                            writer.flush();
                            ForkXMS forkXMS = fxms;
                            synchronized (forkXMS) {
                                if (line.indexOf(pattern) >= 0) {
                                    fxms.ready_ = true;
                                    fxms.notifyAll();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        XpLog.logger().info("MapIO: communication lost");
                        return;
                    }
                }
                int n2;
                while ((n2 = is.read(buff)) >= 0) {
                    os.write(buff, 0, n2);
                }
                return;
            }
        };
        t2.setName("process reader thread");
        t2.setDaemon(true);
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForkXMS createXmSession() {
        final ForkXMS fxms = new ForkXMS();
        int port = 7851;
        try {
            while (true) {
                XmSession ses = new XmSession("localhost", port);
                ses.close();
                ++port;
            }
        }
        catch (Exception ex) {
            XmSession xms;
            final int portno = port;
            ForkXMS forkXMS = fxms;
            synchronized (forkXMS) {
                fxms.ready_ = false;
            }
            String notificationMsg = "okey dokey server started";
            new Thread(){

                @Override
                public void run() {
                    try {
                        XpLog.logger().info("createRenderServer(): executing....");
                        String renderserverArg = XpPropertiesManager.getProperty("jami.rendersession.arg");
                        String[] xmserverArgs = new String[]{"-Xmx784M", "-Dtap.server.port=" + portno, "-Dtap.server.startmsg=okey dokey server started"};
                        if (renderserverArg != null) {
                            xmserverArgs = new String[]{"-Xmx784M", renderserverArg, "-Dtap.server.port=" + portno, "-Dtap.server.startmsg=okey dokey server started"};
                        }
                        Process proc = SimpleUtilities.callInNewJVM(xmserverArgs, "com.ge.med.terra.tap.util.clientServer.XmServer", new String[0]);
                        SimpleUtilities.map(System.err, proc.getErrorStream());
                        ForkXMS.map(fxms, proc.getInputStream(), System.out, "okey dokey server started");
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }.start();
            ForkXMS forkXMS2 = fxms;
            synchronized (forkXMS2) {
                while (!fxms.ready_) {
                    try {
                        fxms.wait();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            fxms.xms_ = xms = new XmSession("localhost", portno);
            fxms.ts = new TermService(xms);
            return fxms;
        }
    }
}

